/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.Data;
import iaik.pkcs.pkcs11.objects.HardwareFeature;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.objects.X509PublicKeyCertificate;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.cert.CertificateFactory;

public class ReadObjects {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 1 || stringArray.length == 2) {
                iaik.pkcs.pkcs11.objects.Object[] objectArray;
                Object object;
                iaik.pkcs.pkcs11.objects.Object[] objectArray2;
                SecretKey secretKey;
                Object object2;
                Module module = Module.getInstance((String)stringArray[0]);
                module.initialize(null);
                Slot[] slotArray = module.getSlotList(true);
                if (slotArray.length == 0) {
                    System.out.println("No slot with present token found!");
                    System.exit(0);
                }
                Slot slot = slotArray[0];
                Token token = slot.getToken();
                Session session = token.openSession(true, false, null, null);
                TokenInfo tokenInfo = token.getTokenInfo();
                if (tokenInfo.isLoginRequired()) {
                    if (tokenInfo.isProtectedAuthenticationPath()) {
                        session.login(true, null);
                    } else {
                        output_.print("Enter user-PIN or press [return] to list just public objects: ");
                        output_.flush();
                        object2 = input_.readLine();
                        output_.println();
                        output_.print("listing all" + (((String)object2).length() > 0 ? "" : " public") + " objects on token");
                        if (((String)object2).length() > 0) {
                            session.login(true, ((String)object2).toCharArray());
                        }
                    }
                }
                output_.println("################################################################################");
                output_.println("listing all private keys");
                object2 = new PrivateKey();
                session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)object2);
                iaik.pkcs.pkcs11.objects.Object[] objectArray3 = session.findObjects(1);
                while (objectArray3.length > 0) {
                    output_.println("________________________________________________________________________________");
                    output_.println(objectArray3[0]);
                    output_.println("________________________________________________________________________________");
                    objectArray3 = session.findObjects(1);
                }
                session.findObjectsFinal();
                output_.println("################################################################################");
                output_.println("################################################################################");
                output_.println("listing all public keys");
                PublicKey publicKey = new PublicKey();
                session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)publicKey);
                iaik.pkcs.pkcs11.objects.Object[] objectArray4 = session.findObjects(1);
                while (objectArray4.length > 0) {
                    output_.println("________________________________________________________________________________");
                    output_.println(objectArray4[0]);
                    output_.println("________________________________________________________________________________");
                    objectArray4 = session.findObjects(1);
                }
                session.findObjectsFinal();
                output_.println("################################################################################");
                output_.println("################################################################################");
                output_.println("listing all X.509 public key certificates");
                X509PublicKeyCertificate x509PublicKeyCertificate = new X509PublicKeyCertificate();
                session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)x509PublicKeyCertificate);
                iaik.pkcs.pkcs11.objects.Object[] objectArray5 = session.findObjects(1);
                while (objectArray5.length > 0) {
                    output_.println("________________________________________________________________________________");
                    output_.println(objectArray5[0]);
                    output_.println("--------------------------------------------------------------------------------");
                    secretKey = (X509PublicKeyCertificate)objectArray5[0];
                    objectArray2 = CertificateFactory.getInstance("X.509");
                    object = secretKey.getValue().getByteArrayValue();
                    objectArray = (iaik.pkcs.pkcs11.objects.Object[])objectArray2.generateCertificate(new ByteArrayInputStream((byte[])object));
                    output_.println(objectArray);
                    output_.println("________________________________________________________________________________");
                    objectArray5 = session.findObjects(1);
                }
                session.findObjectsFinal();
                output_.println("################################################################################");
                output_.println("################################################################################");
                output_.println("listing all secret keys");
                secretKey = new SecretKey();
                session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)secretKey);
                objectArray2 = session.findObjects(1);
                while (objectArray2.length > 0) {
                    output_.println("________________________________________________________________________________");
                    output_.println(objectArray2[0]);
                    output_.println("________________________________________________________________________________");
                    objectArray2 = session.findObjects(1);
                }
                session.findObjectsFinal();
                output_.println("################################################################################");
                output_.println("################################################################################");
                output_.println("listing all data objects");
                object = new Data();
                session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)object);
                objectArray = session.findObjects(1);
                while (objectArray.length > 0) {
                    output_.println("________________________________________________________________________________");
                    output_.println(objectArray[0]);
                    output_.println("________________________________________________________________________________");
                    objectArray = session.findObjects(1);
                }
                session.findObjectsFinal();
                output_.println("################################################################################");
                output_.println("################################################################################");
                output_.println("listing all hardware feature objects");
                HardwareFeature hardwareFeature = new HardwareFeature();
                session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)hardwareFeature);
                iaik.pkcs.pkcs11.objects.Object[] objectArray6 = session.findObjects(1);
                while (objectArray6.length > 0) {
                    output_.println("________________________________________________________________________________");
                    output_.println(objectArray6[0]);
                    output_.println("________________________________________________________________________________");
                    objectArray6 = session.findObjects(1);
                }
                session.findObjectsFinal();
                output_.println("################################################################################");
                session.closeSession();
                module.finalize(null);
            } else {
                ReadObjects.printUsage();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected static void printUsage() {
        output_.println("ReadObjects <PKCS#11 module name>");
        output_.println("e.g.: ReadObjects pk2priv.dll");
    }
}

