/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11;

import iaik.pkcs.pkcs11.Info;
import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Module;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.Slot;
import iaik.pkcs.pkcs11.Token;
import iaik.pkcs.pkcs11.TokenInfo;
import iaik.pkcs.pkcs11.objects.DES3SecretKey;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.parameters.InitializationVectorParameters;
import iaik.pkcs.pkcs11.parameters.Parameters;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public class TripleDESEncrypt {
    static PrintWriter output_;
    static BufferedReader input_;

    static {
        try {
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            output_ = new PrintWriter(System.out, true);
            input_ = new BufferedReader(new InputStreamReader(System.in));
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            TripleDESEncrypt.printUsage();
            System.exit(1);
        }
        try {
            int n;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string;
            TokenInfo tokenInfo;
            output_.println("################################################################################");
            output_.println("load and initialize module: " + stringArray[0]);
            Module module = Module.getInstance((String)stringArray[0]);
            module.initialize(null);
            Info info = module.getInfo();
            output_.println(info);
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.println("getting list of all tokens");
            Slot[] slotArray = module.getSlotList(true);
            Token[] tokenArray = new Token[slotArray.length];
            HashMap<Long, Token> hashMap = new HashMap<Long, Token>(tokenArray.length);
            int n2 = 0;
            while (n2 < slotArray.length) {
                output_.println("________________________________________________________________________________");
                tokenArray[n2] = slotArray[n2].getToken();
                tokenInfo = tokenArray[n2].getTokenInfo();
                long l = tokenArray[n2].getTokenID();
                hashMap.put(new Long(l), tokenArray[n2]);
                output_.println("Token ID: " + l);
                output_.println(tokenInfo);
                output_.println("________________________________________________________________________________");
                ++n2;
            }
            output_.println("################################################################################");
            output_.println("################################################################################");
            tokenInfo = null;
            Long l = null;
            if (tokenArray.length == 0) {
                output_.println("There is no slot with a present token.");
                output_.flush();
                System.exit(0);
            } else if (tokenArray.length == 1) {
                output_.println("Taking token with ID: " + tokenArray[0].getTokenID());
                l = new Long(tokenArray[0].getTokenID());
                tokenInfo = tokenArray[0];
            } else {
                boolean bl = false;
                while (!bl) {
                    output_.print("Enter the ID of the token to use or 'x' to exit: ");
                    output_.flush();
                    string = input_.readLine();
                    if (string.equalsIgnoreCase("x")) {
                        output_.flush();
                        System.exit(0);
                    }
                    try {
                        l = new Long(string);
                        tokenInfo = (Token)hashMap.get(l);
                        if (tokenInfo != null) {
                            bl = true;
                            continue;
                        }
                        output_.println("A token with the entered ID \"" + string + "\" does not exist. Try again.");
                    }
                    catch (NumberFormatException numberFormatException) {
                        output_.println("The entered ID \"" + string + "\" is invalid. Try again.");
                    }
                }
            }
            Session session = tokenInfo.openSession(true, false, null, null);
            string = tokenInfo.getTokenInfo();
            if (string.isLoginRequired()) {
                if (string.isProtectedAuthenticationPath()) {
                    output_.print("Please enter the user PIN at the PIN-pad of your reader.");
                    session.login(true, null);
                } else {
                    output_.print("Enter user-PIN and press [return key]: ");
                    output_.flush();
                    object4 = input_.readLine();
                    session.login(true, ((String)object4).toCharArray());
                }
            }
            output_.println("################################################################################");
            object4 = Arrays.asList(tokenInfo.getMechanismList());
            MechanismInfo mechanismInfo = null;
            if (!object4.contains(Mechanism.DES3_CBC_PAD)) {
                output_.print("This token does not support Tripple DES!");
                output_.flush();
                System.exit(0);
            } else {
                mechanismInfo = tokenInfo.getMechanismInfo(Mechanism.DES3_CBC_PAD);
                if (!mechanismInfo.isEncrypt()) {
                    output_.print("This token does not support Tripple DES for encryption!");
                    output_.flush();
                    System.exit(0);
                }
            }
            output_.println("################################################################################");
            output_.println("searching for Tripple DES encryption keys");
            Vector<iaik.pkcs.pkcs11.objects.Object> vector = new Vector<iaik.pkcs.pkcs11.objects.Object>(4);
            DES3SecretKey dES3SecretKey = new DES3SecretKey();
            dES3SecretKey.getEncrypt().setBooleanValue(Boolean.TRUE);
            session.findObjectsInit((iaik.pkcs.pkcs11.objects.Object)dES3SecretKey);
            iaik.pkcs.pkcs11.objects.Object[] objectArray = session.findObjects(1);
            while (objectArray.length > 0) {
                vector.add(objectArray[0]);
                objectArray = session.findObjects(1);
            }
            session.findObjectsFinal();
            DES3SecretKey dES3SecretKey2 = null;
            if (vector.size() == 0) {
                if (object4.contains(Mechanism.DES3_KEY_GEN)) {
                    output_.println("Found NO Tripple DES key that can be used for encryption.");
                    output_.print("Do you want to generate a temporal session key? (y/n) ");
                    output_.flush();
                    object3 = input_.readLine();
                    if (((String)object3).equalsIgnoreCase("y")) {
                        object2 = (Mechanism)Mechanism.DES3_KEY_GEN.clone();
                        DES3SecretKey dES3SecretKey3 = new DES3SecretKey();
                        dES3SecretKey3.getEncrypt().setBooleanValue(Boolean.TRUE);
                        dES3SecretKey3.getDecrypt().setBooleanValue(Boolean.TRUE);
                        dES3SecretKey3.getToken().setBooleanValue(Boolean.FALSE);
                        dES3SecretKey2 = (DES3SecretKey)session.generateKey(object2, (iaik.pkcs.pkcs11.objects.Object)dES3SecretKey3);
                    } else {
                        output_.flush();
                        System.exit(0);
                    }
                } else {
                    output_.println("Found NO Tripple DES key that can be used for encryption.");
                    output_.println("This token does not support generation of Tripple DES keys.");
                    output_.flush();
                    System.exit(0);
                }
            } else {
                output_.println("found these Tripple DES encryption keys:");
                object3 = new HashMap(vector.size());
                object2 = vector.iterator();
                while (object2.hasNext()) {
                    iaik.pkcs.pkcs11.objects.Object object5 = (iaik.pkcs.pkcs11.objects.Object)object2.next();
                    long l2 = object5.getObjectHandle();
                    object3.put(new Long(l2), object5);
                    output_.println("________________________________________________________________________________");
                    output_.println("Object with handle: " + l2);
                    output_.println(object5);
                    output_.println("________________________________________________________________________________");
                }
                boolean bl = false;
                while (!bl) {
                    output_.print("Enter the handle of the key to use for encryption or 'x' to exit: ");
                    output_.flush();
                    object = input_.readLine();
                    if (((String)object).equalsIgnoreCase("x")) {
                        System.exit(0);
                    }
                    try {
                        Long l3 = new Long((String)object);
                        dES3SecretKey2 = (DES3SecretKey)object3.get(l3);
                        if (dES3SecretKey2 != null) {
                            bl = true;
                            continue;
                        }
                        output_.println("An object with the handle \"" + (String)object + "\" does not exist. Try again.");
                    }
                    catch (NumberFormatException numberFormatException) {
                        output_.println("The entered handle \"" + (String)object + "\" is invalid. Try again.");
                    }
                }
            }
            output_.println("################################################################################");
            output_.println("################################################################################");
            output_.println("encrypting data from file: " + stringArray[1]);
            object3 = new FileInputStream(stringArray[1]);
            object2 = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = ((InputStream)object3).read((byte[])object2)) >= 0) {
                byteArrayOutputStream.write((byte[])object2, 0, n);
            }
            Arrays.fill((byte[])object2, (byte)0);
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            ((InputStream)object3).close();
            object = byteArrayOutputStream.toByteArray();
            Mechanism mechanism = (Mechanism)Mechanism.DES3_CBC_PAD.clone();
            byte[] byArray = new byte[8];
            InitializationVectorParameters initializationVectorParameters = new InitializationVectorParameters(byArray);
            mechanism.setParameters((Parameters)initializationVectorParameters);
            output_.print("encrypting the data... ");
            session.encryptInit(mechanism, (Key)dES3SecretKey2);
            byte[] byArray2 = session.encrypt((byte[])object);
            output_.println("finished");
            output_.print("writing encrypted data to file \"" + stringArray[2] + "\"...");
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[2]);
            fileOutputStream.write(byArray2);
            fileOutputStream.flush();
            fileOutputStream.close();
            output_.println("finished");
            output_.println("################################################################################");
            output_.println("################################################################################");
            if (!mechanismInfo.isDecrypt()) {
                output_.print("This token does not support Tripple DES for decryption!");
            } else if (!dES3SecretKey2.getDecrypt().getBooleanValue().booleanValue()) {
                output_.print("The selected key cannot be used for decryption!");
            } else {
                output_.println("decrypting data from file: " + stringArray[2]);
                mechanism = (Mechanism)Mechanism.DES3_CBC_PAD.clone();
                mechanism.setParameters((Parameters)initializationVectorParameters);
                output_.print("decrypting the data... ");
                session.decryptInit(mechanism, (Key)dES3SecretKey2);
                byte[] byArray3 = session.decrypt(byArray2);
                output_.println("finished");
                boolean bl = false;
                if (((Object)object).length != byArray3.length) {
                    bl = false;
                } else {
                    bl = true;
                    int n3 = 0;
                    while (n3 < ((Object)object).length) {
                        if (object[n3] != byArray3[n3]) {
                            bl = false;
                            break;
                        }
                        ++n3;
                    }
                }
                output_.println("decryption " + (bl ? "successful" : "FAILED"));
                output_.println("finished");
            }
            output_.println("################################################################################");
            session.closeSession();
            module.finalize(null);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void printUsage() {
        output_.println("Usage: Encrypt <PKCS#11 module> <file to be encrypted> <encrypted file>");
        output_.println(" e.g.: Encrypt pk2priv.dll data.dat data.enc");
        output_.println("The given DLL must be in the search path of the system.");
    }
}

