/*
 * Decompiled with CFR 0.152.
 */
package demo.pkcs.pkcs11.wrapper;

import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.CK_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM;
import iaik.pkcs.pkcs11.wrapper.CK_MECHANISM_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_SESSION_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_SLOT_INFO;
import iaik.pkcs.pkcs11.wrapper.CK_TOKEN_INFO;
import iaik.pkcs.pkcs11.wrapper.Functions;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Connector;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;

public class SimpleTest {
    protected static final String CERTIFICATE_FILE = "tokenCertificate.der";
    protected static final String SIGNATURE_FILE = "signature.bin";
    protected static final String DIGEST_FILE = "digest.dat";
    protected PKCS11 myPKCS11Module_;
    protected String userPin_;
    protected long token_ = -1L;
    protected long session_;
    protected long[] objects_;
    protected long signatureKeyHandle_;
    protected long certificateHandle_;
    protected byte[] derEncodedCertificate_;
    protected File file_;
    protected CK_MECHANISM signatureMechanism_;
    protected CK_MECHANISM digestMechanism_;
    protected MessageDigest messageDigest_;
    protected byte[] signature_;
    protected byte[] digest_;

    public SimpleTest(String string, String string2, File file) throws IOException, PKCS11Exception {
        System.out.print("trying to connect to PKCS#11 module: " + string);
        this.myPKCS11Module_ = PKCS11Connector.connectToPKCS11Module((String)string);
        this.userPin_ = string2;
        this.file_ = file;
        this.signatureMechanism_ = new CK_MECHANISM();
        this.signatureMechanism_.mechanism = 6L;
        this.signatureMechanism_.pParameter = null;
        this.digestMechanism_ = new CK_MECHANISM();
        this.digestMechanism_.mechanism = 544L;
        this.digestMechanism_.pParameter = null;
        System.out.println(" FINISHED");
    }

    public void closeSession() throws PKCS11Exception {
        System.out.println("close session");
        this.myPKCS11Module_.C_CloseSession(this.session_);
        System.out.println("FINISHED\n");
    }

    public void digestData() throws IOException, PKCS11Exception {
        int n;
        byte[] byArray = new byte[1024];
        System.out.println("Digest Data");
        this.myPKCS11Module_.C_DigestInit(this.session_, this.digestMechanism_);
        try {
            this.messageDigest_ = MessageDigest.getInstance("SHA-1");
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        FileInputStream fileInputStream = new FileInputStream(this.file_);
        while ((n = ((InputStream)fileInputStream).read(byArray, 0, byArray.length)) >= 0) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            this.myPKCS11Module_.C_DigestUpdate(this.session_, byArray2);
            this.messageDigest_.update(byArray2);
            Arrays.fill(byArray2, (byte)0);
        }
        Arrays.fill(byArray, (byte)0);
        this.digest_ = this.myPKCS11Module_.C_DigestFinal(this.session_);
        byte[] byArray3 = this.messageDigest_.digest();
        System.out.println("PKCS11digest:" + Functions.toHexString((byte[])this.digest_));
        System.out.println("TestDigest  :" + Functions.toHexString((byte[])byArray3));
        System.out.println("FINISHED\n");
    }

    public void findAllObjects() throws PKCS11Exception {
        System.out.println("find all objects");
        this.myPKCS11Module_.C_FindObjectsInit(this.session_, null);
        this.objects_ = this.myPKCS11Module_.C_FindObjects(this.session_, 100L);
        if (this.objects_ == null) {
            System.out.println("null returned - no objects found");
        } else {
            System.out.println("found " + this.objects_.length + " objects");
        }
        this.myPKCS11Module_.C_FindObjectsFinal(this.session_);
        System.out.println("FINISHED\n");
    }

    public void findCertificate() throws PKCS11Exception {
        System.out.println("find certificate");
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        cK_ATTRIBUTEArray[0].type = 258L;
        this.myPKCS11Module_.C_GetAttributeValue(this.session_, this.signatureKeyHandle_, cK_ATTRIBUTEArray);
        byte[] byArray = (byte[])cK_ATTRIBUTEArray[0].pValue;
        System.out.println("ID of siganture key: " + Functions.toHexString((byte[])byArray));
        cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
        cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[0].type = 0L;
        cK_ATTRIBUTEArray[0].pValue = new Long(1L);
        cK_ATTRIBUTEArray[1] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[1].type = 258L;
        cK_ATTRIBUTEArray[1].pValue = byArray;
        this.myPKCS11Module_.C_FindObjectsInit(this.session_, cK_ATTRIBUTEArray);
        long[] lArray = this.myPKCS11Module_.C_FindObjects(this.session_, 100L);
        if (lArray == null) {
            System.out.println("null returned - no certificate found");
        } else {
            System.out.println("found " + lArray.length + " certificates with matching ID");
            int n = 0;
            while (n < lArray.length) {
                if (n == 0) {
                    this.certificateHandle_ = lArray[n];
                    System.out.print("for verification we use ");
                }
                System.out.println("certificate " + n);
                ++n;
            }
        }
        this.myPKCS11Module_.C_FindObjectsFinal(this.session_);
        System.out.println("FINISHED\n");
    }

    public void findSignatureKey() throws PKCS11Exception {
        System.out.println("find signature key");
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[2];
        cK_ATTRIBUTEArray[0] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[0].type = 0L;
        cK_ATTRIBUTEArray[0].pValue = new Long(3L);
        cK_ATTRIBUTEArray[1] = new CK_ATTRIBUTE();
        cK_ATTRIBUTEArray[1].type = 264L;
        cK_ATTRIBUTEArray[1].pValue = new Boolean(true);
        this.myPKCS11Module_.C_FindObjectsInit(this.session_, cK_ATTRIBUTEArray);
        long[] lArray = this.myPKCS11Module_.C_FindObjects(this.session_, 100L);
        if (lArray == null) {
            System.out.println("null returned - no signature key found");
        } else {
            System.out.println("found " + lArray.length + " signature keys");
            int n = 0;
            while (n < lArray.length) {
                if (n == 0) {
                    this.signatureKeyHandle_ = lArray[n];
                    System.out.print("for signing we use ");
                }
                System.out.println("signature key " + n);
                ++n;
            }
        }
        this.myPKCS11Module_.C_FindObjectsFinal(this.session_);
        System.out.println("FINISHED\n");
    }

    public void getInfo() throws PKCS11Exception {
        System.out.println("getting info");
        CK_INFO cK_INFO = this.myPKCS11Module_.C_GetInfo();
        System.out.println("Module Info: ");
        System.out.println(cK_INFO);
        System.out.println("FINISHED\n");
    }

    public void getMechanismInfo() throws PKCS11Exception {
        System.out.println("getting mechanism list");
        System.out.println("getting slot list");
        long[] lArray = this.myPKCS11Module_.C_GetSlotList(true);
        int n = 0;
        while (n < lArray.length) {
            System.out.println("getting mechanism list for slot " + lArray[n]);
            long[] lArray2 = this.myPKCS11Module_.C_GetMechanismList(lArray[n]);
            int n2 = 0;
            while (n2 < lArray2.length) {
                System.out.println("mechanism info for mechanism " + Functions.mechanismCodeToString((long)lArray2[n2]) + ": ");
                CK_MECHANISM_INFO cK_MECHANISM_INFO = this.myPKCS11Module_.C_GetMechanismInfo(lArray[n], lArray2[n2]);
                System.out.println(cK_MECHANISM_INFO);
                ++n2;
            }
            ++n;
        }
        System.out.println("FINISHED\n");
    }

    public void getSessionInfo() throws PKCS11Exception {
        System.out.println("get session info");
        System.out.println("Session Info: ");
        CK_SESSION_INFO cK_SESSION_INFO = this.myPKCS11Module_.C_GetSessionInfo(this.session_);
        System.out.println(cK_SESSION_INFO);
        System.out.println("FINISHED\n");
    }

    public void getSlotInfo() throws PKCS11Exception {
        System.out.println("getting slot list");
        long[] lArray = this.myPKCS11Module_.C_GetSlotList(false);
        int n = 0;
        while (n < lArray.length) {
            System.out.println("Slot Info: ");
            CK_SLOT_INFO cK_SLOT_INFO = this.myPKCS11Module_.C_GetSlotInfo(lArray[n]);
            System.out.println(cK_SLOT_INFO);
            ++n;
        }
        System.out.println("FINISHED\n");
    }

    public void getTokenInfo() throws PKCS11Exception {
        System.out.println("getting token list");
        long[] lArray = this.myPKCS11Module_.C_GetSlotList(true);
        int n = 0;
        while (n < lArray.length) {
            System.out.println("Token Info: ");
            CK_TOKEN_INFO cK_TOKEN_INFO = this.myPKCS11Module_.C_GetTokenInfo(lArray[n]);
            System.out.println(cK_TOKEN_INFO);
            if (this.token_ == -1L) {
                this.token_ = lArray[n];
            }
            ++n;
        }
        System.out.println("FINISHED\n");
    }

    public void initToken() throws PKCS11Exception {
        String string = "The Label!                      ";
        String string2 = "password";
        System.out.println("init token");
        long[] lArray = this.myPKCS11Module_.C_GetSlotList(false);
        this.myPKCS11Module_.C_InitToken(lArray[0], string2.toCharArray(), string.toCharArray());
        System.out.println("FINISHED");
    }

    public void initialize() throws PKCS11Exception {
        System.out.print("initializing... ");
        this.myPKCS11Module_.C_Initialize(null);
        System.out.println("FINISHED\n");
    }

    public void loginUser() throws PKCS11Exception {
        System.out.println("login user to session with password \"" + this.userPin_ + "\"");
        this.myPKCS11Module_.C_Login(this.session_, 1L, this.userPin_.toCharArray());
        System.out.println("FINISHED\n");
    }

    public void logout() throws PKCS11Exception {
        System.out.println("logout session");
        this.myPKCS11Module_.C_Logout(this.session_);
        System.out.println("FINISHED\n");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            SimpleTest.printUsage();
            System.exit(1);
        }
        try {
            SimpleTest simpleTest = new SimpleTest(stringArray[0], stringArray[1], new File(stringArray[2]));
            simpleTest.initialize();
            simpleTest.getInfo();
            simpleTest.getSlotInfo();
            simpleTest.getTokenInfo();
            simpleTest.getMechanismInfo();
            simpleTest.openROSession();
            simpleTest.getSessionInfo();
            simpleTest.findAllObjects();
            simpleTest.printAllObjects();
            simpleTest.loginUser();
            simpleTest.getSessionInfo();
            simpleTest.findAllObjects();
            simpleTest.printAllObjects();
            simpleTest.findSignatureKey();
            simpleTest.findCertificate();
            simpleTest.readCertificate();
            simpleTest.writeCertificateToFile();
            simpleTest.signData();
            simpleTest.writeSignatureToFile();
            simpleTest.digestData();
            simpleTest.writeDigestToFile();
            simpleTest.logout();
            simpleTest.closeSession();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void openROSession() throws PKCS11Exception {
        System.out.println("open RO session");
        this.session_ = this.myPKCS11Module_.C_OpenSession(this.token_, 4L, null, null);
        System.out.println("FINISHED\n");
    }

    public void printAllObjects() throws PKCS11Exception {
        System.out.println("print all objects");
        int n = 0;
        while (n < this.objects_.length) {
            System.out.println("object No. " + n);
            CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
            cK_ATTRIBUTEArray[0].type = 0L;
            this.myPKCS11Module_.C_GetAttributeValue(this.session_, this.objects_[n], cK_ATTRIBUTEArray);
            System.out.println("CKA_CLASS: " + Functions.classTypeToString((long)((Long)cK_ATTRIBUTEArray[0].pValue)));
            ++n;
        }
        System.out.println("FINISHED\n");
    }

    public static void printUsage() {
        System.out.println("Usage: SimepleTest <PKCS#11 module> <userPIN> <file to be signed>");
        System.out.println(" e.g.: SimpleTest pk2priv.dll password data.dat");
        System.out.println("The given DLL must be in the search path of the system.");
    }

    public void readCertificate() throws PKCS11Exception {
        System.out.println("read certificate");
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE()};
        cK_ATTRIBUTEArray[0].type = 17L;
        this.myPKCS11Module_.C_GetAttributeValue(this.session_, this.certificateHandle_, cK_ATTRIBUTEArray);
        this.derEncodedCertificate_ = (byte[])cK_ATTRIBUTEArray[0].pValue;
        System.out.println("DER encoded certificate (" + this.derEncodedCertificate_.length + " bytes):");
        System.out.println(Functions.toHexString((byte[])this.derEncodedCertificate_));
        System.out.println("FINISHED\n");
    }

    public void signData() throws IOException, PKCS11Exception {
        int n;
        byte[] byArray = new byte[1024];
        FileInputStream fileInputStream = new FileInputStream(this.file_);
        this.myPKCS11Module_.C_SignInit(this.session_, this.signatureMechanism_, this.signatureKeyHandle_);
        while ((n = ((InputStream)fileInputStream).read(byArray, 0, byArray.length)) >= 0) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            this.myPKCS11Module_.C_SignUpdate(this.session_, byArray2);
            Arrays.fill(byArray2, (byte)0);
        }
        Arrays.fill(byArray, (byte)0);
        this.signature_ = this.myPKCS11Module_.C_SignFinal(this.session_);
    }

    public void writeCertificateToFile() throws IOException, PKCS11Exception {
        System.out.println("write certificate to file: tokenCertificate.der");
        FileOutputStream fileOutputStream = new FileOutputStream(CERTIFICATE_FILE);
        fileOutputStream.write(this.derEncodedCertificate_);
        fileOutputStream.flush();
        fileOutputStream.close();
        System.out.println("FINISHED\n");
    }

    public void writeDigestToFile() throws IOException, PKCS11Exception {
        System.out.println("write digest to file: digest.dat");
        FileOutputStream fileOutputStream = new FileOutputStream(DIGEST_FILE);
        fileOutputStream.write(this.digest_);
        fileOutputStream.flush();
        fileOutputStream.close();
        System.out.println("FINISHED\n");
    }

    public void writeSignatureToFile() throws IOException, PKCS11Exception {
        System.out.println("write signature to file: signature.bin");
        FileOutputStream fileOutputStream = new FileOutputStream(SIGNATURE_FILE);
        fileOutputStream.write(this.signature_);
        fileOutputStream.flush();
        fileOutputStream.close();
        System.out.println("FINISHED");
    }
}

