/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.wrapper.CK_ATTRIBUTE;
import iaik.pkcs.pkcs11.wrapper.CK_DATE;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.Vector;

public class Util {
    public static CK_ATTRIBUTE[] convertAttributesVectorToArray(Vector vector) {
        if (vector == null) {
            return null;
        }
        int n = vector.size();
        CK_ATTRIBUTE[] cK_ATTRIBUTEArray = new CK_ATTRIBUTE[n];
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.elementAt(n2);
            cK_ATTRIBUTEArray[n2] = e instanceof CK_ATTRIBUTE ? (CK_ATTRIBUTE)e : null;
            ++n2;
        }
        return cK_ATTRIBUTEArray;
    }

    public static CK_DATE convertToCkDate(Date date) {
        CK_DATE cK_DATE = null;
        if (date != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            int n = gregorianCalendar.get(1);
            int n2 = gregorianCalendar.get(2) + 1;
            int n3 = gregorianCalendar.get(5);
            cK_DATE = new CK_DATE();
            cK_DATE.year = Util.toCharArray(n, 4);
            cK_DATE.month = Util.toCharArray(n2, 2);
            cK_DATE.day = Util.toCharArray(n3, 2);
        }
        return cK_DATE;
    }

    public static Date convertToDate(CK_DATE cK_DATE) {
        Date date = null;
        if (cK_DATE != null) {
            int n = Integer.parseInt(new String(cK_DATE.year));
            int n2 = Integer.parseInt(new String(cK_DATE.month));
            int n3 = Integer.parseInt(new String(cK_DATE.day));
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.set(n, n2 - 1, n3);
            date = gregorianCalendar.getTime();
        }
        return date;
    }

    public static Date parseTime(char[] cArray) {
        Date date;
        block2: {
            date = null;
            if (cArray == null || cArray.length <= 2) break block2;
            String string = new String(cArray, 0, cArray.length - 2);
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmss");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
                date = simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {}
        }
        return date;
    }

    public static char[] toCharArray(int n, int n2) {
        char[] cArray = null;
        String string = Integer.toString(n);
        char[] cArray2 = string.toCharArray();
        if (cArray2.length > n2) {
            cArray = new char[n2];
            int n3 = 0;
            while (n3 < cArray.length) {
                cArray[n3] = cArray2[n3];
                ++n3;
            }
        } else if (cArray2.length < n2) {
            cArray = new char[n2];
            int n4 = n2 - cArray2.length;
            int n5 = 0;
            while (n5 < cArray.length) {
                cArray[n5] = n5 < n4 ? 48 : cArray2[n5 - n4];
                ++n5;
            }
        } else {
            cArray = cArray2;
        }
        return cArray;
    }

    public static char[] toPaddedCharArray(String string, int n, char c) {
        char[] cArray = null;
        if (string != null) {
            int n2 = string.length();
            cArray = new char[n];
            string.getChars(0, Math.min(n2, n), cArray, 0);
            int n3 = n2;
            while (n3 < cArray.length) {
                cArray[n3] = c;
                ++n3;
            }
        }
        return cArray;
    }

    public static byte[] unsignedBigIntergerToByteArray(BigInteger bigInteger) {
        byte[] byArray;
        if (bigInteger == null) {
            return null;
        }
        byte[] byArray2 = bigInteger.toByteArray();
        if (byArray2.length > 0 && byArray2[0] == 0) {
            byArray = new byte[byArray2.length - 1];
            int n = 0;
            while (n < byArray.length) {
                byArray[n] = byArray2[n + 1];
                ++n;
            }
        } else {
            byArray = byArray2;
        }
        return byArray;
    }
}

