/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Key;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.objects.SecretKey;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class AESSecretKey
extends SecretKey {
    protected ByteArrayAttribute value_;
    protected LongAttribute valueLen_;

    public AESSecretKey() {
        this.keyType_.setLongValue(Key.KeyType.AES);
    }

    protected AESSecretKey(Session session, long l) throws TokenException {
        super(session, l);
        this.keyType_.setLongValue(Key.KeyType.AES);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        this.valueLen_ = new LongAttribute(Attribute.VALUE_LEN);
        AESSecretKey.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        AESSecretKey aESSecretKey = (AESSecretKey)super.clone();
        aESSecretKey.value_ = (ByteArrayAttribute)this.value_.clone();
        aESSecretKey.valueLen_ = (LongAttribute)this.valueLen_.clone();
        AESSecretKey.putAttributesInTable(aESSecretKey);
        return aESSecretKey;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof AESSecretKey) {
            AESSecretKey aESSecretKey = (AESSecretKey)object;
            bl = this == aESSecretKey || super.equals(aESSecretKey) && this.value_.equals(aESSecretKey.value_) && this.valueLen_.equals(aESSecretKey.valueLen_);
        }
        return bl;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        return new AESSecretKey(session, l);
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public LongAttribute getValueLen() {
        return this.valueLen_;
    }

    protected static void putAttributesInTable(AESSecretKey aESSecretKey) {
        if (aESSecretKey == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        aESSecretKey.attributeTable_.put(Attribute.VALUE, aESSecretKey.value_);
        aESSecretKey.attributeTable_.put(Attribute.VALUE_LEN, aESSecretKey.valueLen_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValue(session, this.objectHandle_, this.value_);
        Object.getAttributeValue(session, this.objectHandle_, this.valueLen_);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (hex): ");
        stringBuffer.append(this.value_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value Length (dec): ");
        stringBuffer.append(this.valueLen_.toString(10));
        return stringBuffer.toString();
    }
}

