/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.Clock;
import iaik.pkcs.pkcs11.objects.HardwareFeatureTypeAttribute;
import iaik.pkcs.pkcs11.objects.LongAttribute;
import iaik.pkcs.pkcs11.objects.MonotonicCounter;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

public class HardwareFeature
extends Object {
    protected static VendorDefinedHardwareFeatureBuilder vendorHardwareFeatureBuilder_;
    protected HardwareFeatureTypeAttribute hardwareFeatureType_;

    public HardwareFeature() {
        this.objectClass_.setLongValue(Object.ObjectClass.HW_FEATURE);
    }

    protected HardwareFeature(Session session, long l) throws TokenException {
        super(session, l);
        this.objectClass_.setLongValue(Object.ObjectClass.HW_FEATURE);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.hardwareFeatureType_ = new HardwareFeatureTypeAttribute();
        HardwareFeature.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        HardwareFeature hardwareFeature = (HardwareFeature)super.clone();
        hardwareFeature.hardwareFeatureType_ = (HardwareFeatureTypeAttribute)this.hardwareFeatureType_.clone();
        HardwareFeature.putAttributesInTable(hardwareFeature);
        return hardwareFeature;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof HardwareFeature) {
            HardwareFeature hardwareFeature = (HardwareFeature)object;
            bl = this == hardwareFeature || super.equals(hardwareFeature) && this.hardwareFeatureType_.equals(hardwareFeature.hardwareFeatureType_);
        }
        return bl;
    }

    public LongAttribute getHardwareFeatureType() {
        return this.hardwareFeatureType_;
    }

    public static String getHardwareFeatureTypeName(Long l) {
        if (l == null) {
            throw new NullPointerException("Argument \"hardwareFeatureType\" must not be null.");
        }
        String string = l.equals(FeatureType.MONOTONIC_COUNTER) ? "Monotonic Counter" : (l.equals(FeatureType.CLOCK) ? "Clock" : (l.equals(FeatureType.USER_INTERFACE) ? "User Interface" : ((l & FeatureType.VENDOR_DEFINED) != 0L ? "Vendor Defined" : "<unknown>")));
        return string;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        HardwareFeatureTypeAttribute hardwareFeatureTypeAttribute = new HardwareFeatureTypeAttribute();
        Object.getAttributeValue(session, l, hardwareFeatureTypeAttribute);
        Long l2 = hardwareFeatureTypeAttribute.getLongValue();
        Object object = hardwareFeatureTypeAttribute.isPresent() && l2 != null ? (l2.equals(FeatureType.MONOTONIC_COUNTER) ? MonotonicCounter.getInstance(session, l) : (l2.equals(FeatureType.CLOCK) ? Clock.getInstance(session, l) : (l2.equals(FeatureType.USER_INTERFACE) ? HardwareFeature.getUnknownHardwareFeature(session, l) : ((l2 & FeatureType.VENDOR_DEFINED) != 0L ? HardwareFeature.getUnknownHardwareFeature(session, l) : HardwareFeature.getUnknownHardwareFeature(session, l))))) : HardwareFeature.getUnknownHardwareFeature(session, l);
        return object;
    }

    protected static Object getUnknownHardwareFeature(Session session, long l) throws TokenException {
        Object object;
        if (session == null) {
            throw new NullPointerException("Argument \"session\" must not be null.");
        }
        if (vendorHardwareFeatureBuilder_ != null) {
            try {
                object = vendorHardwareFeatureBuilder_.build(session, l);
            }
            catch (PKCS11Exception pKCS11Exception) {
                object = new HardwareFeature(session, l);
            }
        } else {
            object = new HardwareFeature(session, l);
        }
        return object;
    }

    public static VendorDefinedHardwareFeatureBuilder getVendorDefinedHardwareFeatureBuilder() {
        return vendorHardwareFeatureBuilder_;
    }

    public int hashCode() {
        return this.hardwareFeatureType_.hashCode();
    }

    protected static void putAttributesInTable(HardwareFeature hardwareFeature) {
        if (hardwareFeature == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        hardwareFeature.attributeTable_.put(Attribute.HW_FEATURE_TYPE, hardwareFeature.hardwareFeatureType_);
    }

    public static void setVendorDefinedHardwareFeatureBuilder(VendorDefinedHardwareFeatureBuilder vendorDefinedHardwareFeatureBuilder) {
        vendorHardwareFeatureBuilder_ = vendorDefinedHardwareFeatureBuilder;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Hardware Feature Type: ");
        if (this.hardwareFeatureType_ != null) {
            stringBuffer.append(this.hardwareFeatureType_.toString());
        } else {
            stringBuffer.append("<unavailable>");
        }
        return stringBuffer.toString();
    }

    public static interface FeatureType {
        public static final Long MONOTONIC_COUNTER = new Long(1L);
        public static final Long CLOCK = new Long(2L);
        public static final Long USER_INTERFACE = new Long(3L);
        public static final Long VENDOR_DEFINED = new Long(0x80000000L);
    }

    public static interface VendorDefinedHardwareFeatureBuilder {
        public Object build(Session var1, long var2) throws PKCS11Exception;
    }
}

