/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.objects;

import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.Attribute;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.Certificate;
import iaik.pkcs.pkcs11.objects.Object;
import iaik.pkcs.pkcs11.wrapper.Constants;

public class X509AttributeCertificate
extends Certificate {
    protected ByteArrayAttribute owner_;
    protected ByteArrayAttribute acIssuer_;
    protected ByteArrayAttribute serialNumber_;
    protected ByteArrayAttribute attrTypes_;
    protected ByteArrayAttribute value_;

    public X509AttributeCertificate() {
        this.certificateType_.setLongValue(Certificate.CertificateType.X_509_ATTRIBUTE);
    }

    protected X509AttributeCertificate(Session session, long l) throws TokenException {
        super(session, l);
        this.certificateType_.setLongValue(Certificate.CertificateType.X_509_ATTRIBUTE);
    }

    protected void allocateAttributes() {
        super.allocateAttributes();
        this.owner_ = new ByteArrayAttribute(Attribute.OWNER);
        this.acIssuer_ = new ByteArrayAttribute(Attribute.AC_ISSUER);
        this.serialNumber_ = new ByteArrayAttribute(Attribute.SERIAL_NUMBER);
        this.attrTypes_ = new ByteArrayAttribute(Attribute.ATTR_TYPES);
        this.value_ = new ByteArrayAttribute(Attribute.VALUE);
        X509AttributeCertificate.putAttributesInTable(this);
    }

    public java.lang.Object clone() {
        X509AttributeCertificate x509AttributeCertificate = (X509AttributeCertificate)super.clone();
        x509AttributeCertificate.owner_ = (ByteArrayAttribute)this.owner_.clone();
        x509AttributeCertificate.acIssuer_ = (ByteArrayAttribute)this.acIssuer_.clone();
        x509AttributeCertificate.serialNumber_ = (ByteArrayAttribute)this.serialNumber_.clone();
        x509AttributeCertificate.attrTypes_ = (ByteArrayAttribute)this.attrTypes_.clone();
        x509AttributeCertificate.value_ = (ByteArrayAttribute)this.value_.clone();
        X509AttributeCertificate.putAttributesInTable(x509AttributeCertificate);
        return x509AttributeCertificate;
    }

    public boolean equals(java.lang.Object object) {
        boolean bl = false;
        if (object instanceof X509AttributeCertificate) {
            X509AttributeCertificate x509AttributeCertificate = (X509AttributeCertificate)object;
            bl = this == x509AttributeCertificate || super.equals(x509AttributeCertificate) && this.owner_.equals(x509AttributeCertificate.owner_) && this.acIssuer_.equals(x509AttributeCertificate.acIssuer_) && this.serialNumber_.equals(x509AttributeCertificate.serialNumber_) && this.attrTypes_.equals(x509AttributeCertificate.attrTypes_) && this.value_.equals(x509AttributeCertificate.value_);
        }
        return bl;
    }

    public ByteArrayAttribute getAcIssuer() {
        return this.acIssuer_;
    }

    public ByteArrayAttribute getAttrTypes() {
        return this.attrTypes_;
    }

    public static Object getInstance(Session session, long l) throws TokenException {
        return new X509AttributeCertificate(session, l);
    }

    public ByteArrayAttribute getOwner() {
        return this.owner_;
    }

    public ByteArrayAttribute getSerialNumber() {
        return this.serialNumber_;
    }

    public ByteArrayAttribute getValue() {
        return this.value_;
    }

    public int hashCode() {
        return this.acIssuer_.hashCode() ^ this.serialNumber_.hashCode();
    }

    protected static void putAttributesInTable(X509AttributeCertificate x509AttributeCertificate) {
        if (x509AttributeCertificate == null) {
            throw new NullPointerException("Argument \"object\" must not be null.");
        }
        x509AttributeCertificate.attributeTable_.put(Attribute.OWNER, x509AttributeCertificate.owner_);
        x509AttributeCertificate.attributeTable_.put(Attribute.AC_ISSUER, x509AttributeCertificate.acIssuer_);
        x509AttributeCertificate.attributeTable_.put(Attribute.SERIAL_NUMBER, x509AttributeCertificate.serialNumber_);
        x509AttributeCertificate.attributeTable_.put(Attribute.ATTR_TYPES, x509AttributeCertificate.attrTypes_);
        x509AttributeCertificate.attributeTable_.put(Attribute.VALUE, x509AttributeCertificate.value_);
    }

    public void readAttributes(Session session) throws TokenException {
        super.readAttributes(session);
        Object.getAttributeValues(session, this.objectHandle_, new Attribute[]{this.owner_, this.acIssuer_, this.serialNumber_, this.attrTypes_, this.value_});
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(super.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Owner (DER, hex): ");
        stringBuffer.append(this.owner_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Attribute Certificate Issuer (DER, hex): ");
        stringBuffer.append(this.acIssuer_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Serial Number (DER, hex): ");
        stringBuffer.append(this.serialNumber_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Attribute Types (BER, hex): ");
        stringBuffer.append(this.attrTypes_.toString());
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Value (BER, hex): ");
        stringBuffer.append(this.value_.toString());
        return stringBuffer.toString();
    }
}

