/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.CK_PKCS5_PBKD2_PARAMS;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class PKCS5PBKD2Parameters
implements Parameters {
    protected long saltSource_;
    protected byte[] saltSourceData_;
    protected long iterations_;
    protected long pseudoRandomFunction_;
    protected byte[] pseudoRandomFunctionData_;

    public PKCS5PBKD2Parameters(long l, byte[] byArray, long l2, long l3, byte[] byArray2) {
        if (l != 1L) {
            throw new IllegalArgumentException("Illegal value for argument\"saltSource\": " + Functions.toHexString(l));
        }
        if (byArray == null) {
            throw new NullPointerException("Argument \"saltSourceData\" must not be null.");
        }
        if (l3 != 1L) {
            throw new IllegalArgumentException("Illegal value for argument\"pseudoRandomFunction\": " + Functions.toHexString(l3));
        }
        if (byArray2 == null) {
            throw new NullPointerException("Argument \"pseudoRandomFunctionData\" must not be null.");
        }
        this.saltSource_ = l;
        this.saltSourceData_ = byArray;
        this.iterations_ = l2;
        this.pseudoRandomFunction_ = l3;
        this.pseudoRandomFunctionData_ = byArray2;
    }

    public Object clone() {
        PKCS5PBKD2Parameters pKCS5PBKD2Parameters;
        try {
            pKCS5PBKD2Parameters = (PKCS5PBKD2Parameters)super.clone();
            pKCS5PBKD2Parameters.saltSourceData_ = (byte[])this.saltSourceData_.clone();
            pKCS5PBKD2Parameters.pseudoRandomFunctionData_ = (byte[])this.pseudoRandomFunctionData_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return pKCS5PBKD2Parameters;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof PKCS5PBKD2Parameters) {
            PKCS5PBKD2Parameters pKCS5PBKD2Parameters = (PKCS5PBKD2Parameters)object;
            bl = this == pKCS5PBKD2Parameters || this.saltSource_ == pKCS5PBKD2Parameters.saltSource_ && Functions.equals(this.saltSourceData_, pKCS5PBKD2Parameters.saltSourceData_) && this.iterations_ == pKCS5PBKD2Parameters.iterations_ && this.pseudoRandomFunction_ == pKCS5PBKD2Parameters.pseudoRandomFunction_ && Functions.equals(this.pseudoRandomFunctionData_, pKCS5PBKD2Parameters.pseudoRandomFunctionData_);
        }
        return bl;
    }

    public long getIterations() {
        return this.iterations_;
    }

    public Object getPKCS11ParamsObject() {
        CK_PKCS5_PBKD2_PARAMS cK_PKCS5_PBKD2_PARAMS = new CK_PKCS5_PBKD2_PARAMS();
        cK_PKCS5_PBKD2_PARAMS.saltSource = this.saltSource_;
        cK_PKCS5_PBKD2_PARAMS.pSaltSourceData = this.saltSourceData_;
        cK_PKCS5_PBKD2_PARAMS.iterations = this.iterations_;
        cK_PKCS5_PBKD2_PARAMS.prf = this.pseudoRandomFunction_;
        cK_PKCS5_PBKD2_PARAMS.pPrfData = this.pseudoRandomFunctionData_;
        return cK_PKCS5_PBKD2_PARAMS;
    }

    public long getPseudoRandomFunction() {
        return this.pseudoRandomFunction_;
    }

    public byte[] getPseudoRandomFunctionData() {
        return this.pseudoRandomFunctionData_;
    }

    public long getSaltSource() {
        return this.saltSource_;
    }

    public byte[] getSaltSourceData() {
        return this.saltSourceData_;
    }

    public int hashCode() {
        return (int)this.saltSource_ ^ Functions.hashCode(this.saltSourceData_) ^ (int)this.iterations_ ^ (int)this.pseudoRandomFunction_ ^ Functions.hashCode(this.pseudoRandomFunctionData_);
    }

    public void setIterations(long l) {
        this.iterations_ = l;
    }

    public void setPseudoRandomFunction(long l) {
        if (l != 1L) {
            throw new IllegalArgumentException("Illegal value for argument\"pseudoRandomFunction\": " + Functions.toHexString(l));
        }
        this.pseudoRandomFunction_ = l;
    }

    public void setPseudoRandomFunctionData(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"pseudoRandomFunctionData\" must not be null.");
        }
        this.pseudoRandomFunctionData_ = byArray;
    }

    public void setSaltSource(long l) {
        if (l != 1L) {
            throw new IllegalArgumentException("Illegal value for argument\"saltSource\": " + Functions.toHexString(l));
        }
        this.saltSource_ = l;
    }

    public void setSaltSourceData(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"saltSourceData\" must not be null.");
        }
        this.saltSourceData_ = byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ");
        stringBuffer.append("Salt Source: ");
        if (this.saltSource_ == 1L) {
            stringBuffer.append("Salt Specified");
        } else {
            stringBuffer.append("<unknown>");
        }
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Salt Source Data (hex): ");
        stringBuffer.append(Functions.toHexString(this.saltSourceData_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Iterations (dec): ");
        stringBuffer.append(this.iterations_);
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Pseudo-Random Function: ");
        if (this.pseudoRandomFunction_ == 1L) {
            stringBuffer.append("HMAC SHA-1");
        } else {
            stringBuffer.append("<unknown>");
        }
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Pseudo-Random Function Data (hex): ");
        stringBuffer.append(Functions.toHexString(this.pseudoRandomFunctionData_));
        return stringBuffer.toString();
    }

    public static interface PseudoRandomFunctionType {
        public static final long HMAC_SHA1 = 1L;
    }

    public static interface SaltSourceType {
        public static final long SALT_SPECIFIED = 1L;
    }
}

