/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.parameters;

import iaik.pkcs.pkcs11.TokenRuntimeException;
import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.CK_SKIPJACK_PRIVATE_WRAP_PARAMS;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class SkipJackPrivateWrapParameters
implements Parameters {
    protected byte[] password_;
    protected byte[] publicData_;
    protected byte[] randomA_;
    protected byte[] primeP_;
    protected byte[] baseG_;
    protected byte[] subprimeQ_;

    public SkipJackPrivateWrapParameters(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"password\" must not be null.");
        }
        if (byArray2 == null) {
            throw new NullPointerException("Argument \"publicData\" must not be null.");
        }
        if (byArray3 == null) {
            throw new NullPointerException("Argument \"randomA\" must not be null.");
        }
        if (byArray4 == null) {
            throw new NullPointerException("Argument \"primeP\" must not be null.");
        }
        if (byArray5 == null) {
            throw new NullPointerException("Argument \"baseG\" must not be null.");
        }
        if (byArray6 == null) {
            throw new NullPointerException("Argument \"subprimeQ\" must not be null.");
        }
        this.password_ = byArray;
        this.publicData_ = byArray2;
        this.randomA_ = byArray3;
        this.primeP_ = byArray4;
        this.baseG_ = byArray5;
        this.subprimeQ_ = byArray6;
    }

    public Object clone() {
        SkipJackPrivateWrapParameters skipJackPrivateWrapParameters;
        try {
            skipJackPrivateWrapParameters = (SkipJackPrivateWrapParameters)super.clone();
            skipJackPrivateWrapParameters.password_ = (byte[])this.password_.clone();
            skipJackPrivateWrapParameters.publicData_ = (byte[])this.publicData_.clone();
            skipJackPrivateWrapParameters.randomA_ = (byte[])this.randomA_.clone();
            skipJackPrivateWrapParameters.primeP_ = (byte[])this.primeP_.clone();
            skipJackPrivateWrapParameters.baseG_ = (byte[])this.baseG_.clone();
            skipJackPrivateWrapParameters.subprimeQ_ = (byte[])this.subprimeQ_.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TokenRuntimeException("An unexpected clone exception occurred.", cloneNotSupportedException);
        }
        return skipJackPrivateWrapParameters;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SkipJackPrivateWrapParameters) {
            SkipJackPrivateWrapParameters skipJackPrivateWrapParameters = (SkipJackPrivateWrapParameters)object;
            bl = this == skipJackPrivateWrapParameters || Functions.equals(this.password_, skipJackPrivateWrapParameters.password_) && Functions.equals(this.publicData_, skipJackPrivateWrapParameters.publicData_) && Functions.equals(this.randomA_, skipJackPrivateWrapParameters.randomA_) && Functions.equals(this.primeP_, skipJackPrivateWrapParameters.primeP_) && Functions.equals(this.baseG_, skipJackPrivateWrapParameters.baseG_) && Functions.equals(this.subprimeQ_, skipJackPrivateWrapParameters.subprimeQ_);
        }
        return bl;
    }

    public byte[] getBaseG() {
        return this.baseG_;
    }

    public Object getPKCS11ParamsObject() {
        CK_SKIPJACK_PRIVATE_WRAP_PARAMS cK_SKIPJACK_PRIVATE_WRAP_PARAMS = new CK_SKIPJACK_PRIVATE_WRAP_PARAMS();
        cK_SKIPJACK_PRIVATE_WRAP_PARAMS.pPassword = this.password_;
        cK_SKIPJACK_PRIVATE_WRAP_PARAMS.pPublicData = this.publicData_;
        cK_SKIPJACK_PRIVATE_WRAP_PARAMS.pRandomA = this.randomA_;
        cK_SKIPJACK_PRIVATE_WRAP_PARAMS.pPrimeP = this.primeP_;
        cK_SKIPJACK_PRIVATE_WRAP_PARAMS.pBaseG = this.baseG_;
        cK_SKIPJACK_PRIVATE_WRAP_PARAMS.pSubprimeQ = this.subprimeQ_;
        return cK_SKIPJACK_PRIVATE_WRAP_PARAMS;
    }

    public byte[] getPassword() {
        return this.password_;
    }

    public byte[] getPrimeP() {
        return this.primeP_;
    }

    public byte[] getPublicData() {
        return this.publicData_;
    }

    public byte[] getRandomA() {
        return this.randomA_;
    }

    public byte[] getSubprimeQ() {
        return this.subprimeQ_;
    }

    public int hashCode() {
        return Functions.hashCode(this.password_) ^ Functions.hashCode(this.publicData_) ^ Functions.hashCode(this.randomA_) ^ Functions.hashCode(this.primeP_) ^ Functions.hashCode(this.baseG_) ^ Functions.hashCode(this.subprimeQ_);
    }

    public void setBaseG(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"baseG\" must not be null.");
        }
        this.baseG_ = byArray;
    }

    public void setPassword(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"password\" must not be null.");
        }
        this.password_ = byArray;
    }

    public void setPrimeP(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"primeP\" must not be null.");
        }
        this.primeP_ = byArray;
    }

    public void setPublicData(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"publicData\" must not be null.");
        }
        this.publicData_ = byArray;
    }

    public void setRandomA(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"randomA\" must not be null.");
        }
        this.randomA_ = byArray;
    }

    public void setSubprimeQ(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Argument \"subprimeQ\" must not be null.");
        }
        this.subprimeQ_ = byArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  ");
        stringBuffer.append("Passord (hex): ");
        stringBuffer.append(Functions.toHexString(this.password_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Public Data (hex): ");
        stringBuffer.append(Functions.toHexString(this.publicData_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Random Data A (hex): ");
        stringBuffer.append(Functions.toHexString(this.randomA_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Prime P (hex): ");
        stringBuffer.append(Functions.toHexString(this.primeP_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Base G (hex): ");
        stringBuffer.append(Functions.toHexString(this.baseG_));
        stringBuffer.append(Constants.NEWLINE);
        stringBuffer.append("  ");
        stringBuffer.append("Subprime Q (hex): ");
        stringBuffer.append(Functions.toHexString(this.subprimeQ_));
        return stringBuffer.toString();
    }
}

