/********************************************************************

   Module Name:     SampleConsumer.java
   Creation Date:   10/15/97
   Description:     Sample InfoBusDataConsumer example -- can dump ImmediateAccess,
                    ArrayAccess, RowsetAccess and DbAccess.

*********************************************************************/

/*
 * Copyright (c) 1997-1998 Lotus Development Corporation. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of 
 * Lotus Development Corporation ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Lotus.
 *
 * LOTUS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. LOTUS SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */




import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.util.*;
import java.io.*;
import java.beans.*;
import java.sql.Types;
import java.sql.SQLException;

import javax.infobus.*;


public class SampleConsumer 
	   extends		Applet
	   implements	InfoBusMember, InfoBusDataProducer, InfoBusDataConsumer,
                    DataItemChangeListener,
                    ActionListener, ItemListener
{
	private String		WHOAMI="SampleConsumer";

    private InfoBusMemberSupport   m_ibmImpl;

	private boolean		debug=false;
    private boolean     setInfoBusDebug=false;

    private Panel       panelGeneral;
	private Panel		panelWatch;
	private Panel		panelGet;
	private Panel		panelBasicAccess;
	private Panel		panelRowsetAccess;
	private Panel		panelMsgs;

	private String		m_watchItemName=null;
    private Object      m_watchItem=null;
    private String      m_getItemName=null;
	private TextField	textFieldWatch=null;
	private TextField	textFieldGet=null;

	private Choice		choiceDump=null;
	private static final int    DUMP_NONE     = 0;
	private static final int    DUMP_SPECIFIED = 1;
	private static final int    DUMP_ALL      = 2;
	private int			        dump = DUMP_ALL; // HTML <PARAM> can override
    private static final String dumpChoices[]={"None", "Specified", "All"};
    private static final int    CHOICE_DUMP_WIDEST_ITEMX=1; // "Specified"

	private Checkbox	checkboxVerbose=null;
	private Checkbox	checkboxImmediate=null;
	private Checkbox	checkboxArray=null;
	private Checkbox	checkboxRowset=null;
    private Checkbox    checkboxModifyRowset=null;
	private Checkbox	checkboxScrollableRowset=null;
	private Checkbox	checkboxForwards=null;
	private Checkbox	checkboxBackwards=null;
	private Checkbox	checkboxAbsolute=null;
	private Checkbox	checkboxDb=null;

	private Button		buttonGetData=null;
	
	private TextArea	textAreaMsgs;
	
	private Button		buttonClear=null;

	private Font		m_defaultFont=null;
	private Font		m_labelsFont=null;
	private int			m_fontSize=12;

    private int         m_testCounter=0;
    private boolean     m_showedRowsetShape=false;

	private FileWriter         m_fileWriter = null;
	private PrintWriter        m_printWriter = null;
	private boolean            m_writeFile = false;

    StringBuffer m_line = new StringBuffer(255);

    public void init() 
	{
		String	s;
		Label	l;
        boolean b;

        m_ibmImpl = new InfoBusMemberSupport ( this );

		if ( (s = getParameter("FileOut")) != null)
		{
		   try 
		   {
		      m_fileWriter = new FileWriter (s);
		      if (m_fileWriter != null)
		      {
                  // enable auto-flush (flushes buffer on every println)
		         m_printWriter = new PrintWriter(m_fileWriter, true);
		         m_writeFile = true;
		      }
		      
		   }
		   catch (IOException ioe)
		   {
		      System.err.println(" Error:  Unable to open file " + s + " for writing: " + ioe);
		   }
		}
		if ( (s = getParameter("WatchDataItemName")) != null)
			m_watchItemName=s;
		   
		if ( (s = getParameter("GetDataItemName")) != null)
			m_getItemName=s;

		if ( (s = getParameter("Dump")) != null)
		{
			if (s.equalsIgnoreCase(dumpChoices[DUMP_NONE]))
				dump = DUMP_NONE;
			else
			if (s.equalsIgnoreCase(dumpChoices[DUMP_SPECIFIED]))
				dump = DUMP_SPECIFIED;
			else
			if (s.equalsIgnoreCase(dumpChoices[DUMP_ALL]))
				dump = DUMP_ALL;
		}

		if ( (s = getParameter("FontSize")) != null)
		{
			try	
			{
				m_fontSize = Integer.parseInt(s);
			}
			catch (Exception e)
			{
			}
		}

		if (m_fontSize<4)
			m_fontSize=4;
		else
		if (m_fontSize>36)
			m_fontSize=36;
        m_defaultFont = new Font("Dialog", Font.PLAIN, m_fontSize);
        m_labelsFont  = new Font("Dialog", Font.BOLD, m_fontSize);
		setFont(m_defaultFont);

        //get InfoBus
        s = getParameter("IBNAME");
        if ( null == s )
        {
            //add default InfoBus with this as component
            try
            {
                m_ibmImpl.joinInfoBus(this);
            }
            catch ( InfoBusMembershipException ibme )
            {
                // throw by joinInfoBus means IB already set
            }
            catch ( PropertyVetoException ibme )
            {
                // throw by joinInfoBus means IB already set
            }
        }
        else
        {
            // add named InfoBus
            try
            {
                m_ibmImpl.joinInfoBus(s);
            }
            catch ( InfoBusMembershipException ibme )
            {
                // throw by joinInfoBus means IB already set
            }
            catch ( PropertyVetoException ibme )
            {
                // throw by joinInfoBus means IB already set
            }
        }

        // register as a PropListener in our m_ibmImpl's InfoBus
        m_ibmImpl.addInfoBusPropertyListener ( this );

		if ( null == m_ibmImpl.getInfoBus() ) 
		{
			teeErrPrint(WHOAMI+":  init failed to obtain InfoBus");
		}

		// Calculate reasonable size for text fields and text areas:
		// Dimension d = size();   // JDK 1.0 // dimension of this applet
		Dimension d = getSize();   // JDK 1.1 // dimension of this applet
		int h, w0, w, r, c0, c, x;      // height, width, rows, columns, misc var

		h = (d.height>>2)*3;	// use 3/4 of applet height for msgs area
        w0 = d.width;           // will use nealy full width for msgs area
		w = (d.width >>3)*7;	// use 7/8 of applet width for text boxes, etc.
        FontMetrics f = getFontMetrics(getFont()); // to estimate #chars that fit
		r = h / f.getHeight();		// rows in msgs area
        c0 = w0 / f.charWidth('n')-4; // columns in msgs area
		c = w / f.charWidth('n');	// columns text fields etc.

        panelGeneral = new Panel();
		panelGeneral.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 1));
		panelGeneral.setFont(m_defaultFont);

        if ( (s = getParameter("setInfoBusDebug")) != null)
        {
            if (s.equals("true"))
                setInfoBusDebug = true;
            else 
            if (s.equals("false"))
                setInfoBusDebug = false;
        }

        checkboxVerbose = new Checkbox("verbose");
		checkboxVerbose.setState(boolFromParam("verbose", false));
        checkboxVerbose.setFont(m_defaultFont);
		panelGeneral.add(checkboxVerbose);

		panelWatch = new Panel();
		panelWatch.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 1));
		panelWatch.setFont(m_defaultFont);
        l = new Label("Watch", Label.LEFT);
		l.setFont(m_labelsFont);

        // Do not make textFieldWatch yet, first make fixed width items:
		choiceDump = new Choice();
        for (int i=0; i<dumpChoices.length; i++)
    		choiceDump.addItem(dumpChoices[i]);
	    choiceDump.select(dump);
        // Add this as ItemListener after setting the initial selection
        choiceDump.addItemListener(this);

        x = c - (   l.getText().length() + 20 + 
                    choiceDump.getItem(CHOICE_DUMP_WIDEST_ITEMX).length()
                );
        if (x<16)
			x=16;
		textFieldWatch = new TextField(x);
		textFieldWatch.setFont(m_defaultFont);
        if (m_watchItemName!=null)
    		textFieldWatch.setText(m_watchItemName);

		panelWatch.add (l);
		panelWatch.add(textFieldWatch);
        panelWatch.add(choiceDump);

		panelGet = new Panel();
		panelGet.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 1));
		panelGet.setFont(m_defaultFont);

		// Create buttons; note that we use getLabel for length calculation:
		buttonGetData = new Button("GetData");
		buttonGetData.setFont(m_labelsFont);
        buttonGetData.addActionListener(this);

		l = new Label("Get", Label.LEFT);
		l.setFont(m_labelsFont);
		panelGet.add(l);
        /*
        x = c - (   l.getText().length() + 4 + 
                    buttonGetData.getLabel().length() + 8
                );
                */
		if (x<16)
			x=16;
		textFieldGet = new TextField(x);
		textFieldGet.setFont(m_defaultFont);
        if (m_getItemName!=null)
    		textFieldGet.setText(m_getItemName);
		panelGet.add(textFieldGet);
		panelGet.add(buttonGetData);
        textFieldGet.addActionListener(this);

		panelBasicAccess = new Panel();
		panelBasicAccess.setLayout(new FlowLayout(FlowLayout.LEFT, 1, 1));
		panelBasicAccess.setFont(m_defaultFont);

		l = new Label("SHOW");
		l.setFont(m_labelsFont);
		panelBasicAccess.add(l);

		checkboxImmediate = new Checkbox("Immediate");
		checkboxImmediate.setState(boolFromParam("dumpImmediate", true));
        checkboxImmediate.setFont(m_labelsFont);
		panelBasicAccess.add(checkboxImmediate);

		checkboxArray = new Checkbox("Array");
		checkboxArray.setState(boolFromParam("dumpArray", true));
        checkboxArray.setFont(m_labelsFont);
		panelBasicAccess.add(checkboxArray);

        checkboxDb = new Checkbox("Db");
		checkboxDb.setState(boolFromParam("dumpDb", true));
        checkboxDb.setFont(m_labelsFont);
    	panelBasicAccess.add(checkboxDb);

		panelRowsetAccess = new Panel();
		panelRowsetAccess.setLayout(new FlowLayout(FlowLayout.LEFT, 1, 1));
		panelRowsetAccess.setFont(m_defaultFont);

		checkboxRowset = new Checkbox("Rowset");
		checkboxRowset.setState(boolFromParam("dumpRowset", true));
        checkboxRowset.setFont(m_labelsFont);
		panelRowsetAccess.add(checkboxRowset);

        checkboxModifyRowset = new Checkbox("modify");
		checkboxModifyRowset.setState(boolFromParam("modify", false));
        checkboxModifyRowset.setFont(m_defaultFont);
		panelRowsetAccess.add(checkboxModifyRowset);

		checkboxScrollableRowset = new Checkbox("Scrollable");
		checkboxScrollableRowset.setState(boolFromParam("dumpScrollableRowset", true));
        checkboxScrollableRowset.setFont(m_labelsFont);
		panelRowsetAccess.add(checkboxScrollableRowset);

		checkboxForwards = new Checkbox("forward");
		checkboxForwards.setState(boolFromParam("forwards", true));
        checkboxForwards.setFont(m_defaultFont);
		panelRowsetAccess.add(checkboxForwards);

		checkboxBackwards = new Checkbox("backward");
		checkboxBackwards.setState(boolFromParam("backwards", true));
        checkboxBackwards.setFont(m_defaultFont);
		panelRowsetAccess.add(checkboxBackwards);

		checkboxAbsolute = new Checkbox("absolute");
		checkboxAbsolute.setState(boolFromParam("absolute", true));
        checkboxAbsolute.setFont(m_defaultFont);
		panelRowsetAccess.add(checkboxAbsolute);


        buttonClear = new Button("Clear Messages");
		buttonClear.setFont(m_labelsFont);
        buttonClear.addActionListener(this);

        panelMsgs = new Panel();
		panelMsgs.setLayout(new BorderLayout());
		panelMsgs.setFont(m_defaultFont);
		//panelMsgs.add("North", buttonClear);
        panelGeneral.add(buttonClear);
		panelMsgs.add("North", panelGeneral);
		textAreaMsgs = new TextArea(r, c0);
		textAreaMsgs.setFont(m_defaultFont);
		panelMsgs.add("Center", textAreaMsgs);

		setLayout(new FlowLayout(FlowLayout.CENTER, 1, 1));
		/// add(panelGeneral);
		add(panelWatch);
		add(panelGet);
		add(panelBasicAccess);
        add(panelRowsetAccess);
		add(panelMsgs);
    }

    public void start()
    {
        InfoBus ib = m_ibmImpl.getInfoBus();
        if (null != ib) 
        {
            msgnl("Adding SampleConsumer as DataProducer and DataConsumer to bus named \""+ ib.getName()+ "\"");
            ib.addDataProducer(this);
            ib.addDataConsumer(this);
        }

        // If we are watching for an item, and haven't found it yet, try to find it
		if (m_watchItemName!=null && m_watchItem==null)
        {
    		m_watchItem = m_ibmImpl.getInfoBus().findDataItem(m_watchItemName, null, this);
            if (m_watchItem!=null)
            {
                msgnl(WHOAMI+"::start(): found watch item {" + m_watchItemName + "}:");
        		switch(dump)
	        	{
		        case DUMP_ALL:
    		    case DUMP_SPECIFIED:
       	    	    showDataItem("", m_watchItem);
            		msgnl("");
    	    	case DUMP_NONE:
	    	    default:
                }
		    }
        }

        // Add (initial start) or re-add (stop and later start) ourself as
        // change listener on watch item if appropriate:
        if (m_watchItem!=null && m_watchItem instanceof DataItemChangeManager)
            ((DataItemChangeManager)m_watchItem).addDataItemChangeListener(this);
    }
    
    public void stop()
    {
        if (m_watchItem!=null && m_watchItem instanceof DataItemChangeManager)
        {
            msgnl("Removing SampleConsumer as DataItemChangeListener from item {"+
                m_watchItemName+"}");
            ( (DataItemChangeManager) m_watchItem).removeDataItemChangeListener(this);
        }
        InfoBus ib = m_ibmImpl.getInfoBus();
        if (null != ib) 
        {
            msgnl("Removing SampleConsumer as DataProducer and DataConsumer from bus "+ ib.getName());
            ib.removeDataProducer(this);
            ib.removeDataConsumer(this);
        }
    }


    public void destroy()
    {
        // free up our InfoBus
        try
        {
            m_ibmImpl.leaveInfoBus();
        }
        catch ( InfoBusMembershipException e )
        {
            System.err.println("SampleConsumer.destroy():  Error leaving InfoBus: "
                + e.toString() );
        }
        catch ( PropertyVetoException pve )
        {
            System.err.println("SampleConsumer.destroy() Warning: leaveInfoBus "
                +"produced PropertyVetoException." );
        }

        // close printstream
	   if (m_printWriter != null)
	   {
	      m_printWriter.close();
	   }
    }

	
	private void teeErrPrint(String s)
	//use instead of System.err.println to capture output to FileOut file
	{
	   if ( m_writeFile && ( m_printWriter != null ))
	   {
	      m_printWriter.println(s);
	   }
	   System.err.println(s);
	}

	private void teeOutPrint(String s)
	//use instead of System.out.println to capture output to FileOut file
	{
	   if ( m_writeFile && ( m_printWriter != null ))
	   {
	      m_printWriter.println(s);
	   }
	   System.out.println(s);
	}

    /////////////////////////////////
    //      InfoBusMember methods
    
    public InfoBus getInfoBus()
    {
        return m_ibmImpl.getInfoBus();
    }

    public void setInfoBus (InfoBus b) throws PropertyVetoException
    {
        m_ibmImpl.setInfoBus ( b );
    }

    public void addInfoBusVetoableListener(VetoableChangeListener l)
    {
        m_ibmImpl.addInfoBusVetoableListener ( l );
    }

    public void removeInfoBusVetoableListener(VetoableChangeListener l)
    {
        m_ibmImpl.removeInfoBusVetoableListener ( l );
    }
    
     public void addInfoBusPropertyListener(PropertyChangeListener l)
    {
        m_ibmImpl.addInfoBusPropertyListener ( l );
    }

    public void removeInfoBusPropertyListener(PropertyChangeListener l)
    {
        m_ibmImpl.removeInfoBusPropertyListener ( l );
    }


    /////////////////////////////////
    // InfoBusDataConsumer methods

    public void dataItemRevoked ( InfoBusItemRevokedEvent e )
    {
        String itemName = e.getDataItemName();

        msg ( "InfoBusItemRevoked: { "+ itemName + " } from "+
            e.getSource().toString() + "\n" );

    }

	public void dataItemAvailable (InfoBusItemAvailableEvent e)
	{
		String itemName;
		Object item;
        boolean isItemToWatch=false;

		itemName = e.getDataItemName();

        msg ( WHOAMI+"::dataItemAvailable: { "+ itemName + " } from "+
            e.getSource().toString() + "\n" );

		// Get the just announced DataItem:
		item = e.requestDataItem( this, null );
		itemName = textFieldWatch.getText();
		if (itemName!=null && e.getDataItemName().equals(itemName))
            isItemToWatch=true;

		switch(dump)
		{
		case DUMP_ALL:
    			showDataItem("", item);
				break;
		case DUMP_SPECIFIED:
            if (isItemToWatch)
    		    showDataItem("", item);
		case DUMP_NONE:
		default:
		}
		msgnl("");

        if (isItemToWatch && item instanceof DataItemChangeManager)
            ((DataItemChangeManager)item).addDataItemChangeListener(this);
	}


    //////////////////////////////////
    //  InfoBusDataProducer methods

	public void dataItemRequested(InfoBusItemRequestedEvent e)
    {
		msg ("dataItemRequested:  {"  +	e.getDataItemName() + "}"
				+"\n   from:  "+e.getSource().toString() + "\n");
	}


    public void propertyChange ( PropertyChangeEvent pce )
    {
        String s = pce.getPropertyName();
        if ( ! s.equals("InfoBus") )
        {
            return;
        }

        Object oldVal = pce.getOldValue();
        Object newVal = pce.getNewValue();

        if ( oldVal == newVal )
        {
            return;
        }

        //note that either old or new value may validly be NULL

        if ( oldVal != null && oldVal instanceof InfoBus )
        {
            ((InfoBus) oldVal).removeDataProducer ( this );
            ((InfoBus) oldVal).removeDataConsumer ( this );
        }

        if ( newVal != null && newVal instanceof InfoBus )
        {
            ((InfoBus) newVal).addDataProducer ( this );
            ((InfoBus) newVal).addDataConsumer ( this );
        }
    }
    
    /////////////////////////////////////////
    //  DataItemChangeListener methods
	private void dataItemChange ( DataItemChangeEvent dice )
	{
        String whoami = WHOAMI+".dataItemChange";
        Object source = dice.getSource();
        Object changedItem = dice.getChangedItem();
		Object item;
        String itemName=m_watchItemName;


        msgnl(whoami+"("+itemName+")");
        msgnl("\tfrom "+source.toString());
        msgnl("\tgetChangedItem()="+changedItem.toString());

        if ( dice instanceof DataItemValueChangedEvent )
		{
            msgnl("\tDataItemValueChangedEvent");
		}
		else if ( dice instanceof DataItemDeletedEvent )
		{
            msgnl("\tDataItemValueDeletedEvent");
		}
		else if ( dice instanceof DataItemRevokedEvent )
		{
            msgnl("\tDataItemRevoked");
		}
		else if ( dice instanceof DataItemAddedEvent )
		{
            msgnl("\tDataItemAddedEvent");
		}
		else if ( dice instanceof RowsetCursorMovedEvent )
		{
            msgnl("\tRowsetCursorMovedEvent");
		}
    
		msgnl("");

        if (true)
        {
    		switch(dump)
    		{
    		case DUMP_ALL:
    		case DUMP_SPECIFIED:
       			showDataItem("", changedItem);
    		case DUMP_NONE:
	    	default:
		    }
        }
	}

	/**
	* Indicates a changed value in the data item.  A reference to the 
	* data item that changed can be obtained from the event.
	* @param event contains change information
	*/
	public void dataItemValueChanged(DataItemValueChangedEvent event)
	{
		dataItemChange( event );
	}

	/**
	* Indicates that a new item was added to an aggregate data item 
	* (ArrayAccess, a JDK Collection, etc).  A reference to the data item 
	* that was added, and a reference to the one that gained it, can be 
	* obtained from the event.
	* @param event contains details of the addition
	*/
	public void dataItemAdded(DataItemAddedEvent event)
	{
		dataItemChange( event );
	}


	/**
	* Indicates that an item was deleted from an aggregate data item 
	* (ArrayAccess, a JDK Collection, etc).  A reference to the data item 
	* that was deleted, and a reference to the one that lost it, can be 
	* obtained from the event.
	* @param event contains details of the deletion
	*/
	public void dataItemDeleted(DataItemDeletedEvent event)
	{
		dataItemChange( event );
	}



	/** 
	* Indicates that an item (and its sub-items, if any) has been revoked, 
	* and is temporarily unavailable.  A reference to the data item that 
	* was revoked can be obtained from the event.
	* @param event contains details of the revoked data
	*/
	public void dataItemRevoked(DataItemRevokedEvent event)
	{
		dataItemChange( event );
	}



	/**
	* Indicates that the cursor for a RowsetAccess item has changed.   
	* A reference to the rowset data item can be obtained from the event.
	* @param event contains details of the cursor move
	*/
	public void rowsetCursorMoved(RowsetCursorMovedEvent event)
	{
		dataItemChange( event );
	}


    //
    // end of IB interface methods
    ///////////////////////////////////////////

    private Object findDataItem(TextField tf)
	{
		// Try to get the specified data item

		Object dataItem = null;

		String itemName = tf.getText();
		if (itemName==null || itemName.equals(""))
		{
			msgnl(WHOAMI+":: DataItemName is null/blank");
			return dataItem;
		}

		msgnl(WHOAMI+": findDataItem('" + itemName + "', this)");
		dataItem = m_ibmImpl.getInfoBus().findDataItem(itemName, null, this);
		msgnl(WHOAMI+":  findDataItem()->" + dataItem==null?"NULL":dataItem.toString());

		return dataItem;
 	}

	private synchronized void showDataItem(String level, Object item)
	{
		String s;
		boolean dumped=false;
        m_testCounter++;
        m_showedRowsetShape = false;

		if (item==null)
		{
			msgnl(level+"DataItem is NULL");
			return;
		}

        if (item instanceof RowsetAccess && checkboxRowset.getState() )
        {
			msgnl(level+"Rowset::");
			RowsetAccess ra = (RowsetAccess) item;
			showRowset(level+"   ", ra);
			dumped=true;
        }

        if (item instanceof ScrollableRowsetAccess && checkboxScrollableRowset.getState() )
        {
			msgnl(level+"ScrollableRowset::");
			ScrollableRowsetAccess sra = (ScrollableRowsetAccess) item;
			showScrollableRowset(level+"   ", sra, 
                checkboxForwards.getState(), checkboxBackwards.getState(), checkboxAbsolute.getState());
			dumped=true;
        }

        if (item instanceof DbAccess && checkboxDb.getState() )
        {
			msgnl(level+"Db::");
			DbAccess dba = (DbAccess) item;
			showDb(level+"   ", dba);
			dumped=true;
        }

        if ( item instanceof ArrayAccess && checkboxArray.getState() )
		{
			msgnl(level+"Array::");
			ArrayAccess aa = (ArrayAccess) item;
			showArray(level+"   ", aa);
			dumped=true;
		}


		if (item instanceof ImmediateAccess && checkboxImmediate.getState() )
		{
			ImmediateAccess ia = (ImmediateAccess) item;

			msg(level);
            msg("Immediate::  ");
            Object o = ia.getValueAsObject();
            if (o == null)
                msgnl("NULL");
            else
            {
                Class c = o.getClass();
                if (c != null)
                    msgnl(c.getName() + "=[" + ia.getValueAsString() + "]");
                else
           			msgnl("[" + ia.getValueAsString() + "]");
            }
			dumped=true;
		}

	}



    private void showShape(String level, RowsetAccess ra)
    {
        if (m_showedRowsetShape)
            return;

        int ncols, colx, row;
        String colnames="";
        String typenames="";
        String typenums="";

        try
        {
            ncols = ra.getColumnCount();
            msgnl(level+"Rowset.getColumnCount()->"+ncols);

            for (colx=1; colx<=ncols; colx++)
            {
                if (colx>1)
                {
                    colnames+=",";
                    typenames+=",";
                    typenums+=",";
                }
                colnames += ra.getColumnName(colx);
                typenames += ra.getColumnDatatypeName(colx);
                typenums += ra.getColumnDatatypeNumber(colx);
            }
            msgnl(level+"Columns:  "+colnames);
            msgnl(level+"Typenames:  "+typenames);
            msgnl(level+"Typenums:  "+typenums);
        }
        catch(Exception e)
        {
            msgnl("Exception:  "+e.toString());
            e.printStackTrace();
        }
        m_showedRowsetShape = true;
    }


    /** 
     * Apply very simple modifications to current row
     */
    private void showRow(String level, RowsetAccess ra, int row)
    {
        try
        {
            int ncols = ra.getColumnCount();
            if (!checkboxVerbose.getState())
            {
                m_line.setLength(0);
                m_line.append(level+"["+row+"] ");
            }
            for (int colx=1; colx<=ncols; colx++)
            {
                Object subitem = ra.getColumnItem(colx);
                if (checkboxVerbose.getState())
                {
    				showDataItem(level + "   [" + colx + "] ", subitem);
                }
                else
                {
                    if (colx>1)
                        m_line.append(',');
                    ImmediateAccess ia = (ImmediateAccess) subitem;
                    m_line.append(ia.getValueAsString());
                }
			}
            if (!checkboxVerbose.getState())
               msgnl(m_line.toString());
        }
        catch(Exception e)
        {
            msgnl("Exception:  "+e.toString());
            e.printStackTrace();
        }
    }

    private void modifyRow(String level, RowsetAccess ra, int row)
    {
        Object subitem;
        Object o;
        ImmediateAccess ia;

        try
        {
            int ncols = ra.getColumnCount();
            for (int colx=1; colx<=ncols; colx++)
            {
                subitem = ra.getColumnItem(colx);
                ia = (ImmediateAccess) subitem;
                o = ia.getValueAsObject();
                if (o == null)
                {
                }
                else
                if (o instanceof Integer)
                {
                    Integer I = (Integer)o;
                    int i = I.intValue();
                    Integer newint = new Integer(i + (i>>1) +1);
                    ra.setColumnValue(colx, newint);
                }
                else
                if (o instanceof Double)
                {
                    Double D = (Double)o;
                    double d = D.doubleValue();
                    Double newdbl = new Double(d + d/2 + 1);
                    ra.setColumnValue(colx, newdbl);
                }
                else
                if (o instanceof String)
                {
                    String S = (String)o;
                    ra.setColumnValue(colx, S + " modified");
                }
                else
                {
                    Class c = o.getClass();
                    if (c != null)
                        msgnl("Object type "+c.getName() + " not supported for modify");
                    else
                        msgnl("Object type not supported for modify"+o);
                }

			}
        }
        catch(Exception e)
        {
            msgnl("Exception:  "+e.toString());
            e.printStackTrace();
        }
    }


    private void showRowset(String level, RowsetAccess ra)
    {
        int nrows=0;

        showShape(level, ra);
        try
        {
            while(ra.next())
            {
                showRow(level, ra, ++nrows);
                if (checkboxModifyRowset.getState())
                    modifyRow(level, ra, nrows);
            }
        }
        catch(Exception e)
        {
            msgnl("Exception:  "+e.toString());
            e.printStackTrace();
        }
        msgnl(level+"Read "+nrows+" rows");
    }

    private void showScrollableRowset(String level, ScrollableRowsetAccess sra, 
                                      boolean forwards, boolean backwards, boolean absolute)
    {
        int rowsRead, totalRows;
        boolean b;

        showShape(level, sra);

        try
        {
            msgnl(level+"ScrollableRowset.getRow()->"+sra.getRow());
        }
        catch(Exception e)
        {
            msgnl("Exception:  "+e.toString());
            e.printStackTrace();
        }

        if (forwards) // Dump rows first to last
        {
            msgnl(level+"Now reading ScrollableRowsetAccess forwards");
            rowsRead=0;
            try
            {
                b = sra.first();
                msgnl(level+"ScrollableRowset.first()->"+b);
                if (b) 
                    do
                    {
                        showRow(level, sra, ++rowsRead);
                    } while (sra.next());
            }
            catch(Exception e)
            {
                msgnl("Exception:  "+e.toString());
                e.printStackTrace();
            }
            msgnl(level+"Read "+rowsRead+" rows forwards");
        }

        if (backwards) // Dump rows last to first
        {
            rowsRead=0;
            try
            {
                msgnl(level+"Now reading ScrollableRowsetAccess backwards");
                b = sra.last();
                msgnl(level+"ScrollableRowset.last()->"+b);
                if (b)
                {
                    do
                    {
                        showRow(level, sra, sra.getRow());
                        rowsRead++;
                    }
                    while (sra.previous());
                }
            }
            catch(Exception e)
            {
                msgnl("Exception:  "+e.toString());
                e.printStackTrace();
            }
            msgnl(level+"Read "+rowsRead+" rows backwards");
        }

        if (absolute) // Dump some rows using absolute row numbers
        {
            msgnl(level+"Now reading ScrollableRowsetAccess via absolute row numbers");
            rowsRead=0;
            try
            {
                int last, low, high;
                b = sra.last();
                msgnl(level+"ScrollableRowset.last()->"+b);
                last=sra.getRow();
                if (b)
                {
                    for (low=1, high=last; low<=high; low++, high--)
                    {
                        sra.absolute(high);
                        showRow(level, sra, high);
                        rowsRead++;
                        if (low==high)
                            break;
                        sra.absolute(low);
                        showRow(level, sra, low);
                        rowsRead++;
                    }
                }
            }
            catch(Exception e)
            {
                msgnl("Exception:  "+e.toString());
                e.printStackTrace();
            }
            msgnl(level+"Read "+rowsRead+" rows absolute");
        }

        try
        {
            // Restore row cursor to before first row (BOF):
            msgnl(level+"Restoring row cursor to before first row");
            b = sra.first();
            msgnl(level+"ScrollableRowset.first()->"+b);
            b = sra.previous();
            msgnl(level+"ScrollableRowset.previous()->"+b);
            msgnl(level+"ScrollableRowset.getRow()->"+sra.getRow());
        }
        catch(Exception e)
        {
            msgnl("Exception:  "+e.toString());
            e.printStackTrace();
        }
    }

    private void showDb(String level, DbAccess dba)
    {
        msgnl(level+dba.toString());
    }

   	private void showArray(String level, ArrayAccess aa)
	{
		int i, x, y, z;
		int[] coords = aa.getDimensions();

        msgnl(level+"ArrayAccess.getDimensions()->="+coords.length);

		for (i = 0; i<coords.length; i++)
			msgnl(level+"dim["+i+"]="+coords[i]);

		// At preesnt we only handle 1 or 2 dimensions and a degenerate 3 dimensional case.

		textAreaMsgs.setVisible( false);
		try
		{
			if (coords.length == 1)
			{
				int xCoord[] = new int[1];
				for (x=0; x<coords[0]; x++) // coords seem to run from 0 through n-1 for n elements
				{
					xCoord[0] = x;
					Object subitem = aa.getItemByCoordinates(xCoord);
					showDataItem(level+"   ["+x+"] ", subitem);
				}
			}
			else
			if (coords.length == 2)
			{
				int xyCoord[] = new int[2];
				for (x=0; x<coords[0]; x++)
				{
                    m_line.setLength(0);
                    m_line.append(level);
					for (y=0; y<coords[1]; y++)
					{
						xyCoord[0] = x;
						xyCoord[1] = y;
						Object subitem = aa.getItemByCoordinates(xyCoord);
                        if (checkboxVerbose.getState())
                        {
    						showDataItem(level+"   ["+x+"]["+y+"] ", subitem);
                        }
                        else
                        {
                            if (y>0)
                                m_line.append(',');
                            ImmediateAccess ia = (ImmediateAccess) subitem;
                            m_line.append(ia.getValueAsString());
                        }
					}
                    if (!checkboxVerbose.getState())
                       msgnl(m_line.toString());
				}
			}
			else
			if (coords.length == 3)
			{
				int xyzCoord[] = new int[3];
	
				// At one time, Sheet component passee a degenerate 3 dimensional array
				// of R rows, C columns and 0 planes: {R,C,0}
				if (coords[2] == 0)
				{
					z = 0;
					for (x=0; x<coords[0]; x++)
					{
                        m_line.setLength(0);
                        m_line.append(level);
						for (y=0; y<coords[1]; y++)
						{
							xyzCoord[0] = x;
							xyzCoord[1] = y;
							xyzCoord[2] = z;
							Object subitem = aa.getItemByCoordinates(xyzCoord);
                            if (checkboxVerbose.getState())
                            {
    							showDataItem(level + "   [" + x + "][" + y + "][0]", subitem);
                            }
                            else
                            {
                                if (y>0)
                                    m_line.append(',');
                                ImmediateAccess ia = (ImmediateAccess) subitem;
                                m_line.append(ia.getValueAsString());
                            }
						}
                        if (!checkboxVerbose.getState())
                            msgnl(m_line.toString());
					}
				}
				else
				{
					for (x=0; x<coords[0]; x++)
					{
						for (y=0; y<coords[1]; y++)
						{
							for (z=0; z<coords[2]; z++)
							{
								xyzCoord[0] = x;
								xyzCoord[1] = y;
								xyzCoord[2] = z;
								Object subitem = aa.getItemByCoordinates(xyzCoord);
								showDataItem(level + "   [" + x + "][" + y + "][" + z + "]"
										, subitem);
							}
						}
					}
				}
			}
			else
			{
				msgnl(level+coords.length+" dimensional array not supported");
			}
		}
		catch(Exception e)
		{
		}
		textAreaMsgs.setVisible( true );
	}



    ///////////////////////////////////////////////////////////////////////
    // Various internal utility methods
    ///////////////////////////////////////////////////////////////////////

    private boolean boolFromParam(String paramName, boolean defaultValue)
    {
        String s = getParameter(paramName);
        if (s != null)
        {
            if (s.equalsIgnoreCase("false"))
                return false;
            else
            if (s.equalsIgnoreCase("true"))
                return true;
        }
        // else leave set to caller specified default
        return defaultValue;
    }
  
    private synchronized void msg(String s)
    {
		textAreaMsgs.setText(textAreaMsgs.getText()+s);
        teeOutPrint(s);
    }

    private synchronized void msgnl(String s)
    {
        msg(s+"\n");
    }

    private void processGetDataItem()
	{
		Object dataItem = findDataItem(textFieldGet);
		showDataItem("", dataItem);
	}

    ///////////////////////////////////////
    // AWT1.1 Event Handling
    ///////////////////////////////////////

    public void itemStateChanged ( ItemEvent e )
    {
        // Currently we only register with choiceDump for these events
		dump = choiceDump.getSelectedIndex();
    }


    public void actionPerformed ( ActionEvent e )
    {
        // we register with two buttons and the Get TextField
        if ( (e.getSource() == buttonGetData)
             || (e.getSource() == textFieldGet) )
        {
                processGetDataItem();
        }
        else if ( e.getSource() == buttonClear )
        {
				textAreaMsgs.setText("");
        }
    }
    
}
