/*
 * Decompiled with CFR 0.152.
 */
package gjc.ant;

import gjc.ant.GjcAdapter;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;

public class Gjc
extends Javac {
    private static final String FAIL_MSG = "Compile failed, messages should have been provided.";
    File generatedJPPath;

    protected CompilerAdapter createCompilerAdapter() {
        return new GjcAdapter();
    }

    public void setGeneratedJPPath(File generatedJPPath) {
        this.generatedJPPath = generatedJPPath;
    }

    public File getGeneratedJPPath() {
        return this.generatedJPPath;
    }

    public void execute() throws BuildException {
        if (this.getSrcdir() == null) {
            throw new BuildException("srcdir attribute must be set!", this.location);
        }
        String[] list = this.getSrcdir().list();
        if (list.length == 0) {
            throw new BuildException("srcdir attribute must be set!", this.location);
        }
        if (this.getDestdir() != null && !this.getDestdir().isDirectory()) {
            throw new BuildException("destination directory \"" + this.getDestdir() + "\" does not exist or is not a directory", this.location);
        }
        this.resetFileLists();
        for (int i = 0; i < list.length; ++i) {
            File srcDir = this.project.resolveFile(list[i]);
            if (!srcDir.exists()) {
                throw new BuildException("srcdir \"" + srcDir.getPath() + "\" does not exist!", this.location);
            }
            DirectoryScanner ds = this.getDirectoryScanner(srcDir);
            String[] files = ds.getIncludedFiles();
            this.scanDir(srcDir, this.getDestdir() != null ? this.getDestdir() : srcDir, files);
        }
        String compiler = this.project.getProperty("build.compiler");
        if (this.isForkedJavac()) {
            if (compiler != null) {
                if (this.isJdkCompiler(compiler)) {
                    this.log("Since fork is true, ignoring build.compiler setting.", 1);
                    compiler = "extJavac";
                } else {
                    this.log("Since build.compiler setting isn't classic or modern, ignoring fork setting.", 1);
                }
            } else {
                compiler = "extJavac";
            }
        }
        if (compiler == null) {
            compiler = Project.getJavaVersion() != "1.1" && Project.getJavaVersion() != "1.2" ? "modern" : "classic";
        }
        if (this.compileList.length > 0) {
            CompilerAdapter adapter = this.createCompilerAdapter();
            this.log("Compiling " + this.compileList.length + " source file" + (this.compileList.length == 1 ? "" : "s") + (this.getDestdir() != null ? " to " + this.getDestdir() : ""));
            adapter.setJavac((Javac)this);
            if (!adapter.execute()) {
                if (this.failOnError) {
                    throw new BuildException(FAIL_MSG, this.location);
                }
                this.log(FAIL_MSG, 0);
            }
        }
    }
}

