/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6;

import gjc.v6.code.ClassReader;
import gjc.v6.code.ClassWriter;
import gjc.v6.code.Symbol;
import gjc.v6.comp.Attr;
import gjc.v6.comp.AttrContext;
import gjc.v6.comp.Check;
import gjc.v6.comp.Enter;
import gjc.v6.comp.Env;
import gjc.v6.comp.Flow;
import gjc.v6.comp.Gen;
import gjc.v6.comp.Infer;
import gjc.v6.comp.Items;
import gjc.v6.comp.Resolve;
import gjc.v6.comp.Symtab;
import gjc.v6.comp.TransInner;
import gjc.v6.comp.TransTypes;
import gjc.v6.parser.Parser;
import gjc.v6.parser.Scanner;
import gjc.v6.tree.Pretty;
import gjc.v6.tree.Tree;
import gjc.v6.tree.TreeMaker;
import gjc.v6.util.Abort;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Log;
import gjc.v6.util.Name;
import gjc.v6.util.Set;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCompiler
implements ClassReader.SourceCompleter {
    private static final String REPORT_BUG_TO = "jparty@ira.uka.de";
    private static final String versionstring;
    protected Hashtable<String, String> options;
    protected Log log;
    protected Symtab syms;
    public TreeMaker make;
    protected Gen gen;
    protected Check chk;
    protected Infer infer;
    protected Resolve rs;
    protected Enter enter;
    protected Attr attr;
    protected Items items;
    protected boolean verbose;
    protected boolean sourceOutput;
    protected boolean classOutput;
    protected boolean printTree;
    protected ListBuffer<Env<AttrContext>> todo = new ListBuffer();
    protected Set<File> inputFiles = Set.make();

    protected static String version() {
        return versionstring;
    }

    protected JavaCompiler() {
        throw new InternalError();
    }

    protected JavaCompiler(Hashtable<String, String> options, Log log, Symtab syms, Check chk, Infer infer, Resolve rs, TreeMaker make, Enter enter, Attr attr, Items items, Gen gen) {
        this.options = options;
        this.log = log;
        this.syms = syms;
        this.chk = chk;
        this.infer = infer;
        this.rs = rs;
        this.make = make;
        this.enter = enter;
        this.attr = attr;
        this.items = items;
        this.gen = gen;
        syms.reader.init(this);
        enter.init(attr, this.todo);
        attr.init(enter);
        this.verbose = options.get("-verbose") != null;
        this.sourceOutput = options.get("-s") != null;
        this.classOutput = options.get("-retrofit") == null;
        this.printTree = options.get("-printtree") != null;
    }

    public static JavaCompiler make() {
        Hashtable<String, String> h = Hashtable.make();
        return JavaCompiler.make(h);
    }

    public static JavaCompiler make(Hashtable<String, String> options) {
        Log log = new Log(options.get("-prompt") != null, options.get("-nowarn") == null);
        return JavaCompiler.make(options, log);
    }

    public static JavaCompiler make(Hashtable<String, String> options, Log log) {
        ClassReader reader = new ClassReader(options);
        ClassWriter writer = new ClassWriter(options);
        Symtab syms = new Symtab(reader, writer);
        return JavaCompiler.make(options, log, syms);
    }

    public static JavaCompiler make(Hashtable<String, String> options, Log log, Symtab syms) {
        Check chk = new Check(log, syms, options);
        Infer infer = new Infer(log, syms, chk);
        Resolve rs = new Resolve(log, syms, chk, infer);
        TreeMaker make = new TreeMaker();
        Enter enter = new Enter(log, syms, rs, chk, make);
        Attr attr = new Attr(options, log, syms, rs, chk, infer, make);
        Items items = new Items();
        Gen gen = new Gen(log, syms, chk, rs, make, items, options);
        return new JavaCompiler(options, log, syms, chk, infer, rs, make, enter, attr, items, gen);
    }

    protected InputStream openSource(String filename) {
        try {
            File f = new File(filename);
            this.inputFiles.put(f);
            return new FileInputStream(f);
        }
        catch (IOException iOException) {
            this.log.error(0, String.valueOf("can't read: ").concat(String.valueOf(filename)));
            return null;
        }
    }

    protected Scanner createScanner(InputStream in, Log _log) {
        Scanner scanner = new Scanner(in, _log);
        scanner.nextToken();
        return scanner;
    }

    public Tree.TopLevel parse(String filename, InputStream input) {
        long msec = System.currentTimeMillis();
        Name prev = this.log.useSource(Name.fromString(filename));
        Tree.TopLevel tree = this.make.TopLevel(null, Tree.emptyList);
        if (input != null) {
            if (this.verbose) {
                System.err.print(String.valueOf(String.valueOf("[parsing ").concat(String.valueOf(filename))).concat(String.valueOf(" ")));
            }
            try {
                Scanner scanner = this.createScanner(input, this.log);
                input.close();
                Parser parser = new Parser(scanner, this.make, this.log);
                tree = parser.compilationUnit();
                if (this.verbose) {
                    System.err.println(String.valueOf(System.currentTimeMillis() - msec).concat(String.valueOf("ms]")));
                }
            }
            catch (IOException iOException) {
                this.log.error(0, String.valueOf(String.valueOf(String.valueOf("error reading ").concat(String.valueOf(filename))).concat(String.valueOf("; "))).concat(String.valueOf(iOException)));
            }
        }
        this.log.useSource(prev);
        tree.sourcefile = Name.fromString(filename);
        return tree;
    }

    public Tree.TopLevel parse(String string) {
        return this.parse(string, this.openSource(string));
    }

    protected void printSource(Env<AttrContext> env, Tree.ClassDef cdef) throws IOException {
        File outFile = this.syms.writer.outputFile(cdef.sym, ".java");
        if (this.inputFiles.contains(outFile)) {
            this.log.error(cdef.pos, String.valueOf("error writing source; cannot overwrite input file ").concat(String.valueOf(outFile)));
        } else {
            PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(outFile)));
            try {
                new Pretty(printStream).printUnit(env.toplevel, cdef);
                if (this.verbose) {
                    System.err.println(String.valueOf(String.valueOf("[wrote ").concat(String.valueOf(outFile.getPath()))).concat(String.valueOf("]")));
                }
                Object var6_5 = null;
                printStream.close();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                printStream.close();
                throw throwable;
            }
        }
    }

    protected void genCode(Env<AttrContext> env, Tree.ClassDef classDef) throws IOException {
        this.gen.genClass(env, classDef);
        this.writeClass(classDef.sym, ".class");
    }

    protected void writeClass(Symbol.ClassSymbol c, String extension) throws IOException {
        File outFile = this.syms.writer.outputFile(c, extension);
        FileOutputStream fileOutputStream = new FileOutputStream(outFile);
        try {
            this.syms.writer.writeClassFile(fileOutputStream, c);
            if (this.verbose) {
                System.err.println(String.valueOf(String.valueOf("[wrote ").concat(String.valueOf(outFile.getPath()))).concat(String.valueOf("]")));
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    @Override
    public void complete(Symbol.ClassSymbol c, String filename, InputStream f) throws Symbol.CompletionFailure {
        Tree.TopLevel topLevel = this.parse(filename, f);
        this.enter.main(List.make(topLevel));
        if (c.members() == null) {
            throw new ClassReader.LoadError(this.syms.reader, c, filename, String.valueOf("file does not contain class ").concat(String.valueOf(c.fullname)));
        }
    }

    public List<Symbol.ClassSymbol> compile(List<String> filenames) throws Exception {
        long msec = System.currentTimeMillis();
        try {
            this.inputFiles.reset();
            Symbol.reset();
            ListBuffer<Tree> trees = new ListBuffer<Tree>();
            List<String> l = filenames;
            while (l.nonEmpty()) {
                trees.append(this.parse((String)l.head));
                l = l.tail;
            }
            return this.compile(trees);
        }
        catch (Abort ex) {
        }
        catch (Exception exception) {
            System.out.flush();
            this.bugMessage();
            this.log.prompt();
            throw exception;
        }
        if (this.verbose) {
            System.err.println(String.valueOf(String.valueOf("[total ").concat(String.valueOf(System.currentTimeMillis() - msec))).concat(String.valueOf("ms]")));
        }
        this.printCount("error", this.log.nerrors);
        this.printCount("warning", this.log.nwarnings);
        return new List<Symbol.ClassSymbol>();
    }

    protected boolean postFlowCheckWork(Env<AttrContext> env) throws Exception {
        return false;
    }

    protected boolean preCodeGenWork(Env<AttrContext> env, Tree.ClassDef classDef) throws Exception {
        return false;
    }

    public List<Symbol.ClassSymbol> compile(ListBuffer<Tree> trees) throws Exception {
        ListBuffer<Symbol.ClassSymbol> classes = new ListBuffer<Symbol.ClassSymbol>();
        this.enter.main(trees.toList());
        while (this.todo.nonEmpty()) {
            Env<AttrContext> env = this.todo.first();
            this.todo.remove();
            if (this.verbose) {
                System.err.println(String.valueOf(String.valueOf("[checking ").concat(String.valueOf(env.enclClass.sym))).concat(String.valueOf("]")));
            }
            Name prev = this.log.useSource(env.enclClass.sym.sourcefile);
            this.attr.attribClass(env.enclClass.sym);
            if (this.log.nerrors == 0) {
                new Flow(this.log, this.syms, this.chk).analyze(env.tree);
            }
            if (this.log.nerrors == 0 && this.postFlowCheckWork(env)) continue;
            TreeMaker maker = new TreeMaker(env.toplevel);
            if (this.log.nerrors == 0) {
                env.tree = new TransTypes(this.log, this.syms, maker).translateTopLevelClass(env.tree);
            }
            if (this.log.nerrors == 0) {
                Tree.ClassDef cdef = null;
                try {
                    if (this.sourceOutput) {
                        cdef = (Tree.ClassDef)env.tree;
                        this.printSource(env, cdef);
                    } else {
                        List<Tree> cdefs;
                        List<Tree> l = cdefs = new TransInner(this.log, this.syms, maker).translateTopLevelClass(env.tree);
                        while (this.log.nerrors == 0 && l.nonEmpty()) {
                            cdef = (Tree.ClassDef)l.head;
                            if (!this.preCodeGenWork(env, cdef)) {
                                if (this.printTree) {
                                    this.printSource(env, cdef);
                                } else if (this.classOutput) {
                                    this.genCode(env, cdef);
                                }
                                classes.append(cdef.sym);
                            }
                            l = l.tail;
                        }
                    }
                }
                catch (IOException iOException) {
                    this.log.error(cdef.pos, String.valueOf(String.valueOf(String.valueOf("error while writing ").concat(String.valueOf(cdef.sym))).concat(String.valueOf(": "))).concat(String.valueOf(iOException)));
                }
            }
            this.log.useSource(prev);
        }
        return classes.toList();
    }

    protected void printCount(String kind, int n) {
        if (n != 0) {
            this.log.println(String.valueOf(String.valueOf(String.valueOf(n).concat(String.valueOf(" "))).concat(String.valueOf(kind))).concat(String.valueOf(n == 1 ? "" : "s")));
        }
    }

    protected void bugMessage() {
        System.err.println(String.valueOf(String.valueOf("\n\nAn exception has occurred in the compiler. (").concat(String.valueOf(JavaCompiler.version()))).concat(String.valueOf(")")));
        System.err.println("Please file a bug report by sending your program and the following diagnostic to");
        System.err.println("jparty@ira.uka.de.\n\n   Thank you.\n");
        System.err.flush();
    }

    static {
        Properties props = new Properties();
        try {
            props.load(Class.forName("gjc.v6.JavaCompiler").getResourceAsStream("/gjc/v6/version.properties"));
        }
        catch (Exception ex) {
            System.err.println("Couldn't get version.");
        }
        versionstring = String.valueOf("gj/").concat(String.valueOf(props.getProperty("version")));
    }
}

