/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6;

import gjc.v6.JavaCompiler;
import gjc.v6.code.ClassReader;
import gjc.v6.code.CompleteClassReader;
import gjc.v6.code.Flags;
import gjc.v6.code.Kinds;
import gjc.v6.code.Scope;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import java.io.IOException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Retro
implements TypeTags,
Kinds,
Flags {
    ClassReader reader;
    JavaCompiler comp;
    boolean verbose;

    public Retro(JavaCompiler comp, Hashtable<String, String> hashtable) {
        this.comp = comp;
        this.reader = new CompleteClassReader(hashtable);
        this.reader.classPath = String.valueOf(String.valueOf(hashtable.get("-retrofit")).concat(String.valueOf(ClassReader.pathSep))).concat(String.valueOf(this.reader.classPath));
        this.reader.readAllOfClassFile = true;
        this.verbose = hashtable.get("-verbose") != null;
    }

    static boolean isGeneric(Type t) {
        switch (t.tag) {
            case 10: {
                return t.typarams().nonEmpty();
            }
            case 11: {
                return Retro.isGeneric(t.elemtype());
            }
            case 12: {
                return Retro.isGeneric(t.argtypes()) || Retro.isGeneric(t.restype());
            }
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    static boolean isGeneric(List<Type> ts) {
        List<Type> l = ts;
        while (l.nonEmpty()) {
            if (Retro.isGeneric((Type)l.head)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    static boolean sameType(Type t1, Type t2) {
        return t1.tag == 10 && t2.tag == 10 && t1.tsym.fullName() == t2.tsym.fullName() || t1.tag == 11 && t2.tag == 11 && Retro.sameType(t1.elemtype(), t2.elemtype()) || t1.tag == 12 && t2.tag == 12 && Retro.sameType(t1.restype(), t2.restype()) && Retro.sameTypes(t1.argtypes(), t2.argtypes()) || t1.sameType(t2);
    }

    static boolean sameTypes(List<Type> ts1, List<Type> ts2) {
        while (ts1.nonEmpty() && ts2.nonEmpty() && Retro.sameType((Type)ts1.head, (Type)ts2.head)) {
            ts1 = ts1.tail;
            ts2 = ts2.tail;
        }
        return ts1.isEmpty() && ts2.isEmpty();
    }

    public void fitClass(Symbol.ClassSymbol classSymbol) {
        if (classSymbol.owner.kind == 1) {
            this.fit(classSymbol);
        }
    }

    public void fit(Symbol.ClassSymbol sig) {
        try {
            if (this.verbose) {
                System.out.println(String.valueOf(String.valueOf("[retrofitting ").concat(String.valueOf(sig))).concat(String.valueOf("]")));
            }
            Symbol.ClassSymbol clazz = this.reader.loadClass(sig.flatname);
            if (!Retro.sameType(sig.type.supertype(), clazz.type.supertype())) {
                this.comp.log.error(0, String.valueOf(String.valueOf("signature does not match ").concat(String.valueOf(clazz))).concat(String.valueOf("; incompatible supertype")));
                return;
            }
            if (!Retro.sameTypes(sig.type.interfaces(), clazz.type.interfaces())) {
                this.comp.log.error(0, String.valueOf(String.valueOf("signature does not match ").concat(String.valueOf(clazz))).concat(String.valueOf("; incompatible interfaces")));
                return;
            }
            if (Retro.isGeneric(sig.type) || Retro.isGeneric(sig.type.supertype()) || Retro.isGeneric(sig.type.interfaces())) {
                if (this.verbose) {
                    System.out.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(" retrofitting ").concat(String.valueOf(clazz))).concat(String.valueOf(" with type parameters "))).concat(String.valueOf(sig.type.typarams()))).concat(String.valueOf(", supertype "))).concat(String.valueOf(sig.type.supertype()))).concat(String.valueOf(", interfaces "))).concat(String.valueOf(sig.type.interfaces())));
                }
                clazz.type = sig.type;
            }
            Scope.Entry e = sig.members().elems;
            while (e != null) {
                Symbol sym = e.sym;
                if ((sym.flags() & 0x10002) == 0) {
                    switch (sym.kind) {
                        case 2: {
                            if (sym.name.len == 0) break;
                            this.fit((Symbol.ClassSymbol)sym);
                            break;
                        }
                        case 4: 
                        case 32: {
                            Scope s = clazz.members();
                            Scope.Entry e1 = s.lookup(sym.name);
                            while (!(e1.scope != s || e1.sym.kind == sym.kind && Retro.sameType(e1.sym.erasure(), sym.erasure()))) {
                                e1 = e1.next();
                            }
                            if (e1.scope == s) {
                                if (!Retro.isGeneric(sym.type)) break;
                                if (this.verbose) {
                                    System.out.println(String.valueOf(String.valueOf(String.valueOf(" retrofitting ").concat(String.valueOf(e1.sym))).concat(String.valueOf(" with "))).concat(String.valueOf(sym.type)));
                                }
                                e1.sym.type = sym.type;
                                break;
                            }
                            this.comp.log.error(0, String.valueOf(String.valueOf(String.valueOf(String.valueOf(sym).concat(String.valueOf(" has no matching entry in "))).concat(String.valueOf(clazz))).concat(String.valueOf("; required: "))).concat(String.valueOf(sym.erasure())));
                        }
                    }
                }
                e = e.sibling;
            }
            if (this.comp.log.nerrors == 0) {
                this.comp.writeClass(clazz, ".class");
            }
        }
        catch (Symbol.CompletionFailure ex) {
            this.comp.log.error(0, String.valueOf(String.valueOf(String.valueOf("cannot access ").concat(String.valueOf(ex.sym))).concat(String.valueOf("; "))).concat(String.valueOf(ex.errmsg)));
        }
        catch (IOException iOException) {
            this.comp.log.error(0, String.valueOf(String.valueOf(String.valueOf("error while writing ").concat(String.valueOf(sig))).concat(String.valueOf(": "))).concat(String.valueOf(iOException)));
        }
    }
}

