/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6;

import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Win32 {
    public static boolean win32 = File.separatorChar == '\\';

    static boolean hasWildcards(String s) {
        return s.length() > 0 && s.charAt(0) != '-' && (s.indexOf(42) >= 0 || s.indexOf("?") >= 0);
    }

    static boolean matches(String s, int soffset, String p, int poffset) {
        if (poffset >= p.length()) {
            return soffset >= s.length();
        }
        if (p.charAt(poffset) == '*') {
            return Win32.matches(s, soffset, p, poffset + 1) || soffset < s.length() && Win32.matches(s, soffset + 1, p, poffset);
        }
        return soffset < s.length() && (p.charAt(poffset) == '?' || Character.toUpperCase(s.charAt(soffset)) == Character.toUpperCase(p.charAt(poffset))) && Win32.matches(s, soffset + 1, p, poffset + 1);
    }

    static void addExpansion(ListBuffer<String> expandedArgs, String s) throws IOException {
        File dir;
        File f = new File(s);
        String path = f.getParent();
        String name = f.getName();
        if (path == null) {
            String string = path = s.indexOf("\\") == 0 ? "" : ".";
        }
        if ((dir = new File(String.valueOf(path).concat(String.valueOf("\\")))) == null) {
            expandedArgs.append(s);
            return;
        }
        String[] files = dir.list();
        if (files != null) {
            for (int j = 0; j < files.length; ++j) {
                if (!Win32.matches(files[j], 0, name, 0)) continue;
                expandedArgs.append(String.valueOf(String.valueOf(path).concat(String.valueOf(File.separator))).concat(String.valueOf(files[j])));
            }
        }
    }

    public static void redirectErr(String filename) {
        try {
            System.setErr(new PrintStream(new BufferedOutputStream(new FileOutputStream(filename))));
        }
        catch (IOException e) {
            System.err.println("cannot redirect output stream");
        }
    }

    public static List<String> expand(String[] argv) throws IOException {
        ListBuffer<String> expandedArgs = new ListBuffer<String>();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].startsWith("@")) {
                argv = Win32.fileArguments(argv, i);
            }
            if (argv[i].startsWith("!")) {
                Win32.redirectErr(argv[i].substring(1));
                continue;
            }
            if (Win32.hasWildcards(argv[i])) {
                Win32.addExpansion(expandedArgs, argv[i]);
                continue;
            }
            expandedArgs.append(argv[i]);
        }
        return expandedArgs.toList();
    }

    public static String[] fileArguments(String[] argv, int i) {
        String filename = new String(argv[i].substring(1));
        try {
            String currentLine;
            Vector<String> newArguments = new Vector<String>();
            int newArgsCount = 0;
            BufferedReader filereader = new BufferedReader(new FileReader(new File(filename)));
            while ((currentLine = filereader.readLine()) != null) {
                StringTokenizer fileArgs = new StringTokenizer(currentLine, " ");
                while (fileArgs.hasMoreTokens()) {
                    newArguments.addElement(fileArgs.nextToken());
                    ++newArgsCount;
                }
            }
            String[] newArgv = new String[argv.length + newArgsCount - 1];
            int Position2 = 0;
            int j = 0;
            while (j < i) {
                if (argv[Position2] != null) {
                    newArgv[j] = argv[Position2];
                    ++j;
                }
                ++Position2;
            }
            Position2 = 0;
            int j2 = i;
            while (j2 < i + newArgsCount) {
                if (newArguments.elementAt(Position2) != null) {
                    newArgv[j2] = new String((String)newArguments.elementAt(Position2));
                    ++j2;
                }
                ++Position2;
            }
            Position2 = i;
            for (int j3 = i + newArgsCount; j3 < argv.length + newArgsCount - 1; ++j3) {
                if (argv[Position2] != null) {
                    newArgv[j3] = argv[Position2];
                    ++j3;
                }
                ++Position2;
            }
            return newArgv;
        }
        catch (IOException e) {
            System.out.println("Error on read of @file");
            return argv;
        }
    }
}

