/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.code;

import gjc.v6.code.ClassFile;
import gjc.v6.code.Code;
import gjc.v6.code.Flags;
import gjc.v6.code.Kinds;
import gjc.v6.code.Pool;
import gjc.v6.code.Scope;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.util.Base;
import gjc.v6.util.Convert;
import gjc.v6.util.FileEntry;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Name;
import gjc.v6.util.Names;
import gjc.v6.util.PathlistParser;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassReader
extends ClassFile
implements Symbol.Completer,
Flags,
Kinds,
TypeTags {
    public static final String pathSep = System.getProperty("path.separator");
    public boolean verbose;
    public boolean printSearch;
    public boolean checkClassFile;
    public boolean readAllOfClassFile = false;
    public String classPath;
    public SourceCompleter sourceCompleter = null;
    public Hashtable<Name, Symbol.ClassSymbol> classes = Hashtable.make();
    public Hashtable<Name, Symbol.PackageSymbol> packages = Hashtable.make();
    Scope typevars = new Scope(null);
    String currentClassFileName = null;
    Symbol.ClassSymbol currentClass = null;
    Symbol currentOwner = null;
    byte[] buf = new byte[65536];
    int bp;
    Object[] pool;
    int[] poolIdx;
    public static int MODE_DEFAULT = 0;
    public static int MODE_LOAD_SIG_FILE = 1;
    public static boolean secondRun = false;
    public int mode_include_classes = MODE_DEFAULT;
    byte[] signature;
    int sigp;
    int siglimit;
    Hashtable<String, ZipFile> dirs = Hashtable.make();

    public ClassReader(Hashtable<String, String> options) {
        this.verbose = options.get("-verbose") != null;
        this.printSearch = options.get("-printsearch") != null;
        this.checkClassFile = options.get("-checkclassfile") != null;
        String cp = options.get("-classpath");
        if (cp == null) {
            cp = System.getProperty("java.class.path");
        }
        if (cp == null) {
            cp = "";
        }
        if (cp.length() > 0 && !cp.endsWith(pathSep)) {
            cp = String.valueOf(cp).concat(String.valueOf(pathSep));
        }
        final StringBuffer endorsedcp = new StringBuffer();
        new PathlistParser(System.getProperty("java.endorsed.dirs")).getJars(new PathlistParser.Callback(){

            @Override
            public void next(String string) {
                endorsedcp.append(string);
                endorsedcp.append(pathSep);
            }
        });
        final StringBuffer extcp = new StringBuffer();
        new PathlistParser(System.getProperty("java.ext.dirs")).getJars(new PathlistParser.Callback(){

            @Override
            public void next(String string) {
                extcp.append(string);
                extcp.append(pathSep);
            }
        });
        String string = options.get("-bootclasspath");
        if (string == null) {
            string = System.getProperty("sun.boot.class.path");
        }
        if (string == null) {
            string = System.getProperty("java.boot.class.path");
        }
        if (string == null) {
            string = System.getProperty("java.sys.class.path");
        }
        if (string == null) {
            string = "";
        }
        if (string.length() > 0 && !string.endsWith(pathSep)) {
            string = String.valueOf(string).concat(String.valueOf(pathSep));
        }
        endorsedcp.append(string);
        endorsedcp.append(extcp.toString());
        endorsedcp.append(cp);
        this.classPath = endorsedcp.toString();
        this.packages.put(Symbol.emptyPackage.fullname, Symbol.emptyPackage);
        Symbol.emptyPackage.completer = this;
    }

    public void init(SourceCompleter sourceCompleter) {
        this.sourceCompleter = sourceCompleter;
    }

    char nextChar() {
        return (char)(((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF));
    }

    int nextInt() {
        return ((this.buf[this.bp++] & 0xFF) << 24) + ((this.buf[this.bp++] & 0xFF) << 16) + ((this.buf[this.bp++] & 0xFF) << 8) + (this.buf[this.bp++] & 0xFF);
    }

    char getChar(int n) {
        return (char)(((this.buf[n] & 0xFF) << 8) + (this.buf[n + 1] & 0xFF));
    }

    int getInt(int n) {
        return ((this.buf[n] & 0xFF) << 24) + ((this.buf[n + 1] & 0xFF) << 16) + ((this.buf[n + 2] & 0xFF) << 8) + (this.buf[n + 3] & 0xFF);
    }

    long getLong(int bp) {
        DataInputStream bufin = new DataInputStream(new ByteArrayInputStream(this.buf, bp, 8));
        try {
            return bufin.readLong();
        }
        catch (IOException iOException) {
            throw new InternalError();
        }
    }

    float getFloat(int bp) {
        DataInputStream bufin = new DataInputStream(new ByteArrayInputStream(this.buf, bp, 4));
        try {
            return bufin.readFloat();
        }
        catch (IOException iOException) {
            throw new InternalError("get");
        }
    }

    double getDouble(int bp) {
        DataInputStream bufin = new DataInputStream(new ByteArrayInputStream(this.buf, bp, 8));
        try {
            return bufin.readDouble();
        }
        catch (IOException iOException) {
            throw new InternalError("get");
        }
    }

    void indexPool() {
        this.poolIdx = new int[this.nextChar()];
        this.pool = new Object[this.poolIdx.length];
        int i = 1;
        byte tag = 0;
        block6: while (i < this.poolIdx.length) {
            this.poolIdx[i++] = this.bp;
            byte tag1 = tag;
            tag = this.buf[this.bp++];
            switch (tag) {
                case 1: 
                case 2: {
                    char c = this.nextChar();
                    this.bp += c;
                    continue block6;
                }
                case 7: 
                case 8: {
                    this.bp += 2;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.bp += 4;
                    continue block6;
                }
                case 5: 
                case 6: {
                    this.bp += 8;
                    ++i;
                    continue block6;
                }
            }
            throw new LoadError(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("bad constant pool tag: ").concat(String.valueOf(tag))).concat(String.valueOf(" at "))).concat(String.valueOf(this.bp - 1))).concat(String.valueOf(", previous tag: "))).concat(String.valueOf(tag1)));
        }
    }

    Object readPool(int i) {
        Object result = this.pool[i];
        if (result != null) {
            return result;
        }
        int index = this.poolIdx[i];
        if (index == 0) {
            return null;
        }
        byte tag = this.buf[index];
        switch (tag) {
            case 1: {
                this.pool[i] = Name.fromUtf(this.buf, index + 3, this.getChar(index + 1));
                break;
            }
            case 2: {
                throw new LoadError("unicode string in class file not supported");
            }
            case 7: {
                this.pool[i] = this.readClassOrType(this.getChar(index + 1));
                break;
            }
            case 8: {
                this.pool[i] = this.readName(this.getChar(index + 1)).toString();
                break;
            }
            case 9: {
                Symbol.ClassSymbol owner = this.readClassSymbol(this.getChar(index + 1));
                ClassFile.NameAndType nt = (ClassFile.NameAndType)this.readPool(this.getChar(index + 3));
                Name name = (Name)nt.fst;
                Type sig = (Type)nt.snd;
                this.pool[i] = new Symbol.VarSymbol(0, name, sig, owner);
                break;
            }
            case 10: 
            case 11: {
                Symbol.ClassSymbol owner = this.readClassSymbol(this.getChar(index + 1));
                ClassFile.NameAndType nt = (ClassFile.NameAndType)this.readPool(this.getChar(index + 3));
                Name name = (Name)nt.fst;
                Type type = (Type)nt.snd;
                this.pool[i] = new Symbol.MethodSymbol(0, name, type, owner);
                break;
            }
            case 12: {
                this.pool[i] = new ClassFile.NameAndType(this.readName(this.getChar(index + 1)), this.readType(this.getChar(index + 3)));
                break;
            }
            case 3: {
                this.pool[i] = new Integer(this.getInt(index + 1));
                break;
            }
            case 4: {
                this.pool[i] = new Float(this.getFloat(index + 1));
                break;
            }
            case 5: {
                this.pool[i] = new Long(this.getLong(index + 1));
                break;
            }
            case 6: {
                this.pool[i] = new Double(this.getDouble(index + 1));
                break;
            }
            default: {
                throw new LoadError(String.valueOf("bad constant pool tag: ").concat(String.valueOf(tag)));
            }
        }
        return this.pool[i];
    }

    Type readType(int i) {
        int n = this.poolIdx[i];
        return this.sigToType(this.buf, n + 3, this.getChar(n + 1));
    }

    Object readClassOrType(int i) {
        int index = this.poolIdx[i];
        char len = this.getChar(index + 1);
        int n = index + 3;
        return this.buf[n] == 91 || this.buf[n + len - 1] == 59 ? this.sigToType(this.buf, n, len) : this.enterClass(Name.fromUtf(ClassFile.internalize(this.buf, n, len)));
    }

    List<Type> readTypeParams(int i) {
        int n = this.poolIdx[i];
        return this.sigToTypeParams(this.buf, n + 3, this.getChar(n + 1));
    }

    Symbol.ClassSymbol readClassSymbol(int n) {
        return (Symbol.ClassSymbol)this.readPool(n);
    }

    Name readName(int n) {
        return (Name)this.readPool(n);
    }

    Type sigToType(Name name) {
        return name == null ? null : this.sigToType(Name.names, name.index, name.len);
    }

    Type sigToType(byte[] sig, int offset, int n) {
        this.signature = sig;
        this.sigp = offset;
        this.siglimit = offset + n;
        return this.sigToType();
    }

    Type sigToType() {
        switch (this.signature[this.sigp]) {
            case 84: {
                ++this.sigp;
                int start = this.sigp;
                while (this.signature[this.sigp] != 59) {
                    ++this.sigp;
                }
                ++this.sigp;
                return this.findTypeVar(Name.fromUtf(this.signature, start, this.sigp - 1 - start));
            }
            case 66: {
                ++this.sigp;
                return Type.byteType;
            }
            case 67: {
                ++this.sigp;
                return Type.charType;
            }
            case 68: {
                ++this.sigp;
                return Type.doubleType;
            }
            case 70: {
                ++this.sigp;
                return Type.floatType;
            }
            case 73: {
                ++this.sigp;
                return Type.intType;
            }
            case 74: {
                ++this.sigp;
                return Type.longType;
            }
            case 76: {
                Type t = this.classSigToType(Type.noType);
                while (this.sigp < this.siglimit && this.signature[this.sigp] == 46) {
                    ++this.sigp;
                    t = this.classSigToType(t);
                }
                return t;
            }
            case 83: {
                ++this.sigp;
                return Type.shortType;
            }
            case 86: {
                ++this.sigp;
                return Type.voidType;
            }
            case 90: {
                ++this.sigp;
                return Type.booleanType;
            }
            case 91: {
                ++this.sigp;
                while (48 <= this.signature[this.sigp] && this.signature[this.sigp] <= 57) {
                    ++this.sigp;
                }
                return new Type.ArrayType(this.sigToType());
            }
            case 40: {
                List<Type> argtypes = this.sigToTypes(')');
                Type restype = this.sigToType();
                return new Type.MethodType(argtypes, restype, Symbol.ClassSymbol.emptyList);
            }
            case 60: {
                this.typevars = this.typevars.dup();
                Type.ForAll forAll = new Type.ForAll(this.sigToTypeParams(), this.sigToType());
                this.typevars = this.typevars.leave();
                return forAll;
            }
        }
        throw new LoadError(String.valueOf("bad signature: ").concat(String.valueOf(Convert.utf2string(this.signature, this.sigp, 10))));
    }

    Type classSigToType(Type outer) {
        if (this.signature[this.sigp] == 76) {
            ++this.sigp;
            int start = this.sigp;
            while (this.signature[this.sigp] != 59 && this.signature[this.sigp] != 60) {
                ++this.sigp;
            }
            Type.ClassType classType = (Type.ClassType)this.enterClass((Name)Name.fromUtf((byte[])ClassFile.internalize((byte[])this.signature, (int)start, (int)(this.sigp - start)))).type;
            if (this.signature[this.sigp] == 60) {
                classType = new Type.ClassType(classType.outer_field, this.sigToTypes('>'), classType.tsym);
            }
            if (outer.isParameterized()) {
                classType.outer_field = outer;
            }
            ++this.sigp;
            return classType;
        }
        throw new LoadError(String.valueOf("bad class signature: ").concat(String.valueOf(Convert.utf2string(this.signature, this.sigp, 10))));
    }

    List<Type> sigToTypes(char terminator) {
        ++this.sigp;
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        while (this.signature[this.sigp] != terminator) {
            listBuffer.append(this.sigToType());
        }
        ++this.sigp;
        return listBuffer.toList();
    }

    List<Type> sigToTypeParams(Name name) {
        return this.sigToTypeParams(Name.names, name.index, name.len);
    }

    List<Type> sigToTypeParams(byte[] sig, int offset, int n) {
        this.signature = sig;
        this.sigp = offset;
        this.siglimit = offset + n;
        return this.sigToTypeParams();
    }

    List<Type> sigToTypeParams() {
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        if (this.signature[this.sigp] == 60) {
            ++this.sigp;
            while (this.signature[this.sigp] != 62) {
                listBuffer.append(this.sigToTypeParam());
            }
            ++this.sigp;
        }
        return listBuffer.toList();
    }

    Type sigToTypeParam() {
        int start = this.sigp;
        while (this.signature[this.sigp] != 58) {
            ++this.sigp;
        }
        Name name = Name.fromUtf(this.signature, start, this.sigp - start);
        Type.TypeVar typeVar = new Type.TypeVar(null, name, this.currentOwner);
        this.typevars.enter(typeVar.tsym);
        ++this.sigp;
        typeVar.bound = this.sigToType();
        return typeVar;
    }

    Type findTypeVar(Name name) {
        Scope.Entry entry = this.typevars.lookup(name);
        if (entry.scope != null) {
            return entry.sym.type;
        }
        throw new LoadError(String.valueOf("undeclared type variable: ").concat(String.valueOf(name)));
    }

    void unrecogized(Name name) {
        if (this.checkClassFile) {
            System.err.println(String.valueOf("unrecogized attribute: ").concat(String.valueOf(name)));
        }
    }

    void readAttr(Symbol sym, Name attrName, int attrLen) {
        if (attrName == Names.ConstantValue) {
            ((Symbol.VarSymbol)sym).constValue = this.readPool(this.nextChar());
        } else if (attrName == Names.Code) {
            if (this.readAllOfClassFile) {
                ((Symbol.MethodSymbol)sym).code = this.readCode(sym);
            } else {
                this.bp += attrLen;
            }
        } else if (attrName == Names.Exceptions) {
            int nexceptions = this.nextChar();
            ListBuffer<Symbol.ClassSymbol> thrown = new ListBuffer<Symbol.ClassSymbol>();
            for (int j = 0; j < nexceptions; ++j) {
                thrown.append(this.readClassSymbol(this.nextChar()));
            }
            sym.type.methodType().thrown = thrown.toList();
        } else if (attrName == Names.Synthetic) {
            sym.flags_field |= 0x10000;
        } else if (attrName == Names.Deprecated) {
            sym.flags_field |= 0x20000;
        } else if (attrName == Names.Signature) {
            List<Symbol.ClassSymbol> list = sym.type.thrown();
            sym.type = this.readType(this.nextChar());
            if (list.nonEmpty()) {
                sym.type.methodType().thrown = list;
            }
        } else {
            this.unrecogized(attrName);
            this.bp += attrLen;
        }
    }

    void readAttrs(Symbol sym) {
        int ac = this.nextChar();
        for (int i = 0; i < ac; ++i) {
            Name attrName = this.readName(this.nextChar());
            int n = this.nextInt();
            this.readAttr(sym, attrName, n);
        }
    }

    Code readCode(Symbol symbol) {
        return null;
    }

    Symbol.VarSymbol readField() {
        char flags = this.nextChar();
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(flags, name, type, this.currentOwner);
        this.readAttrs(varSymbol);
        return varSymbol;
    }

    Symbol.MethodSymbol readMethod() {
        char flags = this.nextChar();
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        if (name == Names.init && this.currentOwner.isNested()) {
            type = new Type.MethodType(type.argtypes().tail, type.restype(), type.thrown());
        }
        Symbol.MethodSymbol m = new Symbol.MethodSymbol(flags, name, type, this.currentOwner);
        Symbol symbol = this.currentOwner;
        this.currentOwner = m;
        this.readAttrs(m);
        this.currentOwner = symbol;
        return m;
    }

    void skipMember() {
        this.bp += 6;
        int ac = this.nextChar();
        for (int i = 0; i < ac; ++i) {
            this.bp += 2;
            int n = this.nextInt();
            this.bp += n;
        }
    }

    void enterTypevars(Type t) {
        if (t.outer().tag == 10) {
            this.enterTypevars(t.outer());
        }
        List<Type> list = t.typarams();
        while (list.nonEmpty()) {
            this.typevars.enter(((Type)list.head).tsym);
            list = list.tail;
        }
    }

    void readClass(Symbol.ClassSymbol c) {
        Symbol.ClassSymbol self;
        this.currentOwner = c;
        Type.ClassType ct = (Type.ClassType)c.type;
        c.members_field = new Scope(c);
        this.typevars = this.typevars.dup();
        if (ct.outer().tag == 10) {
            this.enterTypevars(ct.outer());
        }
        char flags = this.nextChar();
        if (c.owner.kind == 1) {
            c.flags_field = flags;
        }
        if (c != (self = this.readClassSymbol(this.nextChar()))) {
            throw new LoadError(String.valueOf("class file contains wrong class: ").concat(String.valueOf(self.flatname)));
        }
        int startbp = this.bp;
        this.nextChar();
        char interfaceCount = this.nextChar();
        this.bp += interfaceCount * 2;
        int fieldCount = this.nextChar();
        for (int i = 0; i < fieldCount; ++i) {
            this.skipMember();
        }
        int methodCount = this.nextChar();
        for (int i = 0; i < methodCount; ++i) {
            this.skipMember();
        }
        int attrCount = this.nextChar();
        for (int i = 0; i < attrCount; ++i) {
            Name attrName = this.readName(this.nextChar());
            int attrLen = this.nextInt();
            if (attrName == Names.SourceFile) {
                c.sourcefile = this.readName(this.nextChar());
                continue;
            }
            if (attrName == Names.InnerClasses) {
                this.readInnerClasses(c);
                continue;
            }
            if (attrName == Names.Signature) {
                Type.ClassType ct1 = new Type.ClassType(ct.outer_field, this.readTypeParams(this.nextChar()), ct.tsym);
                ct1.supertype_field = this.sigToType();
                ListBuffer<Type> is = new ListBuffer<Type>();
                while (this.sigp != this.siglimit) {
                    is.append(this.sigToType());
                }
                ct1.interfaces_field = is.toList();
                c.type = ct1;
                continue;
            }
            this.readAttr(c, attrName, attrLen);
        }
        if (this.readAllOfClassFile) {
            for (int i = 1; i < this.pool.length; ++i) {
                this.readPool(i);
            }
            c.pool = new Pool(this.pool.length, this.pool);
        }
        this.bp = startbp;
        int n = this.nextChar();
        ct.supertype_field = n == 0 ? Type.noType : this.readClassSymbol((int)n).type;
        n = this.nextChar();
        Type[] is = new Type[n];
        for (int i = 0; i < n; ++i) {
            is[i] = this.readClassSymbol((int)this.nextChar()).type;
        }
        ct.interfaces_field = List.make(is);
        Base._assert(fieldCount == this.nextChar());
        for (int i = 0; i < fieldCount; ++i) {
            c.members_field.enter(this.readField());
        }
        Base._assert(methodCount == this.nextChar());
        for (int i = 0; i < methodCount; ++i) {
            c.members_field.enter(this.readMethod());
        }
        this.typevars = this.typevars.leave();
    }

    void readInnerClasses(Symbol.ClassSymbol c) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.nextChar();
            Symbol.ClassSymbol outer = this.readClassSymbol(this.nextChar());
            Name name = this.readName(this.nextChar());
            if (name == null) {
                name = Names.empty;
            }
            char flags = this.nextChar();
            if (outer == null) continue;
            Symbol.ClassSymbol classSymbol = this.enterClass(name, outer);
            if ((flags & 8) == 0) {
                ((Type.ClassType)classSymbol.type).outer_field = outer.type;
            }
            if (c != outer) continue;
            classSymbol.flags_field = flags;
            c.members_field.enter(classSymbol);
        }
    }

    void readClassFile(Symbol.ClassSymbol c) throws IOException {
        int magic = this.nextInt();
        if (magic != -889275714) {
            throw new LoadError("illegal start of class file");
        }
        char minorVersion = this.nextChar();
        char c2 = this.nextChar();
        if (this.checkClassFile && (c2 > '.' || c2 == '.' && minorVersion > '\u0000')) {
            throw new LoadError(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("class file has wrong version ").concat(String.valueOf((int)c2))).concat(String.valueOf("."))).concat(String.valueOf((int)minorVersion))).concat(String.valueOf(", should be "))).concat(String.valueOf(46))).concat(String.valueOf("."))).concat(String.valueOf(0)));
        }
        this.indexPool();
        this.readClass(c);
    }

    boolean isZip(String string) {
        return string.endsWith(".zip") || string.endsWith(".jar");
    }

    ZipFile openDir(String dirname) throws IOException {
        ZipFile zipFile = this.dirs.get(dirname);
        if (zipFile == null) {
            zipFile = new ZipFile(dirname);
            this.dirs.put(dirname, zipFile);
        }
        return zipFile;
    }

    private List<FileEntry> list(String dirname, String name) {
        ListBuffer<FileEntry> entries = null;
        try {
            if (this.isZip(dirname)) {
                ZipFile zdir = this.openDir(dirname);
                if (name.length() != 0 && !(name = name.replace('\\', '/')).endsWith("/")) {
                    name = String.valueOf(name).concat(String.valueOf("/"));
                }
                int namelen = name.length();
                Enumeration<? extends ZipEntry> e = zdir.entries();
                while (e.hasMoreElements()) {
                    String suffix;
                    ZipEntry entry = e.nextElement();
                    String ename = entry.getName();
                    if (!ename.startsWith(name)) continue;
                    if (entries == null) {
                        entries = new ListBuffer();
                    }
                    if ((suffix = ename.substring(namelen)).length() <= 0 || suffix.indexOf(47) >= 0) continue;
                    entries.append(new FileEntry.Zipped(suffix, zdir, entry));
                }
            } else {
                File f = name.length() != 0 ? new File(dirname, name) : new File(dirname);
                String[] names = f.list();
                if (names != null) {
                    if (entries == null) {
                        entries = new ListBuffer<FileEntry>();
                    }
                    for (int i = 0; i < names.length; ++i) {
                        entries.append(new FileEntry.Regular(names[i], new File(f, names[i])));
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return entries != null ? entries.toList() : null;
    }

    public Symbol.ClassSymbol defineClass(Name name, Symbol owner) {
        Symbol.ClassSymbol classSymbol = new Symbol.ClassSymbol(0, name, owner);
        classSymbol.completer = this;
        return classSymbol;
    }

    public Symbol.ClassSymbol enterClass(Name name, Symbol.TypeSymbol owner) {
        Name flatname = Symbol.TypeSymbol.formFlatName(name, owner);
        Symbol.ClassSymbol classSymbol = this.classes.get(flatname);
        if (classSymbol == null) {
            classSymbol = this.defineClass(name, owner);
            this.classes.put(flatname, classSymbol);
        } else if ((classSymbol.name != name || classSymbol.owner != owner) && owner.kind == 2) {
            classSymbol.name = name;
            classSymbol.owner = owner;
            classSymbol.fullname = Symbol.TypeSymbol.formFullName(name, owner);
        }
        return classSymbol;
    }

    public Symbol.ClassSymbol enterClass(Name flatname) {
        Symbol.ClassSymbol classSymbol = this.classes.get(flatname);
        if (classSymbol == null) {
            if (this.checkClassFile) {
                Base._assert(flatname.indexOf((byte)36) == flatname.len, flatname);
            }
            classSymbol = this.defineClass(Convert.shortName(flatname), this.enterPackage(Convert.packagePart(flatname)));
            this.classes.put(flatname, classSymbol);
        }
        return classSymbol;
    }

    @Override
    public void complete(Symbol sym) throws Symbol.CompletionFailure {
        if (sym.kind == 2) {
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
            c.owner.complete();
            this.fillIn(c);
        } else if (sym.kind == 1) {
            Symbol.PackageSymbol packageSymbol = (Symbol.PackageSymbol)sym;
            this.fillIn(packageSymbol);
        }
        sym.isExternal = true;
    }

    public void fillIn(Symbol.ClassSymbol c) {
        this.currentClass = c;
        FileEntry classfile = c.classfile;
        c.members_field = Scope.errScope;
        if (classfile != null) {
            try {
                InputStream s = classfile.open();
                this.currentClassFileName = classfile.getPath();
                if (this.verbose) {
                    System.err.println(String.valueOf(String.valueOf("[loading ").concat(String.valueOf(this.currentClassFileName))).concat(String.valueOf("]")));
                }
                if (classfile.getName().endsWith(".class") || classfile.getName().endsWith(".signature") || classfile.getName().endsWith(".rep_signature")) {
                    int size = (int)classfile.length();
                    if (this.buf.length < size) {
                        this.buf = new byte[size];
                    }
                    for (int n = 0; n < size; n += s.read(this.buf, n, size - n)) {
                    }
                    s.close();
                    this.bp = 0;
                    this.readClassFile(c);
                } else {
                    this.sourceCompleter.complete(c, this.currentClassFileName, s);
                }
                return;
            }
            catch (IOException iOException) {
                throw new LoadError(iOException.getMessage());
            }
        }
        throw new Symbol.CompletionFailure(c, String.valueOf(String.valueOf("file ").concat(String.valueOf(ClassFile.externalizeFileName(c.flatname)))).concat(String.valueOf(".class not found")));
    }

    public Symbol.ClassSymbol loadClass(Name flatname) throws Symbol.CompletionFailure {
        boolean absent = this.classes.get(flatname) == null;
        Symbol.ClassSymbol c = this.enterClass(flatname);
        if (c.members_field == null && c.completer != null) {
            try {
                c.complete();
            }
            catch (Symbol.CompletionFailure completionFailure) {
                if (absent) {
                    this.classes.remove(flatname);
                }
                throw completionFailure;
            }
        }
        return c;
    }

    public Symbol.PackageSymbol enterPackage(Name fullname) {
        Symbol.PackageSymbol packageSymbol = this.packages.get(fullname);
        if (packageSymbol == null) {
            packageSymbol = new Symbol.PackageSymbol(Convert.shortName(fullname), this.enterPackage(Convert.packagePart(fullname)));
            packageSymbol.completer = this;
            this.packages.put(fullname, packageSymbol);
        }
        return packageSymbol;
    }

    private void fillIn(Symbol.PackageSymbol p) {
        if (p.members_field == null) {
            p.members_field = new Scope(p);
        }
        String dirname = ClassFile.externalizeFileName(p.fullname);
        int i = 0;
        while (i < this.classPath.length()) {
            int end = this.classPath.indexOf(pathSep, i);
            String pathname = this.classPath.substring(i, end);
            List<FileEntry> list = this.list(pathname, dirname);
            if (list != null) {
                p.flags_field |= 0x1000000;
                this.includeClassFiles(list, p);
            }
            i = end + 1;
        }
    }

    void includeClassFiles(List<FileEntry> files, Symbol.PackageSymbol p) {
        List<FileEntry> l;
        if (this.mode_include_classes == MODE_LOAD_SIG_FILE) {
            if (!secondRun) {
                l = files;
                while (l.nonEmpty()) {
                    if (!this.includeClassFile((FileEntry)l.head, p, ".rep_signature")) {
                        this.includeClassFile((FileEntry)l.head, p, ".signature");
                    }
                    l = l.tail;
                }
            } else {
                l = files;
                while (l.nonEmpty()) {
                    this.includeClassFile((FileEntry)l.head, p, ".signature");
                    l = l.tail;
                }
            }
        }
        l = files;
        while (l.nonEmpty()) {
            this.includeClassFile((FileEntry)l.head, p, ".class");
            l = l.tail;
        }
        if (this.sourceCompleter != null) {
            List<FileEntry> list = files;
            while (list.nonEmpty()) {
                this.includeClassFile((FileEntry)list.head, p, ".java");
                list = list.tail;
            }
        }
    }

    boolean includeClassFile(FileEntry file, Symbol.PackageSymbol p, String extension) {
        String filename = file.getName();
        if (filename.endsWith(extension)) {
            Symbol.ClassSymbol classSymbol = this.enterClass(Name.fromString(filename.substring(0, filename.length() - extension.length())), p);
            if (p.members_field.lookup((Name)classSymbol.name).sym != classSymbol) {
                classSymbol.classfile = file;
                p.members_field.enter(classSymbol);
            }
            return true;
        }
        return false;
    }

    public static interface SourceCompleter {
        public void complete(Symbol.ClassSymbol var1, String var2, InputStream var3) throws Symbol.CompletionFailure;
    }

    public class LoadError
    extends Symbol.CompletionFailure {
        public LoadError(Symbol.ClassSymbol c, String cname, String string) {
            super(c, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("bad file: ").concat(String.valueOf(cname))).concat(String.valueOf(", "))).concat(String.valueOf(string))).concat(String.valueOf(". Please remove or make sure it appears in correct "))).concat(String.valueOf("subdirectory of the classpath")));
        }

        public LoadError(String string) {
            this(this$0.currentClass, this$0.currentClassFileName, string);
        }
    }
}

