/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.code;

import gjc.v6.code.ClassReader;
import gjc.v6.code.Code;
import gjc.v6.code.Pool;
import gjc.v6.code.Symbol;
import gjc.v6.util.Hashtable;
import gjc.v6.util.Name;
import gjc.v6.util.Names;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteClassReader
extends ClassReader {
    public CompleteClassReader(Hashtable<String, String> hashtable) {
        super(hashtable);
    }

    @Override
    void indexPool() {
        super.indexPool();
        for (int i = 1; i < this.pool.length; ++i) {
            this.readPool(i);
        }
    }

    @Override
    void readClass(Symbol.ClassSymbol classSymbol) {
        classSymbol.pool = new Pool(this.pool.length, this.pool);
        super.readClass(classSymbol);
    }

    @Override
    void readAttr(Symbol sym, Name attrName, int n) {
        if (attrName == Names.Code) {
            ((Symbol.MethodSymbol)sym).code = this.readCode(sym);
        } else {
            super.readAttr(sym, attrName, n);
        }
    }

    @Override
    Code readCode(Symbol owner) {
        Code code = new Code(false, true);
        code.max_stack = this.nextChar();
        code.max_locals = this.nextChar();
        code.cp = this.nextInt();
        code.code = new byte[code.cp];
        System.arraycopy(this.buf, this.bp, code.code, 0, code.cp);
        this.bp += code.cp;
        int ncatches = this.nextChar();
        for (int i = 0; i < ncatches; ++i) {
            code.addCatch(this.nextChar(), this.nextChar(), this.nextChar(), this.nextChar());
        }
        int ac = this.nextChar();
        for (int i = 0; i < ac; ++i) {
            Name attrName = this.readName(this.nextChar());
            int attrLen = this.nextInt();
            if (attrName == Names.LineNumberTable) {
                int nlines = this.nextChar();
                for (int j = 0; j < nlines; ++j) {
                    code.addLineNumber(this.nextChar(), this.nextChar());
                }
                continue;
            }
            if (attrName == Names.LocalVariableTable) {
                code.nvars = this.nextChar();
                code.lvar_start_pc = new char[code.nvars];
                code.lvar_length = new char[code.nvars];
                code.lvar_reg = new char[code.nvars];
                code.lvar = new Symbol.VarSymbol[code.nvars];
                for (int j = 0; j < code.nvars; ++j) {
                    code.lvar_start_pc[j] = this.nextChar();
                    code.lvar_length[j] = this.nextChar();
                    code.lvar[j] = new Symbol.VarSymbol(0, this.readName(this.nextChar()), this.readType(this.nextChar()), owner);
                    code.lvar_reg[j] = this.nextChar();
                    code.lvar[j].adr = code.lvar_reg[j];
                }
                continue;
            }
            this.unrecogized(attrName);
            this.bp += attrLen;
        }
        return code;
    }
}

