/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.comp;

import gjc.v6.code.ClassReader;
import gjc.v6.code.Flags;
import gjc.v6.code.Kinds;
import gjc.v6.code.Scope;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.comp.Symtab;
import gjc.v6.tree.Tree;
import gjc.v6.tree.TreeInfo;
import gjc.v6.util.Abort;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.Log;
import gjc.v6.util.Name;
import gjc.v6.util.Names;
import gjc.v6.util.Set;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Check
implements Kinds,
Flags,
TypeTags {
    protected Log log;
    protected Symtab syms;
    public Set<Name> compiled = new Set();
    boolean unchecked;
    private Validator validator = new Validator();

    public Check(Log log, Symtab syms, Hashtable<String, String> hashtable) {
        this.log = log;
        this.syms = syms;
        this.unchecked = hashtable.get("-unchecked") != null;
    }

    Type completionError(int pos, Symbol.CompletionFailure completionFailure) {
        this.log.error(pos, String.valueOf(String.valueOf(String.valueOf("cannot access ").concat(String.valueOf(completionFailure.sym))).concat(String.valueOf("; "))).concat(String.valueOf(completionFailure.errmsg)));
        if (completionFailure instanceof ClassReader.LoadError) {
            throw new Abort();
        }
        return Type.errType;
    }

    Type typeError(int pos, String problem, Type found, Type type) {
        this.log.error(pos, String.valueOf(String.valueOf(String.valueOf(String.valueOf(problem).concat(String.valueOf("\n found   : "))).concat(String.valueOf(found))).concat(String.valueOf("\n required: "))).concat(String.valueOf(type)));
        return Type.errType;
    }

    Type typeTagError(int pos, String required, Type type) {
        this.log.error(pos, String.valueOf(String.valueOf(String.valueOf(required).concat(String.valueOf(" type required, but "))).concat(String.valueOf(type))).concat(String.valueOf(" found")));
        return Type.errType;
    }

    void earlyRefError(int pos, Symbol symbol) {
        this.log.error(pos, String.valueOf(String.valueOf("cannot reference ").concat(String.valueOf(symbol.name))).concat(String.valueOf(" before supertype constructor has been called")));
    }

    Type checkType(int pos, Type foundt, Type reqt) {
        if (reqt.tag == 18) {
            return reqt;
        }
        if (foundt.assignable(reqt)) {
            return foundt;
        }
        if (foundt.isRaw() && Type.minimizeRaw(foundt).assignable(reqt)) {
            if (!this.unchecked) {
                this.log.warning(pos, String.valueOf(String.valueOf(String.valueOf("unchecked assignment: ").concat(String.valueOf(foundt))).concat(String.valueOf(" to "))).concat(String.valueOf(reqt)));
            }
            return reqt;
        }
        String string = foundt.tag <= 7 && reqt.tag <= 7 ? "possible loss of precision" : "incompatible types";
        return this.typeError(pos, string, foundt, reqt);
    }

    Type checkCastable(int pos, Type foundt, Type type) {
        if (foundt.castableTo(type)) {
            return type;
        }
        if ((foundt.tag == 10 || foundt.tag == 11) && Check.isTypeVar(type)) {
            if (!this.unchecked) {
                this.log.warning(pos, String.valueOf("unchecked cast to type ").concat(String.valueOf(type)));
            }
            return type;
        }
        return this.typeError(pos, "inconvertible types", foundt, type);
    }

    static boolean isTypeVar(Type t) {
        return t.tag == 14 || t.tag == 11 && Check.isTypeVar(t.elemtype());
    }

    public boolean checkDeeplyExtends(int pos, boolean reportErrors, Type a, Type type) {
        if (!a.subType(type)) {
            this.log.error(pos, String.valueOf(String.valueOf(String.valueOf("type parameter ").concat(String.valueOf(a))).concat(String.valueOf(" is not within its bound "))).concat(String.valueOf(type)));
            return false;
        }
        return this.checkDeeplyExtends(pos, reportErrors, a, type, a, type);
    }

    public boolean checkDeeplyExtends(int pos, boolean reportErrors, Type aroot, Type broot, Type a, Type b) {
        if (a == b) {
            return true;
        }
        if (!a.subType(b)) {
            if (reportErrors) {
                this.log.error(pos, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("type parameter ").concat(String.valueOf(aroot))).concat(String.valueOf(" is not within its bound "))).concat(String.valueOf(broot))).concat(String.valueOf(" since "))).concat(String.valueOf(a))).concat(String.valueOf(" is not a subtype of "))).concat(String.valueOf(b)));
            }
            return false;
        }
        Scope s = b.tsym.members();
        if (s != null) {
            Scope.Entry e = s.elems;
            while (e != null) {
                if (e.sym.kind == 2 && (e.sym.flags_field & 0xA) == 0) {
                    Type b1 = b.memberType(e.sym);
                    Type type = a.memberType(a.memberClass(e.sym.name));
                    if ((type.tsym.flags_field & 8) != 0) {
                        if (reportErrors) {
                            this.log.error(pos, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("type parameter ").concat(String.valueOf(aroot))).concat(String.valueOf(" is not within its bound "))).concat(String.valueOf(broot))).concat(String.valueOf(" since "))).concat(String.valueOf(a))).concat(String.valueOf(" is static")));
                        }
                        return false;
                    }
                    if (Check.protection(a.tsym.flags_field) > Check.protection(b.tsym.flags_field)) {
                        if (reportErrors) {
                            this.log.error(pos, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("type parameter ").concat(String.valueOf(aroot))).concat(String.valueOf(" is not within its bound "))).concat(String.valueOf(broot))).concat(String.valueOf(" since "))).concat(String.valueOf(a))).concat(String.valueOf(" has weaker access priviliges than "))).concat(String.valueOf(b)));
                        }
                        return false;
                    }
                    if (!this.checkDeeplyExtends(pos, reportErrors, aroot, broot, type, b1)) {
                        return false;
                    }
                }
                e = e.sibling;
            }
        }
        return true;
    }

    Type checkNonVoid(int pos, Type type) {
        if (type.tag == 9) {
            this.log.error(pos, "'void' type not allowed here");
            return Type.errType;
        }
        return type;
    }

    Type checkClassType(int pos, Type type) {
        if (type.tag != 10 && type.tag != 11 && type.tag != 18) {
            return this.typeTagError(pos, "class", type);
        }
        return type;
    }

    Type checkClassOrArrayType(int pos, Type type) {
        if (type.tag != 10 && type.tag != 11 && type.tag != 18) {
            return this.typeTagError(pos, "class or array", type);
        }
        return type;
    }

    Type checkRefType(int pos, Type type) {
        if (type.tag != 10 && type.tag != 11 && type.tag != 14 && type.tag != 18) {
            return this.typeTagError(pos, "reference", type);
        }
        return type;
    }

    protected boolean checkDisjoint(int pos, int flags, int set1, int n) {
        if ((flags & set1) != 0 && (flags & n) != 0) {
            this.log.error(pos, String.valueOf(String.valueOf(String.valueOf("illegal combination of modifiers: ").concat(String.valueOf(TreeInfo.flagNames(TreeInfo.firstFlag(flags & set1))))).concat(String.valueOf(" and "))).concat(String.valueOf(TreeInfo.flagNames(TreeInfo.firstFlag(flags & n)))));
            return false;
        }
        return true;
    }

    protected int checkFlags(int pos, int flags, Symbol sym) {
        int mask;
        int implicit = 0;
        switch (sym.kind) {
            case 4: {
                if (sym.owner.kind != 2) {
                    mask = 4112;
                    break;
                }
                if ((sym.owner.flags() & 0x200) != 0) {
                    implicit = 25;
                    mask = 25;
                    break;
                }
                mask = 12511;
                break;
            }
            case 32: {
                if (sym.name == Names.init) {
                    mask = 7;
                    break;
                }
                if ((sym.owner.flags() & 0x200) != 0) {
                    implicit = 1025;
                    mask = 1025;
                    break;
                }
                mask = 469763391;
                break;
            }
            case 2: {
                if (sym.isLocal()) {
                    mask = 1040;
                    if (sym.name.len != 0) break;
                    mask |= 8;
                    break;
                }
                if (sym.owner.kind == 2) {
                    mask = 1559;
                    if (sym.owner.owner.kind == 1 || (sym.owner.flags_field & 8) != 0) {
                        mask |= 8;
                    }
                    if ((flags & 0x200) == 0) break;
                    implicit = 8;
                    break;
                }
                mask = 33558033;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        int n = flags & 0x2FFF & ~mask;
        if (n != 0) {
            this.log.error(pos, String.valueOf(String.valueOf("modifier ").concat(String.valueOf(TreeInfo.flagNames(n)))).concat(String.valueOf(" not allowed here")));
        } else if (sym.kind != 2 && !this.checkDisjoint(pos, flags, 1536, 10) || !this.checkDisjoint(pos, flags, 1536, 304) || !this.checkDisjoint(pos, flags, 1, 6) || !this.checkDisjoint(pos, flags, 2, 5) || this.checkDisjoint(pos, flags, 16, 64)) {
            // empty if block
        }
        return flags & (mask | 0xFFFFD000) | implicit;
    }

    void validate(Tree tree) {
        try {
            if (tree != null) {
                tree.visit(this.validator, null);
            }
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.completionError(tree.pos, completionFailure);
        }
    }

    void validate(List<Tree> trees) {
        List<Tree> list = trees;
        while (list.nonEmpty()) {
            this.validate((Tree)list.head);
            list = list.tail;
        }
    }

    void validateTypeParams(List<Tree.TypeParameter> trees) {
        List<Tree.TypeParameter> list = trees;
        while (list.nonEmpty()) {
            this.validate((Tree)list.head);
            list = list.tail;
        }
    }

    static boolean elem(Symbol.ClassSymbol c, List<Symbol.ClassSymbol> cs) {
        List<Symbol.ClassSymbol> l = cs;
        while (l.nonEmpty()) {
            if (c.subclass((Symbol)l.head)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    static boolean intersects(Symbol.ClassSymbol c, List<Symbol.ClassSymbol> cs) {
        List<Symbol.ClassSymbol> l = cs;
        while (l.nonEmpty()) {
            if (c.subclass((Symbol)l.head) || ((Symbol.ClassSymbol)l.head).subclass(c)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    static List<Symbol.ClassSymbol> incl(Symbol.ClassSymbol c, List<Symbol.ClassSymbol> cs) {
        return Check.elem(c, cs) ? cs : Check.excl(c, cs).prepend(c);
    }

    static List<Symbol.ClassSymbol> excl(Symbol.ClassSymbol c, List<Symbol.ClassSymbol> cs) {
        if (cs.isEmpty()) {
            return cs;
        }
        List<Symbol.ClassSymbol> cs1 = Check.excl(c, cs.tail);
        if (((Symbol.ClassSymbol)cs.head).subclass(c)) {
            return cs1;
        }
        if (cs1 == cs.tail) {
            return cs;
        }
        return cs1.prepend((Symbol.ClassSymbol)cs.head);
    }

    static List<Symbol.ClassSymbol> union(List<Symbol.ClassSymbol> cs1, List<Symbol.ClassSymbol> cs2) {
        List<Symbol.ClassSymbol> cs = cs1;
        List<Symbol.ClassSymbol> l = cs2;
        while (l.nonEmpty()) {
            cs = Check.incl((Symbol.ClassSymbol)l.head, cs);
            l = l.tail;
        }
        return cs;
    }

    static List<Symbol.ClassSymbol> diff(List<Symbol.ClassSymbol> cs1, List<Symbol.ClassSymbol> cs2) {
        List<Symbol.ClassSymbol> cs = cs1;
        List<Symbol.ClassSymbol> l = cs2;
        while (l.nonEmpty()) {
            cs = Check.excl((Symbol.ClassSymbol)l.head, cs);
            l = l.tail;
        }
        return cs;
    }

    static List<Symbol.ClassSymbol> intersect(List<Symbol.ClassSymbol> cs1, List<Symbol.ClassSymbol> cs2) {
        List<Symbol.ClassSymbol> cs = Symbol.ClassSymbol.emptyList;
        List<Symbol.ClassSymbol> l = cs1;
        while (l.nonEmpty()) {
            if (Check.elem((Symbol.ClassSymbol)l.head, cs2)) {
                cs = Check.incl((Symbol.ClassSymbol)l.head, cs);
            }
            l = l.tail;
        }
        List<Symbol.ClassSymbol> l2 = cs2;
        while (l2.nonEmpty()) {
            if (Check.elem((Symbol.ClassSymbol)l2.head, cs1)) {
                cs = Check.incl((Symbol.ClassSymbol)l2.head, cs);
            }
            l2 = l2.tail;
        }
        return cs;
    }

    boolean isUnchecked(Symbol.ClassSymbol classSymbol) {
        return classSymbol == Type.errType.tsym || classSymbol.subclass(this.syms.errorType.tsym) || classSymbol.subclass(this.syms.runtimeExceptionType.tsym);
    }

    boolean isHandled(Symbol.ClassSymbol exc, List<Symbol.ClassSymbol> list) {
        return this.isUnchecked(exc) || Check.elem(exc, list);
    }

    List<Symbol.ClassSymbol> unHandled(List<Symbol.ClassSymbol> thrown, List<Symbol.ClassSymbol> handled) {
        List<Symbol.ClassSymbol> unhandled = Symbol.ClassSymbol.emptyList;
        List<Symbol.ClassSymbol> list = thrown;
        while (list.nonEmpty()) {
            if (!this.isHandled((Symbol.ClassSymbol)list.head, handled)) {
                unhandled = unhandled.prepend((Symbol.ClassSymbol)list.head);
            }
            list = list.tail;
        }
        return unhandled;
    }

    void checkHandled(int pos, Symbol.ClassSymbol exc, List<Symbol.ClassSymbol> list) {
        if (!this.isHandled(exc, list)) {
            this.log.error(pos, String.valueOf(String.valueOf("unreported exception: ").concat(String.valueOf(exc.type))).concat(String.valueOf("; must be caught or declared to be thrown")));
        }
    }

    void checkHandled(int pos, List<Symbol.ClassSymbol> thrown, List<Symbol.ClassSymbol> reported) {
        List<Symbol.ClassSymbol> list = this.unHandled(thrown, reported);
        if (list.nonEmpty()) {
            this.checkHandled(pos, (Symbol.ClassSymbol)list.head, reported);
        }
    }

    private static int protection(int flags) {
        switch (flags & 7) {
            case 2: {
                return 3;
            }
            case 4: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        return 2;
    }

    private static String protectionString(int flags) {
        int flags1 = flags & 7;
        return flags1 == 0 ? "package" : TreeInfo.flagNames(flags1);
    }

    static String cannotOverride(Symbol.MethodSymbol m, Symbol.MethodSymbol other) {
        String rel = (other.flags() & 0x100000 | other.owner.flags() & 0x200) == 0 ? " cannot override " : ((m.flags() & 0x100000 | m.owner.flags() & 0x200) == 0 ? " cannot implement " : " clashes with ");
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(m).concat(String.valueOf(m.location()))).concat(String.valueOf(rel))).concat(String.valueOf(other))).concat(String.valueOf(other.location()));
    }

    void checkOverride(int pos, Symbol.MethodSymbol m, Symbol.MethodSymbol other, Symbol.ClassSymbol origin) {
        if ((other.flags() & 0x10000) == 0) {
            if ((m.flags() & 8) != 0 && (other.flags() & 8) == 0) {
                this.log.error(pos, String.valueOf("static ").concat(String.valueOf(Check.cannotOverride(m, other))));
            } else if ((other.flags() & 0x10) != 0 || (m.flags() & 8) == 0 && (other.flags() & 8) != 0) {
                this.log.error(pos, String.valueOf(String.valueOf(Check.cannotOverride(m, other)).concat(String.valueOf("; overridden method is "))).concat(String.valueOf(TreeInfo.flagNames(other.flags() & 0x18))));
            } else if ((origin.flags() & 0x200) == 0 && Check.protection(m.flags()) > Check.protection(other.flags())) {
                this.log.error(pos, String.valueOf(String.valueOf(Check.cannotOverride(m, other)).concat(String.valueOf(" with weaker access privileges; was "))).concat(String.valueOf(Check.protectionString(other.flags()))));
            } else {
                List<Symbol.ClassSymbol> list;
                Type mt = origin.type.memberType(m);
                Type ot = origin.type.memberType(other);
                List<Type> mtvars = mt.typarams();
                List<Type> otvars = ot.typarams();
                Type otres = ot.restype().subst(otvars, mtvars);
                if (!mt.restype().subType(otres)) {
                    if ((m.flags() & 0x100000) != 0 && otres.subType(mt.restype())) {
                        ((Type.MethodType)mt).restype = otres;
                    } else {
                        this.typeError(pos, String.valueOf(Check.cannotOverride(m, other)).concat(String.valueOf(" with incompatible return type")), mt.restype(), ot.restype().subst(otvars, mtvars));
                    }
                } else if ((origin.flags() & 0x200) == 0 && (list = this.unHandled(mt.thrown(), ot.thrown())).nonEmpty()) {
                    if ((m.flags() & 0x100000) != 0) {
                        ((Type.MethodType)mt).thrown = mt.thrown().prepend(list);
                    } else {
                        this.log.error(pos, String.valueOf(String.valueOf(Check.cannotOverride(m, other)).concat(String.valueOf("; overridden method does not throw "))).concat(String.valueOf(list.head)));
                    }
                }
            }
        }
    }

    void checkOverride(int pos, Symbol.MethodSymbol m) {
        Symbol.ClassSymbol origin = (Symbol.ClassSymbol)m.owner;
        Type t = origin.type.supertype();
        while (t.tag == 10) {
            Symbol.TypeSymbol c = t.tsym;
            Scope.Entry entry = c.members().lookup(m.name);
            while (entry.scope != null) {
                if (m.overrides(entry.sym, origin)) {
                    this.checkOverride(pos, m, (Symbol.MethodSymbol)entry.sym, origin);
                    return;
                }
                entry = entry.next();
            }
            t = t.supertype();
        }
    }

    void checkAllDefined(int pos, Symbol.ClassSymbol c) {
        Symbol.MethodSymbol undef = this.firstUndef(c, c);
        if (undef != null) {
            Symbol.MethodSymbol methodSymbol = new Symbol.MethodSymbol(undef.flags(), undef.name, c.type.memberType(undef), undef.owner);
            this.log.error(pos, String.valueOf(String.valueOf(String.valueOf(c).concat(String.valueOf(" should be declared abstract; it does not define "))).concat(String.valueOf(methodSymbol))).concat(String.valueOf(methodSymbol.location())));
        }
    }

    Symbol.MethodSymbol firstUndef(Symbol.ClassSymbol impl, Symbol.ClassSymbol c) {
        Symbol.MethodSymbol undef = null;
        if (c == impl || (c.flags() & 0x600) != 0) {
            Scope s = c.members();
            Scope.Entry e = s.elems;
            while (undef == null && e != null) {
                Symbol.MethodSymbol absmeth;
                Symbol.MethodSymbol implmeth;
                if (e.sym.kind == 32 && (e.sym.flags() & 0x400) != 0 && ((implmeth = (absmeth = (Symbol.MethodSymbol)e.sym).implementation(impl)) == null || implmeth == absmeth)) {
                    undef = absmeth;
                }
                e = e.sibling;
            }
            if (undef == null) {
                Type st = c.type.supertype();
                if (st.tag == 10) {
                    undef = this.firstUndef(impl, (Symbol.ClassSymbol)st.tsym);
                }
            }
            List<Type> list = c.type.interfaces();
            while (undef == null && list.nonEmpty()) {
                undef = this.firstUndef(impl, (Symbol.ClassSymbol)((Type)list.head).tsym);
                list = list.tail;
            }
        }
        return undef;
    }

    void checkImplementations(int pos, Symbol.ClassSymbol origin) {
        List<Type> list = origin.type.interfaces();
        while (list.nonEmpty()) {
            this.checkImplementations(pos, origin, (Symbol.ClassSymbol)((Type)list.head).tsym);
            list = list.tail;
        }
    }

    void checkImplementations(int pos, Symbol.ClassSymbol origin, Symbol.ClassSymbol ic) {
        Scope.Entry e = ic.members().elems;
        while (e != null) {
            Symbol.MethodSymbol absmeth;
            Symbol.MethodSymbol implmeth;
            if (e.sym.kind == 32 && (e.sym.flags() & 8) == 0 && (implmeth = (absmeth = (Symbol.MethodSymbol)e.sym).implementation(origin)) != null) {
                this.checkOverride(pos, implmeth, absmeth, origin);
            }
            e = e.sibling;
        }
        List<Type> list = ic.type.interfaces();
        while (list.nonEmpty()) {
            this.checkImplementations(pos, origin, (Symbol.ClassSymbol)((Type)list.head).tsym);
            list = list.tail;
        }
    }

    void checkClassBounds(int pos, Symbol.ClassSymbol c) {
        Hashtable<Symbol.TypeSymbol, Type> hashtable = Hashtable.make();
        this.checkClassBounds(pos, hashtable, c.type);
    }

    void checkClassBounds(int pos, Hashtable<Symbol.TypeSymbol, Type> seensofar, Type ctype) {
        List<Type> l = ctype.interfaces();
        while (l.nonEmpty()) {
            List<Type> newparams;
            List<Type> oldparams;
            Type it = (Type)l.head;
            Type oldit = seensofar.put(it.tsym, it);
            if (oldit != null && !Type.sameTypes(oldparams = oldit.allParams(), newparams = it.allParams())) {
                this.log.error(pos, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(it.tsym).concat(String.valueOf(" cannot be inherited with different arguments: <"))).concat(String.valueOf(oldparams))).concat(String.valueOf("> and <"))).concat(String.valueOf(newparams))).concat(String.valueOf(">")));
            }
            this.checkClassBounds(pos, seensofar, it);
            l = l.tail;
        }
        Type type = ctype.supertype();
        if (type != null) {
            this.checkClassBounds(pos, seensofar, type);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Validator
    extends Tree.Visitor<Void, Void>
    implements TypeTags {
        Validator() {
        }

        @Override
        public Void _case(Tree.TypeArray tree, Void void_) {
            Check.this.validate(tree.elemtype);
            return null;
        }

        @Override
        public Void _case(Tree.TypeApply tree, Void arg) {
            if (tree.type.tag == 10) {
                List<Type> formals = tree.type.tsym.type.typarams();
                List<Type> actuals = tree.type.typarams();
                List<Tree> args = tree.arguments;
                List<Type> forms = formals;
                while (args.nonEmpty() && forms.nonEmpty()) {
                    Tree a = (Tree)args.head;
                    Type type = ((Type)forms.head).bound().subst(formals, actuals);
                    Check.this.validate(a);
                    Check.this.checkDeeplyExtends(tree.pos, true, a.type, type);
                    args = args.tail;
                    forms = forms.tail;
                }
            }
            return null;
        }

        @Override
        public Void _case(Tree.TypeParameter tree, Void void_) {
            Check.this.validate(tree.extBound);
            Check.this.validate(tree.implBound);
            return null;
        }

        @Override
        public Void _case(Tree.Select tree, Void void_) {
            if (tree.type.tag == 10) {
                if (tree.type.outer().tag == 10) {
                    Check.this.validate(tree.selected);
                } else if (tree.selected.type.isParameterized()) {
                    Check.this.log.error(tree.pos, "cannot select a static class from a parameterized type");
                }
                if (tree.type.isRaw() && tree.type.allParams().nonEmpty()) {
                    Check.this.log.error(tree.pos, "improperly formed type, some parameters are missing");
                }
            }
            return null;
        }

        @Override
        public Void _case(Tree tree, Void void_) {
            return null;
        }

        @Override
        public /* synthetic */ Object _case(Tree x0, Object object) {
            return this._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Erroneous x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeParameter x0, Object object) {
            return this._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeApply x0, Object object) {
            return this._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeArray x0, Object object) {
            return this._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeIdent x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Literal x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Ident x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Select x0, Object object) {
            return this._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Indexed x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeTest x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeCast x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Operation x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Assignop x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Assign x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.NewArray x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.NewClass x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Apply x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Throw x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Return x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Continue x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Break x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Exec x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Assert x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Conditional x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Catch x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Try x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Synchronized x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Case x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Switch x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Labelled x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.ForLoop x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.WhileLoop x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.DoLoop x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Block x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.VarDef x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.MethodDef x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.ClassDef x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Import x0, Object object) {
            return super._case(x0, (Void)object);
        }

        @Override
        public /* synthetic */ Object _case(Tree.TopLevel x0, Object object) {
            return super._case(x0, (Void)object);
        }
    }
}

