/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.comp;

import gjc.v6.code.ByteCodes;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.comp.Symtab;
import gjc.v6.util.List;
import gjc.v6.util.Log;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstFold
implements TypeTags,
ByteCodes {
    Log log;
    Symtab syms;
    static Integer minusOne = new Integer(-1);
    static Integer zero = new Integer(0);
    static Integer one = new Integer(1);

    ConstFold(Log log, Symtab symtab) {
        this.log = log;
        this.syms = symtab;
    }

    private static Integer b2i(boolean b) {
        return b ? one : zero;
    }

    static int intValue(Object x) {
        return ((Number)x).intValue();
    }

    static long longValue(Object x) {
        return ((Number)x).longValue();
    }

    static float floatValue(Object x) {
        return ((Number)x).floatValue();
    }

    static double doubleValue(Object x) {
        return ((Number)x).doubleValue();
    }

    Type fold(int pos, int opcode, List<Type> argtypes) {
        int n = argtypes.length();
        if (n == 1) {
            return this.fold1(pos, opcode, (Type)argtypes.head);
        }
        if (n == 2) {
            return this.fold2(pos, opcode, (Type)argtypes.head, (Type)argtypes.tail.head);
        }
        throw new InternalError();
    }

    Type fold1(int pos, int opcode, Type operand) {
        try {
            Object od = operand.constValue;
            switch (opcode) {
                case 0: {
                    return operand;
                }
                case 116: {
                    return Type.intType.constType(new Integer(-ConstFold.intValue(od)));
                }
                case 130: {
                    return Type.intType.constType(new Integer(~ConstFold.intValue(od)));
                }
                case 257: {
                    return Type.booleanType.constType(new Integer(~ConstFold.intValue(od) & 1));
                }
                case 153: {
                    return Type.booleanType.constType(ConstFold.b2i(ConstFold.intValue(od) == 0));
                }
                case 154: {
                    return Type.booleanType.constType(ConstFold.b2i(ConstFold.intValue(od) != 0));
                }
                case 155: {
                    return Type.booleanType.constType(ConstFold.b2i(ConstFold.intValue(od) < 0));
                }
                case 157: {
                    return Type.booleanType.constType(ConstFold.b2i(ConstFold.intValue(od) > 0));
                }
                case 158: {
                    return Type.booleanType.constType(ConstFold.b2i(ConstFold.intValue(od) <= 0));
                }
                case 156: {
                    return Type.booleanType.constType(ConstFold.b2i(ConstFold.intValue(od) >= 0));
                }
                case 117: {
                    return Type.longType.constType(new Long(-ConstFold.longValue(od)));
                }
                case 131: {
                    return Type.longType.constType(new Long(ConstFold.longValue(od) ^ 0L - 1L));
                }
                case 118: {
                    return Type.floatType.constType(new Float(-ConstFold.floatValue(od)));
                }
                case 119: {
                    return Type.doubleType.constType(new Double(-ConstFold.doubleValue(od)));
                }
            }
            return null;
        }
        catch (ArithmeticException arithmeticException) {
            this.log.error(pos, arithmeticException.toString());
            return Type.errType;
        }
    }

    Type fold2(int pos, int opcode, Type left, Type right) {
        try {
            if (opcode > 511) {
                Type t1 = this.fold2(pos, opcode >> 9, left, right);
                return t1.constValue == null ? t1 : this.fold1(pos, opcode & 0x1FF, t1);
            }
            Object l = left.constValue;
            Object r = right.constValue;
            switch (opcode) {
                case 96: {
                    return Type.intType.constType(new Integer(ConstFold.intValue(l) + ConstFold.intValue(r)));
                }
                case 100: {
                    return Type.intType.constType(new Integer(ConstFold.intValue(l) - ConstFold.intValue(r)));
                }
                case 104: {
                    return Type.intType.constType(new Integer(ConstFold.intValue(l) * ConstFold.intValue(r)));
                }
                case 108: {
                    return Type.intType.constType(new Integer(ConstFold.intValue(l) / ConstFold.intValue(r)));
                }
                case 112: {
                    return Type.intType.constType(new Integer(ConstFold.intValue(l) % ConstFold.intValue(r)));
                }
                case 126: {
                    return Type.intType.constType(new Integer(ConstFold.intValue(l) & ConstFold.intValue(r)));
                }
                case 258: {
                    return Type.booleanType.constType(new Integer(ConstFold.intValue(l) & ConstFold.intValue(r)));
                }
                case 128: {
                    return Type.intType.constType(new Integer(ConstFold.intValue(l) | ConstFold.intValue(r)));
                }
                case 259: {
                    return Type.booleanType.constType(new Integer(ConstFold.intValue(l) | ConstFold.intValue(r)));
                }
                case 130: {
                    return Type.intType.constType(new Integer(ConstFold.intValue(l) ^ ConstFold.intValue(r)));
                }
                case 120: 
                case 270: {
                    return Type.intType.constType(new Integer(ConstFold.intValue(l) << ConstFold.intValue(r)));
                }
                case 122: 
                case 272: {
                    return Type.intType.constType(new Integer(ConstFold.intValue(l) >> ConstFold.intValue(r)));
                }
                case 124: 
                case 274: {
                    return Type.intType.constType(new Integer(ConstFold.intValue(l) >>> ConstFold.intValue(r)));
                }
                case 159: {
                    return Type.booleanType.constType(ConstFold.b2i(ConstFold.intValue(l) == ConstFold.intValue(r)));
                }
                case 160: {
                    return Type.booleanType.constType(ConstFold.b2i(ConstFold.intValue(l) != ConstFold.intValue(r)));
                }
                case 161: {
                    return Type.booleanType.constType(ConstFold.b2i(ConstFold.intValue(l) < ConstFold.intValue(r)));
                }
                case 163: {
                    return Type.booleanType.constType(ConstFold.b2i(ConstFold.intValue(l) > ConstFold.intValue(r)));
                }
                case 164: {
                    return Type.booleanType.constType(ConstFold.b2i(ConstFold.intValue(l) <= ConstFold.intValue(r)));
                }
                case 162: {
                    return Type.booleanType.constType(ConstFold.b2i(ConstFold.intValue(l) >= ConstFold.intValue(r)));
                }
                case 97: {
                    return Type.longType.constType(new Long(ConstFold.longValue(l) + ConstFold.longValue(r)));
                }
                case 101: {
                    return Type.longType.constType(new Long(ConstFold.longValue(l) - ConstFold.longValue(r)));
                }
                case 105: {
                    return Type.longType.constType(new Long(ConstFold.longValue(l) * ConstFold.longValue(r)));
                }
                case 109: {
                    return Type.longType.constType(new Long(ConstFold.longValue(l) / ConstFold.longValue(r)));
                }
                case 113: {
                    return Type.longType.constType(new Long(ConstFold.longValue(l) % ConstFold.longValue(r)));
                }
                case 127: {
                    return Type.longType.constType(new Long(ConstFold.longValue(l) & ConstFold.longValue(r)));
                }
                case 129: {
                    return Type.longType.constType(new Long(ConstFold.longValue(l) | ConstFold.longValue(r)));
                }
                case 131: {
                    return Type.longType.constType(new Long(ConstFold.longValue(l) ^ ConstFold.longValue(r)));
                }
                case 121: 
                case 271: {
                    return Type.longType.constType(new Long(ConstFold.longValue(l) << ConstFold.intValue(r)));
                }
                case 123: 
                case 273: {
                    return Type.longType.constType(new Long(ConstFold.longValue(l) >> ConstFold.intValue(r)));
                }
                case 125: {
                    return Type.longType.constType(new Long(ConstFold.longValue(l) >>> ConstFold.intValue(r)));
                }
                case 148: {
                    if (ConstFold.longValue(l) < ConstFold.longValue(r)) {
                        return Type.intType.constType(minusOne);
                    }
                    if (ConstFold.longValue(l) > ConstFold.longValue(r)) {
                        return Type.intType.constType(one);
                    }
                    return Type.intType.constType(zero);
                }
                case 98: {
                    return Type.floatType.constType(new Float(ConstFold.floatValue(l) + ConstFold.floatValue(r)));
                }
                case 102: {
                    return Type.floatType.constType(new Float(ConstFold.floatValue(l) - ConstFold.floatValue(r)));
                }
                case 106: {
                    return Type.floatType.constType(new Float(ConstFold.floatValue(l) * ConstFold.floatValue(r)));
                }
                case 110: {
                    return Type.floatType.constType(new Float(ConstFold.floatValue(l) / ConstFold.floatValue(r)));
                }
                case 114: {
                    return Type.floatType.constType(new Float(ConstFold.floatValue(l) % ConstFold.floatValue(r)));
                }
                case 149: 
                case 150: {
                    if (ConstFold.floatValue(l) < ConstFold.floatValue(r)) {
                        return Type.intType.constType(minusOne);
                    }
                    if (ConstFold.floatValue(l) > ConstFold.floatValue(r)) {
                        return Type.intType.constType(one);
                    }
                    if (ConstFold.floatValue(l) == ConstFold.floatValue(r)) {
                        return Type.intType.constType(zero);
                    }
                    if (opcode == 150) {
                        return Type.intType.constType(one);
                    }
                    return Type.intType.constType(minusOne);
                }
                case 99: {
                    return Type.doubleType.constType(new Double(ConstFold.doubleValue(l) + ConstFold.doubleValue(r)));
                }
                case 103: {
                    return Type.doubleType.constType(new Double(ConstFold.doubleValue(l) - ConstFold.doubleValue(r)));
                }
                case 107: {
                    return Type.doubleType.constType(new Double(ConstFold.doubleValue(l) * ConstFold.doubleValue(r)));
                }
                case 111: {
                    return Type.doubleType.constType(new Double(ConstFold.doubleValue(l) / ConstFold.doubleValue(r)));
                }
                case 115: {
                    return Type.doubleType.constType(new Double(ConstFold.doubleValue(l) % ConstFold.doubleValue(r)));
                }
                case 151: 
                case 152: {
                    if (ConstFold.doubleValue(l) < ConstFold.doubleValue(r)) {
                        return Type.intType.constType(minusOne);
                    }
                    if (ConstFold.doubleValue(l) > ConstFold.doubleValue(r)) {
                        return Type.intType.constType(one);
                    }
                    if (ConstFold.doubleValue(l) == ConstFold.doubleValue(r)) {
                        return Type.intType.constType(zero);
                    }
                    if (opcode == 152) {
                        return Type.intType.constType(one);
                    }
                    return Type.intType.constType(minusOne);
                }
                case 165: {
                    return Type.booleanType.constType(ConstFold.b2i(l.equals(r)));
                }
                case 166: {
                    return Type.booleanType.constType(ConstFold.b2i(!l.equals(r)));
                }
                case 256: {
                    return this.syms.stringType.constType(String.valueOf(left.constValue.toString()).concat(String.valueOf(right.constValue.toString())));
                }
            }
            return null;
        }
        catch (ArithmeticException arithmeticException) {
            this.log.error(pos, arithmeticException.toString());
            return Type.errType;
        }
    }

    Type coerce(Type etype, Type ttype) {
        if (etype.tag == ttype.tag) {
            return etype;
        }
        if (etype.tag <= 7) {
            Object object = etype.constValue;
            switch (ttype.tag) {
                case 1: {
                    return Type.byteType.constType(new Integer((byte)ConstFold.intValue(object)));
                }
                case 2: {
                    return Type.charType.constType(new Integer((char)ConstFold.intValue(object)));
                }
                case 3: {
                    return Type.shortType.constType(new Integer((short)ConstFold.intValue(object)));
                }
                case 4: {
                    return Type.intType.constType(new Integer(ConstFold.intValue(object)));
                }
                case 5: {
                    return Type.longType.constType(new Long(ConstFold.longValue(object)));
                }
                case 6: {
                    return Type.floatType.constType(new Float(ConstFold.floatValue(object)));
                }
                case 7: {
                    return Type.doubleType.constType(new Double(ConstFold.doubleValue(object)));
                }
            }
        }
        return ttype;
    }
}

