/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.comp;

import gjc.v6.code.ByteCodes;
import gjc.v6.code.Code;
import gjc.v6.code.Flags;
import gjc.v6.code.Kinds;
import gjc.v6.code.Pool;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.comp.AttrContext;
import gjc.v6.comp.Check;
import gjc.v6.comp.Env;
import gjc.v6.comp.Gen;
import gjc.v6.comp.GenContext;
import gjc.v6.comp.Items;
import gjc.v6.comp.Resolve;
import gjc.v6.comp.Symtab;
import gjc.v6.tree.Pretty;
import gjc.v6.tree.Tree;
import gjc.v6.tree.TreeInfo;
import gjc.v6.tree.TreeMaker;
import gjc.v6.util.Base;
import gjc.v6.util.Enumeration;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Log;
import gjc.v6.util.Name;
import gjc.v6.util.Names;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gen
extends Tree.Visitor<Items.Item, Env<GenContext>>
implements Flags,
Kinds,
TypeTags,
ByteCodes {
    Log log;
    Symtab syms;
    Check chk;
    Resolve rs;
    TreeMaker make;
    Items items;
    boolean switchCheck;
    boolean debugInfo;
    Pool pool = new Pool();
    Code code;
    Env<AttrContext> attrEnv;
    static Env<GenContext> exprEnv = new Env<GenContext>(null, new GenContext());
    static Type methodType = new Type.MethodType(null, null, null);

    public Gen(Log log, Symtab syms, Check chk, Resolve rs, TreeMaker make, Items items, Hashtable<String, String> hashtable) {
        this.log = log;
        this.syms = syms;
        this.chk = chk;
        this.rs = rs;
        this.make = make;
        this.items = items;
        this.switchCheck = hashtable.get("-switchcheck") != null;
        this.debugInfo = hashtable.get("-g") != null;
    }

    void loadIntConst(int n) {
        this.items.makeImmediateItem(Type.intType, new Integer(n)).load();
    }

    public static int zero(int tc) {
        switch (tc) {
            case 0: 
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 14;
            }
        }
        throw new InternalError("zero");
    }

    public static int one(int tc) {
        return Gen.zero(tc) + 1;
    }

    void emitMinusOne(int n) {
        if (n == 1) {
            this.code.emitop(9);
            this.code.emitop(10);
            this.code.emitop(101);
        } else {
            this.code.emitop(2);
        }
    }

    int mkref(Type type) {
        return this.pool.put(type.tag == 10 ? type.tsym : type);
    }

    Items.LocalItem makeTemp(Type type) {
        return (Items.LocalItem)this.items.makeLocalItem(type, this.code.newLocal(type));
    }

    void callFinalizer(Env<GenContext> env) {
        if (this.code.alive) {
            this.code.pushStack(4);
            ((GenContext)env.info).cont = new Code.Chain(this.code.curPc(), ((GenContext)env.info).cont, this.code.stacksize);
            this.code.popStack(4);
            this.code.emitJump(((GenContext)env.info).cont, 168);
        }
    }

    Env<GenContext> jumpto(Tree target, Env<GenContext> env) {
        Env<GenContext> env1 = env;
        while (env1 != null && env1.tree != target) {
            env1 = env1.next;
        }
        if (env1 != null) {
            Tree tree = null;
            while (env != env1) {
                if (env.tree != tree) {
                    if (env.tree.tag == 14 && ((Tree.Try)env.tree).finalizer != null || env.tree.tag == 13) {
                        this.callFinalizer(env);
                    }
                    tree = env.tree;
                }
                env = env.next;
            }
        }
        return env1;
    }

    boolean hasFinalizers(Tree target, Env<GenContext> env) {
        while (env.tree != target) {
            if (env.tree.tag == 14 && ((Tree.Try)env.tree).finalizer != null || env.tree.tag == 13) {
                return true;
            }
            env = env.next;
        }
        return false;
    }

    List<Tree> normalizeDefs(List<Tree> defs, Symbol.ClassSymbol c) {
        ListBuffer initCode = new ListBuffer();
        ListBuffer<Tree> clinitCode = new ListBuffer<Tree>();
        ListBuffer<Tree> methoddefs = new ListBuffer<Tree>();
        List<Tree> l = defs;
        while (l.nonEmpty()) {
            Tree def = (Tree)l.head;
            switch (def.tag) {
                case 6: {
                    Tree.Block block = (Tree.Block)def;
                    ((block.flags & 8) != 0 ? clinitCode : initCode).append(def);
                    break;
                }
                case 4: {
                    methoddefs.append(def);
                    break;
                }
                case 5: {
                    Tree.VarDef vdef = (Tree.VarDef)def;
                    if (vdef.init == null || vdef.sym.constValue != null) break;
                    ((vdef.sym.flags() & 8) != 0 ? clinitCode : initCode).append(this.make.at(vdef.pos).Assignment(vdef.sym, vdef.init));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            l = l.tail;
        }
        if (initCode.length() != 0) {
            List<Tree> inits = initCode.toList();
            Enumeration e = methoddefs.elements();
            while (e.hasMoreElements()) {
                this.normalizeMethod((Tree.MethodDef)e.nextElement(), inits);
            }
        }
        if (clinitCode.length() != 0) {
            Symbol.MethodSymbol clinit = new Symbol.MethodSymbol(8, Names.clinit, new Type.MethodType(Type.emptyList, Type.voidType, Symbol.ClassSymbol.emptyList), c);
            c.members().enter(clinit);
            List<Tree> list = clinitCode.toList();
            this.make.at(((Tree)list.head).pos);
            methoddefs.append(this.make.MethodDef(clinit, this.make.Block(0, list)));
        }
        return methoddefs.toList();
    }

    void normalizeMethod(Tree.MethodDef md, List<Tree> initCode) {
        if (md.name == Names.init && TreeInfo.isInitialConstructor(md)) {
            List<Tree> stats = md.body.stats;
            ListBuffer listBuffer = new ListBuffer();
            listBuffer.append(stats.head);
            stats = stats.tail;
            while (stats.nonEmpty() && TreeInfo.isSyntheticInit((Tree)stats.head)) {
                listBuffer.append(stats.head);
                stats = stats.tail;
            }
            listBuffer.append(initCode);
            while (stats.nonEmpty()) {
                listBuffer.append(stats.head);
                stats = stats.tail;
            }
            md.body.stats = listBuffer.toList();
        }
    }

    public void genStat(Tree tree, Env<GenContext> env) {
        try {
            this.code.statBegin(tree.pos);
            tree.visit(this, env);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.chk.completionError(tree.pos, completionFailure);
        }
    }

    public void genStats(List<Tree> trees, Env<GenContext> env) {
        List<Tree> list = trees;
        while (list.nonEmpty()) {
            this.genStat((Tree)list.head, env);
            list = list.tail;
        }
    }

    public Items.Item genExpr(Tree tree, Type pt) {
        try {
            Items.Item res;
            if (tree.type.constValue != null) {
                res = this.items.makeImmediateItem(tree.type, tree.type.constValue);
            } else {
                ((GenContext)Gen.exprEnv.info).pt = pt;
                res = tree.visit(this, exprEnv);
            }
            return res.coerce(pt);
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.chk.completionError(tree.pos, completionFailure);
            return this.items.makeStackItem(pt);
        }
    }

    public void genArgs(List<Tree> trees, List<Type> pts) {
        List<Tree> list = trees;
        while (list.nonEmpty()) {
            this.genExpr((Tree)list.head, (Type)pts.head).load();
            pts = pts.tail;
            list = list.tail;
        }
    }

    @Override
    public Items.Item _case(Tree.MethodDef tree, Env<GenContext> env) {
        Env<GenContext> env2 = env.dup(tree);
        env2.enclMethod = tree;
        ((GenContext)env2.info).pt = tree.sym.erasure().restype();
        this.genMethod(tree, env2, false);
        return null;
    }

    void genMethod(Tree.MethodDef tree, Env<GenContext> env, boolean fatcode) {
        Symbol.MethodSymbol meth = tree.sym;
        if (tree.body != null) {
            meth.code = this.code = new Code(fatcode, this.debugInfo);
            this.items.setCode(this.code);
            if ((tree.flags & 8) == 0) {
                this.code.newLocal(meth.owner.erasure());
            }
            List<Tree.VarDef> list = tree.params;
            while (list.nonEmpty()) {
                this.code.setStartPc(this.code.newLocal(((Tree.VarDef)list.head).sym));
                list = list.tail;
            }
            this.genStat(tree.body, env);
            Base._assert(this.code.stacksize == 0);
            if (this.code.alive) {
                if (tree.body.stats.isEmpty()) {
                    this.code.statBegin(tree.body.pos);
                }
                this.code.emitop(177);
                this.code.endScopes(0);
                if (!fatcode && this.code.fatcode) {
                    this.genMethod(tree, env, true);
                }
            } else {
                this.code.endScopes(0);
            }
        }
    }

    @Override
    public Items.Item _case(Tree.VarDef tree, Env<GenContext> env) {
        Symbol.VarSymbol varSymbol = tree.sym;
        this.code.newLocal(varSymbol);
        if (tree.init != null && varSymbol.constValue == null) {
            this.genExpr(tree.init, varSymbol.erasure()).load();
            this.items.makeLocalItem(varSymbol).store();
        }
        return null;
    }

    @Override
    public Items.Item _case(Tree.Block tree, Env<GenContext> env) {
        if (this.code.alive) {
            int n = this.code.nextadr;
            this.genStats(tree.stats, env);
            this.code.endScopes(n);
        }
        return null;
    }

    @Override
    public Items.Item _case(Tree.DoLoop tree, Env<GenContext> env) {
        int startpc = this.code.curPc();
        Env<GenContext> loopEnv = env.dup(tree, ((GenContext)env.info).dup());
        this.genStat(tree.body, loopEnv);
        this.code.resolve(((GenContext)loopEnv.info).cont);
        this.code.statBegin(tree.cond.pos);
        Items.CondItem condItem = this.genExpr(tree.cond, Type.booleanType).mkCond();
        this.code.resolve(condItem.jumpTrue(), startpc);
        this.code.resolve(condItem.falseJumps);
        this.code.resolve(((GenContext)loopEnv.info).exit);
        return null;
    }

    @Override
    public Items.Item _case(Tree.WhileLoop tree, Env<GenContext> env) {
        int startpc = this.code.curPc();
        Items.CondItem c = this.genExpr(tree.cond, Type.booleanType).mkCond();
        Env<GenContext> env2 = env.dup(tree, ((GenContext)env.info).dup());
        ((GenContext)env2.info).exit = c.jumpFalse();
        if (c.trueJumps != null || c.opcode != 168) {
            this.code.resolve(c.trueJumps);
            this.genStat(tree.body, env2);
            this.code.resolve(((GenContext)env2.info).cont);
            this.code.resolve(this.code.branch(167), startpc);
        }
        this.code.resolve(((GenContext)env2.info).exit);
        return null;
    }

    @Override
    public Items.Item _case(Tree.ForLoop tree, Env<GenContext> env) {
        Items.CondItem c;
        this.genStats(tree.init, env);
        int startpc = this.code.curPc();
        if (tree.cond != null) {
            this.code.statBegin(tree.cond.pos);
            c = this.genExpr(tree.cond, Type.booleanType).mkCond();
        } else {
            c = this.items.makeCondItem(167);
        }
        Env<GenContext> env2 = env.dup(tree, ((GenContext)env.info).dup());
        ((GenContext)env2.info).exit = c.jumpFalse();
        if (c.trueJumps != null || c.opcode != 168) {
            this.code.resolve(c.trueJumps);
            this.genStat(tree.body, env2);
            this.code.resolve(((GenContext)env2.info).cont);
            this.genStats(tree.step, env2);
            this.code.resolve(this.code.branch(167), startpc);
        }
        this.code.resolve(((GenContext)env2.info).exit);
        return null;
    }

    @Override
    public Items.Item _case(Tree.Labelled tree, Env<GenContext> env) {
        Env<GenContext> env2 = env.dup(tree.body, ((GenContext)env.info).dup());
        this.genStat(tree.body, env2);
        this.code.resolve(((GenContext)env2.info).exit);
        return null;
    }

    @Override
    public Items.Item _case(Tree.Switch tree, Env<GenContext> env) {
        block22: {
            int i;
            int opcode;
            List<Tree.Case> cases;
            Items.Item sel;
            block23: {
                block21: {
                    sel = this.genExpr(tree.selector, Type.intType);
                    cases = tree.cases;
                    if (!cases.isEmpty()) break block21;
                    sel.load().drop();
                    break block22;
                }
                if (!cases.tail.isEmpty() || ((Tree.Case)cases.head).pat != null) break block23;
                sel.drop();
                this.genStats(((Tree.Case)cases.head).stats, env);
                break block22;
            }
            sel.load();
            Env<GenContext> switchEnv = env.dup(tree, ((GenContext)env.info).dup());
            int lo = Integer.MAX_VALUE;
            int hi = Integer.MIN_VALUE;
            int ntags = 0;
            int[] tags = new int[cases.length()];
            int[] labels = null;
            int defaultIndex = -1;
            List<Tree.Case> l = cases;
            for (int i2 = 0; i2 < tags.length; ++i2) {
                if (((Tree.Case)l.head).pat != null) {
                    int val;
                    tags[i2] = val = ((Number)((Tree.Case)l.head).pat.type.constValue).intValue();
                    if (val < lo) {
                        lo = val;
                    }
                    if (hi < val) {
                        hi = val;
                    }
                    ++ntags;
                } else {
                    Base._assert(defaultIndex == -1);
                    defaultIndex = i2;
                }
                l = l.tail;
            }
            long table_space_cost = 4L + (long)(hi - lo + 1);
            long table_time_cost = 3L;
            long lookup_space_cost = 3L + (long)(2 * ntags);
            long lookup_time_cost = ntags;
            int n = opcode = table_space_cost + 3L * table_time_cost <= lookup_space_cost + 3L * lookup_time_cost ? 170 : 171;
            if (!this.code.alive) break block22;
            int startpc = this.code.curPc();
            this.code.emitop(opcode);
            this.code.align(4);
            int tableBase = this.code.curPc();
            this.code.emit4(-1);
            if (opcode == 170) {
                this.code.emit4(lo);
                this.code.emit4(hi);
                for (i = lo; i <= hi; ++i) {
                    this.code.emit4(-1);
                }
            } else {
                this.code.emit4(ntags);
                for (i = 0; i < ntags; ++i) {
                    this.code.emit4(-1);
                    this.code.emit4(-1);
                }
                labels = new int[tags.length];
            }
            this.code.alive = false;
            l = cases;
            for (i = 0; i < tags.length; ++i) {
                Tree.Case c = (Tree.Case)l.head;
                l = l.tail;
                if (i != defaultIndex) {
                    if (opcode == 170) {
                        this.code.put4(tableBase + 4 * (tags[i] - lo + 3), this.code.curPc() - startpc);
                    } else {
                        labels[i] = this.code.curPc() - startpc;
                    }
                } else {
                    this.code.put4(tableBase, this.code.curPc() - startpc);
                }
                this.code.alive = true;
                this.genStats(c.stats, switchEnv);
                if (!this.switchCheck || !this.code.alive || !c.stats.nonEmpty() || i >= tags.length - 1) continue;
                this.log.warning(c.pos, "possible fall-through from case");
            }
            this.code.resolve(((GenContext)switchEnv.info).exit);
            if (this.code.get4(tableBase) == -1) {
                this.code.put4(tableBase, this.code.curPc() - startpc);
                this.code.alive = true;
            }
            if (opcode == 170) {
                int defaultOffset = this.code.get4(tableBase);
                for (int i3 = lo; i3 <= hi; ++i3) {
                    if (this.code.get4(tableBase + 4 * (i3 - lo + 3)) != -1) continue;
                    this.code.put4(tableBase + 4 * (i3 - lo + 3), defaultOffset);
                }
            } else {
                if (defaultIndex >= 0) {
                    for (int i4 = defaultIndex; i4 < tags.length - 1; ++i4) {
                        tags[i4] = tags[i4 + 1];
                        labels[i4] = labels[i4 + 1];
                    }
                }
                Gen.qsort2(tags, labels, 0, ntags - 1);
                for (int i5 = 0; i5 < ntags; ++i5) {
                    int n2 = tableBase + 8 * (i5 + 1);
                    this.code.put4(n2, tags[i5]);
                    this.code.put4(n2 + 4, labels[i5]);
                }
            }
        }
        return null;
    }

    static void qsort2(int[] keys, int[] values, int lo, int hi) {
        int i = lo;
        int j = hi;
        int pivot = keys[(i + j) / 2];
        while (true) {
            if (keys[i] < pivot) {
                ++i;
                continue;
            }
            while (pivot < keys[j]) {
                --j;
            }
            if (i <= j) {
                int temp1 = keys[i];
                keys[i] = keys[j];
                keys[j] = temp1;
                int temp2 = values[i];
                values[i] = values[j];
                values[j] = temp2;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (lo < j) {
            Gen.qsort2(keys, values, lo, j);
        }
        if (i < hi) {
            Gen.qsort2(keys, values, i, hi);
        }
    }

    @Override
    public Items.Item _case(Tree.Synchronized tree, Env<GenContext> env) {
        Items.LocalItem lockVar = this.makeTemp(this.syms.objectType);
        this.genExpr(tree.lock, tree.lock.type).load();
        ((Items.Item)lockVar).store();
        ((Items.Item)lockVar).load();
        this.code.emitop(194);
        Env<GenContext> env2 = env.dup(tree, ((GenContext)env.info).dup());
        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FinalizeSync
        extends GenFinal {
            final /* synthetic */ Items.Item val$lockVar;
            final /* synthetic */ Gen this$0;

            FinalizeSync() {
                this.this$0 = this$0;
                this.val$lockVar = item;
            }

            void gen() {
                this.val$lockVar.load();
                this.this$0.code.emitop(195);
            }
        }
        this.genTry(tree.body, Tree.Catch.emptyList, new FinalizeSync(this, (Items.Item)lockVar), env2);
        this.code.resolve(((GenContext)env2.info).exit);
        return null;
    }

    @Override
    public Items.Item _case(Tree.Try tree, Env<GenContext> env) {
        Env<GenContext> env2 = env.dup(tree, ((GenContext)env.info).dup());
        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FinalizeTry
        extends GenFinal {
            final /* synthetic */ Tree.Try val$tree;
            final /* synthetic */ Env val$env;
            final /* synthetic */ Gen this$0;

            FinalizeTry() {
                this.this$0 = this$0;
                this.val$tree = val$tree;
                this.val$env = env;
            }

            void gen() {
                this.this$0.genStat(this.val$tree.finalizer, this.val$env);
            }
        }
        this.genTry(tree.body, tree.catchers, tree.finalizer == null ? null : new FinalizeTry(this, tree, env), env2);
        this.code.resolve(((GenContext)env2.info).exit);
        return null;
    }

    void genTry(Tree body, List<Tree.Catch> catchers, GenFinal genfinal, Env<GenContext> env) {
        int limit = this.code.nextadr;
        int startpc = this.code.curPc();
        this.genStat(body, env);
        int endpc = this.code.curPc();
        if (genfinal != null) {
            this.callFinalizer(env);
        }
        Code.Chain exitChain = this.code.branch(167);
        if (startpc != endpc) {
            List<Tree.Catch> l = catchers;
            while (l.nonEmpty()) {
                this.code.alive = true;
                this.code.clearStack();
                this.code.pushStack(4);
                this.genCatch((Tree.Catch)l.head, env, startpc, endpc);
                if (genfinal != null) {
                    this.callFinalizer(env);
                }
                exitChain = Code.mergeChains(exitChain, this.code.branch(167));
                l = l.tail;
            }
        }
        if (genfinal != null) {
            this.code.alive = true;
            this.registerCatch(body.pos, startpc, this.code.curPc(), this.code.curPc(), 0);
            this.code.newRegSegment();
            this.code.clearStack();
            this.code.pushStack(4);
            Items.LocalItem excVar = this.makeTemp(this.syms.throwableType);
            ((Items.Item)excVar).store();
            this.callFinalizer(env);
            ((Items.Item)excVar).load();
            this.code.emitop(191);
            this.code.alive = true;
            this.code.clearStack();
            this.code.pushStack(4);
            this.code.resolve(((GenContext)env.info).cont);
            Items.LocalItem localItem = this.makeTemp(this.syms.throwableType);
            localItem.store();
            genfinal.gen();
            this.code.emitop1w(169, this.code.regOf(localItem.adr));
            this.code.alive = false;
        }
        this.code.resolve(exitChain);
        this.code.endScopes(limit);
    }

    void genCatch(Tree.Catch tree, Env<GenContext> env, int startpc, int n) {
        if (startpc != n) {
            this.registerCatch(tree.pos, startpc, n, this.code.curPc(), this.mkref(tree.param.type));
            this.code.newLocal(tree.param.sym);
            this.items.makeLocalItem(tree.param.sym).store();
            this.genStat(tree.body, env);
        }
    }

    void registerCatch(int pos, int start_pc, int end_pc, int handler_pc, int catch_type) {
        if (start_pc != end_pc) {
            char start_pc1 = (char)start_pc;
            char end_pc1 = (char)end_pc;
            char c = (char)handler_pc;
            if (start_pc1 == start_pc && end_pc1 == end_pc && c == handler_pc) {
                this.code.addCatch(start_pc1, end_pc1, c, (char)catch_type);
            } else {
                this.log.error(pos, "code too large for try statement");
            }
        }
    }

    @Override
    public Items.Item _case(Tree.Conditional tree, Env<GenContext> env) {
        Type pt = ((GenContext)env.info).pt;
        Code.Chain thenExit = null;
        Items.CondItem c = this.genExpr(tree.cond, Type.booleanType).mkCond();
        Code.Chain chain = c.jumpFalse();
        if (c.trueJumps != null || c.opcode != 168) {
            this.code.resolve(c.trueJumps);
            if (tree.tag == 17) {
                this.genStat(tree.thenpart, env);
            } else {
                this.genExpr(tree.thenpart, pt).load();
            }
            thenExit = this.code.branch(167);
        }
        if (tree.elsepart != null && chain != null) {
            this.code.resolve(chain);
            if (tree.tag == 17) {
                this.genStat(tree.elsepart, env);
            } else {
                this.genExpr(tree.elsepart, pt).load();
            }
            this.code.resolve(thenExit);
        } else {
            this.code.resolve(thenExit);
            this.code.resolve(chain);
        }
        if (tree.tag == 17) {
            return null;
        }
        return this.items.makeStackItem(pt);
    }

    @Override
    public Items.Item _case(Tree.Assert tree, Env<GenContext> env) {
        return null;
    }

    @Override
    public Items.Item _case(Tree.Exec tree, Env<GenContext> env) {
        if (tree.expr.tag == 44) {
            tree.expr.tag = 42;
        } else if (tree.expr.tag == 45) {
            tree.expr.tag = 43;
        }
        this.genExpr(tree.expr, tree.expr.type).drop();
        return null;
    }

    @Override
    public Items.Item _case(Tree.Break tree, Env<GenContext> env) {
        Env<GenContext> env2 = this.jumpto(tree.target, env);
        if (env2 != null) {
            ((GenContext)env2.info).addExit(this.code.branch(167));
        }
        return null;
    }

    @Override
    public Items.Item _case(Tree.Continue tree, Env<GenContext> env) {
        ((GenContext)this.jumpto((Tree)tree.target, env).info).addCont(this.code.branch(167));
        return null;
    }

    @Override
    public Items.Item _case(Tree.Return tree, Env<GenContext> env) {
        if (tree.expr != null) {
            Items.Item item = this.genExpr(tree.expr, ((GenContext)env.info).pt);
            if (this.hasFinalizers(env.enclMethod, env)) {
                item.load();
                item = this.makeTemp(((GenContext)env.info).pt);
                item.store();
            }
            this.jumpto(env.enclMethod, env);
            item.load();
            this.code.emitop(172 + Code.truncate(Code.typecode(((GenContext)env.info).pt)));
        } else {
            this.jumpto(env.enclMethod, env);
            this.code.emitop(177);
        }
        return null;
    }

    @Override
    public Items.Item _case(Tree.Throw tree, Env<GenContext> env) {
        this.genExpr(tree.expr, tree.expr.type).load();
        this.code.emitop(191);
        return null;
    }

    @Override
    public Items.Item _case(Tree.Apply tree, Env<GenContext> env) {
        Items.Item item = this.genExpr(tree.meth, methodType);
        if (tree.args.length() != TreeInfo.symbol(tree.meth).externalType().argtypes().length()) {
            System.err.println(String.valueOf("length mismatch: ").concat(String.valueOf(TreeInfo.symbol(tree.meth))));
            System.err.println(TreeInfo.symbol(tree.meth).externalType().argtypes());
            new Pretty().printExprs(tree.args);
        }
        this.genArgs(tree.args, TreeInfo.symbol(tree.meth).externalType().argtypes());
        return item.invoke();
    }

    @Override
    public Items.Item _case(Tree.NewClass tree, Env<GenContext> env) {
        Base._assert(tree.encl == null && tree.def == null);
        this.code.emitop2(187, this.mkref(tree.type));
        this.code.emitop(89);
        this.genArgs(tree.args, tree.constructor.externalType().argtypes());
        this.items.makeMemberItem(tree.constructor, true).invoke();
        return this.items.makeStackItem(tree.type);
    }

    @Override
    public Items.Item _case(Tree.NewArray tree, Env<GenContext> env) {
        if (tree.elems != null) {
            Type elemtype = tree.type.elemtype();
            this.loadIntConst(tree.elems.length());
            Items.Item arr = this.makeNewArray(tree.type, 1);
            int i = 0;
            List<Tree> l = tree.elems;
            while (l.nonEmpty()) {
                arr.duplicate();
                this.loadIntConst(i);
                ++i;
                this.genExpr((Tree)l.head, elemtype).load();
                this.items.makeIndexedItem(elemtype).store();
                l = l.tail;
            }
            return arr;
        }
        List<Tree> list = tree.dims;
        while (list.nonEmpty()) {
            this.genExpr((Tree)list.head, Type.intType).load();
            list = list.tail;
        }
        return this.makeNewArray(tree.type, tree.dims.length());
    }

    Items.Item makeNewArray(Type type, int ndims) {
        Type elemtype = type.elemtype();
        int n = Code.arraycode(elemtype);
        if (n == 0 || n == 1 && ndims == 1) {
            this.code.emitop2(189, this.mkref(elemtype));
        } else if (n == 1) {
            this.code.emitop(197, 1 - ndims);
            this.code.emit2(this.mkref(type));
            this.code.emit1(ndims);
        } else {
            this.code.emitop1(188, n);
        }
        return this.items.makeStackItem(type);
    }

    @Override
    public Items.Item _case(Tree.Assign tree, Env<GenContext> env) {
        Items.Item item = this.genExpr(tree.lhs, tree.lhs.type);
        if (item instanceof Items.StackItem) {
            throw new InternalError();
        }
        this.genExpr(tree.rhs, tree.lhs.type).load();
        return this.items.makeAssignItem(item);
    }

    @Override
    public Items.Item _case(Tree.Assignop tree, Env<GenContext> env) {
        Items.Item l = this.genExpr(tree.lhs, tree.lhs.type);
        if ((tree.tag == 60 || tree.tag == 61) && l instanceof Items.LocalItem && tree.lhs.type.tag <= 4 && tree.rhs.type.tag <= 4 && tree.rhs.type.constValue != null) {
            int ival = ((Number)tree.rhs.type.constValue).intValue();
            if (tree.tag == 61) {
                ival = -ival;
            }
            if (-128 <= ival && ival <= 127) {
                ((Items.LocalItem)l).incr(ival);
                return l;
            }
        }
        l.duplicate();
        Symbol.OperatorSymbol operatorSymbol = (Symbol.OperatorSymbol)tree.operator;
        l.coerce((Type)operatorSymbol.type.argtypes().head).load();
        this.completeBinop(tree.lhs, tree.rhs, operatorSymbol).coerce(tree.lhs.type);
        return this.items.makeAssignItem(l);
    }

    @Override
    public Items.Item _case(Tree.Operation tree, Env<GenContext> env) {
        Symbol.OperatorSymbol operator = (Symbol.OperatorSymbol)tree.operator;
        Items.Item od = this.genExpr((Tree)tree.args.head, (Type)operator.type.argtypes().head);
        switch (tree.tag) {
            case 38: {
                return od.load();
            }
            case 39: {
                od = od.load();
                this.code.emitop(operator.opcode);
                return od;
            }
            case 40: {
                return od.mkCond().negate();
            }
            case 41: {
                od = od.load();
                this.emitMinusOne(od.typecode);
                this.code.emitop(operator.opcode);
                return od;
            }
            case 42: 
            case 43: {
                od.duplicate();
                if (od instanceof Items.LocalItem && operator.opcode == 96) {
                    ((Items.LocalItem)od).incr(tree.tag == 42 ? 1 : -1);
                    return od;
                }
                od.load();
                this.code.emitop(Gen.one(od.typecode));
                this.code.emitop(operator.opcode);
                return this.items.makeAssignItem(od);
            }
            case 44: 
            case 45: {
                od.duplicate();
                if (od instanceof Items.LocalItem && operator.opcode == 96) {
                    Items.Item res = od.load();
                    ((Items.LocalItem)od).incr(tree.tag == 44 ? 1 : -1);
                    return res;
                }
                Items.Item res = od.load();
                od.stash(od.typecode);
                this.code.emitop(Gen.one(od.typecode));
                this.code.emitop(operator.opcode);
                od.store();
                return res;
            }
            case 46: {
                Items.CondItem lcond = od.mkCond();
                if (lcond.falseJumps != null || lcond.opcode != 167) {
                    Code.Chain trueJumps = lcond.jumpTrue();
                    this.code.resolve(lcond.falseJumps);
                    Items.CondItem rcond = this.genExpr((Tree)tree.args.tail.head, ((Tree)tree.args.tail.head).type).mkCond();
                    return this.items.makeCondItem(rcond.opcode, Code.mergeChains(trueJumps, rcond.trueJumps), rcond.falseJumps);
                }
                return lcond;
            }
            case 47: {
                Items.CondItem lcond = od.mkCond();
                if (lcond.trueJumps != null || lcond.opcode != 168) {
                    Code.Chain falseJumps = lcond.jumpFalse();
                    this.code.resolve(lcond.trueJumps);
                    Items.CondItem condItem = this.genExpr((Tree)tree.args.tail.head, ((Tree)tree.args.tail.head).type).mkCond();
                    return this.items.makeCondItem(condItem.opcode, condItem.trueJumps, Code.mergeChains(falseJumps, condItem.falseJumps));
                }
                return lcond;
            }
        }
        od.load();
        return this.completeBinop((Tree)tree.args.head, (Tree)tree.args.tail.head, operator);
    }

    Items.Item mkString(int pos, Type argtype) {
        Symbol symbol = this.rs.resolveQualifiedMethod(pos, this.attrEnv, this.syms.stringType, Names.valueOf, Type.emptyList, Type.emptyList.prepend(argtype));
        if (symbol.kind == 32) {
            return this.items.makeStaticItem(symbol).invoke();
        }
        return this.items.makeStackItem(this.syms.stringType);
    }

    Items.Item completeBinop(Tree lhs, Tree rhs, Symbol.OperatorSymbol operator) {
        Type.MethodType optype = (Type.MethodType)operator.type;
        int opcode = operator.opcode;
        if (opcode == 256) {
            this.mkString(lhs.pos, lhs.type);
            this.genExpr(rhs, rhs.type).load();
            this.mkString(rhs.pos, rhs.type);
            Symbol concatSym = this.rs.resolveQualifiedMethod(lhs.pos, this.attrEnv, this.syms.stringType, Names.concat, Type.emptyList, Type.emptyList.prepend(this.syms.stringType));
            if (concatSym.kind == 32) {
                return this.items.makeMemberItem(concatSym, false).invoke();
            }
            return this.items.makeStackItem(this.syms.stringType);
        }
        Type type = (Type)operator.erasure().argtypes().tail.head;
        if (opcode >= 270 && opcode <= 275) {
            opcode += -150;
            type = Type.intType;
        }
        this.genExpr(rhs, type).load();
        if (opcode >= 512) {
            this.code.emitop(opcode >> 9);
            opcode &= 0xFF;
        }
        if (opcode >= 153 && opcode <= 166) {
            return this.items.makeCondItem(opcode);
        }
        this.code.emitop(opcode);
        return this.items.makeStackItem(optype.restype);
    }

    @Override
    public Items.Item _case(Tree.TypeCast tree, Env<GenContext> env) {
        Items.Item item = this.genExpr(tree.expr, tree.clazz.type).load();
        if (tree.clazz.type.tag > 8 && tree.expr.type.asSuper(tree.clazz.type.tsym) == null) {
            this.code.emitop2(192, this.mkref(tree.clazz.type));
        }
        return item;
    }

    @Override
    public Items.Item _case(Tree.TypeTest tree, Env<GenContext> env) {
        this.genExpr(tree.expr, tree.expr.type).load();
        this.code.emitop2(193, this.mkref(tree.clazz.type));
        return this.items.makeStackItem(Type.booleanType);
    }

    @Override
    public Items.Item _case(Tree.Indexed tree, Env<GenContext> env) {
        this.genExpr(tree.indexed, tree.indexed.type).load();
        this.genExpr(tree.index, Type.intType).load();
        return this.items.makeIndexedItem(tree.type);
    }

    @Override
    public Items.Item _case(Tree.Select tree, Env<GenContext> env) {
        Items.Item item;
        Symbol sym = tree.sym;
        if (tree.name == Names._class) {
            return this.genClassOf(tree.pos, tree.selected.type);
        }
        Symbol ssym = TreeInfo.symbol(tree.selected);
        boolean selectSuper = ssym != null && (ssym.kind == 2 || ssym.name == Names._super);
        Items.Item item2 = item = selectSuper ? this.items.makeSuperItem() : this.genExpr(tree.selected, tree.selected.type);
        if ((sym.flags() & 8) != 0) {
            item.drop();
            return this.items.makeStaticItem(sym);
        }
        item.load();
        if (sym == this.syms.lengthVar) {
            this.code.emitop(190);
            return this.items.makeStackItem(Type.intType);
        }
        return this.items.makeMemberItem(sym, (sym.flags() & 2) != 0 || selectSuper);
    }

    Items.Item genClassOf(int pos, Type type) {
        switch (type.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                Name bname = Type.boxedName[type.tag];
                Symbol.ClassSymbol c = this.syms.reader.enterClass(bname);
                Symbol typeSym = this.rs.access(this.rs.findIdentInType(this.attrEnv, c.type, Names.TYPE, 4), pos, c.type, Names.TYPE);
                if (typeSym.kind != 4) break;
                return this.items.makeStaticItem(typeSym);
            }
            case 10: 
            case 11: {
                this.items.makeImmediateItem(this.syms.stringType, this.syms.writer.xClassName(type).toString().replace('/', '.')).load();
                Symbol symbol = this.rs.resolveQualifiedMethod(pos, this.attrEnv, this.syms.classType, Names.forName, Type.emptyList, Type.emptyList.prepend(this.syms.stringType));
                if (symbol.kind != 32) break;
                return this.items.makeStaticItem(symbol).invoke();
            }
        }
        this.code.emitop(1);
        return this.items.makeStackItem(this.syms.classType);
    }

    @Override
    public Items.Item _case(Tree.Ident tree, Env<GenContext> env) {
        Symbol sym = tree.sym;
        if (tree.name == Names._this || tree.name == Names._super) {
            Items.Item item;
            Items.Item item2 = item = tree.name == Names._this ? this.items.makeThisItem() : this.items.makeSuperItem();
            if (sym.kind == 32) {
                item.load();
                item = this.items.makeMemberItem(sym, true);
            }
            return item;
        }
        if (tree.name == Names._null) {
            this.code.emitop(1);
            return this.items.makeStackItem(tree.type);
        }
        if (sym.kind == 4 && sym.owner.kind == 32) {
            return this.items.makeLocalItem((Symbol.VarSymbol)sym);
        }
        if ((sym.flags() & 8) != 0) {
            return this.items.makeStaticItem(sym);
        }
        this.items.makeThisItem().load();
        return this.items.makeMemberItem(sym, (sym.flags() & 2) != 0);
    }

    @Override
    public Items.Item _case(Tree.Literal tree, Env<GenContext> env) {
        return this.items.makeImmediateItem(tree.type, tree.value);
    }

    public Items.Item _case(Tree tree) {
        throw new InternalError();
    }

    public void genClass(Env<AttrContext> env, Tree.ClassDef cdef) {
        this.attrEnv = env;
        Symbol.ClassSymbol c = cdef.sym;
        cdef.defs = this.normalizeDefs(cdef.defs, c);
        c.pool = this.pool;
        this.pool.reset();
        this.items.setPool(this.pool);
        Env<GenContext> localEnv = new Env<GenContext>(cdef, new GenContext());
        localEnv.toplevel = env.toplevel;
        localEnv.enclClass = cdef;
        List<Tree> list = cdef.defs;
        while (list.nonEmpty()) {
            ((Tree)list.head).visit(this, localEnv);
            list = list.tail;
        }
    }

    @Override
    public /* synthetic */ Object _case(Tree x0, Object object) {
        return super._case(x0, (Env)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Erroneous x0, Object object) {
        return super._case(x0, (Env)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object object) {
        return super._case(x0, (Env)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeApply x0, Object object) {
        return super._case(x0, (Env)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeArray x0, Object object) {
        return super._case(x0, (Env)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object object) {
        return super._case(x0, (Env)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Literal x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Ident x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Select x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Indexed x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeTest x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeCast x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Operation x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assignop x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assign x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewArray x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewClass x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Apply x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Throw x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Return x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Continue x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Break x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Exec x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assert x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Conditional x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Catch x0, Object object) {
        return super._case(x0, (Env)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Try x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Synchronized x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Case x0, Object object) {
        return super._case(x0, (Env)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Switch x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Labelled x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ForLoop x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.DoLoop x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Block x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.VarDef x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.MethodDef x0, Object object) {
        return this._case(x0, (Env<GenContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ClassDef x0, Object object) {
        return super._case(x0, (Env)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Import x0, Object object) {
        return super._case(x0, (Env)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TopLevel x0, Object object) {
        return super._case(x0, (Env)object);
    }

    abstract class GenFinal
    implements ByteCodes {
        GenFinal() {
        }

        abstract void gen();
    }
}

