/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.comp;

import gjc.v6.code.ByteCodes;
import gjc.v6.code.Code;
import gjc.v6.code.Pool;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.util.Base;

public class Items
implements ByteCodes,
TypeTags {
    private Pool pool;
    private Code code;
    private final Item voidItem;
    private final Item thisItem;
    private final Item superItem;
    private final Item[] stackItem = new Item[9];
    public static int count = 0;

    public Items() {
        this.voidItem = new Item(8);
        this.thisItem = new SelfItem(false);
        this.superItem = new SelfItem(true);
        for (int i = 0; i < 8; ++i) {
            this.stackItem[i] = new StackItem(i);
        }
        this.stackItem[8] = this.voidItem;
    }

    void setPool(Pool pool) {
        this.pool = pool;
    }

    void setCode(Code code) {
        this.code = code;
    }

    Item makeVoidItem() {
        return this.voidItem;
    }

    Item makeThisItem() {
        return this.thisItem;
    }

    Item makeSuperItem() {
        return this.superItem;
    }

    Item makeStackItem(Type type) {
        return this.stackItem[Code.typecode(type)];
    }

    Item makeIndexedItem(Type type) {
        return new IndexedItem(type);
    }

    Item makeLocalItem(Symbol.VarSymbol varSymbol) {
        return new LocalItem(varSymbol.erasure(), varSymbol.adr);
    }

    Item makeLocalItem(Type t, int n) {
        return new LocalItem(t, n);
    }

    Item makeStaticItem(Symbol symbol) {
        return new StaticItem(symbol);
    }

    Item makeMemberItem(Symbol member, boolean bl) {
        return new MemberItem(member, bl);
    }

    Item makeImmediateItem(Type type, Object object) {
        return new ImmediateItem(type, object);
    }

    Item makeAssignItem(Item item) {
        return new AssignItem(item);
    }

    CondItem makeCondItem(int opcode, Code.Chain truejumps, Code.Chain chain) {
        return new CondItem(opcode, truejumps, chain);
    }

    CondItem makeCondItem(int n) {
        return this.makeCondItem(n, null, null);
    }

    class CondItem
    extends Item
    implements ByteCodes,
    TypeTags {
        Code.Chain trueJumps;
        Code.Chain falseJumps;
        int opcode;

        CondItem(int opcode, Code.Chain truejumps, Code.Chain chain) {
            super(5);
            this.opcode = opcode;
            this.trueJumps = truejumps;
            this.falseJumps = chain;
        }

        Item load() {
            Code.Chain trueExit = null;
            Code.Chain chain = this.jumpFalse();
            if (this.trueJumps != null || this.opcode != 168) {
                Items.this.code.resolve(this.trueJumps);
                Items.this.code.emitop(4);
                trueExit = Items.this.code.branch(167);
            }
            if (chain != null) {
                Items.this.code.resolve(chain);
                Items.this.code.emitop(3);
            }
            Items.this.code.resolve(trueExit);
            return Items.this.stackItem[this.typecode];
        }

        void duplicate() {
            this.load().duplicate();
        }

        void drop() {
            this.load().drop();
        }

        void stash(int n) {
            throw new InternalError("stash");
        }

        CondItem mkCond() {
            return this;
        }

        Code.Chain jumpTrue() {
            return Code.mergeChains(this.trueJumps, Items.this.code.branch(this.opcode));
        }

        Code.Chain jumpFalse() {
            return Code.mergeChains(this.falseJumps, Items.this.code.branch(Code.negate(this.opcode)));
        }

        CondItem negate() {
            return new CondItem(Code.negate(this.opcode), this.falseJumps, this.trueJumps);
        }
    }

    class AssignItem
    extends Item
    implements ByteCodes,
    TypeTags {
        Item lhs;

        AssignItem(Item item) {
            super(item.typecode);
            this.lhs = item;
        }

        Item load() {
            this.lhs.stash(this.typecode);
            this.lhs.store();
            return Items.this.stackItem[this.typecode];
        }

        void duplicate() {
            this.load().duplicate();
        }

        void drop() {
            this.lhs.store();
        }

        void stash(int n) {
            throw new InternalError("stash");
        }
    }

    class ImmediateItem
    extends Item
    implements ByteCodes,
    TypeTags {
        Object value;

        ImmediateItem(Type type, Object object) {
            super(Code.typecode(type));
            this.value = object;
        }

        private void ldc() {
            int n = Items.this.pool.put(this.value);
            if (this.typecode == 1 || this.typecode == 3) {
                Items.this.code.emitop(20, 2);
                Items.this.code.emit2(n);
            } else if (n <= 255) {
                Items.this.code.emitop(18, 1);
                Items.this.code.emit1(n);
            } else {
                Items.this.code.emitop(19, 1);
                Items.this.code.emit2(n);
            }
        }

        Item load() {
            switch (this.typecode) {
                case 0: 
                case 5: 
                case 6: 
                case 7: {
                    int ival = ((Number)this.value).intValue();
                    if (-1 <= ival && ival <= 5) {
                        Items.this.code.emitop(3 + ival);
                        break;
                    }
                    if (-128 <= ival && ival <= 127) {
                        Items.this.code.emitop1(16, ival);
                        break;
                    }
                    if (Short.MIN_VALUE <= ival && ival <= Short.MAX_VALUE) {
                        Items.this.code.emitop2(17, ival);
                        break;
                    }
                    this.ldc();
                    break;
                }
                case 1: {
                    long lval = ((Number)this.value).longValue();
                    if (lval == 0L || lval == 1L) {
                        Items.this.code.emitop(9 + (int)lval);
                        break;
                    }
                    this.ldc();
                    break;
                }
                case 2: {
                    float fval = ((Number)this.value).floatValue();
                    if ((double)fval == 0.0 || (double)fval == 1.0 || (double)fval == 2.0) {
                        Items.this.code.emitop(11 + (int)fval);
                        break;
                    }
                    this.ldc();
                    break;
                }
                case 3: {
                    double d = ((Number)this.value).doubleValue();
                    if (d == 0.0 || d == 1.0) {
                        Items.this.code.emitop(14 + (int)d);
                        break;
                    }
                    this.ldc();
                    break;
                }
                case 4: {
                    this.ldc();
                    break;
                }
                default: {
                    throw new InternalError("load");
                }
            }
            return Items.this.stackItem[this.typecode];
        }

        CondItem mkCond() {
            int n = ((Number)this.value).intValue();
            return Items.this.makeCondItem(n != 0 ? 167 : 168);
        }

        Item coerce(int n) {
            if (this.typecode == n) {
                return this;
            }
            switch (n) {
                case 0: {
                    if (Code.truncate(this.typecode) == 0) {
                        return this;
                    }
                    return new ImmediateItem(Type.intType, new Integer(((Number)this.value).intValue()));
                }
                case 1: {
                    return new ImmediateItem(Type.longType, new Long(((Number)this.value).longValue()));
                }
                case 2: {
                    return new ImmediateItem(Type.floatType, new Float(((Number)this.value).floatValue()));
                }
                case 3: {
                    return new ImmediateItem(Type.doubleType, new Double(((Number)this.value).doubleValue()));
                }
                case 5: {
                    return new ImmediateItem(Type.byteType, new Integer((byte)((Number)this.value).intValue()));
                }
                case 6: {
                    return new ImmediateItem(Type.charType, new Integer((char)((Number)this.value).intValue()));
                }
                case 7: {
                    return new ImmediateItem(Type.shortType, new Integer((short)((Number)this.value).intValue()));
                }
            }
            return super.coerce(n);
        }
    }

    class MemberItem
    extends Item
    implements ByteCodes,
    TypeTags {
        Symbol member;
        boolean nonvirtual;

        MemberItem(Symbol member, boolean bl) {
            super(Code.typecode(member.erasure()));
            this.member = member;
            this.nonvirtual = bl;
        }

        Item load() {
            Items.this.code.emitop(180, Code.width(this.typecode) - 1);
            Items.this.code.emit2(Items.this.pool.put(this.member));
            return Items.this.stackItem[this.typecode];
        }

        Item store() {
            Items.this.code.emitop(181, -Code.width(this.typecode) - 1);
            Items.this.code.emit2(Items.this.pool.put(this.member));
            return Items.this.voidItem;
        }

        Item invoke() {
            Type.MethodType mtype = (Type.MethodType)this.member.externalType();
            int argsize = Code.width(mtype.argtypes);
            int rescode = Code.typecode(mtype.restype);
            int n = Code.width(rescode) - argsize;
            if ((this.member.owner.flags() & 0x200) != 0) {
                Items.this.code.emitop(185, n - 1);
                Items.this.code.emit2(Items.this.pool.put(this.member));
                Items.this.code.emit1(argsize + 1);
                Items.this.code.emit1(0);
            } else if (this.nonvirtual) {
                Items.this.code.emitop(183, n - 1);
                Items.this.code.emit2(Items.this.pool.put(this.member));
            } else {
                Items.this.code.emitop(182, n - 1);
                Items.this.code.emit2(Items.this.pool.put(this.member));
            }
            return Items.this.stackItem[rescode];
        }

        void duplicate() {
            Items.this.stackItem[4].duplicate();
        }

        void drop() {
            Items.this.stackItem[4].drop();
        }

        void stash(int n) {
            Items.this.stackItem[4].stash(n);
        }
    }

    class StaticItem
    extends Item
    implements ByteCodes,
    TypeTags {
        Symbol member;

        StaticItem(Symbol symbol) {
            super(Code.typecode(symbol.erasure()));
            this.member = symbol;
        }

        Item load() {
            Items.this.code.emitop(178, Code.width(this.typecode));
            Items.this.code.emit2(Items.this.pool.put(this.member));
            return Items.this.stackItem[this.typecode];
        }

        Item store() {
            Items.this.code.emitop(179, -Code.width(this.typecode));
            Items.this.code.emit2(Items.this.pool.put(this.member));
            return Items.this.voidItem;
        }

        Item invoke() {
            Type.MethodType mtype = (Type.MethodType)this.member.erasure();
            int argsize = Code.width(mtype.argtypes);
            int rescode = Code.typecode(mtype.restype);
            int n = Code.width(rescode) - argsize;
            Items.this.code.emitop(184, n);
            Items.this.code.emit2(Items.this.pool.put(this.member));
            return Items.this.stackItem[rescode];
        }
    }

    class LocalItem
    extends Item
    implements ByteCodes,
    TypeTags {
        int adr;
        Type type;

        LocalItem(Type type, int n) {
            super(Code.typecode(type));
            Base._assert(n >= 0);
            this.type = type;
            this.adr = n;
        }

        Item load() {
            int n = Items.this.code.regOf(this.adr);
            if (n <= 3) {
                Items.this.code.emitop(26 + Code.truncate(this.typecode) * 4 + n);
            } else {
                Items.this.code.emitop1w(21 + Code.truncate(this.typecode), n);
            }
            return Items.this.stackItem[this.typecode];
        }

        Item store() {
            int n = Items.this.code.regOf(this.adr);
            if (n <= 3) {
                Items.this.code.emitop(59 + Code.truncate(this.typecode) * 4 + n);
            } else {
                Items.this.code.emitop1w(54 + Code.truncate(this.typecode), n);
            }
            Items.this.code.setStartPc(this.adr);
            return Items.this.voidItem;
        }

        void incr(int x) {
            if (this.typecode == 0) {
                int n = Items.this.code.regOf(this.adr);
                Items.this.code.emitop1w(132, n);
                if (n > 255) {
                    Items.this.code.emit2(x);
                } else {
                    Items.this.code.emit1(x);
                }
            } else {
                this.load();
                Items.this.makeImmediateItem(Type.intType, new Integer(x)).load();
                Items.this.code.emitop(96);
                Items.this.makeStackItem(Type.intType).coerce(this.typecode);
                this.store();
            }
        }
    }

    class SelfItem
    extends Item
    implements ByteCodes,
    TypeTags {
        boolean isSuper;

        SelfItem(boolean bl) {
            super(4);
            this.isSuper = bl;
        }

        Item load() {
            Items.this.code.emitop(42);
            return Items.this.stackItem[this.typecode];
        }
    }

    class IndexedItem
    extends Item
    implements ByteCodes,
    TypeTags {
        Type type;

        IndexedItem(Type type) {
            super(Code.typecode(type));
            this.type = type;
        }

        Item load() {
            Items.this.code.emitop(46 + this.typecode);
            return Items.this.stackItem[this.typecode];
        }

        Item store() {
            Items.this.code.emitop(79 + this.typecode);
            return Items.this.voidItem;
        }

        void duplicate() {
            Items.this.code.emitop(92);
        }

        void drop() {
            Items.this.code.emitop(88);
        }

        void stash(int n) {
            Items.this.code.emitop(91 + 3 * (Code.width(n) - 1));
        }
    }

    class StackItem
    extends Item
    implements ByteCodes,
    TypeTags {
        StackItem(int n) {
            super(n);
        }

        Item load() {
            return this;
        }

        void duplicate() {
            Items.this.code.emitop(Code.width(this.typecode) == 2 ? 92 : 89);
        }

        void drop() {
            Items.this.code.emitop(Code.width(this.typecode) == 2 ? 88 : 87);
        }

        void stash(int n) {
            Items.this.code.emitop((Code.width(this.typecode) == 2 ? 91 : 90) + 3 * (Code.width(n) - 1));
        }
    }

    class Item
    implements ByteCodes,
    TypeTags {
        int typecode;

        Item(int n) {
            this.typecode = n;
        }

        Item load() {
            throw new InternalError();
        }

        Item store() {
            throw new InternalError(String.valueOf("store unsupported: ").concat(String.valueOf(this)));
        }

        Item invoke() {
            throw new InternalError();
        }

        void duplicate() {
        }

        void drop() {
        }

        void stash(int n) {
            Items.this.stackItem[n].duplicate();
        }

        CondItem mkCond() {
            this.load();
            return Items.this.makeCondItem(154);
        }

        Item coerce(int targetcode) {
            if (this.typecode == targetcode) {
                return this;
            }
            this.load();
            int typecode1 = Code.truncate(this.typecode);
            int targetcode1 = Code.truncate(targetcode);
            if (typecode1 != targetcode1) {
                int n = targetcode1 > typecode1 ? targetcode1 - 1 : targetcode1;
                Items.this.code.emitop(133 + typecode1 * 3 + n);
            }
            if (targetcode != targetcode1) {
                Items.this.code.emitop(145 + targetcode - 5);
            }
            return Items.this.stackItem[targetcode];
        }

        Item coerce(Type type) {
            return this.coerce(Code.typecode(type));
        }
    }
}

