/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.jp;

import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.comp.Attr;
import gjc.v6.comp.AttrContext;
import gjc.v6.comp.Check;
import gjc.v6.comp.Env;
import gjc.v6.comp.Infer;
import gjc.v6.comp.Resolve;
import gjc.v6.jp.JPSymtab;
import gjc.v6.jp.Tools;
import gjc.v6.tree.Tree;
import gjc.v6.tree.TreeMaker;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.Log;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPAttr
extends Attr {
    JPSymtab syms;
    Tools tools;
    public boolean secondRun = false;

    public JPAttr(Hashtable<String, String> options, Log log, JPSymtab syms, Resolve rs, Check chk, Infer infer, TreeMaker make, Tools tools) {
        super(options, log, syms, rs, chk, infer, make);
        this.syms = syms;
        this.tools = tools;
    }

    @Override
    public void attribClass(Symbol.ClassSymbol c) {
        Env<AttrContext> env = this.enter.classEnvs.get(c);
        super.attribClass(c);
        if (env == null) {
            return;
        }
        if (!this.tools.rnames.local_only && (c.flags() & 0x800) != 0) {
            if (!this.tools.isRemoteRoot(c.type) && !this.tools.isRemote(c.type.supertype())) {
                this.log.error(env.tree.pos, String.valueOf("super class of a remote class must also be remote: ").concat(String.valueOf(c)));
            }
            if (this.isInner(c)) {
                this.log.error(env.tree.pos, String.valueOf("inner classes can not be declared remote: ").concat(String.valueOf(c)));
            }
        }
        Symbol.ClassSymbol classSymbol = c.owner.enclClass();
        if (!this.tools.rnames.local_only && this.isInner(c) && classSymbol != null && this.tools.isRemote(classSymbol) && !this.isAnonymous(c)) {
            this.log.error(env.tree.pos, String.valueOf("only anonymous inner classes are supported inside a remote class: ").concat(String.valueOf(c)));
        }
    }

    private boolean isInner(Symbol.ClassSymbol classSymbol) {
        return classSymbol.owner.kind == 4 || classSymbol.owner.kind == 32 || classSymbol.owner.kind == 2;
    }

    private boolean isAnonymous(Symbol.ClassSymbol classSymbol) {
        return classSymbol.name.len == 0;
    }

    @Override
    protected List<Type> attribArgs(List<Tree> trees, Env<AttrContext> env) {
        List<Type> result = super.attribArgs(trees, env);
        List<Tree> list = trees;
        while (list.nonEmpty()) {
            if (!this.checkConstArray((Tree)list.head, env, false)) {
                this.log.error(((Tree)list.head).pos, String.valueOf("illegal passing of reference to constant: ").concat(String.valueOf(this.getVarSymbol((Tree)list.head))));
            }
            list = list.tail;
        }
        return result;
    }

    @Override
    public Type _case(Tree.NewClass tree, Env<AttrContext> env) {
        Type result = super._case(tree, env);
        if (!this.tools.rnames.local_only && tree.constructor != null && tree.at != null && tree.constructor != Symbol.errSymbol) {
            Symbol owner = tree.constructor.owner;
            if (owner != Symbol.errSymbol && !owner.type.subType(this.syms.remoteType) && (owner.flags_field & 0x2000000) == 0) {
                this.log.error(tree.at.pos, "target of annotation is not a remote or replicated class");
            } else if ((owner.flags_field & 0x2000000) != 0) {
                Type type = this.attribExpr(tree.at, env, new Type.ArrayType(Type.intType));
            } else {
                Type type = this.attribExpr(tree.at, env, Type.intType);
            }
        }
        return result;
    }

    @Override
    public Type _case(Tree.Assign tree, Env<AttrContext> env) {
        Type type = super._case(tree, env);
        if (!this.checkConstArray(tree.lhs, env, true)) {
            this.log.error(tree.pos, String.valueOf("illegal assignment to constant: ").concat(String.valueOf(this.getVarSymbol(tree.lhs))));
        }
        if (!this.checkConstArray(tree.rhs, env, false)) {
            this.log.error(tree.pos, String.valueOf("illegal passing of reference to constant: ").concat(String.valueOf(this.getVarSymbol(tree.rhs))));
        }
        return type;
    }

    @Override
    public Type _case(Tree.Assignop tree, Env<AttrContext> env) {
        Type type = super._case(tree, env);
        if (!this.checkConstArray(tree.lhs, env, true)) {
            this.log.error(tree.pos, String.valueOf("illegal assignment to constant: ").concat(String.valueOf(this.getVarSymbol(tree.lhs))));
        }
        return type;
    }

    @Override
    public Type _case(Tree.VarDef tree, Env<AttrContext> env) {
        Type result = super._case(tree, env);
        this.checkStatic(tree.pos, tree.sym);
        if (!((tree.sym.flags() & 0x1000) == 0 || this.tools.rnames.local_only || this.tools.isLocal(tree.sym) || this.tools.isRemote(tree.sym.owner))) {
            this.log.error(tree.pos, String.valueOf("constants are only supported in remote classes: ").concat(String.valueOf(tree.sym)));
        }
        if (!(tree.init == null || this.tools.isLocal(tree.sym) && (tree.sym.flags() & 0x1000) != 0 || this.checkConstArray(tree.init, env, false))) {
            this.log.error(tree.pos, String.valueOf("illegal passing of references to constant: ").concat(String.valueOf(this.getVarSymbol(tree.init))));
        }
        if (tree.merge != null) {
            Type mergeType = this.attribType(tree.merge, env);
            if (mergeType.tag != 10 || mergeType.tsym.flags() == 512) {
                this.log.error(tree.merge.pos, "class type expected");
            }
            if (result.tag >= 9) {
                this.log.error(tree.merge.pos, "merge annotations are supported for primitive types only");
            }
            if (((AttrContext)env.info).scope.owner.kind == 32) {
                this.log.error(tree.merge.pos, "merge annotation not allowed for local variables");
            } else {
                Symbol symbol = tree.sym.owner;
                if (!this.tools.rnames.local_only && symbol != Symbol.errSymbol && symbol.type.subType(this.syms.remoteType)) {
                    this.log.error(tree.merge.pos, "members of remote classes cannot have merge annotations");
                }
            }
            tree.sym.mergeType = mergeType;
        }
        return result;
    }

    @Override
    public Type _case(Tree.MethodDef tree, Env<AttrContext> env) {
        Type type = super._case(tree, env);
        this.checkStatic(tree.pos, tree.sym);
        if (this.tools.rnames.with_karmi && !this.secondRun) {
            if (this.tools.isReplicated(tree.sym.owner)) {
                if ((tree.flags & 0x20) != 0 ^ (tree.flags & 0x1C000000) != 0) {
                    this.log.error(tree.pos, "Synchronized methods of replicated objects must be qualified with 'collective', 'exclusive' or 'shared'.");
                }
            } else if ((tree.flags & 0x1C000000) != 0) {
                this.log.error(tree.pos, "Methods of non-replicated objects must not be qualified with 'collective', 'exclusive' or 'shared'.");
            }
        }
        return type;
    }

    private void checkStatic(int pos, Symbol symbol) {
        if (this.tools.rnames.jp_bootstrap && this.tools.isType(symbol.owner) && this.tools.isRemote(symbol.owner) && !this.tools.isRemoteRoot(symbol.owner.type) && this.tools.isStatic(symbol) && !this.tools.isConstant(symbol)) {
            this.log.error(pos, String.valueOf("static members of remote classes are not allowed in bootstrap mode: ").concat(String.valueOf(symbol)));
        }
    }

    @Override
    public Type _case(Tree.Block tree, Env<AttrContext> env) {
        Type type = super._case(tree, env);
        if (this.tools.rnames.jp_bootstrap && this.tools.isRemote(env.enclClass.sym) && this.tools.isStatic(tree.flags)) {
            this.log.error(tree.pos, "static members of remote classes are not allowed in bootstrap mode");
        }
        return type;
    }

    private Symbol getVarSymbol(Tree tree) {
        block6: while (true) {
            switch (tree.tag) {
                case 29: {
                    tree = ((Tree.Indexed)tree).indexed;
                    continue block6;
                }
                case 27: {
                    tree = ((Tree.TypeCast)tree).expr;
                    continue block6;
                }
                case 31: {
                    return ((Tree.Ident)tree).sym;
                }
                case 30: {
                    return ((Tree.Select)tree).sym;
                }
            }
            break;
        }
        return null;
    }

    protected boolean checkConstArray(Tree tree, Env<AttrContext> env, boolean leftHand) {
        Symbol sym = this.getVarSymbol(tree);
        if (sym == null) {
            return true;
        }
        if (sym.kind != 4) {
            return true;
        }
        Type type = sym.type;
        if (!(type instanceof Type.ArrayType) || (sym.flags() & 0x1000) == 0) {
            return true;
        }
        int depth = 0;
        while (type instanceof Type.ArrayType) {
            type = ((Type.ArrayType)type).elemtype;
            ++depth;
        }
        int accessDepth = 0;
        while (tree instanceof Tree.Indexed) {
            tree = ((Tree.Indexed)tree).indexed;
            ++accessDepth;
        }
        if (leftHand) {
            Symbol symbol = ((AttrContext)env.info).scope.owner;
            return !this.tools.isLocal(sym) && (sym.owner == symbol || Resolve.isStatic(env) && (symbol.flags() & 0x80000) != 0 && sym.owner == symbol.owner);
        }
        return depth == accessDepth;
    }

    @Override
    public Type _case(Tree.Operation tree, Env<AttrContext> env) {
        Type type = super._case(tree, env);
        if (42 <= tree.tag && tree.tag <= 45 && !this.checkConstArray((Tree)tree.args.head, env, true)) {
            this.log.error(tree.pos, String.valueOf("illegal operation on constant: ").concat(String.valueOf(this.getVarSymbol((Tree)tree.args.head))));
        }
        return type;
    }

    @Override
    public Type _case(Tree.Synchronized tree, Env<AttrContext> env) {
        Type result = super._case(tree, env);
        if (this.tools.rnames.with_karmi && !this.secondRun) {
            int n = ((Tree.Block)tree.body).flags;
            if (this.tools.isReplicated(tree.lock) && (n & 0x1C000000) == 0) {
                this.log.error(tree.pos, "Synchronization on replicated objects must be qualified with 'collective', 'exclusive' or 'shared'.");
            }
            if (!this.tools.maybeReplicated(tree.lock) && (n & 0x1C000000) != 0) {
                this.log.error(tree.pos, "Synchronization on non-replicated objects must not be qualified with 'collective', 'exclusive' or 'shared'.");
            }
        }
        return result;
    }

    @Override
    public /* synthetic */ Object _case(Tree x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Erroneous x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeApply x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeArray x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Literal x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Ident x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Select x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Indexed x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeTest x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeCast x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Operation x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assignop x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assign x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewArray x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewClass x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Apply x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Throw x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Return x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Continue x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Break x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Exec x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assert x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Conditional x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Catch x0, Object object) {
        return super._case(x0, (Env)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Try x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Synchronized x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Case x0, Object object) {
        return super._case(x0, (Env)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Switch x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Labelled x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ForLoop x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.DoLoop x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Block x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.VarDef x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.MethodDef x0, Object object) {
        return this._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ClassDef x0, Object object) {
        return super._case(x0, (Env<AttrContext>)((Env)object));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Import x0, Object object) {
        return super._case(x0, (Env)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TopLevel x0, Object object) {
        return super._case(x0, (Env)object);
    }
}

