/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.jp;

import gjc.v6.code.Kinds;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.jp.Context;
import gjc.v6.jp.ReplicatedContext;
import gjc.v6.jp.Tools;
import gjc.v6.tree.Tree;
import gjc.v6.util.Log;
import gjc.v6.util.Name;
import gjc.v6.util.Names;

public class MethodAccess
implements Kinds {
    Tree ref;
    boolean isStaticRef;
    boolean isSelfRef;
    Name name;
    Symbol.MethodSymbol fun;
    Type refType;

    public MethodAccess(Tools tools, Context c, Tree meth, Log log) {
        switch (meth.tag) {
            case 30: {
                Tree.Select select = (Tree.Select)meth;
                if (select.sym.kind != 32) {
                    log.error(meth.pos, String.valueOf(String.valueOf("internal: not a method (").concat(String.valueOf(select.sym.kind))).concat(String.valueOf(")")));
                    return;
                }
                this.ref = select.selected;
                this.isStaticRef = tools.isStaticRef(this.ref);
                this.isSelfRef = this.isSelf(this.ref);
                this.refType = this.ref.type;
                this.name = select.name;
                this.fun = (Symbol.MethodSymbol)select.sym;
                break;
            }
            case 31: {
                Tree.Ident ident = (Tree.Ident)meth;
                if (ident.sym.kind != 32) {
                    log.error(ident.pos, String.valueOf(String.valueOf("internal: not a method (").concat(String.valueOf(ident.sym.kind))).concat(String.valueOf(")")));
                    return;
                }
                if (c.isStatic()) {
                    this.ref = tools.getRef(c.clazz);
                    this.isStaticRef = true;
                    this.isSelfRef = false;
                } else {
                    this.ref = c.f.Ident(Names._this);
                    this.isStaticRef = false;
                    this.isSelfRef = true;
                }
                this.refType = c.clazz.type;
                this.name = ident.name;
                this.fun = (Symbol.MethodSymbol)ident.sym;
                break;
            }
            default: {
                log.error(meth.pos, String.valueOf(String.valueOf("internal: unexpected tag (").concat(String.valueOf(meth.tag))).concat(String.valueOf(")")));
                return;
            }
        }
    }

    public MethodAccess(Tools tools, ReplicatedContext rc, Tree meth, Log log) {
        switch (meth.tag) {
            case 30: {
                Tree.Select select = (Tree.Select)meth;
                if (select.sym == null) break;
                if (select.sym.kind != 32) {
                    log.error(meth.pos, String.valueOf(String.valueOf("internal: not a method (").concat(String.valueOf(select.sym.kind))).concat(String.valueOf(")")));
                    return;
                }
                this.ref = select.selected;
                this.isStaticRef = tools.isStaticRef(this.ref);
                this.isSelfRef = this.isSelf(this.ref);
                this.refType = this.ref.type;
                this.name = select.name;
                this.fun = (Symbol.MethodSymbol)select.sym;
                break;
            }
            case 31: {
                Tree.Ident ident = (Tree.Ident)meth;
                if (ident.sym.kind != 32) {
                    log.error(ident.pos, String.valueOf(String.valueOf("internal: not a method (").concat(String.valueOf(ident.sym.kind))).concat(String.valueOf(")")));
                    return;
                }
                if (rc.isStatic()) {
                    this.ref = rc.f.Ident(rc.clazz);
                    this.isStaticRef = true;
                    this.isSelfRef = false;
                }
                this.refType = rc.clazz.type;
                this.name = ident.name;
                this.fun = (Symbol.MethodSymbol)ident.sym;
                break;
            }
            default: {
                log.error(meth.pos, String.valueOf(String.valueOf("internal: unexpected tag (").concat(String.valueOf(meth.tag))).concat(String.valueOf(")")));
                return;
            }
        }
    }

    boolean isSelfRef(Tree tree) {
        if (tree.tag == 31) {
            return true;
        }
        if (tree.tag == 30) {
            return this.isSelf(((Tree.Select)tree).selected);
        }
        return false;
    }

    boolean isSelf(Tree t) {
        if (t.tag == 31) {
            Name name = ((Tree.Ident)t).name;
            return name == Names._this || name == Names._super;
        }
        return false;
    }
}

