/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.jp;

import gjc.v6.code.Flags;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.jp.JPSymtab;
import gjc.v6.jp.KaRMIcGenerator;
import gjc.v6.jp.SourceGenerator;
import gjc.v6.tree.Tree;
import gjc.v6.tree.TreeInfo;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Name;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInfo
implements Flags {
    public int flags;
    public int flagsimpl;
    public int flagshandle;
    public Type type;
    public Name fun;
    public Name funimpl;
    public List<ParamInfo> params;
    public List<Type> thrown;
    public List<Type> thrownimpl;
    public List<Type> thrownstub;
    public List<Type> thrownwrap;

    public MethodInfo(MethodInfo methodInfo) {
        this.flags = methodInfo.flags;
        this.flagsimpl = methodInfo.flagsimpl;
        this.flagshandle = methodInfo.flagshandle;
        this.type = methodInfo.type;
        this.fun = methodInfo.fun;
        this.funimpl = methodInfo.funimpl;
        this.params = methodInfo.params;
        this.thrown = methodInfo.thrown;
        this.thrownimpl = methodInfo.thrownimpl;
        this.thrownstub = methodInfo.thrownstub;
        this.thrownwrap = methodInfo.thrownwrap;
    }

    public MethodInfo(JPSymtab syms, Tree.MethodDef methodDef) {
        this(syms, methodDef, false);
    }

    public MethodInfo(JPSymtab syms, Tree.MethodDef md, boolean canMigrate) {
        this(syms, md.sym, canMigrate);
        ListBuffer<ParamInfo> b = new ListBuffer<ParamInfo>();
        List<Tree.VarDef> paramDefs = md.params;
        List<Type> list = ((Type.MethodType)md.sym.type).argtypes;
        while (paramDefs.nonEmpty()) {
            b.append(new ParamInfo(((Tree.VarDef)paramDefs.head).flags, (Type)list.head, ((Tree.VarDef)paramDefs.head).name));
            paramDefs = paramDefs.tail;
            list = list.tail;
        }
        this.params = b.toList();
    }

    public MethodInfo(JPSymtab syms, Symbol.MethodSymbol methodSymbol) {
        this(syms, methodSymbol, false);
    }

    public MethodInfo(JPSymtab syms, Symbol.MethodSymbol msym, boolean bl) {
        this(syms, (Type.MethodType)msym.type, bl);
        this.setFlags(msym.flags());
        this.setName(msym.name);
    }

    public MethodInfo(JPSymtab syms, Type.MethodType methodType) {
        this(syms, methodType, false);
    }

    public MethodInfo(JPSymtab syms, Type.MethodType mtype, boolean bl) {
        this.type = mtype.restype;
        this.setThrown(syms, mtype.thrown, bl);
        this.initParameters(mtype.argtypes);
    }

    public void initParameters(List<Type> paramTypes) {
        ListBuffer<ParamInfo> b = new ListBuffer<ParamInfo>();
        int n = 0;
        while (paramTypes.nonEmpty()) {
            b.append(new ParamInfo((Type)paramTypes.head, Name.fromString(String.valueOf("p").concat(String.valueOf(n++)))));
            paramTypes = paramTypes.tail;
        }
        this.params = b.toList();
    }

    public List<Type> getParameterTypes() {
        ListBuffer<Type> b = new ListBuffer<Type>();
        List<ParamInfo> list = this.params;
        while (list.nonEmpty()) {
            b.append(((ParamInfo)list.head).type);
            list = list.tail;
        }
        return b.toList();
    }

    public void setThrown(JPSymtab syms, List<Symbol.ClassSymbol> methodThrown, boolean canMigrate) {
        Type[] _thrown = new Type[methodThrown.length()];
        int idx = 0;
        List<Symbol.ClassSymbol> ex = methodThrown;
        while (ex.nonEmpty()) {
            _thrown[idx++] = ((Symbol.ClassSymbol)ex.head).type;
            ex = ex.tail;
        }
        this.normalizeExceptionTable(_thrown);
        this.thrown = this.makeList(_thrown);
        _thrown = new Type[this.thrown.length() + (canMigrate ? 1 : 0)];
        idx = 0;
        List<Type> list = this.thrown;
        while (list.nonEmpty()) {
            _thrown[idx++] = (Type)list.head;
            list = list.tail;
        }
        if (canMigrate) {
            _thrown[idx++] = syms.movedExceptionType;
        }
        this.normalizeExceptionTable(_thrown);
        this.thrownimpl = this.makeList(_thrown);
        this.setThrownStub(syms, this.thrownimpl);
        this.setThrownWrap(syms, this.thrownimpl);
    }

    private void setThrownStub(JPSymtab syms, List<Type> thrownimpl) {
        Type[] _thrown = new Type[thrownimpl.length() + 1];
        int idx = 0;
        List<Type> list = thrownimpl;
        while (list.nonEmpty()) {
            _thrown[idx++] = (Type)list.head;
            list = list.tail;
        }
        _thrown[idx++] = syms.remoteExceptionType;
        this.normalizeExceptionTable(_thrown);
        this.thrownstub = this.makeList(_thrown);
    }

    private void setThrownWrap(JPSymtab syms, List<Type> thrownimpl) {
        Type[] _thrown = new Type[thrownimpl.length() + 2];
        int idx = 0;
        List<Type> list = thrownimpl;
        while (list.nonEmpty()) {
            _thrown[idx++] = (Type)list.head;
            list = list.tail;
        }
        _thrown[idx++] = syms.errorType;
        _thrown[idx++] = syms.runtimeExceptionType;
        this.normalizeExceptionTable(_thrown);
        this.thrownwrap = this.makeList(_thrown);
    }

    private void normalizeExceptionTable(Type[] _thrown) {
        for (int i = 0; i < _thrown.length; ++i) {
            if (_thrown[i] == null) continue;
            for (int j = 0; j < _thrown.length; ++j) {
                if (i == j || _thrown[j] == null || !_thrown[j].subType(_thrown[i])) continue;
                _thrown[j] = null;
            }
        }
    }

    private List<Type> makeList(Type[] _thrown) {
        ListBuffer<Type> thrownList = new ListBuffer<Type>();
        for (int i = 0; i < _thrown.length; ++i) {
            if (_thrown[i] == null) continue;
            thrownList.append(_thrown[i]);
        }
        return thrownList.toList();
    }

    public MethodInfo() {
    }

    public void setName(Name name) {
        this.fun = name;
        this.setImplName(name);
    }

    public void setImplName(Name name) {
        this.funimpl = name;
    }

    public void setFlags(int n) {
        this.flags = n;
        this.flagsimpl = MethodInfo.methodImplModifiers(n);
        this.flagshandle = MethodInfo.methodHandleModifiers(n);
    }

    public void set(SourceGenerator.Scope s) {
        s.set("flags", this.flags);
        s.set("flagshandle", this.flagshandle);
        s.set("flagsimpl", this.flagsimpl);
        s.set("type", this.type);
        s.set("fun", this.fun);
        s.set("funimpl", this.funimpl);
        s.set("thrown", this.createThrown(this.thrown));
        s.set("thrownimpl", this.createThrown(this.thrownimpl));
        s.set("thrownstub", this.createThrown(this.thrownstub));
        StringBuffer paramsS = new StringBuffer();
        StringBuffer argsS = new StringBuffer();
        List<ParamInfo> list = this.params;
        while (list.nonEmpty()) {
            if (list != this.params) {
                paramsS.append(", ");
                argsS.append(", ");
            }
            paramsS.append(TreeInfo.flagNames(((ParamInfo)list.head).flags));
            if ((((ParamInfo)list.head).flags & 0x2FFF) != 0) {
                paramsS.append(' ');
            }
            paramsS.append(((ParamInfo)list.head).type.toString());
            paramsS.append(' ');
            paramsS.append(((ParamInfo)list.head).name.toString());
            argsS.append(((ParamInfo)list.head).name.toString());
            list = list.tail;
        }
        s.set("args", argsS.toString());
        s.set("params", paramsS.toString());
        MethodInfo.setReturn(s, this.type == Type.voidType);
    }

    public String createSubscript() {
        StringBuffer subscr = new StringBuffer();
        List<ParamInfo> list = this.params;
        while (list.nonEmpty()) {
            subscr.append('[');
            subscr.append(((ParamInfo)list.head).name.toString());
            subscr.append(']');
            list = list.tail;
        }
        return subscr.toString();
    }

    public String createThrown(List<Type> _thrown) {
        StringBuffer buffer = new StringBuffer();
        List<Type> list = _thrown;
        while (list.nonEmpty()) {
            if (list != _thrown) {
                buffer.append(", ");
            }
            buffer.append(((Type)list.head).tsym.fullName().toString());
            list = list.tail;
        }
        return buffer.toString();
    }

    public static void setReturn(SourceGenerator.Scope s, boolean isVoid) {
        s.set("returnEarly", isVoid ? "" : "return");
        s.set("returnLate", isVoid ? "return" : "");
    }

    public static int methodHandleModifiers(int flags) {
        flags &= 0xFFFFFBFF;
        flags &= 0xFFFFFFFD;
        flags &= 0xFFFFFFFB;
        flags |= 1;
        return flags &= 0xFFFFFFDF;
    }

    public static int methodImplModifiers(int flags) {
        return 1 | flags & 0x10 | flags & 0x20 | flags & 0x400;
    }

    public static int methodReplicatedClassModifiers(int flags) {
        return 1 | flags & 0x10 | flags & 0x20 | flags & 0x400;
    }

    public static int methodClassImplModifiers(int flags) {
        flags &= 0xFFFFFFFD;
        flags &= 0xFFFFFFFB;
        return flags |= 1;
    }

    public static class SortedParams {
        public ListBuffer<Type> basicTypes = new ListBuffer();
        public ListBuffer<Name> basicNames = new ListBuffer();
        public ListBuffer<Type> objectTypes = new ListBuffer();
        public ListBuffer<Name> objectNames = new ListBuffer();
        public int basicSize = 0;

        public SortedParams(MethodInfo minfo) {
            List<ParamInfo> list = minfo.params;
            while (list.nonEmpty()) {
                if (((ParamInfo)list.head).type.tag <= 8) {
                    this.basicTypes.append(((ParamInfo)list.head).type);
                    this.basicNames.append(((ParamInfo)list.head).name);
                    this.basicSize += KaRMIcGenerator.SIZEOF[KaRMIcGenerator.IDX[((ParamInfo)list.head).type.tag]];
                } else {
                    this.objectTypes.append(((ParamInfo)list.head).type);
                    this.objectNames.append(((ParamInfo)list.head).name);
                }
                list = list.tail;
            }
        }
    }

    public static class ParamInfo {
        public int flags;
        public Name name;
        public Type type;

        public ParamInfo(Type type, Name name) {
            this(0, type, name);
        }

        public ParamInfo(int flags, Type type, Name name) {
            this.flags = flags;
            this.name = name;
            this.type = type;
        }
    }
}

