/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.jp;

import gjc.v6.jp.ConfigurationException;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.Log;
import gjc.v6.util.Name;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteNames {
    public final boolean local_only;
    public final boolean with_karmi;
    public final boolean karmi_with_transport;
    public final boolean karmi_with_smartstubs;
    public final boolean jp_with_transport;
    public final boolean jp_with_smarthandles;
    public final boolean jp_bootstrap;
    public final Name nameKaRMIPackage;
    public final Name nameRemote;
    public final Name nameRemoteStub;
    public final Name nameRemoteRef;
    public final Name nameRemoteSkeleton;
    public final Name nameRemoteException;
    public final Name nameRestoreMethod;
    public static final Name writeObjectMethod = Name.fromString("writeObject");
    public static final Name readObjectMethod = Name.fromString("readObject");
    public final Name docTagAt = Name.fromString("at");
    public final Name docTagMerge = Name.fromString("merge");
    public final Name docTagEmbedded = Name.fromString("embedded");
    public final Name _thisVariable = Name.fromString("_this");
    public final Name _syncedObjectVariablePrefix = Name.fromString("_syncedObject");
    public final Name _testlockMethod = Name.fromString("_testlock");
    public final Name waitMethod = Name.fromString("wait");
    public final Name notifyMethod = Name.fromString("notify");
    public final Name notifyAllMethod = Name.fromString("notifyAll");
    public final Name getClassMethod = Name.fromString("getClass");
    public final Name finalizeMethod = Name.fromString("finalize");
    public final Name doWaitMethod = Name.fromString("doWait");
    public final Name doNotifyMethod = Name.fromString("doNotify");
    public final Name _ClassType_Method = Name.fromString("_ClassType_");
    public final Name instanceIntfSuffix = Name.fromString("_instance_intf");
    public final Name instanceImplSuffix = Name.fromString("_instance_impl");
    public final Name classIntfSuffix = Name.fromString("_class_intf");
    public final Name classImplSuffix = Name.fromString("_class_impl");
    public final Name getMethodSuffix = Name.fromString("_get_");
    public final Name setMethodSuffix = Name.fromString("_set_");
    public final Name incMethodSuffix = Name.fromString("_inc_");
    public final List<Name> rootHandle = Name.fromString("jp.lang.RemoteObject").toList();
    public final List<Name> rootInstanceIntf = RemoteNames.toName(this.rootHandle).append(this.instanceIntfSuffix).toList();
    public final List<Name> rootInstanceImpl = RemoteNames.toName(this.rootHandle).append(this.instanceImplSuffix).toList();
    public final List<Name> rootClassIntf = RemoteNames.toName(this.rootHandle).append(this.classIntfSuffix).toList();
    public final List<Name> rootClassImpl = RemoteNames.toName(this.rootHandle).append(this.classImplSuffix).toList();
    public final List<Name> rmaAcquire = Name.fromString("jp.lang.RemoteTools.rmaAcquire").toList();
    public final List<Name> rmaRelease = Name.fromString("jp.lang.RemoteTools.rmaRelease").toList();
    public final List<Name> remoteTools = Name.fromString("jp.lang.RemoteTools").toList();
    public final List<Name> doEqualsMethod = Name.fromString("jp.lang.RemoteTools.doEquals").toList();

    public static Name getName(Hashtable<String, String> options, String property) {
        String str = options.get(property);
        if (str != null) {
            return Name.fromString(str);
        }
        return null;
    }

    public RemoteNames(Hashtable<String, String> hashtable) {
        this.jp_bootstrap = hashtable.get("-bootstrap") != null;
        this.local_only = hashtable.get("-local") != null;
        this.nameRestoreMethod = Name.fromString("restoreAfterUnmarshal");
        this.with_karmi = Boolean.valueOf(hashtable.get("jp.with_karmi"));
        this.jp_with_transport = Boolean.valueOf(hashtable.get("jp.with_transport"));
        this.jp_with_smarthandles = Boolean.valueOf(hashtable.get("jp.with_smarthandles"));
        this.karmi_with_transport = Boolean.valueOf(hashtable.get("karmi.with_transport"));
        this.karmi_with_smartstubs = Boolean.valueOf(hashtable.get("karmi.with_smartstubs"));
        this.nameKaRMIPackage = RemoteNames.getName(hashtable, "rmi.package");
        this.nameRemote = RemoteNames.getName(hashtable, "rmi.class.Remote");
        this.nameRemoteStub = RemoteNames.getName(hashtable, "rmi.class.RemoteStub");
        this.nameRemoteRef = RemoteNames.getName(hashtable, "rmi.class.RemoteRef");
        this.nameRemoteSkeleton = RemoteNames.getName(hashtable, "rmi.class.RemoteSkeleton");
        this.nameRemoteException = RemoteNames.getName(hashtable, "rmi.class.RemoteException");
    }

    public void printConfig(Log log) {
        log.println("Configuration options:");
        log.println(String.valueOf("  with_karmi=").concat(String.valueOf(this.with_karmi)));
        log.println(String.valueOf("  jp_with_transport=").concat(String.valueOf(this.jp_with_transport)));
        log.println(String.valueOf("  jp_with_smarthandles=").concat(String.valueOf(this.jp_with_smarthandles)));
        log.println(String.valueOf("  karmi_with_transport=").concat(String.valueOf(this.karmi_with_transport)));
        log.println(String.valueOf("  karmi_with_smartstubs=").concat(String.valueOf(this.karmi_with_transport)));
        log.println(String.valueOf("  nameKaRMIPackage=").concat(String.valueOf(this.nameKaRMIPackage)));
        log.println(String.valueOf("  nameRemote=").concat(String.valueOf(this.nameRemote)));
        log.println(String.valueOf("  nameRemoteStub=").concat(String.valueOf(this.nameRemoteStub)));
        log.println(String.valueOf("  nameRemoteRef=").concat(String.valueOf(this.nameRemoteRef)));
        log.println(String.valueOf("  nameRemoteSkeleton=").concat(String.valueOf(this.nameRemoteSkeleton)));
        log.println(String.valueOf("  nameRemoteException=").concat(String.valueOf(this.nameRemoteException)));
    }

    public void checkJPConfig() {
        if (this.with_karmi) {
            if (this.jp_with_smarthandles != this.karmi_with_smartstubs) {
                throw new ConfigurationException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("jp_with_smarthandles=").concat(String.valueOf(this.jp_with_smarthandles))).concat(String.valueOf(" "))).concat(String.valueOf("does not match karmi_with_smartstubs="))).concat(String.valueOf(this.karmi_with_smartstubs))).concat(String.valueOf(". "))).concat(String.valueOf("Make sure, the correct version of karmi.jar is in your CLASSPATH.")));
            }
            if (this.jp_with_transport != this.karmi_with_transport) {
                throw new ConfigurationException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("jp_with_transport=").concat(String.valueOf(this.jp_with_transport))).concat(String.valueOf(" "))).concat(String.valueOf("does not match karmi_with_transport="))).concat(String.valueOf(this.karmi_with_transport))).concat(String.valueOf(". "))).concat(String.valueOf("Make sure, the correct version of karmi.jar is in your CLASSPATH.")));
            }
        }
    }

    public static Name toName(List<Name> names) {
        StringBuffer result = new StringBuffer();
        if (names.nonEmpty()) {
            result.append(((Name)names.head).toString());
            names = names.tail;
            while (names.nonEmpty()) {
                result.append('.');
                result.append(((Name)names.head).toString());
                names = names.tail;
            }
        }
        return Name.fromString(result.toString());
    }
}

