/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.jp;

import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.jp.RemoteNames;
import gjc.v6.tree.Pretty;
import gjc.v6.tree.Tree;
import gjc.v6.tree.TreeInfo;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.Name;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;

public class SourceGenerator {
    static final String EMPTY = "";
    private int level = 0;
    private char[] indentBuffer = new char[0];
    protected StringBuffer result = new StringBuffer();
    String sourcename;

    public SourceGenerator() {
        this.sourcename = "noname";
    }

    public SourceGenerator(String string) {
        this.sourcename = string;
    }

    public String getName() {
        return this.sourcename;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.result.toString().getBytes());
    }

    public void forall(Scope.Iterator it, String string) {
        while (it.hasNext()) {
            this.append(it.next(), string);
        }
    }

    public void append(Scope s, String macro) {
        int lengtBefore = this.result.length();
        this.result.append(this.indentBuffer);
        int start = this.result.length();
        s.eval(macro, this.result);
        int stop = this.result.length();
        for (int i = start; i < stop; ++i) {
            if (this.result.charAt(i) != '\n') continue;
            this.result.insert(i + 1, this.indentBuffer);
            i += this.level;
            stop += this.level;
        }
        if (start < stop) {
            this.newLine();
        } else {
            this.result.setLength(lengtBefore);
        }
    }

    public void newLine() {
        this.result.append('\n');
    }

    public String toString() {
        return this.result.toString();
    }

    public void indent(int ind) {
        this.level += ind;
        this.indentBuffer = new char[this.level];
        for (int i = 0; i < this.level; ++i) {
            this.indentBuffer[i] = 32;
        }
    }

    public void unindent(int ind) {
        this.level -= ind;
        this.indentBuffer = new char[this.level];
        for (int i = 0; i < this.level; ++i) {
            this.indentBuffer[i] = 32;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Scope
    extends Hashtable<String, String> {
        Scope parent;
        private static final int PLAIN = 0;
        private static final int MACRO = 1;

        public Scope() {
            this.parent = null;
        }

        private Scope(Scope scope) {
            this.parent = scope;
        }

        public Scope createInner() {
            return new Scope(this);
        }

        private String superGet(String string) {
            return (String)super.get(string);
        }

        @Override
        public String get(String var) {
            Scope lookupScope = this;
            do {
                String string;
                if ((string = lookupScope.superGet(var)) == null) continue;
                return string;
            } while ((lookupScope = lookupScope.parent) != null);
            if (var.length() == 0) {
                return "@";
            }
            throw new InternalError(String.valueOf(String.valueOf("undefined macro '").concat(String.valueOf(var))).concat(String.valueOf("'")));
        }

        public void set(String var, int n) {
            ((Hashtable)this).put(var, TreeInfo.flagNames(n));
        }

        public void set(String var, Tree tree) {
            if (tree != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream print = new PrintStream(out);
                Pretty pretty = new Pretty(print);
                pretty.printStat(tree);
                ((Hashtable)this).put(var, out.toString());
            } else {
                ((Hashtable)this).put(var, SourceGenerator.EMPTY);
            }
        }

        public <T extends Tree> void setExprs(String var, List<T> list) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream print = new PrintStream(out);
            Pretty pretty = new Pretty(print);
            pretty.printExprs(list);
            ((Hashtable)this).put(var, out.toString());
        }

        public <T extends Tree> void setStats(String var, List<T> list) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream print = new PrintStream(out);
            Pretty pretty = new Pretty(print);
            pretty.printStats(list);
            ((Hashtable)this).put(var, out.toString());
        }

        public void set(String var, Name name) {
            ((Hashtable)this).put(var, name.toString());
        }

        public void set(String var, List<Name> list) {
            this.set(var, RemoteNames.toName(list));
        }

        public void set(String var, Symbol symbol) {
            ((Hashtable)this).put(var, symbol == null ? SourceGenerator.EMPTY : symbol.name.toString());
        }

        public void set(String var, Type type) {
            ((Hashtable)this).put(var, type.toString());
        }

        public void setConst(String var, String string) {
            ((Hashtable)this).put(var, string);
        }

        public void set(String var, String string) {
            ((Hashtable)this).put(var, this.eval(string));
        }

        public void reset(String string) {
            ((Hashtable)this).remove(string);
        }

        public boolean hasVar(String string) {
            return this.superGet(string) != null;
        }

        public static String concat(Iterator it, String macro, String delim, String empty) {
            StringBuffer result = new StringBuffer();
            if (it.hasNext()) {
                while (true) {
                    result.append(it.next().eval(macro));
                    if (it.hasNext()) {
                        result.append(delim);
                        continue;
                    }
                    break;
                }
            } else {
                result.append(empty);
            }
            return result.toString();
        }

        public String eval(String macro) {
            StringBuffer stringBuffer = new StringBuffer();
            this.eval(macro, stringBuffer);
            return stringBuffer.toString();
        }

        void eval(String macro, StringBuffer result) {
            int idx;
            char[] source = macro.toCharArray();
            int length = source.length;
            int startIdx = 0;
            int preIdx = 0;
            int postIdx = 0;
            int stopIdx = 0;
            boolean hasPre = false;
            boolean hasPost = false;
            int state = 0;
            block12: for (idx = 0; idx < length; ++idx) {
                switch (state) {
                    case 0: {
                        switch (source[idx]) {
                            case '@': {
                                startIdx = idx;
                                hasPre = false;
                                hasPost = false;
                                state = 1;
                                continue block12;
                            }
                        }
                        continue block12;
                    }
                    case 1: {
                        switch (source[idx]) {
                            case '@': {
                                result.append(source, stopIdx, startIdx - stopIdx);
                                stopIdx = idx + 1;
                                int nameStart = hasPre ? preIdx + 1 : startIdx + 1;
                                int nameStop = hasPost ? postIdx : stopIdx - 1;
                                String name = new String(source, nameStart, nameStop - nameStart);
                                String string = this.get(name);
                                if (string.length() > 0) {
                                    if (hasPre) {
                                        result.append(source, startIdx + 1, preIdx - (startIdx + 1));
                                    }
                                    result.append(string);
                                    if (hasPost) {
                                        result.append(source, postIdx + 1, stopIdx - 1 - (postIdx + 1));
                                    }
                                }
                                state = 0;
                                continue block12;
                            }
                            case '(': {
                                if (hasPre) {
                                    throw new InternalError(String.valueOf(String.valueOf("illegal macro format '").concat(String.valueOf(macro))).concat(String.valueOf("'")));
                                }
                                preIdx = idx;
                                hasPre = true;
                                continue block12;
                            }
                            case ')': {
                                if (hasPost) {
                                    throw new InternalError(String.valueOf(String.valueOf("illegal macro format '").concat(String.valueOf(macro))).concat(String.valueOf("'")));
                                }
                                postIdx = idx;
                                hasPost = true;
                                continue block12;
                            }
                        }
                        continue block12;
                    }
                }
            }
            if (state == 1) {
                throw new InternalError(String.valueOf(String.valueOf("missing end of macro '").concat(String.valueOf(macro))).concat(String.valueOf("'")));
            }
            result.append(source, stopIdx, idx - stopIdx);
        }

        @Override
        public /* synthetic */ Object remove(Object object) {
            return super.remove((String)object);
        }

        @Override
        public /* synthetic */ Object put(Object x0, Object object) {
            return super.put((String)x0, (String)object);
        }

        @Override
        public /* synthetic */ Object get(Object object) {
            return this.get((String)object);
        }

        public static interface Iterator {
            public boolean hasNext();

            public Scope next();
        }
    }
}

