/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.jp;

import gjc.v6.code.Flags;
import gjc.v6.code.Kinds;
import gjc.v6.code.Scope;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.jp.JPSymtab;
import gjc.v6.jp.RemoteNames;
import gjc.v6.jp.ReplicatedNames;
import gjc.v6.jp.TransImport;
import gjc.v6.jp.TransportableGenerator;
import gjc.v6.tree.Tree;
import gjc.v6.tree.TreeInfo;
import gjc.v6.tree.TreeMaker;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Name;
import gjc.v6.util.Names;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools
implements Flags,
Kinds,
TypeTags {
    final JPSymtab syms;
    final TreeMaker f;
    final RemoteNames rnames;
    final ReplicatedNames replicatedNames;
    public final TransportableGenerator transportableGenerator;
    private Type immutableType;
    private Type transportableType;
    private Type unmarshalStreamType;
    private Type patchableType;
    private Type referenceConsumerType;

    public Tools(Hashtable<String, String> options, JPSymtab syms, TreeMaker f, RemoteNames remoteNames) {
        this.syms = syms;
        this.f = f;
        this.rnames = remoteNames;
        this.replicatedNames = new ReplicatedNames(options);
        this.transportableGenerator = remoteNames.local_only || remoteNames.karmi_with_transport || remoteNames.jp_with_transport ? new TransportableGenerator(this) : null;
    }

    public Tools(Hashtable<String, String> options, JPSymtab syms, TreeMaker f, RemoteNames rnames, ReplicatedNames replicatedNames) {
        this.syms = syms;
        this.f = f;
        this.rnames = rnames;
        this.replicatedNames = replicatedNames;
        this.transportableGenerator = rnames.local_only || rnames.karmi_with_transport || rnames.jp_with_transport ? new TransportableGenerator(this) : null;
    }

    public Tree.Literal createNumberLiteral(Type expectedType, int intValue) {
        Number number;
        switch (expectedType.tag) {
            case 1: 
            case 2: 
            case 4: {
                number = new Integer(intValue);
                break;
            }
            case 5: {
                number = new Long(intValue);
                break;
            }
            case 6: {
                number = new Float(intValue);
                break;
            }
            case 7: {
                number = new Double(intValue);
                break;
            }
            default: {
                throw new InternalError(String.valueOf(String.valueOf("illegal type tag (").concat(String.valueOf(expectedType.tag))).concat(String.valueOf(")")));
            }
        }
        return this.f.Literal(expectedType.tag, number);
    }

    public Tree.Ident createBooleanLiteral(boolean bl) {
        if (bl) {
            return this.f.Ident(Names._true);
        }
        return this.f.Ident(Names._false);
    }

    public Tree.TopLevel makeTopLevel(Tree classDef, Tree.TopLevel toplevel) {
        List<Tree> defs = new List<Tree>(classDef);
        Tree.TopLevel topLevel = this.f.TopLevel(toplevel.packge == Symbol.emptyPackage ? null : this.getRef(toplevel.packge), this.prependImports(toplevel, defs));
        topLevel.sourcefile = toplevel.sourcefile;
        return topLevel;
    }

    public Tree.TopLevel makeTopLevel(Tree classDef, Tree.TopLevel toplevel, Name sourcefile) {
        List<Tree> defs = new List<Tree>(classDef);
        Tree.TopLevel topLevel = this.f.TopLevel(toplevel.packge == Symbol.emptyPackage ? null : this.getRef(toplevel.packge), this.prependImports(toplevel, defs));
        topLevel.sourcefile = sourcefile;
        return topLevel;
    }

    public List<Tree> prependImports(Tree.TopLevel top, List<Tree> defs) {
        ListBuffer<Object> listBuffer = new ListBuffer();
        listBuffer = top.visit(new TransImport(this.f), listBuffer);
        listBuffer.append(defs);
        return listBuffer.toList();
    }

    public Symbol.ClassSymbol getSuperClass(Symbol.ClassSymbol classSymbol) {
        return (Symbol.ClassSymbol)classSymbol.type.supertype().tsym;
    }

    public boolean needsIncMethod(Type type) {
        return type.tag >= 1 && type.tag <= 7;
    }

    public boolean hasRestoreMethod(Symbol.ClassSymbol clazz) {
        Scope.Entry entry = clazz.members().lookup(this.rnames.nameRestoreMethod);
        while (entry.sym != null) {
            if (entry.sym.type.tag == 12 && ((Type.MethodType)entry.sym.type).argtypes.isEmpty() && Tools.isPrivate(entry.sym)) {
                return true;
            }
            entry = entry.next();
        }
        return false;
    }

    public boolean needsRestore(Symbol.ClassSymbol classSymbol) {
        while (!this.hasRestoreMethod(classSymbol)) {
            if (classSymbol.type == this.syms.objectType) {
                return false;
            }
            classSymbol = this.getSuperClass(classSymbol);
        }
        return true;
    }

    public boolean overridesMethodInClass(Symbol.MethodSymbol method, Symbol.TypeSymbol clazz) {
        Scope.Entry entry = clazz.members().lookup(method.name);
        while (entry.sym != null) {
            if (method.overrides(entry.sym, clazz)) {
                return true;
            }
            entry = entry.next();
        }
        return false;
    }

    public Symbol.MethodSymbol findMethod(Symbol.TypeSymbol clazz, Name name, List<Type> argtypes) {
        Scope.Entry entry = clazz.members().lookup(name);
        while (entry.sym != null) {
            if (entry.sym.type.tag == 12 && Type.subTypes(argtypes, ((Type.MethodType)entry.sym.type).argtypes)) {
                return (Symbol.MethodSymbol)entry.sym;
            }
            entry = entry.next();
        }
        throw new InternalError(String.valueOf(String.valueOf(String.valueOf(String.valueOf("unable to find method '").concat(String.valueOf(name))).concat(String.valueOf("' of class '"))).concat(String.valueOf(clazz.fullName()))).concat(String.valueOf("'")));
    }

    public Tree getRef(List<Name> names) {
        Tree tree = this.f.Ident((Name)names.head);
        names = names.tail;
        while (names.nonEmpty()) {
            tree = this.f.Select(tree, (Name)names.head);
            names = names.tail;
        }
        return tree;
    }

    public boolean hasRef(Symbol symbol) {
        if (symbol.owner == null || symbol.owner == Symbol.emptyPackage) {
            return true;
        }
        if (symbol.name == Names.empty) {
            return false;
        }
        return this.hasRef(symbol.owner);
    }

    public Tree getRef(Symbol symbol) {
        if (symbol.owner == null || symbol.owner == Symbol.emptyPackage) {
            return this.f.Ident(symbol.name);
        }
        return this.f.Select(this.getRef(symbol.owner), symbol.name);
    }

    public Tree getTypeRef(Type type) {
        if (type.tag == 11) {
            return this.f.Indexed(this.getTypeRef(type.elemtype()), null);
        }
        if (type.tag == 10 || type.tag == 13) {
            if (type.tsym.owner == Symbol.emptyPackage) {
                return this.f.Ident(type.tsym.name);
            }
            return this.f.Select(this.getTypeRef(type.tsym.owner.type), type.tsym.name);
        }
        throw new InternalError(String.valueOf(String.valueOf("unexpected type tag (").concat(String.valueOf(type.tag))).concat(String.valueOf(")")));
    }

    public boolean hasInitializer(Tree.VarDef varDef) {
        return varDef.init != null;
    }

    public boolean isFinal(int n) {
        return (n & 0x10) != 0;
    }

    public boolean isFinal(Tree tree) {
        return (TreeInfo.flags(tree) & 0x10) != 0;
    }

    public boolean isFinal(Symbol symbol) {
        return (symbol.flags() & 0x10) != 0;
    }

    public boolean isConstant(Symbol symbol) {
        return this.isVariable(symbol) && this.isFinal(symbol) && ((Symbol.VarSymbol)symbol).constValue != null;
    }

    public boolean isLocal(Symbol symbol) {
        return symbol.owner.kind == 32;
    }

    public boolean isInterface(Symbol symbol) {
        return symbol.kind == 2 && (symbol.flags() & 0x200) != 0;
    }

    public boolean isVoid(Tree.MethodDef methodDef) {
        return ((Type.MethodType)methodDef.sym.type).restype.tag == 9;
    }

    public boolean isNative(Tree.MethodDef methodDef) {
        return (methodDef.flags & 0x100) != 0;
    }

    public boolean isConstructor(Tree.MethodDef methodDef) {
        return methodDef.name.equals(Names.init);
    }

    public boolean isSelfRef(Tree tree) {
        if (tree.tag == 31) {
            return true;
        }
        if (tree.tag == 30) {
            return this.isSelf(((Tree.Select)tree).selected);
        }
        return false;
    }

    public boolean isSelf(Tree t) {
        if (t.tag == 31) {
            Name name = ((Tree.Ident)t).name;
            return name == Names._this || name == Names._super;
        }
        return false;
    }

    public boolean isStaticRef(Tree tree) {
        switch (tree.tag) {
            case 30: 
            case 31: {
                Symbol symbol = TreeInfo.symbol(tree);
                switch (symbol.kind) {
                    case 2: {
                        return true;
                    }
                    case 4: {
                        return false;
                    }
                }
                throw new InternalError(String.valueOf(String.valueOf("unexpected symbol (").concat(String.valueOf(symbol.kind))).concat(String.valueOf(")")));
            }
        }
        return false;
    }

    public boolean isStatic(Tree tree) {
        return (TreeInfo.flags(tree) & 8) != 0;
    }

    public boolean isStaticFinal(Symbol symbol) {
        return this.isStatic(symbol) && this.isFinal(symbol);
    }

    public boolean isConst(Symbol.VarSymbol varSymbol) {
        return (varSymbol.flags() & 0x1000) != 0;
    }

    public boolean isReplicable(Symbol.VarSymbol varSymbol) {
        return this.isImmutable(varSymbol) && this.isStaticFinal(varSymbol) || this.isConst(varSymbol);
    }

    private Type getImmutableType() {
        if (this.immutableType == null) {
            this.immutableType = this.syms.reader.loadClass((Name)Name.fromString((String)"uka.lang.Immutable")).type;
        }
        return this.immutableType;
    }

    public boolean isImmutable(Symbol symbol) {
        return this.isImmutable(symbol.type);
    }

    public boolean isImmutable(Type type) {
        return type.tag <= 8 || type == Type.voidType || type == this.syms.langBooleanType || type == this.syms.langByteType || type == this.syms.langCharacterType || type == this.syms.langShortType || type == this.syms.langIntegerType || type == this.syms.langLongType || type == this.syms.langFloatType || type == this.syms.langDoubleType || type == this.syms.stringType || type == this.syms.netInetSocketAddressType || type == this.syms.netInet4AddressType || type == this.syms.netInet6AddressType || type.subType(this.getImmutableType());
    }

    public boolean useAnonymousMarshaling(Symbol.VarSymbol varSymbol) {
        if ((varSymbol.flags() & 0x2000) != 0) {
            return true;
        }
        return varSymbol.type.tag == 11 && this.getBaseType(varSymbol.type).subType(this.getImmutableType());
    }

    public Type getBaseType(Type type) {
        while (type.tag == 11) {
            type = type.elemtype();
        }
        return type;
    }

    public Type getTransportableType() {
        if (this.transportableType == null) {
            this.transportableType = this.syms.reader.loadClass((Name)Name.fromString((String)"uka.transport.Transportable")).type;
        }
        return this.transportableType;
    }

    public Type getUnmarshalStreamType() {
        if (this.unmarshalStreamType == null) {
            this.unmarshalStreamType = this.syms.reader.loadClass((Name)Name.fromString((String)"uka.transport.UnmarshalStream")).type;
        }
        return this.unmarshalStreamType;
    }

    public boolean isTransportable(Symbol clazz) {
        boolean bl = clazz.type.subType(this.getTransportableType());
        if (!bl) {
            return false;
        }
        return Tools.findMethod((Symbol.ClassSymbol)clazz, Names.init, List.make(this.getUnmarshalStreamType(), Type.intType)) != null;
    }

    public static Symbol.MethodSymbol findMethod(Symbol.ClassSymbol clazz, Name name, List<Type> argtypes) {
        Scope.Entry e = clazz.members().lookup(name);
        while (e.scope != null) {
            if (e.sym.kind == 32) {
                Symbol.MethodSymbol m = (Symbol.MethodSymbol)e.sym;
                Type.MethodType t = (Type.MethodType)m.type;
                if (t.argtypes.equals(argtypes)) {
                    return m;
                }
            }
            e = e.next();
        }
        return null;
    }

    public Type getPatchableType() {
        if (this.patchableType == null) {
            this.patchableType = this.syms.reader.loadClass((Name)Name.fromString((String)"uka.patch.Patchable")).type;
        }
        return this.patchableType;
    }

    public boolean requiresDeepCloneableSupport(Symbol.ClassSymbol classSymbol) {
        return !this.isImmutable(classSymbol);
    }

    public boolean requiresPatchableInjection(Symbol.ClassSymbol classSymbol) {
        if (this.isImmutable(classSymbol)) {
            return false;
        }
        if (!this.isPatchable(classSymbol)) {
            return true;
        }
        return Tools.findMethod(classSymbol, Name.fromString("descendReferences"), List.make(this.getReferenceConsumerType())) == null;
    }

    public Type getReferenceConsumerType() {
        if (this.referenceConsumerType == null) {
            this.referenceConsumerType = this.syms.reader.loadClass((Name)Name.fromString((String)"uka.patch.ReferenceConsumer")).type;
        }
        return this.referenceConsumerType;
    }

    public boolean isPatchable(Symbol symbol) {
        return symbol.type.subType(this.getPatchableType());
    }

    public boolean isStatic(Symbol symbol) {
        return (symbol.flags() & 8) != 0;
    }

    public boolean isStatic(int n) {
        return (n & 8) != 0;
    }

    public boolean isNull(Tree tree) {
        return tree.tag == 31 && ((Tree.Ident)tree).name.equals(Names._null);
    }

    public boolean isRemote(Type type) {
        return type.subType(this.syms.remoteType) && type != Type.allType;
    }

    public boolean isRemote(Tree tree) {
        return tree.type.subType(this.syms.remoteType) && tree.type != Type.allType;
    }

    public boolean isRemoteRoot(Type type) {
        return type == this.syms.remoteType;
    }

    public boolean isRemoteRoot(Tree tree) {
        return tree.type == this.syms.remoteType;
    }

    public boolean implementsOrExtendsReplicated(Symbol symbol) {
        return this.isReplicated(symbol) && !this.isReplicatedRoot(symbol.type);
    }

    public boolean implementsOrExtendsReplicated(Tree.ClassDef classDef) {
        return this.implementsOrExtendsReplicated(classDef.sym);
    }

    public boolean isReplicated(Symbol symbol) {
        if (symbol.kind != 2) {
            throw new InternalError(String.valueOf(String.valueOf("not a class (").concat(String.valueOf(symbol))).concat(String.valueOf(")")));
        }
        return this.isReplicated(symbol.type) || (symbol.flags() & 0x2000000) != 0;
    }

    public boolean isReplicated(Type type) {
        return (type.subType(this.syms.jpReplicatedType) || type.isReplicated) && type != Type.allType;
    }

    public boolean isReplicated(Tree tree) {
        return this.isReplicated(tree.type);
    }

    public boolean isReplicated(int n) {
        return (n & 0x2000000) != 0;
    }

    public boolean isReplicatedRoot(Type type) {
        return type == this.syms.jpReplicatedType;
    }

    public boolean isJPReplicatedObject(Tree.ClassDef classDef) {
        return classDef.sym.fullname.equals(this.replicatedNames.JPReplicatedObject);
    }

    public boolean isCollective(int n) {
        return (n & 0x4000000) != 0;
    }

    public boolean isExclusive(int n) {
        return (n & 0x8000000) != 0;
    }

    public boolean isShared(int n) {
        return (n & 0x10000000) != 0;
    }

    public int getSynchronizedType(int n) {
        if ((n & 0x8000000) != 0) {
            return 0x8000000;
        }
        if ((n & 0x4000000) != 0) {
            return 0x4000000;
        }
        if ((n & 0x10000000) != 0) {
            return 0x10000000;
        }
        if ((n & 0x20) != 0) {
            return 32;
        }
        return -1;
    }

    public int getSynchronizedType(Tree.MethodDef methodDef) {
        return this.getSynchronizedType(methodDef.flags);
    }

    public int getSynchronizedType(Tree.Block block) {
        return this.getSynchronizedType(block.flags);
    }

    public boolean implementsOrExtendsRemote(Symbol symbol) {
        return this.isRemote(symbol) && !this.isRemoteRoot(symbol.type);
    }

    public boolean isRemote(Symbol symbol) {
        if (symbol.kind != 2) {
            throw new InternalError(String.valueOf(String.valueOf("not a class (").concat(String.valueOf(symbol))).concat(String.valueOf(")")));
        }
        return this.isRemote(symbol.type);
    }

    public boolean maybeRemote(Tree tree) {
        return this.isRemote(tree.type) || tree.type == this.syms.objectType && !this.isNull(tree);
    }

    public boolean maybeReplicated(Tree tree) {
        if (this.isNull(tree)) {
            return false;
        }
        return this.isReplicated(tree) || this.isObject(tree) || this.isClassType(tree);
    }

    public boolean maybeReplicated(Symbol.ClassSymbol classSymbol) {
        return classSymbol.type == this.syms.objectType || classSymbol.type == this.syms.classType || classSymbol.type == this.syms.jpReplicatedType;
    }

    public boolean isObject(Tree tree) {
        return tree.type == this.syms.objectType && !this.isNull(tree);
    }

    public boolean isClassType(Tree tree) {
        return tree.type == this.syms.classType && !this.isNull(tree);
    }

    public boolean isFinalizer(Tree.MethodDef methodDef) {
        return methodDef.name.equals(this.rnames.finalizeMethod) && methodDef.params.length() == 0;
    }

    public static boolean isPrivate(Symbol sym) {
        return (sym.flags() & 2) != 0;
    }

    public boolean isAbstract(Tree tree) {
        return (TreeInfo.flags(tree) & 0x400) != 0;
    }

    public boolean isAbstract(Symbol symbol) {
        return (symbol.flags() & 0x400) != 0;
    }

    public boolean isTransient(Symbol symbol) {
        return (symbol.flags() & 0x80) != 0;
    }

    public boolean isType(Symbol symbol) {
        return symbol.kind == 2;
    }

    public boolean isVariable(Symbol symbol) {
        return symbol.kind == 4;
    }

    public boolean isSerializable(Symbol symbol) {
        return symbol.type.subType(this.syms.serializableType);
    }

    public boolean hasWriteObjectMethod(Symbol.ClassSymbol clazz) {
        if (!this.isSerializable(clazz)) {
            return false;
        }
        Symbol.MethodSymbol methodSymbol = Tools.findMethod(clazz, RemoteNames.writeObjectMethod, List.make(this.syms.objectOutputStreamType));
        if (methodSymbol != null && Tools.isPrivate(methodSymbol)) {
            return true;
        }
        return this.hasWriteObjectMethod(this.getSuperClass(clazz));
    }

    public boolean isExternalizable(Symbol symbol) {
        return symbol.type.subType(this.syms.externalizableType);
    }

    public Name getClassImpl(Symbol.ClassSymbol classSymbol) {
        return classSymbol.fullName().append(this.rnames.classImplSuffix);
    }

    public Name getReplicatedClassImpl(Symbol.ClassSymbol classSymbol) {
        return classSymbol.fullName().append(this.replicatedNames.classImplSuffix);
    }

    public Name getClassImpl(Symbol symbol) {
        return symbol.fullName().append(this.rnames.classImplSuffix);
    }

    public Name getReplicatedClassImpl(Symbol symbol) {
        return symbol.fullName().append(this.replicatedNames.classImplSuffix);
    }

    public Name getHandle(Symbol.ClassSymbol classSymbol) {
        return classSymbol.fullName();
    }

    public String fullID(Symbol symbol) {
        return symbol.fullName().toString().replace('.', '_');
    }

    public Name getMethod(Symbol.VarSymbol varSymbol) {
        return Name.fromString(String.valueOf(String.valueOf(String.valueOf(this.fullID(varSymbol.owner)).concat(String.valueOf('_'))).concat(String.valueOf(varSymbol.name))).concat(String.valueOf(this.rnames.getMethodSuffix)));
    }

    public Name setMethod(Symbol.VarSymbol varSymbol) {
        return Name.fromString(String.valueOf(String.valueOf(String.valueOf(this.fullID(varSymbol.owner)).concat(String.valueOf('_'))).concat(String.valueOf(varSymbol.name))).concat(String.valueOf(this.rnames.setMethodSuffix)));
    }

    public Name incMethod(Symbol.VarSymbol varSymbol) {
        return Name.fromString(String.valueOf(String.valueOf(String.valueOf(this.fullID(varSymbol.owner)).concat(String.valueOf('_'))).concat(String.valueOf(varSymbol.name))).concat(String.valueOf(this.rnames.incMethodSuffix)));
    }
}

