/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.jp;

import gjc.v6.code.Flags;
import gjc.v6.code.Kinds;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.code.TypeTags;
import gjc.v6.jp.Context;
import gjc.v6.jp.JPSymtab;
import gjc.v6.jp.KaRMIcGenerator;
import gjc.v6.jp.MethodAccess;
import gjc.v6.jp.MethodInfo;
import gjc.v6.jp.RemoteClassBundle;
import gjc.v6.jp.RemoteNames;
import gjc.v6.jp.ReplicatedContext;
import gjc.v6.jp.SourceGenerator;
import gjc.v6.jp.Tools;
import gjc.v6.jp.TransRecurse;
import gjc.v6.tree.Tree;
import gjc.v6.util.Hashtable;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Log;
import gjc.v6.util.Name;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransRemote
extends Tree.Visitor<RemoteClassBundle, Context>
implements Flags,
Kinds,
TypeTags {
    final Tools tools;
    final JPSymtab syms;
    final RemoteNames rnames;
    protected ReplicatedContext rc;
    public final KaRMIcGenerator karmic;
    final Log log;
    ListBuffer<MethodInfo> instanceImplMethods;
    private Type _residentType;
    private static final String NL = "\n";
    SourceGenerator.Scope sInstanceStub;
    SourceGenerator.Scope sClassStub;

    private boolean isResident(Type type) {
        if (this._residentType == null) {
            this._residentType = this.syms.reader.loadClass((Name)Name.fromString((String)"jp.lang.Resident")).type;
        }
        return type.subType(this._residentType);
    }

    public TransRemote(Hashtable<String, String> options, Log log, Tools tools) {
        this.log = log;
        this.tools = tools;
        this.rnames = tools.rnames;
        this.syms = tools.syms;
        this.karmic = this.rnames.jp_with_smarthandles ? new KaRMIcGenerator(options, tools, log) : null;
    }

    public void setReplicatedContext(ReplicatedContext replicatedContext) {
        this.rc = replicatedContext;
    }

    private Tree visit(Tree tree, Context context) {
        if (tree != null) {
            return tree.visit(context.transBody, context);
        }
        return null;
    }

    static String arglist(List<Tree.VarDef> params) {
        StringBuffer result = new StringBuffer();
        while (!params.isEmpty()) {
            result.append(((Tree.VarDef)params.head).name.toString());
            params = params.tail;
            if (params.isEmpty()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public static int varAccessModifiers(int flags) {
        return flags & 0x1C00053F | 0x10;
    }

    static List<Type> getArrayAccessType(int dim) {
        List<Type> result = new List<Type>();
        for (int n = 0; n < dim; ++n) {
            result = new List<Type>(Type.intType, result);
        }
        return result;
    }

    void setArrayAccess(SourceGenerator.Scope s, int dim) {
        StringBuffer params = new StringBuffer();
        StringBuffer args = new StringBuffer();
        StringBuffer subscr = new StringBuffer();
        for (int i = 0; i < dim; ++i) {
            if (i > 0) {
                params.append(", ");
                args.append(", ");
            }
            params.append("int _d");
            params.append(i);
            args.append("_d");
            args.append(i);
            subscr.append("[_d");
            subscr.append(i);
            subscr.append("]");
        }
        s.setConst("params", params.toString());
        s.setConst("args", args.toString());
        s.setConst("subscr", subscr.toString());
    }

    SourceGenerator.Scope generateInstanceBody(RemoteClassBundle gen, SourceGenerator.Scope s, Context c, MethodInfo minfo) {
        boolean resident = this.isResident(c.clazz.type);
        boolean bl = (minfo.flagsimpl & 0x20) != 0;
        gen.instanceImpl.append(s, "{");
        gen.instanceImpl.indent(2);
        if (!resident) {
            gen.instanceImpl.append(s, "// method counting for migration control");
            gen.instanceImpl.append(s, "_inc();");
            gen.instanceImpl.append(s, "try {");
            gen.instanceImpl.indent(2);
        }
        if (bl && !this.rnames.with_karmi) {
            gen.instanceImpl.append(s, "// make sure no remotely synchronized block is running");
            gen.instanceImpl.append(s, "_testlock();");
        }
        gen.instanceImpl.append(s, "// application code");
        gen.instanceImpl.append(s, "@body@");
        if (!resident) {
            gen.instanceImpl.unindent(2);
            gen.instanceImpl.append(s, "} finally {");
            gen.instanceImpl.append(s, "  _dec();");
            gen.instanceImpl.append(s, "}");
        }
        gen.instanceImpl.unindent(2);
        gen.instanceImpl.append(s, "}");
        return s;
    }

    public void setParams(SourceGenerator.Scope s, String macro, List<Type> argtypes) {
        StringBuffer b = new StringBuffer();
        int pnum = 0;
        List<Type> list = argtypes;
        while (list.nonEmpty()) {
            if (list != argtypes) {
                b.append(", ");
            }
            b.append(((Type)list.head).toString());
            b.append(" p");
            b.append(pnum++);
            list = list.tail;
        }
        s.set(macro, b.toString());
    }

    public void setArglst(SourceGenerator.Scope s, String macro, List<Type> argtypes) {
        StringBuffer b = new StringBuffer();
        int pnum = 0;
        List<Type> list = argtypes;
        while (list.nonEmpty()) {
            if (list != argtypes) {
                b.append(", ");
            }
            b.append("p");
            b.append(pnum++);
            list = list.tail;
        }
        s.set(macro, b.toString());
    }

    public void setThrown(SourceGenerator.Scope s, String macro, List<Symbol.ClassSymbol> thrown) {
        StringBuffer b = new StringBuffer();
        List<Symbol.ClassSymbol> list = thrown;
        while (list.nonEmpty()) {
            if (list != thrown) {
                b.append(", ");
            }
            b.append(((Symbol.ClassSymbol)list.head).toString());
            list = list.tail;
        }
        s.set(macro, b.toString());
    }

    SourceGenerator.Scope generateInstanceMethod(RemoteClassBundle gen, SourceGenerator.Scope s, Context c, MethodInfo minfo) {
        minfo.set(s);
        boolean bl = !this.isResident(c.clazz.type);
        this.instanceImplMethods.append(new MethodInfo(minfo));
        gen.instanceIntf.append(s, "public @type@ @funimpl@(@params@) @throws (thrownstub@;");
        gen.instanceIntf.newLine();
        if ((minfo.flags & 0x400) != 0) {
            gen.instanceImpl.append(s, "@comment@");
            gen.instanceImpl.append(s, "@flagsimpl) @@type@ @funimpl@(@params@) @throws (thrownimpl@;");
            gen.instanceImpl.newLine();
        } else {
            gen.instanceImpl.append(s, "@comment@");
            gen.instanceImpl.append(s, "@flagsimpl) @@type@ @funimpl@(@params@) @throws (thrownimpl@");
            this.generateInstanceBody(gen, s, c, minfo);
            gen.instanceImpl.newLine();
        }
        gen.handle.append(s, "@comment@");
        gen.handle.append(s, "@flagshandle) @@type@ @fun@(@params@) @throws (thrown@ {");
        gen.handle.indent(2);
        if (bl) {
            gen.handle.append(s, "while (true) {");
            gen.handle.indent(2);
        }
        gen.handle.append(s, "try {");
        gen.handle.indent(2);
        if (this.rnames.jp_with_smarthandles) {
            gen.handle.append(s, "// KaRMI inlined stub code ");
            this.karmic.prepareScopeForMethod(this.sInstanceStub, minfo);
            this.karmic.generateStubBodyForMethod(this.sInstanceStub, gen.handle, minfo);
        } else {
            gen.handle.append(s, "// use generated stub to invoke remote call");
            gen.handle.append(s, "@returnEarly) @((@instanceIntf@) ref).@funimpl@(@args@);");
            gen.handle.append(s, "@returnLate);@");
        }
        gen.handle.unindent(2);
        if (bl) {
            gen.handle.append(s, "} catch (jp.lang.MovedException _e) {");
            gen.handle.append(s, "  _adaptRef(_e);");
        }
        gen.handle.append(s, "} catch (@RemoteException@ _e) {");
        if (!this.rnames.with_karmi) {
            gen.handle.append(s, "  _handleRMIRemoteException(_e);");
        }
        gen.handle.append(s, "  throw new jp.lang.RemoteError(\"@handle@.@fun@(@params@)\", _e);");
        gen.handle.append(s, "}");
        if (bl) {
            gen.handle.unindent(2);
            gen.handle.append(s, "}");
        }
        gen.handle.unindent(2);
        gen.handle.append(s, "}");
        gen.handle.newLine();
        return s;
    }

    SourceGenerator.Scope generateInstanceGetMethod(RemoteClassBundle gen, SourceGenerator.Scope _s, Context c, MethodInfo minfo) {
        SourceGenerator.Scope scope = _s.createInner();
        scope.set("subscr", minfo.createSubscript());
        scope.set("comment", "/** Remote variable access: get @handle@.@var@@subscr@ */");
        scope.set("body", "return this.@var@@subscr@;");
        minfo.setName(Name.fromString(scope.eval("@classID@_@var@@getMethodSuffix@")));
        return this.generateInstanceMethod(gen, scope, c, minfo);
    }

    public static <T> List<T> append(List<T> l, T x) {
        if (l.isEmpty()) {
            return List.make(x);
        }
        return new List(l.head, TransRemote.append(l.tail, x));
    }

    public static <T> List<T> append(List<T> l, T x, T y) {
        if (l.isEmpty()) {
            return List.make(x, y);
        }
        return new List(l.head, TransRemote.append(l.tail, x, y));
    }

    SourceGenerator.Scope generateInstanceSetMethod(RemoteClassBundle gen, SourceGenerator.Scope _s, Context c, MethodInfo minfo) {
        SourceGenerator.Scope scope = _s.createInner();
        scope.set("subscr", minfo.createSubscript());
        scope.set("comment", "/** Remote variable access: set @handle@.@var@@subscr@ */");
        minfo.params = TransRemote.append(minfo.params, new MethodInfo.ParamInfo(minfo.type, Name.fromString("_value_")));
        minfo.setName(Name.fromString(scope.eval("@classID@_@var@@setMethodSuffix@")));
        scope.set("body", "return this.@var@@subscr@ = _value_;");
        return this.generateInstanceMethod(gen, scope, c, minfo);
    }

    SourceGenerator.Scope generateInstanceIncMethod(RemoteClassBundle gen, SourceGenerator.Scope _s, Context c, MethodInfo minfo) {
        SourceGenerator.Scope scope = _s.createInner();
        scope.set("subscr", minfo.createSubscript());
        scope.set("comment", "/** Remote variable access: increment @handle@.@var@@subscr@ */");
        minfo.params = TransRemote.append(minfo.params, new MethodInfo.ParamInfo(minfo.type, Name.fromString("_value_")), new MethodInfo.ParamInfo(Type.booleanType, Name.fromString("_post_")));
        minfo.setName(Name.fromString(scope.eval("@classID@_@var@@incMethodSuffix@")));
        minfo.set(scope);
        scope.set("body", "if (_post_) {\n  @type@ _before_ = this.@var@@subscr@;\n  this.@var@@subscr@ += _value_;\n  return _before_;\n} else {\n  return this.@var@@subscr@ += _value_;\n}");
        return this.generateInstanceMethod(gen, scope, c, minfo);
    }

    SourceGenerator.Scope generateInstanceVariable(RemoteClassBundle gen, SourceGenerator.Scope _s, Tree.VarDef vd, Context c) {
        SourceGenerator.Scope s = _s.createInner();
        int parent = c.setStatic(this.tools.isStatic(vd));
        int replicatedParent = this.rc.setStatic(this.tools.isStatic(vd));
        try {
            s.set("flags", vd.flags);
            s.set("classID", this.tools.fullID(vd.sym.owner));
            s.set("type", vd.sym.type);
            s.set("var", vd.sym);
            s.set("init", this.visit(vd.init, c));
            gen.instanceImpl.append(s, "@flags) @@type@ @var@@ = (init@;");
            gen.instanceImpl.newLine();
            s.set("params", "");
            s.set("args", "");
            s.set("thrown", "");
            s.set("subscr", "");
            Object var9_8 = null;
            c.setState(parent);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            c.setState(parent);
            this.rc.setState(replicatedParent);
            throw throwable;
        }
        this.rc.setState(replicatedParent);
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setFlags(TransRemote.varAccessModifiers(vd.flags));
        methodInfo.type = vd.sym.type;
        methodInfo.params = new List();
        methodInfo.setThrown(this.syms, new List<Symbol.ClassSymbol>(), !this.isResident(c.clazz.type));
        this.generateInstanceGetMethod(gen, s, c, new MethodInfo(methodInfo));
        if (!this.tools.isFinal(vd.sym)) {
            this.generateInstanceSetMethod(gen, s, c, new MethodInfo(methodInfo));
            if (this.tools.needsIncMethod(vd.sym.type)) {
                this.generateInstanceIncMethod(gen, s, c, new MethodInfo(methodInfo));
            }
        }
        int n = 0;
        Type type = vd.sym.type;
        while (type.tag == 11) {
            type = ((Type.ArrayType)type).elemtype;
            methodInfo.type = type;
            methodInfo.initParameters(TransRemote.getArrayAccessType(++n));
            this.generateInstanceGetMethod(gen, s, c, new MethodInfo(methodInfo));
            this.generateInstanceSetMethod(gen, s, c, new MethodInfo(methodInfo));
            if (!this.tools.needsIncMethod(type)) continue;
            this.generateInstanceIncMethod(gen, s, c, new MethodInfo(methodInfo));
        }
        return s;
    }

    SourceGenerator.Scope generateConstant(RemoteClassBundle gen, SourceGenerator.Scope _s, Tree.VarDef vd, Context c) {
        SourceGenerator.Scope scope = _s.createInner();
        scope.set("flags", vd.flags & 0xFFFFFFF9 | 8);
        scope.set("type", vd.sym.type);
        scope.set("var", vd.name);
        scope.set("init", vd.init);
        gen.handle.append(scope, "@flags) @@type@ @var@@ = (init@;");
        gen.handle.newLine();
        return scope;
    }

    SourceGenerator.Scope generateStaticMethodIntf(RemoteClassBundle gen, SourceGenerator.Scope scope) {
        gen.classIntf.append(scope, "public @type@ @fun@(@params@) throws @RemoteException@@, (thrown@;");
        gen.classIntf.newLine();
        return scope;
    }

    SourceGenerator.Scope generateStaticMethodImpl(RemoteClassBundle gen, SourceGenerator.Scope scope) {
        gen.classImpl.append(scope, "@comment@");
        gen.classImpl.append(scope, "@flagsimpl) @@type@ @fun@(@params@) @throws (thrown@ {");
        gen.classImpl.indent(2);
        gen.classImpl.append(scope, "@body@");
        gen.classImpl.unindent(2);
        gen.classImpl.append(scope, "}");
        gen.classImpl.newLine();
        return scope;
    }

    SourceGenerator.Scope generateStaticMethodHandle(RemoteClassBundle gen, SourceGenerator.Scope scope) {
        gen.handle.append(scope, "@comment@");
        gen.handle.append(scope, "@flags) @@type@ @fun@(@params@) @throws (thrown@ {");
        gen.handle.indent(2);
        gen.handle.append(scope, "try {");
        gen.handle.indent(2);
        gen.handle.append(scope, "@returnEarly) @_class.@fun@(@args@);");
        gen.handle.append(scope, "@returnLate);@");
        gen.handle.unindent(2);
        gen.handle.append(scope, "} catch (@RemoteException@ _e) {");
        if (!this.rnames.with_karmi) {
            gen.handle.append(scope, "  _handleRMIRemoteException(_e);");
        }
        gen.handle.append(scope, "  throw new jp.lang.RemoteError(\"@handle@.@fun@(@params@)\", _e);");
        gen.handle.append(scope, "}");
        gen.handle.unindent(2);
        gen.handle.append(scope, "}");
        gen.handle.newLine();
        return scope;
    }

    SourceGenerator.Scope generateStaticMethod(RemoteClassBundle gen, SourceGenerator.Scope scope) {
        this.generateStaticMethodIntf(gen, scope);
        this.generateStaticMethodImpl(gen, scope);
        this.generateStaticMethodHandle(gen, scope);
        return scope;
    }

    SourceGenerator.Scope generateStaticGetMethod(RemoteClassBundle gen, SourceGenerator.Scope _s) {
        SourceGenerator.Scope scope = _s.createInner();
        scope.set("comment", "/** Remote static variable access: get @handle@.@var@@subscr@ */");
        scope.set("fun", "@classID@_@var@@getMethodSuffix@");
        scope.set("body", "return this.@var@@subscr@;");
        MethodInfo.setReturn(scope, false);
        return this.generateStaticMethod(gen, scope);
    }

    SourceGenerator.Scope generateStaticSetMethod(RemoteClassBundle gen, SourceGenerator.Scope _s) {
        SourceGenerator.Scope scope = _s.createInner();
        scope.set("comment", "/** Remote static variable access: set @handle@.@var@@subscr@ */");
        scope.set("params", "@params), @@type@ _value_");
        scope.set("args", "@args), @_value_");
        scope.set("fun", "@classID@_@var@@setMethodSuffix@");
        scope.set("body", "return this.@var@@subscr@ = _value_;");
        MethodInfo.setReturn(scope, false);
        this.generateStaticMethod(gen, scope);
        return scope;
    }

    SourceGenerator.Scope generateStaticIncMethod(RemoteClassBundle gen, SourceGenerator.Scope _s) {
        SourceGenerator.Scope scope = _s.createInner();
        scope.set("comment", "/** Remote static variable access: increment @handle@.@var@@subscr@ */");
        scope.set("params", "@params), @@type@ _value_, boolean _post_");
        scope.set("args", "@args), @_value_, _post_");
        scope.set("fun", "@classID@_@var@@incMethodSuffix@");
        scope.set("body", "if (_post_) {\n  @type@ _before_ = this.@var@@subscr@;\n  this.@var@@subscr@ += _value_;\n  return _before_;\n} else {\n  return this.@var@@subscr@ += _value_;\n}");
        MethodInfo.setReturn(scope, false);
        return this.generateStaticMethod(gen, scope);
    }

    SourceGenerator.Scope generateStaticVariable(RemoteClassBundle gen, SourceGenerator.Scope _s, Tree.VarDef vd, Context c, boolean isReplicable) {
        SourceGenerator.Scope s = _s.createInner();
        int flags = vd.flags;
        Symbol owner = vd.sym.owner;
        Type type = vd.sym.type;
        Name name = vd.name;
        int parentState = c.setStatic(this.tools.isStatic(flags));
        int n = this.rc.setStatic(this.tools.isStatic(flags));
        try {
            s.set("init", this.visit(vd.init, c));
            Object var14_13 = null;
            c.setState(parentState);
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            c.setState(parentState);
            this.rc.setState(n);
            throw throwable;
        }
        this.rc.setState(n);
        this.generateStaticVariable(gen, _s, isReplicable, flags, owner, type, name);
        return s;
    }

    SourceGenerator.Scope generateSimpleStaticReplicatedVariable(RemoteClassBundle gen, SourceGenerator.Scope _s, int flags, Symbol owner, String type, String name, String init) {
        SourceGenerator.Scope s = _s.createInner();
        s.set("init", init);
        s.set("flags", MethodInfo.methodHandleModifiers(TransRemote.varAccessModifiers(flags)));
        s.set("flagsimpl", MethodInfo.methodImplModifiers(TransRemote.varAccessModifiers(flags)));
        s.set("classID", this.tools.fullID(owner));
        s.set("type", type);
        s.set("var", name);
        s.set("flagsvar", flags & 0xFFFFFFEF);
        gen.classImpl.append(s, "/** Replicated static constant '@var@' */");
        gen.classImpl.append(s, "@flagsvar) @@type@ @var@;");
        gen.classImpl.newLine();
        s.set("params", "");
        s.set("args", "");
        s.set("thrown", "");
        s.set("subscr", "");
        SourceGenerator.Scope scope = this.generateStaticGetMethod(gen, s);
        gen.handle.append(scope, "/** Replicated static constant '@var@' */");
        gen.handle.append(scope, "@flags) @@type@ @var@ = @classImpl@.@var@;");
        gen.handle.newLine();
        return s;
    }

    private void generateStaticVariable(RemoteClassBundle gen, SourceGenerator.Scope s, boolean isReplicable, int flags, Symbol owner, Type type, Name name) {
        s.set("flags", MethodInfo.methodHandleModifiers(TransRemote.varAccessModifiers(flags)));
        s.set("flagsimpl", MethodInfo.methodImplModifiers(TransRemote.varAccessModifiers(flags)));
        s.set("classID", this.tools.fullID(owner));
        s.set("type", type);
        s.set("var", name);
        if (isReplicable) {
            s.set("flagsvar", flags & 0xFFFFFFEF);
        } else {
            s.set("flagsvar", flags & 0xFFFFFFF7 & 0xFFFFFFEF);
        }
        gen.classImpl.append(s, "/** Static variable '@var@' */");
        gen.classImpl.append(s, "@flagsvar) @@type@ @var@;");
        gen.classImpl.newLine();
        s.set("params", "");
        s.set("args", "");
        s.set("thrown", "");
        s.set("subscr", "");
        SourceGenerator.Scope local = this.generateStaticGetMethod(gen, s);
        if (isReplicable) {
            gen.handle.append(local, "/** Static variable '@var@' */");
            gen.handle.append(local, "@flags) @@type@ @var@ = @classImpl@.@var@;");
            gen.handle.newLine();
        } else if (!this.tools.isFinal(flags)) {
            this.generateStaticSetMethod(gen, s);
            if (this.tools.needsIncMethod(type)) {
                this.generateStaticIncMethod(gen, s);
            }
        }
        int n = 0;
        while (type.tag == 11) {
            type = ((Type.ArrayType)type).elemtype;
            s.set("type", type);
            this.setArrayAccess(s, ++n);
            this.generateStaticGetMethod(gen, s);
            if (isReplicable) continue;
            this.generateStaticSetMethod(gen, s);
            if (!this.tools.needsIncMethod(type)) continue;
            this.generateStaticIncMethod(gen, s);
        }
    }

    SourceGenerator.Scope generateAdditionals(RemoteClassBundle gen, SourceGenerator.Scope s, Tree.ClassDef classDef) {
        gen.handle.append(s, "/** Forwarding constructor. Handle constructors are 'final'. That");
        gen.handle.append(s, "    means they need only the functionality of the remote base classes");
        gen.handle.append(s, "    constructor. To prevent the execution of application defined super");
        gen.handle.append(s, "    constructors, this forwarding constructor is generated in each");
        gen.handle.append(s, "    handle class and called from all constructors of subclasses. */");
        gen.handle.append(s, "protected @handle@(jp.lang.Marker dummy) {");
        gen.handle.append(s, "  super(dummy);");
        gen.handle.append(s, "}");
        gen.handle.newLine();
        gen.classImpl.append(s, "/** Constructor for class implementation part of class @handle@. */");
        gen.classImpl.append(s, "public @classImpl@(boolean isConstructor) throws @RemoteException@ {");
        gen.classImpl.append(s, "  super(isConstructor);");
        gen.classImpl.append(s, "}");
        gen.classImpl.newLine();
        gen.classImpl.append(s, "/** Dummy method to achieve type conversion inside an expression ");
        gen.classImpl.append(s, "    between the handle class '@handle@' and the the class implementation ");
        gen.classImpl.append(s, "    '@classImpl@'. The argument is not needed. ");
        gen.classImpl.append(s, "    This is only used by the transformation internally.");
        gen.classImpl.append(s, "*/");
        gen.classImpl.append(s, "private static final @classImpl@ @_ClassType_Method@(@handle@ x) {");
        gen.classImpl.append(s, "  return null;");
        gen.classImpl.append(s, "}");
        gen.classImpl.newLine();
        return s;
    }

    SourceGenerator.Scope generateStaticMethod(RemoteClassBundle gen, SourceGenerator.Scope _s, Tree.MethodDef md, Context c) {
        SourceGenerator.Scope scope;
        SourceGenerator.Scope s = _s.createInner();
        int parent = c.setStatic(this.tools.isStatic(md));
        int n = this.rc.setStatic(this.tools.isStatic(md));
        try {
            s.set("comment", "/** Application method of class @handle@ */");
            s.set("flagsimpl", MethodInfo.methodImplModifiers(md.flags));
            s.set("flags", MethodInfo.methodHandleModifiers(md.flags));
            s.set("type", md.restype);
            s.set("fun", md.name);
            s.setExprs("params", md.params);
            s.setExprs("thrown", md.thrown);
            s.set("body", this.visit(md.body, c));
            s.setConst("args", TransRemote.arglist(md.params));
            MethodInfo.setReturn(s, this.tools.isVoid(md));
            scope = this.generateStaticMethod(gen, s);
            Object var10_9 = null;
            c.setState(parent);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            c.setState(parent);
            this.rc.setState(n);
            throw throwable;
        }
        this.rc.setState(n);
        return scope;
    }

    SourceGenerator.Scope generateInstanceConstructor(RemoteClassBundle gen, SourceGenerator.Scope _s, final Context c, Tree.MethodDef md) {
        SourceGenerator.Scope scope;
        SourceGenerator.Scope s = _s.createInner();
        int parent = c.setStatic(this.tools.isStatic(md));
        int replicatedParent = this.rc.setStatic(this.tools.isStatic(md));
        try {
            boolean bl;
            s.setExprs("params", md.params);
            s.setExprs("thrown", md.thrown);
            s.setConst("args", TransRemote.arglist(md.params));
            Flag flag = new Flag();
            if (md.body != null) {
                Type classType = c.clazz.type;
                md.body.visit(new TransRecurse<Flag>(){

                    @Override
                    public Tree _case(Tree.Try that, Flag arg) {
                        boolean moveCatched = false;
                        List<Tree.Catch> list = that.catchers;
                        while (list.nonEmpty()) {
                            if (TransRemote.this.syms.exceptionType.subType(((Tree.Catch)list.head).param.vartype.type)) {
                                moveCatched = true;
                                break;
                            }
                            list = list.tail;
                        }
                        if (moveCatched) {
                            that.catchers = ((TransRecurse)this).doVisit(that.catchers, arg);
                            that.finalizer = ((TransRecurse)this).visit(that.finalizer, arg);
                            return that;
                        }
                        return super._case(that, (Object)arg);
                    }

                    @Override
                    public Tree _case(Tree.Apply that, Flag arg) {
                        MethodAccess methodAccess = new MethodAccess(TransRemote.this.tools, c, that.meth, TransRemote.this.log);
                        if (methodAccess.isSelfRef && !TransRemote.this.tools.isStatic(methodAccess.fun) && !methodAccess.fun.isConstructor()) {
                            arg.flag = true;
                        }
                        return super._case(that, (Object)arg);
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Erroneous x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.TypeParameter x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.TypeApply x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.TypeArray x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.TypeIdent x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Literal x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Ident x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Select x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Indexed x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.TypeTest x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.TypeCast x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Operation x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Assignop x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Assign x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.NewArray x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.NewClass x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Apply x0, Object object) {
                        return this._case(x0, (Flag)object);
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Throw x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Return x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Continue x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Break x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Exec x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Assert x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Conditional x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Catch x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Try x0, Object object) {
                        return this._case(x0, (Flag)object);
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Synchronized x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Case x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Switch x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Labelled x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.ForLoop x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.WhileLoop x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.DoLoop x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Block x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.VarDef x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.MethodDef x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.ClassDef x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.Import x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Tree _case(Tree.TopLevel x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ List doVisit(List x0, Object object) {
                        return super.doVisit(x0, (Flag)object);
                    }

                    @Override
                    public /* synthetic */ Tree visit(Tree x0, Object object) {
                        return super.visit(x0, (Flag)object);
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree x0, Object object) {
                        return super._case(x0, (Flag)object);
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Erroneous x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.TypeApply x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.TypeArray x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Literal x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Ident x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Select x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Indexed x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.TypeTest x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.TypeCast x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Operation x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Assignop x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Assign x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.NewArray x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.NewClass x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Apply x0, Object object) {
                        return this._case(x0, (Flag)object);
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Throw x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Return x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Continue x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Break x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Exec x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Assert x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Conditional x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Catch x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Try x0, Object object) {
                        return this._case(x0, (Flag)object);
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Synchronized x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Case x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Switch x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Labelled x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.ForLoop x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.DoLoop x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Block x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.VarDef x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.MethodDef x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.ClassDef x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.Import x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }

                    @Override
                    public /* synthetic */ Object _case(Tree.TopLevel x0, Object object) {
                        return super._case(x0, (Object)((Flag)object));
                    }
                }, flag);
            }
            Tree.Block body = (Tree.Block)this.visit(md.body, c);
            s.set("firststat", (Tree)body.stats.head);
            s.setStats("nextstats", body.stats.tail);
            s.set("flags", MethodInfo.methodHandleModifiers(md.flags));
            gen.instanceImpl.append(s, "public @instanceImpl@(@params@) throws @RemoteException@@, (thrown@ {");
            gen.instanceImpl.indent(2);
            gen.instanceImpl.append(s, "@firststat@;");
            boolean bl2 = bl = flag.flag && !this.isResident(c.clazz.type);
            if (bl) {
                gen.instanceImpl.append(s, "try {");
                gen.instanceImpl.indent(2);
            }
            gen.instanceImpl.append(s, "@nextstats@;");
            if (bl) {
                gen.instanceImpl.unindent(2);
                gen.instanceImpl.append(s, "} catch (jp.lang.MovedException _e) {");
                gen.instanceImpl.append(s, "  // can never occurr, but the constructor code might call");
                gen.instanceImpl.append(s, "  // other instance methods of the same class that (have to)");
                gen.instanceImpl.append(s, "  // declare MovedException to be thrown.");
                gen.instanceImpl.append(s, "  throw new @RemoteException@(");
                gen.instanceImpl.append(s, "     \"assertion failed: migration during object construction\", _e);");
                gen.instanceImpl.append(s, "}");
            }
            gen.instanceImpl.unindent(2);
            gen.instanceImpl.append(s, "}");
            gen.instanceImpl.newLine();
            if (!this.tools.isAbstract(c.clazz)) {
                gen.classIntf.append(s, "public @refType@ _new(@params@) throws @RemoteException@@, (thrown@;");
                gen.classIntf.newLine();
                gen.classImpl.append(s, "/** Factory method to calls the constructor @instanceImpl@(@args@) ");
                gen.classImpl.append(s, "    on a remote node and passes the result back to the caller. This");
                gen.classImpl.append(s, "    method is used during remote object instantiations on remote nodes.");
                gen.classImpl.append(s, "*/");
                gen.classImpl.append(s, "public @refType@ _new(@params@) throws @RemoteException@@, (thrown@ {");
                gen.classImpl.indent(2);
                gen.classImpl.append(s, "// remote object creation may throw a RemoteException");
                gen.classImpl.append(s, "// during object export");
                gen.classImpl.append(s, "@instanceImpl@ _impl = new @instanceImpl@(@args@);");
                gen.classImpl.newLine();
                gen.classImpl.append(s, "return (@refType@) _impl._getRef();");
                gen.classImpl.unindent(2);
                gen.classImpl.append(s, "}");
                gen.classImpl.newLine();
                this.generateHandleConstructor(gen.handle, s, false);
                this.generateHandleConstructor(gen.handle, s, true);
            }
            scope = s;
            Object var13_12 = null;
            c.setState(parent);
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            c.setState(parent);
            this.rc.setState(replicatedParent);
            throw throwable;
        }
        this.rc.setState(replicatedParent);
        return scope;
    }

    private void generateHandleConstructor(SourceGenerator handle, SourceGenerator.Scope s, boolean bl) {
        handle.append(s, "/** Handle constructor of class '@handle@'. This constructor");
        handle.append(s, "    initiates Remote object instantiation. It uses the");
        handle.append(s, "    RuntimeEnvironment to decide about the remote node, on");
        handle.append(s, "    which the object will be allocated. */");
        if (bl) {
            handle.append(s, "@flags) @@handle@(jp.lang.Node _node@, (params@) @throws (thrown@ {");
        } else {
            handle.append(s, "@flags) @@handle@(@params@) @throws (thrown@ {");
        }
        handle.append(s, "  super((jp.lang.Marker) null);");
        handle.append(s, "  try {");
        handle.indent(4);
        handle.append(s, "// look up the remote constructor object");
        handle.append(s, "@classIntf@ constr = (@classIntf@)");
        if (bl) {
            handle.append(s, "  jp.lang.RuntimeEnvironment.getConstrObj(\"@package).@@handle@\", _node.getMachineID());");
        } else {
            handle.append(s, "  jp.lang.RuntimeEnvironment.getConstrObj(\"@package).@@handle@\");");
        }
        handle.newLine();
        handle.append(s, "// create the remote implementation");
        handle.append(s, "@refType@ _ref = constr._new(@args@);");
        handle.newLine();
        if (this.rnames.jp_with_smarthandles) {
            handle.append(s, "// assign the remote reference");
            handle.append(s, "_KARMI_setRemoteClientRef((@RemoteRef@) _ref);");
        } else {
            handle.append(s, "// assign the remote stub");
            handle.append(s, "this.ref = (@instanceIntf@) _ref;");
        }
        handle.unindent(4);
        handle.append(s, "  } catch (@RemoteException@ _e) {");
        handle.indent(4);
        if (!this.rnames.with_karmi) {
            handle.append(s, "_handleRMIRemoteException(_e);");
        }
        handle.append(s, "throw new jp.lang.RemoteError(\"@handle@(@params@)\", _e);");
        handle.unindent(4);
        handle.append(s, "  }");
        handle.append(s, "}");
        handle.newLine();
    }

    SourceGenerator.Scope generateFinalizerMethod(RemoteClassBundle gen, SourceGenerator.Scope s, MethodInfo methodInfo) {
        methodInfo.set(s);
        gen.instanceImpl.append(s, "@flagsimpl) @@type@ @fun@(@params@) @throws (thrown@ {");
        gen.instanceImpl.indent(2);
        gen.instanceImpl.append(s, "@body@");
        gen.instanceImpl.unindent(2);
        gen.instanceImpl.append(s, "}");
        gen.instanceImpl.newLine();
        return s;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    SourceGenerator.Scope generateInstanceMethod(RemoteClassBundle gen, SourceGenerator.Scope _s, Context c, Tree.MethodDef md) {
        SourceGenerator.Scope scope;
        int replicatedParent;
        int parent;
        block7: {
            SourceGenerator.Scope scope2;
            block6: {
                SourceGenerator.Scope scope3;
                block5: {
                    SourceGenerator.Scope s = _s.createInner();
                    parent = c.setStatic(this.tools.isStatic(md));
                    replicatedParent = this.rc.setStatic(this.tools.isStatic(md));
                    try {
                        s.set("comment", "/** Application method of class @handle@ */");
                        s.set("flags", MethodInfo.methodHandleModifiers(md.flags));
                        s.set("flagsimpl", MethodInfo.methodImplModifiers(md.flags));
                        MethodInfo methodInfo = new MethodInfo(this.syms, md, !this.isResident(c.clazz.type));
                        if (this.tools.isNative(md)) {
                            throw new InternalError(String.valueOf(String.valueOf("native remote methods not supported (").concat(String.valueOf(md))).concat(String.valueOf(")")));
                        }
                        s.set("body", this.visit(md.body, c));
                        if (this.tools.overridesMethodInClass(md.sym, this.syms.objectType.tsym)) {
                            if (this.tools.isFinalizer(md)) {
                                scope3 = this.generateFinalizerMethod(gen, s, methodInfo);
                                Object var11_12 = null;
                                c.setState(parent);
                                break block5;
                            }
                            methodInfo.funimpl = Name.fromString(String.valueOf("_").concat(String.valueOf(methodInfo.funimpl)));
                            scope2 = this.generateInstanceMethod(gen, s, c, methodInfo);
                            break block6;
                        }
                        scope = this.generateInstanceMethod(gen, s, c, methodInfo);
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        c.setState(parent);
                        this.rc.setState(replicatedParent);
                        throw throwable;
                    }
                }
                this.rc.setState(replicatedParent);
                return scope3;
            }
            Object var11_13 = null;
            c.setState(parent);
            this.rc.setState(replicatedParent);
            return scope2;
        }
        Object var11_14 = null;
        c.setState(parent);
        this.rc.setState(replicatedParent);
        return scope;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RemoteClassBundle _case(Tree.ClassDef cd, Context c) {
        Name prevSrc = this.log.useSource(c.toplevel.sourcefile);
        try {
            SourceGenerator.Scope s = new SourceGenerator.Scope();
            this.instanceImplMethods = new ListBuffer();
            s.set("Remote", this.rnames.nameRemote.toString());
            s.set("RemoteException", this.rnames.nameRemoteException.toString());
            if (this.rnames.jp_with_smarthandles) {
                s.set("RemoteRef", this.rnames.nameRemoteRef.toString());
            }
            s.set("rootHandle", this.rnames.rootHandle);
            s.set("rootInstanceIntf", this.rnames.rootInstanceIntf);
            s.set("rootInstanceImpl", this.rnames.rootInstanceImpl);
            s.set("rootClassIntf", this.rnames.rootClassIntf);
            s.set("rootClassImpl", this.rnames.rootClassImpl);
            s.set("instanceIntfSuffix", this.rnames.instanceIntfSuffix);
            s.set("instanceImplSuffix", this.rnames.instanceImplSuffix);
            s.set("classIntfSuffix", this.rnames.classIntfSuffix);
            s.set("classImplSuffix", this.rnames.classImplSuffix);
            s.set("getMethodSuffix", this.rnames.getMethodSuffix);
            s.set("setMethodSuffix", this.rnames.setMethodSuffix);
            s.set("incMethodSuffix", this.rnames.incMethodSuffix);
            s.set("_ClassType_Method", this.rnames._ClassType_Method);
            int parentState = c.getState();
            int replicatedParentState = this.rc.getState();
            Symbol.ClassSymbol parent = c.setClass(cd.sym);
            Symbol.ClassSymbol replicatedParent = this.rc.setClass(cd.sym);
            try {
                SourceGenerator.Scope local;
                s.set("package", cd.sym.owner.fullName());
                String className = cd.name.toString();
                s.set("handle", className);
                s.set("instanceIntf", "@handle@@instanceIntfSuffix@");
                s.set("instanceImpl", "@handle@@instanceImplSuffix@");
                s.set("classIntf", "@handle@@classIntfSuffix@");
                s.set("classImpl", "@handle@@classImplSuffix@");
                s.set("refType", "java.lang.Object");
                System.err.println(s.eval("generating JavaParty code for class '@handle@'"));
                Type supertype = cd.sym.type.supertype();
                if (supertype == this.syms.remoteType) {
                    s.set("superHandle", "@rootHandle@");
                    s.set("superInstanceIntf", "@rootInstanceIntf@");
                    s.set("superInstanceImpl", "@rootInstanceImpl@");
                } else {
                    String superName = supertype.tsym.fullName().toString();
                    s.set("superHandle", superName);
                    s.set("superInstanceIntf", "@superHandle@@instanceIntfSuffix@");
                    s.set("superInstanceImpl", "@superHandle@@instanceImplSuffix@");
                }
                s.setExprs("implements", cd.implementing);
                RemoteClassBundle gen = new RemoteClassBundle();
                List<Tree> importdefs = this.tools.prependImports(c.toplevel, new List<Tree>());
                s.setStats("importdefs", importdefs);
                if (this.rnames.jp_with_transport) {
                    s.set("handleflags", cd.flags & 0xFFFFF7FF & 0xFFFFFFF8 | 1);
                } else {
                    s.set("handleflags", cd.flags & 0xFFFFF7FF);
                }
                s.set("implflags", 1 | cd.flags & 0x400);
                if (this.rnames.jp_with_smarthandles) {
                    this.sInstanceStub = new SourceGenerator.Scope();
                    this.sClassStub = new SourceGenerator.Scope();
                    this.karmic.prepareScopeForClass(this.sInstanceStub, s.eval("@package@"), s.eval("@instanceImpl@"), s.eval("@superInstanceImpl@"), s.eval("@package).@@instanceImpl@"), s.eval("@instanceImpl@"), s.eval("@instanceIntf@"), false);
                    this.karmic.prepareScopeForClass(this.sClassStub, s.eval("@package@"), s.eval("@classImpl@"), s.eval("@rootClassImpl@"), s.eval("@package).@@classImpl@"), s.eval("@classImpl@"), s.eval("@classIntf@"), false);
                }
                gen.handle.append(s, "@package (package);\n@");
                gen.handle.append(s, "@importdefs)\n@");
                gen.handle.append(s, "@handleflags) @class @handle@ extends @superHandle@");
                gen.handle.append(s, "@  implements (implements@");
                gen.handle.append(s, "{");
                gen.handle.newLine();
                gen.handle.indent(2);
                if (this.rnames.jp_with_transport) {
                    SourceGenerator.Scope __s = s.createInner();
                    __s.set("Class", "@handle@");
                    __s.set("Super", "@superHandle@");
                    __s.set("Serializable", "uka.transport.Transportable");
                    __s.set("MarshalStream", "uka.transport.MarshalStream");
                    __s.set("UnmarshalStream", "uka.transport.UnmarshalStream");
                    __s.set("BasicIO", "uka.transport.BasicIO");
                    this.tools.transportableGenerator.generateFull(gen.handle, __s, false, this.tools.isAbstract(c.clazz), false, false, true, false, new List<Symbol.VarSymbol>());
                }
                gen.instanceIntf.append(s, "@package (package);\n@");
                gen.instanceIntf.append(s, "@importdefs)\n@");
                gen.instanceIntf.append(s, "public interface @instanceIntf@ extends @superInstanceIntf@ {");
                gen.instanceIntf.newLine();
                gen.instanceIntf.indent(2);
                gen.instanceImpl.append(s, "@package (package);\n@");
                gen.instanceImpl.append(s, "@importdefs)\n@");
                gen.instanceImpl.append(s, "@implflags@ class @instanceImpl@ extends @superInstanceImpl@");
                gen.instanceImpl.append(s, "  implements @instanceIntf@");
                gen.instanceImpl.append(s, "{");
                gen.instanceImpl.newLine();
                gen.instanceImpl.indent(2);
                gen.classIntf.append(s, "@package (package);\n@");
                gen.classIntf.append(s, "@importdefs)\n@");
                gen.classIntf.append(s, "import jp.lang.*;\n");
                gen.classIntf.append(s, "public interface @classIntf@ extends @rootClassIntf@ {");
                gen.classIntf.newLine();
                gen.classIntf.indent(2);
                gen.classImpl.append(s, "@package (package);\n@");
                gen.classImpl.append(s, "@importdefs)\n@");
                gen.classImpl.append(s, "import jp.lang.*;\n");
                gen.classImpl.append(s, "public final class @classImpl@ extends @rootClassImpl@");
                gen.classImpl.append(s, "  implements @classIntf@");
                gen.classImpl.append(s, "{");
                gen.classImpl.newLine();
                gen.classImpl.indent(2);
                this.generateAdditionals(gen, s, cd);
                s.set("clinitbody", "");
                s.set("cleanupbody", "");
                s.set("replinit", "");
                if (!this.rnames.jp_bootstrap && (local = this.generateSimpleStaticReplicatedVariable(gen, s, 25, cd.sym, "@classIntf@", "_class", "")).get("init").length() > 0) {
                    s.set("replinit", local.eval("@replinit)\n@@classImpl@.@var@ = _class.@classID@_@var@_get_();"));
                    s.set("clinitbody", local.eval("@clinitbody)\n@@classImpl@.@var@ = @init@;"));
                }
                List<Tree> defs = cd.defs;
                while (!defs.isEmpty()) {
                    Tree def = (Tree)defs.head;
                    switch (def.tag) {
                        case 5: {
                            SourceGenerator.Scope local2;
                            Tree.VarDef vd = (Tree.VarDef)def;
                            if (this.tools.isConstant(vd.sym)) {
                                this.generateConstant(gen, s, vd, c);
                                break;
                            }
                            if (this.tools.isStatic(vd)) {
                                if (this.tools.isReplicable(vd.sym)) {
                                    local2 = this.generateStaticVariable(gen, s, vd, c, true);
                                    s.set("replinit", local2.eval("@replinit)\n@@classImpl@.@var@ = _class.@classID@_@var@_get_();"));
                                    if (!this.tools.hasInitializer(vd)) break;
                                    s.set("clinitbody", local2.eval("@clinitbody)\n@@classImpl@.@var@ = @init@;"));
                                    break;
                                }
                                local2 = this.generateStaticVariable(gen, s, vd, c, false);
                                if (!this.tools.hasInitializer(vd)) break;
                                s.set("clinitbody", local2.eval("@clinitbody)\n@this.@var@ = @init@;"));
                                break;
                            }
                            local2 = this.generateInstanceVariable(gen, s, vd, c);
                            if (!vd.sym.type.subType(this.syms.objectType) || this.tools.isFinal(vd.sym)) break;
                            s.set("cleanupbody", local2.eval("@cleanupbody)\n@this.@var@ = null;"));
                            break;
                        }
                        case 4: {
                            Tree.MethodDef md = (Tree.MethodDef)def;
                            if (this.tools.isStatic(md)) {
                                this.generateStaticMethod(gen, s, md, c);
                                break;
                            }
                            if (this.tools.isConstructor(md)) {
                                this.generateInstanceConstructor(gen, s, c, md);
                                break;
                            }
                            this.generateInstanceMethod(gen, s, c, md);
                            break;
                        }
                        case 6: {
                            Object var23_21;
                            SourceGenerator.Scope local2;
                            Tree.Block bd = (Tree.Block)def;
                            if (this.tools.isStatic(bd)) {
                                Object var21_20;
                                local2 = s.createInner();
                                int last = c.setStatic(true);
                                int replicatedLast = this.rc.setStatic(true);
                                try {
                                    Tree.Block transformedBlock = (Tree.Block)this.visit(bd, c);
                                    local2.set("block", c.f.Block(0, transformedBlock.stats));
                                    s.set("clinitbody", local2.eval("@clinitbody)\n@@block@"));
                                    var21_20 = null;
                                    c.setState(last);
                                }
                                catch (Throwable throwable) {
                                    var21_20 = null;
                                    c.setState(last);
                                    this.rc.setState(replicatedLast);
                                    throw throwable;
                                }
                                this.rc.setState(replicatedLast);
                                break;
                            }
                            local2 = s.createInner();
                            int n = c.setStatic(false);
                            int n2 = this.rc.setStatic(false);
                            try {
                                Tree.Block block = (Tree.Block)this.visit(bd, c);
                                local2.set("block", block);
                                gen.instanceImpl.append(local2, "/** application defined non-static block */");
                                gen.instanceImpl.append(local2, "@block@");
                                gen.instanceImpl.newLine();
                                var23_21 = null;
                                c.setState(n);
                            }
                            catch (Throwable throwable) {
                                var23_21 = null;
                                c.setState(n);
                                this.rc.setState(n2);
                                throw throwable;
                            }
                            this.rc.setState(n2);
                            break;
                        }
                        case 3: {
                            throw new InternalError("inner classes not supported");
                        }
                        default: {
                            throw new InternalError(String.valueOf(String.valueOf("unknown definition (").concat(String.valueOf(def))).concat(String.valueOf(")")));
                        }
                    }
                    defs = defs.tail;
                }
                if (!this.tools.isAbstract(cd)) {
                    gen.instanceImpl.append(s, "/** @@see RemoteObject.__init() */");
                    gen.instanceImpl.append(s, "protected void __init() {");
                    gen.instanceImpl.append(s, "  _this = new @handle@((jp.lang.Marker) null);");
                    gen.instanceImpl.append(s, "  _this._init(_getRef());");
                    gen.instanceImpl.append(s, "}");
                    gen.instanceImpl.newLine();
                }
                if (s.get("cleanupbody").length() > 0) {
                    gen.instanceImpl.append(s, "/** Called to free heap space after object migration.");
                    gen.instanceImpl.append(s, "    @@see RemoteObject._cleanup() */");
                    gen.instanceImpl.append(s, "protected void _cleanup() {");
                    gen.instanceImpl.indent(2);
                    gen.instanceImpl.append(s, "super._cleanup();");
                    gen.instanceImpl.append(s, "@cleanupbody@");
                    gen.instanceImpl.unindent(2);
                    gen.instanceImpl.append(s, "}");
                    gen.instanceImpl.newLine();
                }
                if (this.isResident(cd.sym.type) && !this.isResident(cd.sym.type.supertype())) {
                    gen.instanceImpl.append(s, "/** @handle@ is declared to be resident, the method");
                    gen.instanceImpl.append(s, "    counter has no longer to be allocated. */");
                    gen.instanceImpl.append(s, "protected final void _init() {");
                    gen.instanceImpl.append(s, "  __init();");
                    gen.instanceImpl.append(s, "}");
                    gen.instanceImpl.newLine();
                    gen.instanceImpl.append(s, "/** @handle@ is declared to be resident,");
                    gen.instanceImpl.append(s, "    there is no method counter, do nothing if _inc()");
                    gen.instanceImpl.append(s, "    is called from inherited methods */");
                    gen.instanceImpl.append(s, "protected final void _inc() {}");
                    gen.instanceImpl.newLine();
                    gen.instanceImpl.append(s, "/** @handle@ is declared to be resident,");
                    gen.instanceImpl.append(s, "    there is no method counter, do nothing if _dec()");
                    gen.instanceImpl.append(s, "    is called from inherited methods */");
                    gen.instanceImpl.append(s, "protected final void _dec() {}");
                    gen.instanceImpl.newLine();
                }
                gen.classImpl.append(s, "/** Code of all static initializers of the class */");
                gen.classImpl.append(s, "protected void _init() {");
                gen.classImpl.indent(2);
                gen.classImpl.append(s, "@clinitbody@");
                gen.classImpl.unindent(2);
                gen.classImpl.append(s, "}");
                gen.classImpl.newLine();
                if (!this.rnames.jp_bootstrap) {
                    gen.classImpl.append(s, "static {");
                    gen.classImpl.indent(2);
                    gen.classImpl.append(s, "int _location = RuntimeEnvironment.getMachineID();");
                    gen.classImpl.append(s, "try {");
                    gen.classImpl.indent(2);
                    gen.classImpl.append(s, "// Lookup class object for initialization");
                    gen.classImpl.append(s, "// of replicated constants (if already present).");
                    gen.classImpl.append(s, "_class = (@classIntf@) RuntimeEnvironment.rm.getClassInitializer(\"@package).@@handle@\", _location);");
                    gen.classImpl.append(s, "if (_class == null) {");
                    gen.classImpl.indent(2);
                    gen.classImpl.append(s, "// Class is not yet loaded, load and initialize locally.");
                    gen.classImpl.append(s, "@classImpl@ _classImpl = new @classImpl@(false);");
                    gen.classImpl.append(s, "_class = (@classIntf@) _classImpl._getStub();");
                    gen.classImpl.append(s, "RuntimeEnvironment.rm.setClassObject(\"@package).@@handle@\",_class);");
                    gen.classImpl.unindent(2);
                    gen.classImpl.append(s, "} else {");
                    gen.classImpl.indent(2);
                    gen.classImpl.append(s, "// Class was loaded elsewhere, copy replicated constants (if any).");
                    gen.classImpl.append(s, "@replinit@");
                    gen.classImpl.unindent(2);
                    gen.classImpl.append(s, "}");
                    gen.classImpl.unindent(2);
                    gen.classImpl.append(s, "} catch (@RemoteException@ _e) {");
                    gen.classImpl.indent(2);
                    gen.classImpl.append(s, "throw new jp.lang.RemoteError(\"@classImpl@.<clinit>()\", _e);");
                    gen.classImpl.unindent(2);
                    gen.classImpl.append(s, "} catch (Exception _e) {");
                    gen.classImpl.indent(2);
                    gen.classImpl.append(s, "// ClassNotFoundException, IllegalAccessException, RuntimeException");
                    gen.classImpl.append(s, "_e.printStackTrace();");
                    gen.classImpl.append(s, "throw new InternalError(\"@classImpl@.<clinit>(): \" + _e);");
                    gen.classImpl.unindent(2);
                    gen.classImpl.append(s, "}");
                    gen.classImpl.unindent(2);
                    gen.classImpl.append(s, "}");
                }
                gen.handle.unindent(2);
                gen.instanceIntf.unindent(2);
                gen.instanceImpl.unindent(2);
                gen.classIntf.unindent(2);
                gen.classImpl.unindent(2);
                gen.handle.append(s, "}");
                gen.instanceIntf.append(s, "}");
                gen.instanceImpl.append(s, "}");
                gen.classIntf.append(s, "}");
                gen.classImpl.append(s, "}");
                if (this.rnames.jp_with_smarthandles) {
                    gen.instanceStub = this.karmic.generateStub(this.sInstanceStub, this.instanceImplMethods.toList(), this.tools.isAbstract(cd.sym));
                }
                RemoteClassBundle remoteClassBundle = gen;
                Object var25_24 = null;
                c.setClass(parent);
                this.rc.setClass(replicatedParent);
                c.setState(parentState);
                this.rc.setState(replicatedParentState);
                Object var27_26 = null;
                this.log.useSource(prevSrc);
                return remoteClassBundle;
            }
            catch (Throwable throwable) {
                Object var25_25 = null;
                c.setClass(parent);
                this.rc.setClass(replicatedParent);
                c.setState(parentState);
                this.rc.setState(replicatedParentState);
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var27_27 = null;
            this.log.useSource(prevSrc);
            throw throwable;
        }
    }

    @Override
    public /* synthetic */ Object _case(Tree x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Erroneous x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeApply x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeArray x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Literal x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Ident x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Select x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Indexed x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeTest x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeCast x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Operation x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assignop x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assign x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewArray x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewClass x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Apply x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Throw x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Return x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Continue x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Break x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Exec x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assert x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Conditional x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Catch x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Try x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Synchronized x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Case x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Switch x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Labelled x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ForLoop x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.DoLoop x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Block x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.VarDef x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.MethodDef x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ClassDef x0, Object object) {
        return this._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Import x0, Object object) {
        return super._case(x0, (Context)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TopLevel x0, Object object) {
        return super._case(x0, (Context)object);
    }

    public static class Flag {
        public boolean flag;
    }
}

