/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.jp;

import gjc.v6.code.Scope;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.jp.JPSymtab;
import gjc.v6.jp.RemoteNames;
import gjc.v6.jp.SourceGenerator;
import gjc.v6.jp.Tools;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Name;
import gjc.v6.util.Names;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransportableGenerator {
    public final RemoteNames rnames;
    public final Tools tools;
    public final JPSymtab syms;
    public static final Name serialPersistentFieldsName = Name.fromString("serialPersistentFields");
    public static final Name serialVersionUIDName = Name.fromString("serialVersionUID");
    public static final String EMPTY = "";

    public TransportableGenerator(Tools tools) {
        this.tools = tools;
        this.rnames = tools.rnames;
        this.syms = tools.syms;
    }

    public SourceGenerator.Scope getScopeFor(Symbol.ClassSymbol clazz) {
        SourceGenerator.Scope scope = new SourceGenerator.Scope();
        scope.set("Class", clazz.name);
        scope.set("Super", clazz.type.supertype().tsym.fullName());
        return scope;
    }

    public SourceGenerator.Scope generate(SourceGenerator src, Symbol.ClassSymbol clazz) {
        Symbol.ClassSymbol superclazz = (Symbol.ClassSymbol)clazz.type.supertype().tsym;
        boolean bl = !this.tools.isSerializable(superclazz);
        return this.generate(src, clazz, bl);
    }

    public SourceGenerator.Scope generate(SourceGenerator src, Symbol.ClassSymbol clazz, boolean root) {
        boolean abstr = this.tools.isAbstract(clazz);
        boolean needinit = true;
        Scope.Entry e = clazz.members().lookup(Names.init);
        while (e.scope != null) {
            if (e.sym.kind == 32) {
                Symbol.MethodSymbol m = (Symbol.MethodSymbol)e.sym;
                Type.MethodType t = (Type.MethodType)m.type;
                if (!t.argtypes.equals(Type.emptyList)) {
                    needinit = false;
                    break;
                }
            }
            e = e.next();
        }
        boolean hasRestoreMethod = this.tools.hasRestoreMethod(clazz);
        boolean superNeedsRestore = this.tools.needsRestore(this.tools.getSuperClass(clazz));
        ListBuffer<Symbol.VarSymbol> vars = new ListBuffer<Symbol.VarSymbol>();
        Scope classScope = clazz.members();
        Scope.Entry e2 = classScope.elems;
        while (e2 != null && e2.scope == classScope) {
            if (this.tools.isVariable(e2.sym) && !this.tools.isStatic(e2.sym) && !this.tools.isConstant(e2.sym) && !this.tools.isTransient(e2.sym)) {
                vars.append((Symbol.VarSymbol)e2.sym);
            }
            e2 = e2.sibling;
        }
        if (this.tools.requiresPatchableInjection(clazz)) {
            this.generatePatchable(src, this.getScopeFor(clazz), root, vars.toList());
        }
        boolean bl = this.tools.requiresDeepCloneableSupport(clazz);
        if (this.tools.isExternalizable(clazz)) {
            return this.generateAdapter(src, this.getScopeFor(clazz), root, abstr, needinit, hasRestoreMethod);
        }
        return this.generateFull(src, this.getScopeFor(clazz), root, abstr, needinit, hasRestoreMethod, superNeedsRestore, bl, vars.toList());
    }

    public SourceGenerator.Scope generateInit(SourceGenerator src, SourceGenerator.Scope scope) {
        return scope;
    }

    public SourceGenerator.Scope generateAdapter(SourceGenerator src, SourceGenerator.Scope _s, boolean root, boolean abstr, boolean needinit, boolean hasRestoreMethod) {
        SourceGenerator.Scope scope = _s.createInner();
        if (needinit) {
            this.generateInit(src, scope);
        }
        if (!abstr) {
            src.append(scope, "/**");
            src.append(scope, " * Transport descriptor for class @Class@.");
            src.append(scope, " */");
            src.append(scope, "public static final uka.transport.TransportDescriptor TRANSPORT_DESCRIPTOR =");
            src.append(scope, "  new uka.transport.TransportDescriptor() {");
            src.append(scope, "    public Object unmarshalReference(uka.transport.UnmarshalStream s, int id)");
            src.append(scope, "      throws java.io.IOException, ClassNotFoundException");
            src.append(scope, "    {");
            src.append(scope, "      Object obj = new @Class@();");
            src.append(scope, "      s.register(obj, id);");
            src.append(scope, "      return obj;");
            src.append(scope, "    }");
            src.newLine();
            src.append(scope, "    public boolean unmarshal(Object obj, uka.transport.UnmarshalStream s)");
            src.append(scope, "      throws ClassNotFoundException, java.io.IOException");
            src.append(scope, "    {");
            src.append(scope, "      ((@Class@) obj).readExternal(s);");
            src.append(scope, "      return false;");
            src.append(scope, "    }");
            src.newLine();
            src.append(scope, "    public void marshalReference(Object obj, uka.transport.MarshalStream s)");
            src.append(scope, "      throws java.io.IOException");
            src.append(scope, "    {");
            src.append(scope, "    }");
            src.newLine();
            src.append(scope, "    public void marshal(Object obj, uka.transport.MarshalStream s)");
            src.append(scope, "      throws java.io.IOException");
            src.append(scope, "    {");
            src.append(scope, "      ((@Class@) obj).writeExternal(s);");
            src.append(scope, "    }");
            src.newLine();
            src.append(scope, "    public Object deepClone(Object orig, int id, uka.transport.DeepClone _helper)");
            src.append(scope, "      throws CloneNotSupportedException");
            src.append(scope, "    {");
            src.append(scope, "      return _helper.internalCloneByMarshal(orig);");
            src.append(scope, "    }");
            src.newLine();
            src.append(scope, "    public boolean deepCloneReferences(Object orig, Object copy, uka.transport.DeepClone _helper)");
            src.append(scope, "      throws CloneNotSupportedException");
            src.append(scope, "    {");
            src.append(scope, "      return false;");
            src.append(scope, "    }");
            src.newLine();
            src.append(scope, "    public Class getType() {");
            src.append(scope, "      return @Class@.class;");
            src.append(scope, "    }");
            src.append(scope, "  };");
            src.newLine();
            src.append(scope, "public uka.transport.TransportDescriptor getTransportDescriptor() {");
            src.append(scope, "  return TRANSPORT_DESCRIPTOR;");
            src.append(scope, "}");
            src.newLine();
        }
        return scope;
    }

    public SourceGenerator.Scope generateFull(SourceGenerator src, SourceGenerator.Scope _s, boolean root, boolean abstr, boolean needinit, boolean hasRestoreMethod, boolean superNeedsRestore, boolean needclone, List<Symbol.VarSymbol> vars) {
        SourceGenerator.Scope vs;
        Symbol.VarSymbol vv;
        SourceGenerator.Scope s = _s.createInner();
        ListBuffer primitive = new ListBuffer();
        ListBuffer reference = new ListBuffer();
        ListBuffer primitiveConst = new ListBuffer();
        ListBuffer referenceConst = new ListBuffer();
        while (vars.nonEmpty()) {
            if (this.tools.isFinal((Symbol)vars.head)) {
                if (((Symbol.VarSymbol)vars.head).type.assignable(this.syms.objectType)) {
                    referenceConst.append(vars.head);
                } else {
                    primitiveConst.append(vars.head);
                }
            } else if (((Symbol.VarSymbol)vars.head).type.assignable(this.syms.objectType)) {
                reference.append(vars.head);
            } else {
                primitive.append(vars.head);
            }
            vars = vars.tail;
        }
        if (needinit) {
            this.generateInit(src, s);
        }
        Vars p = new Vars(s, primitive.toList());
        Vars r = new Vars(s, reference.toList());
        Vars pc = new Vars(s, primitiveConst.toList());
        Vars rc = new Vars(s, referenceConst.toList());
        if (!abstr) {
            src.append(s, "/**");
            src.append(s, " * Transport descriptor for class @Class@.");
            src.append(s, " */");
            src.append(s, "public static final uka.transport.TransportDescriptor TRANSPORT_DESCRIPTOR =");
            src.append(s, "  new uka.transport.TransportDescriptor() {");
            src.append(s, "    public Object unmarshalReference(uka.transport.UnmarshalStream s, int id)");
            src.append(s, "      throws java.io.IOException, ClassNotFoundException");
            src.append(s, "    {");
            src.append(s, "      return new @Class@(s, id);");
            src.append(s, "    }");
            src.newLine();
            src.append(s, "    public boolean unmarshal(Object obj, uka.transport.UnmarshalStream s)");
            src.append(s, "      throws ClassNotFoundException, java.io.IOException");
            src.append(s, "    {");
            src.append(s, "      ((@Class@) obj).unmarshal(s);");
            if (hasRestoreMethod || superNeedsRestore) {
                src.append(s, "      return true;");
            } else {
                src.append(s, "      return false;");
            }
            src.append(s, "    }");
            src.newLine();
            src.append(s, "    public void marshalReference(Object obj, uka.transport.MarshalStream s)");
            src.append(s, "      throws java.io.IOException");
            src.append(s, "    {");
            src.append(s, "      ((@Class@) obj).marshalReference(s);");
            src.append(s, "    }");
            src.newLine();
            src.append(s, "    public void marshal(Object obj, uka.transport.MarshalStream s)");
            src.append(s, "      throws java.io.IOException");
            src.append(s, "    {");
            src.append(s, "      ((@Class@) obj).marshal(s);");
            src.append(s, "    }");
            src.newLine();
            src.append(s, "    public Object deepClone(Object orig, int id, uka.transport.DeepClone _helper)");
            src.append(s, "      throws CloneNotSupportedException");
            src.append(s, "    {");
            if (needclone) {
                src.append(s, "      try {");
                src.append(s, "        return new @Class@((@Class@) orig, id, _helper);");
                src.append(s, "      } catch (java.io.IOException ex) {");
                src.append(s, "        // TBD: Sould catch all exception the super constructor of @Class@ may throw.");
                src.append(s, "        throw (CloneNotSupportedException) new CloneNotSupportedException().initCause(ex);");
                src.append(s, "      }");
            } else {
                src.append(s, "      return orig;");
            }
            src.append(s, "    }");
            src.newLine();
            src.append(s, "    public boolean deepCloneReferences(Object orig, Object copy, uka.transport.DeepClone _helper)");
            src.append(s, "      throws CloneNotSupportedException");
            src.append(s, "    {");
            if (needclone) {
                src.append(s, "      ((@Class@) copy).deepCloneReferences((@Class@) orig, _helper);");
            }
            if (needclone && (hasRestoreMethod || superNeedsRestore)) {
                src.append(s, "      return true;");
            } else {
                src.append(s, "      return false;");
            }
            src.append(s, "    }");
            src.newLine();
            if (hasRestoreMethod || superNeedsRestore) {
                src.append(s, "    public void restoreAfterUnmarshal(Object obj)");
                src.append(s, "      throws ClassNotFoundException, java.io.IOException");
                src.append(s, "    {");
                src.append(s, "      ((@Class@) obj).externalRestoreAfterUnmarshal();");
                src.append(s, "    }");
                src.newLine();
            }
            src.append(s, "    public Class getType() {");
            src.append(s, "      return @Class@.class;");
            src.append(s, "    }");
            src.append(s, "  };");
            src.newLine();
            src.append(s, "public uka.transport.TransportDescriptor getTransportDescriptor() {");
            src.append(s, "  return TRANSPORT_DESCRIPTOR;");
            src.append(s, "}");
            src.newLine();
        }
        p.reset();
        pc.reset();
        if (p.hasNext() || pc.hasNext()) {
            if (p.hasNext()) {
                s.set("size", SourceGenerator.Scope.concat(p, "uka.transport.BasicIO.SIZEOF_@type@", " + ", "0"));
                src.append(s, "private static final int _SIZE = @size@;");
            }
            if (pc.hasNext()) {
                s.set("constSize", SourceGenerator.Scope.concat(pc, "uka.transport.BasicIO.SIZEOF_@type@", " + ", "0"));
                src.append(s, "private static final int _CONSTSIZE = @constSize@;");
            }
            src.newLine();
        }
        pc.reset();
        rc.reset();
        src.append(s, "/**");
        src.append(s, " * Called from uka.transport.UnmarshalStream to create");
        src.append(s, " * a transportable object.");
        src.append(s, " */");
        src.append(s, "public @Class@(uka.transport.UnmarshalStream _stream, int _id)");
        src.append(s, "  throws java.io.IOException, ClassNotFoundException");
        src.append(s, "{");
        if (root) {
            src.append(s, "  _stream.register(this, _id);");
        } else {
            src.append(s, "  super(_stream, _id);");
        }
        if (pc.hasNext()) {
            src.append(s, "  // Unmarshal primitive constant fields");
            src.append(s, "  _stream.request(@Class@._CONSTSIZE); ");
            src.append(s, "  byte[] _buffer = _stream.getBuffer();");
            src.append(s, "  int    _pos    = _stream.getPosition();");
            src.forall(pc, "  this.@var@ = uka.transport.BasicIO.extract@Type@(_buffer, _pos);\n  _pos += uka.transport.BasicIO.SIZEOF_@type@;");
            src.append(s, "  _stream.accept(@Class@._CONSTSIZE); ");
            src.newLine();
        }
        if (rc.hasNext()) {
            src.append(s, "  // Unmarshal constant references to other objects");
            while (rc.hasNext()) {
                vv = rc.top();
                vs = rc.next();
                if (this.tools.useAnonymousMarshaling(vv)) {
                    src.append(vs, "  this.@var@ = (@type@) _stream.readReference();");
                    continue;
                }
                src.append(vs, "  this.@var@ = (@type@) _stream.readReference();");
            }
            src.newLine();
        }
        src.append(s, "}");
        src.newLine();
        p.reset();
        r.reset();
        if (root || p.hasNext() || r.hasNext()) {
            src.append(s, "/**");
            src.append(s, " * Called from uka.transport.UnmarshalStream to unmarshal a");
            src.append(s, " * transportable object.");
            src.append(s, " */");
            src.append(s, "public void unmarshal(uka.transport.UnmarshalStream _stream)");
            src.append(s, "  throws java.io.IOException, ClassNotFoundException");
            src.append(s, "{");
            if (!root) {
                src.append(s, "  super.unmarshal(_stream);");
            }
            src.newLine();
            if (p.hasNext()) {
                src.append(s, "  // Unmarshal primitive fields");
                src.append(s, "  _stream.request(@Class@._SIZE); ");
                src.append(s, "  byte[] _buffer = _stream.getBuffer();");
                src.append(s, "  int    _pos    = _stream.getPosition();");
                src.forall(p, "  this.@var@ = uka.transport.BasicIO.extract@Type@(_buffer, _pos);\n  _pos += uka.transport.BasicIO.SIZEOF_@type@;");
                src.append(s, "  _stream.accept(@Class@._SIZE); ");
                src.newLine();
            }
            if (r.hasNext()) {
                src.append(s, "  // Unmarshal references to other objects");
                while (r.hasNext()) {
                    vv = r.top();
                    vs = r.next();
                    if (this.tools.useAnonymousMarshaling(vv)) {
                        src.append(vs, "  this.@var@ = (@type@) _stream.readReference();");
                        continue;
                    }
                    src.append(vs, "  this.@var@ = (@type@) _stream.readReference();");
                }
                src.newLine();
            }
            src.append(s, "}");
            src.newLine();
        }
        if (hasRestoreMethod) {
            src.append(s, "    public void externalRestoreAfterUnmarshal()");
            src.append(s, "      throws ClassNotFoundException, java.io.IOException");
            src.append(s, "    {");
            if (superNeedsRestore) {
                src.append(s, "      super.externalRestoreAfterUnmarshal();");
            }
            src.append(s, "      restoreAfterUnmarshal();");
            src.append(s, "    }");
            src.newLine();
        }
        pc.reset();
        rc.reset();
        if (root || pc.hasNext() || rc.hasNext()) {
            src.append(s, "/**");
            src.append(s, " * Called directly by uka.transport.MarshalStream to marshal");
            src.append(s, " * the reference to a transportable object.");
            src.append(s, " */");
            src.append(s, "public void marshalReference(uka.transport.MarshalStream _stream)");
            src.append(s, "  throws java.io.IOException");
            src.append(s, "{");
            if (!root) {
                src.append(s, "  super.marshalReference(_stream);");
            }
            if (pc.hasNext()) {
                src.append(s, "  // Marshal primitive constant fields.");
                src.append(s, "  _stream.reserve(@Class@._CONSTSIZE);");
                src.append(s, "  byte[] _buffer = _stream.getBuffer();");
                src.append(s, "  int    _pos    = _stream.getPosition();");
                src.forall(pc, "  _pos = uka.transport.BasicIO.insert(_buffer, _pos, this.@var@);");
                src.append(s, "  _stream.deliver(_CONSTSIZE);");
                src.newLine();
            }
            if (rc.hasNext()) {
                src.append(s, "  // Marshal constant references to other objects.");
                while (rc.hasNext()) {
                    vv = rc.top();
                    vs = rc.next();
                    if (this.tools.useAnonymousMarshaling(vv)) {
                        src.append(vs, "  _stream.writeAnonymous(this.@var@);");
                        continue;
                    }
                    src.append(vs, "  _stream.writeReference(this.@var@);");
                }
                src.newLine();
            }
            src.append(s, "}");
            src.newLine();
        }
        p.reset();
        r.reset();
        if (root || p.hasNext() || r.hasNext()) {
            src.append(s, "/**");
            src.append(s, " * Called directly by uka.transport.MarshalStream to marshal");
            src.append(s, " * the state of a transportable object.");
            src.append(s, " */");
            src.append(s, "public void marshal(uka.transport.MarshalStream _stream)");
            src.append(s, "  throws java.io.IOException");
            src.append(s, "{");
            if (!root) {
                src.append(s, "  super.marshal(_stream);");
            }
            if (p.hasNext()) {
                src.append(s, "  // Marshal primitive fields.");
                src.append(s, "  _stream.reserve(@Class@._SIZE);");
                src.append(s, "  byte[] _buffer = _stream.getBuffer();");
                src.append(s, "  int    _pos    = _stream.getPosition();");
                src.forall(p, "  _pos = uka.transport.BasicIO.insert(_buffer, _pos, this.@var@);");
                src.append(s, "  _stream.deliver(_SIZE);");
                src.newLine();
            }
            if (r.hasNext()) {
                src.append(s, "  // Marshal references to other objects.");
                while (r.hasNext()) {
                    vv = r.top();
                    vs = r.next();
                    if (this.tools.useAnonymousMarshaling(vv)) {
                        src.append(vs, "  _stream.writeAnonymous(this.@var@);");
                        continue;
                    }
                    src.append(vs, "  _stream.writeReference(this.@var@);");
                }
                src.newLine();
            }
            src.append(s, "}");
            src.newLine();
        }
        if (needclone) {
            p.reset();
            pc.reset();
            rc.reset();
            src.append(s, "/** Deep clone constructor for <code>@Class@</code>.*/");
            src.append(s, "public @Class@(@Class@ _orig, int _id, uka.transport.DeepClone _helper)");
            src.append(s, "  throws CloneNotSupportedException,");
            src.append(s, "  /* TBD: Should throw any exceptions that the super constructor declares to be thrown instead of simply IOException. */ java.io.IOException");
            src.append(s, "{");
            if (root) {
                src.append(s, "  _helper.add(_id, this);");
            } else {
                src.append(s, "  super(_orig, _id, _helper);");
            }
            src.append(s, "  // Copy primitive data.");
            src.forall(pc, "  this.@var@ = _orig.@var@;");
            src.forall(p, "  this.@var@ = _orig.@var@;");
            src.append(s, "  // Clone constant references.");
            while (rc.hasNext()) {
                vv = rc.top();
                vs = rc.next();
                if (this.tools.useAnonymousMarshaling(vv)) {
                    src.append(vs, "  this.@var@ = (@type@) _helper.internalDeepCloneAnonymous(_orig.@var@);");
                    continue;
                }
                src.append(vs, "  this.@var@ = (@type@) _helper.internalDeepClone(_orig.@var@);");
            }
            src.append(s, "}");
            src.newLine();
        }
        if (needclone && (root || reference.nonEmpty())) {
            r.reset();
            src.append(s, "/** ");
            src.append(s, " * Clone all references to other objects. Use the provided ");
            src.append(s, " * DeepClone object to resolve cycles.");
            src.append(s, " */");
            src.append(s, "public void deepCloneReferences(@Class@ _orig, uka.transport.DeepClone _helper)");
            src.append(s, "  throws CloneNotSupportedException");
            src.append(s, "{");
            if (!root) {
                src.append(s, "  super.deepCloneReferences(_orig, _helper);");
                src.newLine();
            }
            if (r.hasNext()) {
                src.append(s, "  // Clone references to other objects.");
                while (r.hasNext()) {
                    vv = r.top();
                    SourceGenerator.Scope scope = r.next();
                    if (this.tools.useAnonymousMarshaling(vv)) {
                        src.append(scope, "  this.@var@ = (@type@) _helper.internalDeepCloneAnonymous(_orig.@var@);");
                        continue;
                    }
                    src.append(scope, "  this.@var@ = (@type@) _helper.internalDeepClone(_orig.@var@);");
                }
                src.newLine();
            }
            src.append(s, "}");
            src.newLine();
        }
        return s;
    }

    public SourceGenerator.Scope generatePatchable(SourceGenerator src, SourceGenerator.Scope _s, boolean root, List<Symbol.VarSymbol> vars) {
        Symbol.VarSymbol vv;
        SourceGenerator.Scope s = _s.createInner();
        ListBuffer primitive = new ListBuffer();
        ListBuffer reference = new ListBuffer();
        ListBuffer primitiveConst = new ListBuffer();
        ListBuffer referenceConst = new ListBuffer();
        while (vars.nonEmpty()) {
            if (this.tools.isFinal((Symbol)vars.head)) {
                if (((Symbol.VarSymbol)vars.head).type.assignable(this.syms.objectType)) {
                    referenceConst.append(vars.head);
                } else {
                    primitiveConst.append(vars.head);
                }
            } else if (((Symbol.VarSymbol)vars.head).type.assignable(this.syms.objectType)) {
                reference.append(vars.head);
            } else {
                primitive.append(vars.head);
            }
            vars = vars.tail;
        }
        Vars p = new Vars(s, primitive.toList());
        Vars r = new Vars(s, reference.toList());
        Vars pc = new Vars(s, primitiveConst.toList());
        Vars rc = new Vars(s, referenceConst.toList());
        if (root || !primitive.isEmpty() || !reference.isEmpty()) {
            SourceGenerator.Scope vs;
            SourceGenerator.Scope ss;
            Symbol.VarSymbol pv;
            src.append(s, "public void createPatch(Object _copy, uka.patch.PatchOutput po) ");
            src.append(s, "  throws java.io.IOException");
            src.append(s, "{");
            src.append(s, "  @Class@ copy = (@Class@) _copy;");
            if (!root) {
                src.append(s, "  super.createPatch(copy, po);");
            }
            src.newLine();
            while (p.hasNext()) {
                pv = p.top();
                ss = p.next();
                if (pv.mergeType == null) {
                    src.append(ss, "  if (po.writeDiff(this.@var@, copy.@var@)) copy.@var@ = this.@var@;");
                    continue;
                }
                src.append(ss, "  if (po.writeDiff(@merge@.diff@T@(this.@var@, copy.@var@), @merge@.zero@T@())) copy.@var@ = this.@var@;");
            }
            while (r.hasNext()) {
                vv = r.top();
                vs = r.next();
                if (this.tools.useAnonymousMarshaling(vv)) {
                    if (this.tools.isImmutable(vv.type)) continue;
                    src.append(vs, "  po.createPatchAnonymous(this.@var@, copy.@var@);");
                    continue;
                }
                src.append(vs, "  copy.@var@ = this.@var@ = (@type@) po.writeDiff(this.@var@, copy.@var@);");
            }
            src.append(s, "}");
            src.newLine();
            p.reset();
            r.reset();
            src.append(s, "public void applyPatch(Object _copy, uka.patch.PatchInput pi)");
            src.append(s, "    throws java.io.IOException, ClassNotFoundException");
            src.append(s, "{");
            src.append(s, "    @Class@ copy = (@Class@) _copy;");
            if (!root) {
                src.append(s, "  super.applyPatch(copy, pi);");
            }
            src.newLine();
            while (p.hasNext()) {
                pv = p.top();
                ss = p.next();
                if (pv.mergeType == null) {
                    src.append(ss, "  if (pi.hasDiff()) copy.@var@ = this.@var@ = pi.getDiffAs@Type@();");
                    continue;
                }
                src.append(ss, "  if (pi.hasDiff()) {");
                src.append(ss, "    @type@ _d@var@ = pi.getDiffAs@Type@();");
                src.append(ss, "    copy.@var@ = @merge@.merge@T@(copy.@var@, _d@var@);");
                src.append(ss, "    this.@var@ = @merge@.merge@T@(this.@var@, _d@var@);");
                src.append(ss, "  }");
            }
            while (r.hasNext()) {
                vv = r.top();
                vs = r.next();
                if (this.tools.useAnonymousMarshaling(vv)) {
                    src.append(vs, "  pi.applyPatchAnonymous(this.@var@, copy.@var@);");
                    continue;
                }
                src.append(vs, "  if (pi.hasDiff()) copy.@var@ = this.@var@ = (@type@) pi.getDiffAsObject();");
            }
            src.append(s, "}");
            src.newLine();
            p.reset();
            r.reset();
        }
        if (root || !reference.isEmpty()) {
            src.append(s, "public void descendReferences(uka.patch.ReferenceConsumer c)");
            src.append(s, "    throws java.io.IOException");
            src.append(s, "{");
            if (!root) {
                src.append(s, "  super.descendReferences(c);");
            }
            src.forall(rc, "  c.descend(this.@var@);");
            src.forall(r, "  c.descend(this.@var@);");
            src.append(s, "}");
            src.newLine();
            rc.reset();
            r.reset();
            src.append(s, "public void filterReferences(uka.patch.ReferenceFilter f) {");
            if (!root) {
                src.append(s, "  super.filterReferences(f);");
            }
            src.newLine();
            while (r.hasNext()) {
                vv = r.top();
                SourceGenerator.Scope scope = r.next();
                if (this.tools.useAnonymousMarshaling(vv)) continue;
                src.append(scope, "  this.@var@ = (@type@) f.filter(this.@var@);");
            }
            src.append(s, "}");
            src.newLine();
            r.reset();
        }
        if (root) {
            src.append(s, "/** @@see uka.patch.Patchable */");
            src.append(s, "public Object flatClone() {");
            src.append(s, "  try {");
            src.append(s, "    return super.clone();");
            src.append(s, "  } catch (CloneNotSupportedException ex) {");
            src.append(s, "    throw new AssertionError(\"Declared Cloneable but clone() is still unsupported\");");
            src.append(s, "  }");
            src.append(s, "}");
            src.newLine();
            r.reset();
        }
        return s;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Vars
    implements SourceGenerator.Scope.Iterator {
        private SourceGenerator.Scope s;
        private List<Symbol.VarSymbol> vars;
        private List<Symbol.VarSymbol> head;

        public Vars(SourceGenerator.Scope s, List<Symbol.VarSymbol> list) {
            this.s = s;
            this.vars = list;
            this.head = this.vars;
        }

        @Override
        public boolean hasNext() {
            return this.vars.nonEmpty();
        }

        public Symbol.VarSymbol top() {
            return (Symbol.VarSymbol)this.vars.head;
        }

        @Override
        public SourceGenerator.Scope next() {
            String varType = ((Symbol.VarSymbol)this.vars.head).type.toString();
            SourceGenerator.Scope scope = this.s.createInner();
            scope.set("type", varType);
            scope.set("var", ((Symbol.VarSymbol)this.vars.head).name);
            scope.set("Type", String.valueOf(varType.substring(0, 1).toUpperCase()).concat(String.valueOf(varType.substring(1))));
            scope.set("T", ((Symbol.VarSymbol)this.vars.head).type.subType(TransportableGenerator.this.syms.objectType) ? TransportableGenerator.EMPTY : "@Type@");
            if (((Symbol.VarSymbol)this.vars.head).mergeType != null) {
                scope.set("merge", ((Symbol.VarSymbol)this.vars.head).mergeType);
            }
            this.vars = this.vars.tail;
            return scope;
        }

        public void reset() {
            this.vars = this.head;
        }
    }
}

