/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.parser;

import gjc.v6.parser.Tokens;
import gjc.v6.tree.Tree;
import gjc.v6.util.LayoutCharacters;
import gjc.v6.util.Log;
import gjc.v6.util.Name;
import gjc.v6.util.Names;
import gjc.v6.util.Position;
import gjc.v6.util.PositionTranslator;
import java.io.IOException;
import java.io.InputStream;

public class Scanner
implements Tokens,
LayoutCharacters {
    int token;
    int pos;
    int lastPos;
    int errPos = 0;
    Name name;
    int radix;
    boolean deprecatedFlag = false;
    private char[] sbuf = new char[128];
    private int sp;
    private byte[] buf;
    private int bp;
    private int endBp;
    private char ch;
    private int line;
    private int col;
    private static byte[] key;
    private static int maxKey;
    private int lastEscape;
    protected Log log;
    protected Tree tagAt;
    protected Tree tagMerge;
    protected boolean tagEmbedded = false;
    final PositionTranslator translator;
    Name tag;
    protected int sndbufp = 0;
    protected byte[] sndbuf = new byte[1024];
    protected int lineStartPosP = 0;
    protected int[] lineStartPos = new int[256];
    private PositionTranslator commentTranslator = new PositionTranslator(){

        public int translate(int line, int col) {
            if (line - 1 >= Scanner.this.lineStartPosP) {
                throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(String.valueOf("accessing line outside comment: ").concat(String.valueOf(line))).concat(String.valueOf(" > "))).concat(String.valueOf(Scanner.this.lineStartPosP)));
            }
            int posOffset = Scanner.this.lineStartPos[line - 1];
            int originalLine = Position.line(posOffset);
            int n = Position.column(posOffset) + (col - 1);
            return Position.make(originalLine, n);
        }
    };
    private static Name[] tokenName;

    public Scanner(InputStream in, Log log) {
        this.log = log;
        try {
            this.buf = new byte[in.available() + 1];
            if (in.read(this.buf) != this.buf.length - 1) {
                throw new IOException("read error");
            }
        }
        catch (IOException iOException) {
            this.lexError(iOException.toString());
            this.buf = new byte[1];
        }
        this.endBp = this.buf.length - 1;
        this.buf[this.endBp] = 0;
        this.line = 1;
        this.col = 0;
        this.bp = -1;
        this.lastEscape = -1;
        this.translator = null;
        this.scanChar();
    }

    public Scanner(byte[] buf, int start, int stop, Log log, PositionTranslator positionTranslator) {
        this.buf = buf;
        this.bp = start - 1;
        this.endBp = stop;
        if (buf[this.endBp] != 0) {
            throw new InternalError(String.valueOf(String.valueOf("assert: buffer does not end with EOB ('").concat(String.valueOf((char)buf[this.endBp]))).concat(String.valueOf("')")));
        }
        this.log = log;
        this.translator = positionTranslator;
        this.line = 1;
        this.col = 0;
        this.lastEscape = -1;
        this.scanChar();
    }

    private void lexError(int pos, String string) {
        this.log.error(pos, string);
        this.token = 1;
        this.errPos = pos;
    }

    private void lexError(String string) {
        this.lexError(this.pos, string);
    }

    private void convertUnicode() {
        int startcol = this.col++;
        if (this.ch == '\\') {
            this.ch = (char)this.buf[++this.bp];
            if (this.ch == 'u') {
                do {
                    this.ch = (char)this.buf[++this.bp];
                    ++this.col;
                } while (this.ch == 'u');
                int limit = this.bp + 3;
                if (limit < this.endBp) {
                    int d;
                    int n = d = Character.digit(this.ch, 16);
                    while (this.bp < limit && d >= 0) {
                        this.ch = (char)this.buf[++this.bp];
                        ++this.col;
                        d = Character.digit(this.ch, 16);
                        n = (n << 4) + d;
                    }
                    if (d >= 0) {
                        this.ch = (char)n;
                        this.lastEscape = this.bp;
                        return;
                    }
                }
                this.lexError(Position.make(this.line, startcol), "illegal unicode escape");
            } else {
                --this.bp;
                this.ch = (char)92;
            }
        }
    }

    private void scanChar() {
        this.ch = (char)(this.buf[++this.bp] & 0xFF);
        ++this.col;
        if (this.ch == '\\') {
            this.convertUnicode();
        }
    }

    private void scanCommentChar() {
        this.ch = (char)(this.buf[++this.bp] & 0xFF);
        ++this.col;
        switch (this.ch) {
            case '\\': {
                if (this.buf[this.bp + 1] == 92) {
                    ++this.bp;
                    ++this.col;
                    break;
                }
                this.convertUnicode();
                break;
            }
            case '\t': {
                this.col = (this.col - 1) / 8 * 8 + 8;
            }
        }
    }

    private void putChar(char ch) {
        if (this.sp == this.sbuf.length) {
            char[] cArray = new char[this.sbuf.length * 2];
            System.arraycopy(this.sbuf, 0, cArray, 0, this.sbuf.length);
            this.sbuf = cArray;
        }
        this.sbuf[this.sp++] = ch;
    }

    private void dch() {
        System.err.print(this.ch);
        System.out.flush();
    }

    private void scanLitChar() {
        if (this.ch == '\\') {
            if (this.buf[this.bp + 1] == 92) {
                ++this.bp;
                ++this.col;
                this.putChar('\\');
                this.scanChar();
            } else {
                this.scanChar();
                switch (this.ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char leadch = this.ch;
                        int n = Character.digit(this.ch, 8);
                        this.scanChar();
                        if ('0' <= this.ch && this.ch <= '7') {
                            n = n * 8 + Character.digit(this.ch, 8);
                            this.scanChar();
                            if (leadch <= '3' && '0' <= this.ch && this.ch <= '7') {
                                n = n * 8 + Character.digit(this.ch, 8);
                                this.scanChar();
                            }
                        }
                        this.putChar((char)n);
                        break;
                    }
                    case 'b': {
                        this.putChar('\b');
                        this.scanChar();
                        break;
                    }
                    case 't': {
                        this.putChar('\t');
                        this.scanChar();
                        break;
                    }
                    case 'n': {
                        this.putChar('\n');
                        this.scanChar();
                        break;
                    }
                    case 'f': {
                        this.putChar('\f');
                        this.scanChar();
                        break;
                    }
                    case 'r': {
                        this.putChar('\r');
                        this.scanChar();
                        break;
                    }
                    case '\'': {
                        this.putChar('\'');
                        this.scanChar();
                        break;
                    }
                    case '\"': {
                        this.putChar('\"');
                        this.scanChar();
                        break;
                    }
                    default: {
                        this.lexError(Position.make(this.line, this.col), "illegal escape character");
                    }
                }
            }
        } else if (this.bp != this.endBp) {
            this.putChar(this.ch);
            this.scanChar();
        }
    }

    private void scanFraction() {
        while (Character.digit(this.ch, 10) >= 0) {
            this.putChar(this.ch);
            this.scanChar();
        }
        int n = this.sp;
        if (this.ch == 'e' || this.ch == 'E') {
            this.putChar(this.ch);
            this.scanChar();
            if (this.ch == '+' || this.ch == '-') {
                this.putChar(this.ch);
                this.scanChar();
            }
            if ('0' <= this.ch && this.ch <= '9') {
                do {
                    this.putChar(this.ch);
                    this.scanChar();
                } while ('0' <= this.ch && this.ch <= '9');
                return;
            }
            this.lexError("malformed floating point literal");
            this.sp = n;
        }
    }

    private void scanFractionAndSuffix() {
        this.scanFraction();
        if (this.ch == 'f' || this.ch == 'F') {
            this.scanChar();
            this.token = 58;
        } else {
            if (this.ch == 'd' || this.ch == 'D') {
                this.scanChar();
            }
            this.token = 59;
        }
    }

    private void scanNumber(int n) {
        this.radix = n;
        while (Character.digit(this.ch, n == 8 ? 10 : n) >= 0) {
            this.putChar(this.ch);
            this.scanChar();
        }
        if (n <= 10 && this.ch == '.') {
            this.putChar(this.ch);
            this.scanChar();
            this.scanFractionAndSuffix();
        } else if (n <= 10 && (this.ch == 'e' || this.ch == 'E' || this.ch == 'f' || this.ch == 'F' || this.ch == 'd' || this.ch == 'D')) {
            this.scanFractionAndSuffix();
        } else if (this.ch == 'l' || this.ch == 'L') {
            this.scanChar();
            this.token = 57;
        } else {
            this.token = 56;
        }
    }

    private void scanIdent() {
        int start = this.bp;
        boolean escaped = false;
        block3: while (true) {
            if (this.lastEscape >= start) {
                if (!escaped) {
                    for (int i = 0; i < this.sp; ++i) {
                        this.sbuf[i] = (char)this.buf[start + i];
                    }
                    escaped = true;
                }
                this.putChar(this.ch);
            } else {
                ++this.sp;
            }
            this.ch = (char)this.buf[++this.bp];
            ++this.col;
            if (this.ch == '\\') {
                this.convertUnicode();
            }
            switch (this.ch) {
                case '$': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    continue block3;
                }
            }
            if (this.ch <= '\u0080' || !Character.isJavaIdentifierPart(this.ch)) break;
        }
        this.name = escaped ? Name.fromChars(this.sbuf, 0, this.sp) : Name.fromUtf(this.buf, start, this.sp);
        this.token = this.name.index <= maxKey ? key[this.name.index] : 2;
    }

    private boolean isSpecial(char c) {
        switch (c) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private void scanOperator() {
        do {
            this.putChar(this.ch);
            Name name = Name.fromChars(this.sbuf, 0, this.sp);
            if (name.index > maxKey || key[name.index] == 2) {
                --this.sp;
                break;
            }
            this.name = name;
            this.token = key[name.index];
            this.scanChar();
        } while (this.isSpecial(this.ch));
    }

    private void scanDocComment() {
        this.sndbufp = 0;
        if (this.ch == '/') {
            return;
        }
        while (this.scanLine()) {
        }
        this.docParagraph();
    }

    private void docParagraph() {
        this.putByte('\u0000');
        this.scanDocParagraph(this.tag, this.sndbuf, 0, this.sndbufp - 1, this.commentTranslator);
        this.tag = null;
        while (this.lineStartPosP > 0) {
            this.lineStartPos[this.lineStartPosP--] = 0;
        }
        this.sndbufp = 0;
    }

    private boolean scanLine() {
        if (!this.scanLineHead()) {
            this.putNL(this.makePosition(this.line, this.col));
            return false;
        }
        Name name = this.scanLineTag();
        if (name != null) {
            if (this.sndbufp > 0) {
                this.docParagraph();
            }
            this.tag = name;
        }
        this.putNL(this.makePosition(this.line, this.col));
        return this.scanLineContent();
    }

    private boolean scanLineHead() {
        while (this.ch == ' ' || this.ch == '\t') {
            this.scanCommentChar();
        }
        if (this.ch == '*') {
            this.scanCommentChar();
            while (this.ch == '*') {
                this.scanCommentChar();
            }
            if (this.ch == '/') {
                return false;
            }
            while (this.ch == ' ' || this.ch == '\t') {
                this.scanCommentChar();
            }
        }
        return true;
    }

    private Name scanLineTag() {
        if (this.ch != '@') {
            return null;
        }
        this.scanCommentChar();
        this.sp = 0;
        while (this.ch >= 'a' && this.ch <= 'z') {
            this.putChar(this.ch);
            this.scanCommentChar();
        }
        while (this.ch == ' ' || this.ch == '\t') {
            this.scanCommentChar();
        }
        Name name = Name.fromChars(this.sbuf, 0, this.sp);
        this.sp = 0;
        return name;
    }

    private boolean scanLineContent() {
        while (true) {
            if (this.ch == '\r') {
                ++this.line;
                this.col = 0;
                this.scanCommentChar();
                if (this.ch == '\n') {
                    this.col = 0;
                    this.scanCommentChar();
                }
                this.putByte('\n');
                return true;
            }
            if (this.ch == '\n') {
                ++this.line;
                this.col = 0;
                this.scanCommentChar();
                this.putByte('\n');
                return true;
            }
            if (this.ch == '*') {
                this.scanCommentChar();
                if (this.ch == '/') {
                    return false;
                }
                this.putByte('*');
                continue;
            }
            this.putByte(this.ch);
            this.scanCommentChar();
        }
    }

    protected void scanDocParagraph(Name tag, byte[] contents, int start, int stop, PositionTranslator positionTranslator) {
        if (tag == Names.deprecated) {
            this.deprecatedFlag = true;
        }
    }

    private void putNL(int pos) {
        if (this.lineStartPosP == this.lineStartPos.length) {
            int[] nArray = new int[this.lineStartPosP * 2];
            System.arraycopy(this.lineStartPos, 0, nArray, 0, this.lineStartPosP);
            this.lineStartPos = nArray;
        }
        this.lineStartPos[this.lineStartPosP++] = pos;
    }

    private void putByte(char ch) {
        int n;
        if (this.sndbufp == this.sndbuf.length) {
            byte[] newbuf = new byte[this.sndbuf.length * 2];
            System.arraycopy(this.sndbuf, 0, newbuf, 0, this.sndbuf.length);
            this.sndbuf = newbuf;
        }
        if ((n = ch >>> 8) == 0) {
            this.sndbuf[this.sndbufp++] = (byte)ch;
        } else {
            this.putByte('\\');
            this.putByte('u');
            this.putByte(Character.forDigit(ch >>> 24 & 0xF, 16));
            this.putByte(Character.forDigit(ch >>> 16 & 0xF, 16));
            this.putByte(Character.forDigit(ch >>> 8 & 0xF, 16));
            this.putByte(Character.forDigit(ch & 0xF, 16));
        }
    }

    private void skipComment() {
        boolean linestart = true;
        boolean bl = true;
        block8: while (true) {
            switch (this.ch) {
                case ' ': {
                    this.scanCommentChar();
                    continue block8;
                }
                case '\t': {
                    this.scanCommentChar();
                    continue block8;
                }
                case '\f': {
                    this.col = 0;
                    this.scanCommentChar();
                    continue block8;
                }
                case '\r': {
                    ++this.line;
                    this.col = 0;
                    this.scanCommentChar();
                    if (this.ch == '\n') {
                        this.col = 0;
                        this.scanCommentChar();
                    }
                    linestart = true;
                    bl = false;
                    continue block8;
                }
                case '\n': {
                    ++this.line;
                    this.col = 0;
                    this.scanCommentChar();
                    linestart = true;
                    bl = false;
                    continue block8;
                }
                case '*': {
                    break;
                }
                default: {
                    if (this.bp >= this.endBp) break;
                    this.scanCommentChar();
                    linestart = false;
                    continue block8;
                }
            }
            bl = true;
            while (this.ch == '*') {
                this.scanCommentChar();
            }
            if (this.ch == '/' || this.bp >= this.endBp) break;
        }
    }

    public String stringVal() {
        return new String(this.sbuf, 0, this.sp);
    }

    private int makePosition(int line, int n) {
        if (this.translator != null) {
            return this.translator.translate(line, n);
        }
        return (line << 10) + n;
    }

    public void nextToken() {
        this.lastPos = this.makePosition(this.line, this.col);
        this.sp = 0;
        block22: while (true) {
            this.pos = this.makePosition(this.line, this.col);
            int n = this.bp++;
            switch (this.ch) {
                case ' ': {
                    this.ch = (char)this.buf[this.bp];
                    ++this.col;
                    if (this.ch != '\\') continue block22;
                    this.convertUnicode();
                    break;
                }
                case '\t': {
                    this.col = (this.col - 1) / 8 * 8 + 8;
                    this.scanChar();
                    break;
                }
                case '\f': {
                    this.col = 0;
                    this.scanChar();
                    break;
                }
                case '\r': {
                    ++this.line;
                    this.col = 0;
                    this.scanChar();
                    if (this.ch != '\n') continue block22;
                    this.col = 0;
                    this.scanChar();
                    break;
                }
                case '\n': {
                    ++this.line;
                    this.col = 0;
                    this.scanChar();
                    break;
                }
                case '$': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case '_': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    this.scanIdent();
                    return;
                }
                case '0': {
                    this.scanChar();
                    if (this.ch == 'x' || this.ch == 'X') {
                        this.scanChar();
                        if (Character.digit(this.ch, 16) < 0) {
                            this.lexError("hexadecimal numbers must contain at least one hexadecimal digit");
                        }
                        this.scanNumber(16);
                    } else {
                        this.putChar('0');
                        this.scanNumber(8);
                    }
                    return;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.scanNumber(10);
                    return;
                }
                case '.': {
                    this.scanChar();
                    if ('0' <= this.ch && this.ch <= '9') {
                        this.putChar('.');
                        this.scanFractionAndSuffix();
                    } else {
                        this.token = 73;
                    }
                    return;
                }
                case ',': {
                    this.scanChar();
                    this.token = 72;
                    return;
                }
                case ';': {
                    this.scanChar();
                    this.token = 71;
                    return;
                }
                case '(': {
                    this.scanChar();
                    this.token = 65;
                    return;
                }
                case ')': {
                    this.scanChar();
                    this.token = 66;
                    return;
                }
                case '[': {
                    this.scanChar();
                    this.token = 69;
                    return;
                }
                case ']': {
                    this.scanChar();
                    this.token = 70;
                    return;
                }
                case '{': {
                    this.scanChar();
                    this.token = 67;
                    return;
                }
                case '}': {
                    this.scanChar();
                    this.token = 68;
                    return;
                }
                case '/': {
                    this.scanChar();
                    if (this.ch == '/') {
                        do {
                            this.scanCommentChar();
                            if (this.ch == '\r' || this.ch == '\n') continue block22;
                        } while (this.bp < this.endBp);
                        break;
                    }
                    if (this.ch == '*') {
                        this.scanChar();
                        if (this.ch == '*') {
                            this.scanCommentChar();
                            this.scanDocComment();
                        } else {
                            this.skipComment();
                        }
                        if (this.ch == '/') {
                            this.scanChar();
                            break;
                        }
                        this.lexError("unclosed comment");
                        return;
                    }
                    if (this.ch == '=') {
                        this.name = Names.slashequals;
                        this.token = 103;
                        this.scanChar();
                    } else {
                        this.name = Names.slash;
                        this.token = 92;
                    }
                    return;
                }
                case '\'': {
                    this.scanChar();
                    if (this.ch == '\'') {
                        this.lexError("empty character literal");
                    } else {
                        this.scanLitChar();
                        if (this.ch == '\'') {
                            this.scanChar();
                            this.token = 60;
                        } else {
                            this.lexError("unclosed character literal");
                        }
                    }
                    return;
                }
                case '\"': {
                    this.scanChar();
                    while (this.ch != '\"' && this.ch != '\r' && this.ch != '\n' && this.bp < this.endBp) {
                        this.scanLitChar();
                    }
                    if (this.ch == '\"') {
                        this.token = 61;
                        this.scanChar();
                    } else {
                        this.lexError(this.pos, "unclosed string literal");
                    }
                    return;
                }
                default: {
                    if (this.isSpecial(this.ch)) {
                        this.scanOperator();
                    } else if (Character.isJavaIdentifierStart(this.ch)) {
                        this.scanIdent();
                    } else if (this.bp == this.endBp) {
                        this.token = 0;
                    } else {
                        this.lexError("illegal character");
                        this.scanChar();
                    }
                    return;
                }
            }
        }
    }

    String token2string(int n) {
        switch (n) {
            case 2: {
                return "<identifier>";
            }
            case 60: {
                return "<character>";
            }
            case 61: {
                return "<string>";
            }
            case 56: {
                return "<integer>";
            }
            case 57: {
                return "<long integer>";
            }
            case 58: {
                return "<float>";
            }
            case 59: {
                return "<double>";
            }
            case 73: {
                return "'.'";
            }
            case 72: {
                return "','";
            }
            case 71: {
                return "';'";
            }
            case 65: {
                return "'('";
            }
            case 66: {
                return "')'";
            }
            case 69: {
                return "'['";
            }
            case 70: {
                return "']'";
            }
            case 67: {
                return "'{'";
            }
            case 68: {
                return "'}'";
            }
            case 1: {
                return "<bad symbol>";
            }
            case 0: {
                return "<end of input>";
            }
        }
        return tokenName[n].toString();
    }

    private static void enterKeyword(String s, int token) {
        Name n;
        Scanner.tokenName[token] = n = Name.fromString(s);
        if (n.index > maxKey) {
            maxKey = n.index;
        }
    }

    static {
        maxKey = 0;
        tokenName = new Name[111];
        for (int j = 0; j < 111; ++j) {
            Scanner.tokenName[j] = null;
        }
        Scanner.enterKeyword("+", 89);
        Scanner.enterKeyword("-", 90);
        Scanner.enterKeyword("!", 77);
        Scanner.enterKeyword("%", 96);
        Scanner.enterKeyword("^", 95);
        Scanner.enterKeyword("&", 93);
        Scanner.enterKeyword("*", 91);
        Scanner.enterKeyword("|", 94);
        Scanner.enterKeyword("~", 78);
        Scanner.enterKeyword("/", 92);
        Scanner.enterKeyword(">", 75);
        Scanner.enterKeyword("<", 76);
        Scanner.enterKeyword("?", 79);
        Scanner.enterKeyword(":", 80);
        Scanner.enterKeyword("=", 74);
        Scanner.enterKeyword("++", 87);
        Scanner.enterKeyword("--", 88);
        Scanner.enterKeyword("==", 81);
        Scanner.enterKeyword("<=", 82);
        Scanner.enterKeyword(">=", 83);
        Scanner.enterKeyword("!=", 84);
        Scanner.enterKeyword("<<", 97);
        Scanner.enterKeyword(">>", 98);
        Scanner.enterKeyword(">>>", 99);
        Scanner.enterKeyword("+=", 100);
        Scanner.enterKeyword("-=", 101);
        Scanner.enterKeyword("*=", 102);
        Scanner.enterKeyword("/=", 103);
        Scanner.enterKeyword("&=", 104);
        Scanner.enterKeyword("|=", 105);
        Scanner.enterKeyword("^=", 106);
        Scanner.enterKeyword("%=", 107);
        Scanner.enterKeyword("<<=", 108);
        Scanner.enterKeyword(">>=", 109);
        Scanner.enterKeyword(">>>=", 110);
        Scanner.enterKeyword("||", 86);
        Scanner.enterKeyword("&&", 85);
        Scanner.enterKeyword("abstract", 3);
        Scanner.enterKeyword("boolean", 4);
        Scanner.enterKeyword("break", 5);
        Scanner.enterKeyword("byte", 6);
        Scanner.enterKeyword("case", 7);
        Scanner.enterKeyword("catch", 8);
        Scanner.enterKeyword("char", 9);
        Scanner.enterKeyword("class", 10);
        Scanner.enterKeyword("const", 11);
        Scanner.enterKeyword("continue", 12);
        Scanner.enterKeyword("default", 13);
        Scanner.enterKeyword("do", 14);
        Scanner.enterKeyword("double", 15);
        Scanner.enterKeyword("else", 16);
        Scanner.enterKeyword("extends", 17);
        Scanner.enterKeyword("final", 18);
        Scanner.enterKeyword("finally", 19);
        Scanner.enterKeyword("float", 20);
        Scanner.enterKeyword("for", 21);
        Scanner.enterKeyword("goto", 22);
        Scanner.enterKeyword("if", 23);
        Scanner.enterKeyword("assert", 24);
        Scanner.enterKeyword("implements", 25);
        Scanner.enterKeyword("import", 26);
        Scanner.enterKeyword("instanceof", 27);
        Scanner.enterKeyword("int", 28);
        Scanner.enterKeyword("interface", 29);
        Scanner.enterKeyword("long", 30);
        Scanner.enterKeyword("native", 31);
        Scanner.enterKeyword("new", 32);
        Scanner.enterKeyword("package", 33);
        Scanner.enterKeyword("private", 34);
        Scanner.enterKeyword("protected", 35);
        Scanner.enterKeyword("public", 36);
        Scanner.enterKeyword("remote", 37);
        Scanner.enterKeyword("replicated", 39);
        Scanner.enterKeyword("collective", 40);
        Scanner.enterKeyword("exclusive", 41);
        Scanner.enterKeyword("shared", 42);
        Scanner.enterKeyword("return", 38);
        Scanner.enterKeyword("short", 43);
        Scanner.enterKeyword("static", 44);
        Scanner.enterKeyword("super", 45);
        Scanner.enterKeyword("switch", 46);
        Scanner.enterKeyword("synchronized", 47);
        Scanner.enterKeyword("this", 48);
        Scanner.enterKeyword("throw", 49);
        Scanner.enterKeyword("throws", 50);
        Scanner.enterKeyword("transient", 51);
        Scanner.enterKeyword("try", 52);
        Scanner.enterKeyword("void", 53);
        Scanner.enterKeyword("volatile", 54);
        Scanner.enterKeyword("while", 55);
        Scanner.enterKeyword("true", 62);
        Scanner.enterKeyword("false", 63);
        Scanner.enterKeyword("null", 64);
        key = new byte[maxKey + 1];
        for (int i = 0; i <= maxKey; ++i) {
            Scanner.key[i] = 2;
        }
        for (int j = 0; j < 111; j = (int)((byte)(j + 1))) {
            if (tokenName[j] == null) continue;
            Scanner.key[Scanner.tokenName[j].index] = j;
        }
    }
}

