/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.tree;

import gjc.v6.code.Flags;
import gjc.v6.code.Type;
import gjc.v6.tree.Tree;
import gjc.v6.tree.TreeInfo;
import gjc.v6.util.Convert;
import gjc.v6.util.List;
import gjc.v6.util.Name;
import gjc.v6.util.Names;
import gjc.v6.util.Position;
import java.io.PrintStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pretty
extends Tree.Visitor<Void, Integer>
implements Flags {
    PrintStream out = System.out;
    boolean doAnnotatePositions = false;
    static Integer[] Precedence = new Integer[16];
    public int width = 3;
    int lmargin = 0;
    Name enclClassName = null;

    public Pretty(PrintStream printStream) {
        this.out = printStream;
    }

    public Pretty() {
        this(System.out);
    }

    public void setAnnotatePositions(boolean bl) {
        this.doAnnotatePositions = bl;
    }

    void align() {
        for (int i = 0; i < this.lmargin; ++i) {
            this.out.print(" ");
        }
    }

    void indent() {
        this.lmargin += this.width;
    }

    void undent() {
        this.lmargin -= this.width;
    }

    void open(Integer contextPrec, int n) {
        if (contextPrec != null && n < contextPrec) {
            this.out.print("(");
        }
    }

    void close(Integer contextPrec, int n) {
        if (contextPrec != null && n < contextPrec) {
            this.out.print(")");
        }
    }

    public void print(String string) {
        this.out.print(Convert.escapeUnicode(string));
    }

    public void println() {
        this.out.println();
    }

    public void printPos(Tree tree) {
        if (this.doAnnotatePositions) {
            this.print(String.valueOf(String.valueOf(String.valueOf(String.valueOf("/**@pos ").concat(String.valueOf(Position.line(tree.pos)))).concat(String.valueOf(", "))).concat(String.valueOf(Position.column(tree.pos)))).concat(String.valueOf("*/")));
        }
    }

    public void printExpr(Tree tree, int n) {
        if (tree == null) {
            this.print("/*missing*/");
        } else {
            tree.visit(this, Precedence[n]);
        }
    }

    public void printExpr(Tree tree) {
        this.printExpr(tree, 0);
    }

    public void printStat(Tree tree) {
        if (tree == null) {
            this.print("/*missing*/");
        } else {
            tree.visit(this, null);
        }
    }

    public <T extends Tree> void printExprs(List<T> trees) {
        if (trees.nonEmpty()) {
            this.printExpr((Tree)trees.head);
            List list = trees.tail;
            while (list.nonEmpty()) {
                this.print(", ");
                this.printExpr((Tree)list.head);
                list = list.tail;
            }
        }
    }

    public <T extends Tree> void printStats(List<T> trees) {
        List<Object> list = trees;
        while (list.nonEmpty()) {
            this.align();
            this.printStat((Tree)list.head);
            this.println();
            list = list.tail;
        }
    }

    public void printFlags(int n) {
        if ((n & 0x10000) != 0) {
            this.print("/*synthetic*/ ");
        }
        this.print(TreeInfo.flagNames(n));
        if ((n & 0x2FFF) != 0) {
            this.print(" ");
        }
    }

    public void printTypeParameters(List<Tree.TypeParameter> list) {
        if (list.nonEmpty()) {
            this.print("<");
            this.printExprs(list);
            this.print(">");
        }
    }

    public void printBlock(List<Tree> list) {
        this.print("{");
        this.println();
        this.indent();
        this.printStats(list);
        this.undent();
        this.align();
        this.print("}");
    }

    public void printUnit(Tree.TopLevel tree, Tree.ClassDef cdef) {
        if (tree.pid != null) {
            this.print("package ");
            this.printExpr(tree.pid);
            this.print(";");
            this.println();
        }
        List<Tree> list = tree.defs;
        while (list.nonEmpty() && (cdef == null || ((Tree)list.head).tag == 2)) {
            this.printStat((Tree)list.head);
            this.println();
            list = list.tail;
        }
        if (cdef != null) {
            this.printStat(cdef);
            this.println();
        }
    }

    @Override
    public Void _case(Tree.TopLevel tree, Integer n) {
        this.printUnit(tree, null);
        return null;
    }

    @Override
    public Void _case(Tree.Import tree, Integer n) {
        this.print("import ");
        this.printExpr(tree.qualid);
        this.print(";");
        this.println();
        return null;
    }

    @Override
    public Void _case(Tree.ClassDef tree, Integer prec) {
        this.printFlags(tree.flags & 0xFFFFFDFF);
        Name name = this.enclClassName;
        this.enclClassName = tree.name;
        if ((tree.flags & 0x200) != 0) {
            this.print(String.valueOf("interface ").concat(String.valueOf(tree.name)));
            this.printTypeParameters(tree.typarams);
            if (tree.implementing.nonEmpty()) {
                this.print(" extends ");
                this.printExprs(tree.implementing);
            }
        } else {
            this.print(String.valueOf("class ").concat(String.valueOf(tree.name)));
            this.printTypeParameters(tree.typarams);
            if (tree.extending != null) {
                this.print(" extends ");
                this.printExpr(tree.extending);
            }
            if (tree.implementing.nonEmpty()) {
                this.print(" implements ");
                this.printExprs(tree.implementing);
            }
        }
        this.print(" ");
        this.printBlock(tree.defs);
        this.enclClassName = name;
        return null;
    }

    @Override
    public Void _case(Tree.MethodDef tree, Integer n) {
        if (tree.name != Names.init || this.enclClassName != null) {
            this.printFlags(tree.flags);
            if (tree.name == Names.init) {
                this.print(this.enclClassName.toString());
            } else {
                this.printExpr(tree.restype);
                this.print(String.valueOf(" ").concat(String.valueOf(tree.name)));
            }
            this.printTypeParameters(tree.typarams);
            this.print("(");
            this.printExprs(tree.params);
            this.print(")");
            if (tree.thrown.nonEmpty()) {
                this.print(" throws ");
                this.printExprs(tree.thrown);
            }
            if (tree.body != null) {
                this.print(" ");
                this.printStat(tree.body);
            } else {
                this.print(";");
            }
        }
        return null;
    }

    @Override
    public Void _case(Tree.VarDef tree, Integer n) {
        if (tree.merge != null) {
            this.print("/** @merge ");
            this.printExpr(tree.merge);
            this.print(" */");
            this.println();
        }
        this.printFlags(tree.flags);
        this.printExpr(tree.vartype);
        this.print(" ");
        this.printPos(tree);
        this.print(tree.name.toString());
        if (tree.init != null) {
            this.print(" = ");
            this.printExpr(tree.init);
        }
        if (n == null) {
            this.print(";");
        }
        return null;
    }

    @Override
    public Void _case(Tree.Block tree, Integer n) {
        this.printFlags(tree.flags);
        this.printBlock(tree.stats);
        return null;
    }

    @Override
    public Void _case(Tree.DoLoop tree, Integer n) {
        this.print("do ");
        this.printStat(tree.body);
        this.align();
        this.print(" while (");
        this.printExpr(tree.cond);
        this.print(");");
        return null;
    }

    @Override
    public Void _case(Tree.WhileLoop tree, Integer n) {
        this.print("while (");
        this.printExpr(tree.cond);
        this.print(") ");
        this.printStat(tree.body);
        return null;
    }

    @Override
    public Void _case(Tree.ForLoop tree, Integer prec) {
        this.print("for (");
        if (tree.init.nonEmpty()) {
            if (((Tree)tree.init.head).tag == 5) {
                this.printExpr((Tree)tree.init.head);
                List l = tree.init.tail;
                while (l.nonEmpty()) {
                    Tree.VarDef varDef = (Tree.VarDef)l.head;
                    this.print(String.valueOf(String.valueOf(", ").concat(String.valueOf(varDef.name))).concat(String.valueOf(" = ")));
                    this.printExpr(varDef.init);
                    l = l.tail;
                }
            } else {
                this.printExprs(tree.init);
            }
        }
        this.print("; ");
        if (tree.cond != null) {
            this.printExpr(tree.cond);
        }
        this.print("; ");
        this.printExprs(tree.step);
        this.print(") ");
        this.printStat(tree.body);
        return null;
    }

    @Override
    public Void _case(Tree.Labelled tree, Integer n) {
        this.print(String.valueOf(tree.label).concat(String.valueOf(": ")));
        this.printStat(tree.body);
        return null;
    }

    @Override
    public Void _case(Tree.Switch tree, Integer n) {
        this.print("switch (");
        this.printExpr(tree.selector);
        this.print(") {\n");
        this.printStats(tree.cases);
        this.align();
        this.print("}");
        return null;
    }

    @Override
    public Void _case(Tree.Case tree, Integer n) {
        if (tree.pat == null) {
            this.print("default");
        } else {
            this.print("case ");
            this.printExpr(tree.pat);
        }
        this.print(": \n");
        this.indent();
        this.printStats(tree.stats);
        this.undent();
        this.align();
        return null;
    }

    @Override
    public Void _case(Tree.Synchronized tree, Integer n) {
        this.print("synchronized (");
        this.printExpr(tree.lock);
        this.print(") ");
        this.printStat(tree.body);
        return null;
    }

    @Override
    public Void _case(Tree.Try tree, Integer prec) {
        this.print("try ");
        this.printStat(tree.body);
        this.print(" ");
        List<Tree.Catch> list = tree.catchers;
        while (list.nonEmpty()) {
            this.printStat((Tree)list.head);
            list = list.tail;
        }
        if (tree.finalizer != null) {
            this.print(" finally ");
            this.printStat(tree.finalizer);
        }
        return null;
    }

    @Override
    public Void _case(Tree.Catch tree, Integer n) {
        this.print(" catch (");
        this.printExpr(tree.param);
        this.print(") ");
        this.printStat(tree.body);
        return null;
    }

    @Override
    public Void _case(Tree.Conditional tree, Integer n) {
        if (tree.tag == 17) {
            this.print("if (");
            this.printExpr(tree.cond);
            this.print(") ");
            this.printStat(tree.thenpart);
            if (tree.elsepart != null) {
                this.print(" else ");
                this.printStat(tree.elsepart);
            }
        } else {
            this.open(n, 3);
            this.printExpr(tree.cond, 3);
            this.print(" ? ");
            this.printExpr(tree.thenpart, 3);
            this.print(" : ");
            this.printExpr(tree.elsepart, 3);
            this.close(n, 3);
        }
        return null;
    }

    @Override
    public Void _case(Tree.Assert tree, Integer n) {
        this.print("assert ");
        this.printExpr(tree.cond);
        if (tree.msg != null) {
            this.print(" : ");
            this.printExpr(tree.msg);
        }
        return null;
    }

    @Override
    public Void _case(Tree.Exec tree, Integer n) {
        this.printExpr(tree.expr);
        if (n == null) {
            this.print(";");
        }
        return null;
    }

    @Override
    public Void _case(Tree.Break tree, Integer n) {
        this.print("break");
        if (tree.label != null) {
            this.print(String.valueOf(" ").concat(String.valueOf(tree.label)));
        }
        this.print(";");
        return null;
    }

    @Override
    public Void _case(Tree.Continue tree, Integer n) {
        this.print("continue");
        if (tree.label != null) {
            this.print(String.valueOf(" ").concat(String.valueOf(tree.label)));
        }
        this.print(";");
        return null;
    }

    @Override
    public Void _case(Tree.Return tree, Integer n) {
        this.print("return");
        if (tree.expr != null) {
            this.print(" ");
            this.printExpr(tree.expr);
        }
        this.print(";");
        return null;
    }

    @Override
    public Void _case(Tree.Throw tree, Integer n) {
        this.print("throw ");
        this.printExpr(tree.expr);
        this.print(";");
        return null;
    }

    @Override
    public Void _case(Tree.Apply tree, Integer n) {
        this.printExpr(tree.meth);
        this.print("(");
        this.printExprs(tree.args);
        this.print(")");
        return null;
    }

    @Override
    public Void _case(Tree.NewClass tree, Integer prec) {
        if (tree.encl != null) {
            this.printExpr(tree.encl);
            this.print(".");
        }
        if (tree.at != null) {
            this.print(" /** @at ");
            this.printExpr(tree.at);
            this.print(" */ ");
        }
        this.print("new ");
        this.printExpr(tree.clazz);
        this.print("(");
        this.printExprs(tree.args);
        this.print(")");
        if (tree.def != null) {
            Name name = this.enclClassName;
            this.enclClassName = null;
            this.printBlock(tree.def.defs);
            this.enclClassName = name;
        }
        return null;
    }

    @Override
    public Void _case(Tree.NewArray tree, Integer prec) {
        if (tree.elemtype != null) {
            this.print("new ");
            int n = 0;
            Tree elemtype = tree.elemtype;
            while (elemtype.tag == 34) {
                ++n;
                elemtype = ((Tree.TypeArray)elemtype).elemtype;
            }
            this.printExpr(elemtype);
            List<Tree> l = tree.dims;
            while (l.nonEmpty()) {
                this.print("[");
                this.printExpr((Tree)l.head);
                this.print("]");
                l = l.tail;
            }
            for (int i = 0; i < n; ++i) {
                this.print("[]");
            }
            if (tree.elems != null) {
                this.print("[]");
            }
        }
        if (tree.elems != null) {
            this.print("{");
            this.printExprs(tree.elems);
            this.print("}");
        }
        return null;
    }

    @Override
    public Void _case(Tree.Assign tree, Integer n) {
        this.open(n, 1);
        this.printExpr(tree.lhs, 2);
        this.print(" = ");
        this.printExpr(tree.rhs, 1);
        this.close(n, 1);
        return null;
    }

    @Override
    public Void _case(Tree.Assignop tree, Integer n) {
        this.open(n, 2);
        this.printExpr(tree.lhs, 3);
        this.print(String.valueOf(String.valueOf(" ").concat(String.valueOf(TreeInfo.operatorName(tree.tag - 17)))).concat(String.valueOf("= ")));
        this.printExpr(tree.rhs, 2);
        this.close(n, 2);
        return null;
    }

    @Override
    public Void _case(Tree.Operation tree, Integer prec) {
        int ownprec = TreeInfo.opPrec(tree.tag);
        String string = TreeInfo.operatorName(tree.tag).toString();
        this.open(prec, ownprec);
        if (tree.tag <= 43) {
            this.print(string);
            this.printExpr((Tree)tree.args.head, ownprec);
        } else if (tree.tag <= 45) {
            this.printExpr((Tree)tree.args.head, ownprec);
            this.print(string);
        } else {
            this.printExpr((Tree)tree.args.head, ownprec);
            this.print(String.valueOf(String.valueOf(" ").concat(String.valueOf(string))).concat(String.valueOf(" ")));
            this.printExpr((Tree)tree.args.tail.head, ownprec + 1);
        }
        this.close(prec, ownprec);
        return null;
    }

    @Override
    public Void _case(Tree.TypeCast tree, Integer n) {
        this.open(n, 14);
        this.print("(");
        this.printExpr(tree.clazz);
        this.print(")");
        this.printExpr(tree.expr, 14);
        this.close(n, 14);
        return null;
    }

    @Override
    public Void _case(Tree.TypeTest tree, Integer n) {
        this.open(n, 10);
        this.printExpr(tree.expr, 10);
        this.print(" instanceof ");
        this.printExpr(tree.clazz, 11);
        this.close(n, 10);
        return null;
    }

    @Override
    public Void _case(Tree.Indexed tree, Integer n) {
        this.printExpr(tree.indexed, 15);
        this.print("[");
        this.printExpr(tree.index);
        this.print("]");
        return null;
    }

    @Override
    public Void _case(Tree.Select tree, Integer n) {
        this.printExpr(tree.selected, 15);
        this.print(String.valueOf(".").concat(String.valueOf(tree.name)));
        return null;
    }

    @Override
    public Void _case(Tree.Ident tree, Integer n) {
        this.printPos(tree);
        this.print(tree.name.toString());
        return null;
    }

    @Override
    public Void _case(Tree.Literal tree, Integer n) {
        switch (tree.typetag) {
            case 1: {
                this.print(String.valueOf("(byte)").concat(String.valueOf(tree.value.toString())));
                break;
            }
            case 3: {
                this.print(String.valueOf("(short)").concat(String.valueOf(tree.value.toString())));
                break;
            }
            case 4: {
                this.print(tree.value.toString());
                break;
            }
            case 5: {
                this.print(String.valueOf(tree.value.toString()).concat(String.valueOf("L")));
                break;
            }
            case 6: {
                this.print(String.valueOf(tree.value.toString()).concat(String.valueOf("F")));
                break;
            }
            case 7: {
                this.print(tree.value.toString());
                break;
            }
            case 2: {
                this.print(String.valueOf(String.valueOf("'").concat(String.valueOf(Convert.quote(String.valueOf((char)((Number)tree.value).intValue()))))).concat(String.valueOf("'")));
                break;
            }
            case 10: {
                this.print(String.valueOf(String.valueOf("\"").concat(String.valueOf(Convert.quote((String)tree.value)))).concat(String.valueOf("\"")));
                break;
            }
            default: {
                this.print(tree.value.toString());
            }
        }
        return null;
    }

    @Override
    public Void _case(Tree.TypeIdent tree, Integer n) {
        this.print(Type.typeOfTag[tree.typetag].tsym.name.toString());
        return null;
    }

    @Override
    public Void _case(Tree.TypeArray tree, Integer n) {
        this.printExpr(tree.elemtype);
        this.print("[]");
        return null;
    }

    @Override
    public Void _case(Tree.TypeApply tree, Integer n) {
        this.printExpr(tree.clazz);
        this.print("<");
        this.printExprs(tree.arguments);
        this.print(">");
        return null;
    }

    @Override
    public Void _case(Tree.TypeParameter tree, Integer n) {
        this.print(tree.name.toString());
        if (tree.extBound != null) {
            this.print(" extends ");
            this.printExpr(tree.extBound);
        } else if (tree.implBound != null) {
            this.print(" implements ");
            this.printExpr(tree.implBound);
        }
        return null;
    }

    @Override
    public Void _case(Tree.Erroneous tree, Integer n) {
        this.print("(ERROR)");
        return null;
    }

    @Override
    public Void _case(Tree tree, Integer n) {
        this.print(String.valueOf(String.valueOf("(UNKNOWN: ").concat(String.valueOf(tree))).concat(String.valueOf(")")));
        this.println();
        return null;
    }

    @Override
    public /* synthetic */ Object _case(Tree x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Erroneous x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeApply x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeArray x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Literal x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Ident x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Select x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Indexed x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeTest x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeCast x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Operation x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assignop x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assign x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewArray x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewClass x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Apply x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Throw x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Return x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Continue x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Break x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Exec x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assert x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Conditional x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Catch x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Try x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Synchronized x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Case x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Switch x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Labelled x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ForLoop x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.DoLoop x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Block x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.VarDef x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.MethodDef x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ClassDef x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Import x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TopLevel x0, Object object) {
        return this._case(x0, (Integer)object);
    }

    static {
        for (int i = 0; i < 16; ++i) {
            Pretty.Precedence[i] = new Integer(i);
        }
    }
}

