/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.tree;

import gjc.v6.code.Scope;
import gjc.v6.code.Symbol;
import gjc.v6.code.Type;
import gjc.v6.util.List;
import gjc.v6.util.ListBuffer;
import gjc.v6.util.Name;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Tree {
    public static final int TOPLEVEL = 1;
    public static final int IMPORT = 2;
    public static final int CLASSDEF = 3;
    public static final int METHODDEF = 4;
    public static final int VARDEF = 5;
    public static final int BLOCK = 6;
    public static final int DOLOOP = 7;
    public static final int WHILELOOP = 8;
    public static final int FORLOOP = 9;
    public static final int LABELLED = 10;
    public static final int SWITCH = 11;
    public static final int CASE = 12;
    public static final int SYNCHRONIZED = 13;
    public static final int TRY = 14;
    public static final int CATCH = 15;
    public static final int CONDEXPR = 16;
    public static final int CONDSTAT = 17;
    public static final int ASSERT = 17;
    public static final int EXEC = 18;
    public static final int BREAK = 19;
    public static final int CONTINUE = 20;
    public static final int RETURN = 21;
    public static final int THROW = 22;
    public static final int APPLY = 23;
    public static final int NEWCLASS = 24;
    public static final int NEWARRAY = 25;
    public static final int ASSIGN = 26;
    public static final int TYPECAST = 27;
    public static final int TYPETEST = 28;
    public static final int INDEXED = 29;
    public static final int SELECT = 30;
    public static final int IDENT = 31;
    public static final int LITERAL = 32;
    public static final int TYPEIDENT = 33;
    public static final int TYPEARRAY = 34;
    public static final int TYPEAPPLY = 35;
    public static final int TYPEPARAMETER = 36;
    public static final int ERRONEOUS = 37;
    public static final int POS = 38;
    public static final int NEG = 39;
    public static final int NOT = 40;
    public static final int COMPL = 41;
    public static final int PREINC = 42;
    public static final int PREDEC = 43;
    public static final int POSTINC = 44;
    public static final int POSTDEC = 45;
    public static final int OR = 46;
    public static final int AND = 47;
    public static final int BITOR = 48;
    public static final int BITXOR = 49;
    public static final int BITAND = 50;
    public static final int EQ = 51;
    public static final int NE = 52;
    public static final int LT = 53;
    public static final int GT = 54;
    public static final int LE = 55;
    public static final int GE = 56;
    public static final int SL = 57;
    public static final int SR = 58;
    public static final int USR = 59;
    public static final int PLUS = 60;
    public static final int MINUS = 61;
    public static final int MUL = 62;
    public static final int DIV = 63;
    public static final int MOD = 64;
    public static final int BITOR_ASG = 65;
    public static final int BITXOR_ASG = 66;
    public static final int BITAND_ASG = 67;
    public static final int SL_ASG = 74;
    public static final int SR_ASG = 75;
    public static final int USR_ASG = 76;
    public static final int PLUS_ASG = 77;
    public static final int MINUS_ASG = 78;
    public static final int MUL_ASG = 79;
    public static final int DIV_ASG = 80;
    public static final int MOD_ASG = 81;
    public static final int ASGOffset = 17;
    public int pos;
    public int internalPos;
    public Type type;
    public int tag;
    public static final List<Tree> emptyList = new List();
    public static int count = 0;

    public Tree(int n) {
        this.tag = n;
    }

    public Tree setPos(int pos, int n) {
        this.pos = pos;
        this.internalPos = n;
        return this;
    }

    public Tree setType(Type type) {
        this.type = type;
        return this;
    }

    public <R, A> R visit(Visitor<R, A> v, A a) {
        return v._case(this, a);
    }

    public static <R, A, T extends Tree> List<R> mapVisit(List<T> these, Visitor<R, A> v, A arg) {
        ListBuffer<R> results = new ListBuffer<R>();
        List<Object> l = these;
        while (l.nonEmpty()) {
            results.append(((Tree)l.head).visit(v, arg));
            l = l.tail;
        }
        return results.toList();
    }

    public static <R, A, T extends Tree> void doVisit(List<T> these, Visitor<R, A> v, A arg) {
        List<Object> l = these;
        while (l.nonEmpty()) {
            ((Tree)l.head).visit(v, arg);
            l = l.tail;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Visitor<R, A> {
        public R _case(TopLevel that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Import that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(ClassDef that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(MethodDef that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(VarDef that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Block that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(DoLoop that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(WhileLoop that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(ForLoop that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Labelled that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Switch that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Case that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Synchronized that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Try that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Catch that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Conditional that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Assert that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Exec that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Break that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Continue that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Return that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Throw that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Apply that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(NewClass that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(NewArray that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Assign that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Assignop that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Operation that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(TypeCast that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(TypeTest that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Indexed that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Select that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Ident that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Literal that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(TypeIdent that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(TypeArray that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(TypeApply that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(TypeParameter that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Erroneous that, A a) {
            return this._case((Tree)that, a);
        }

        public R _case(Tree that, A a) {
            throw new InternalError(String.valueOf("unexpected: ").concat(String.valueOf(that)));
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory {
        public TopLevel TopLevel(Tree var1, List<Tree> var2);

        public Import Import(Tree var1);

        public ClassDef ClassDef(int var1, Name var2, List<TypeParameter> var3, Tree var4, List<Tree> var5, List<Tree> var6);

        public MethodDef MethodDef(int var1, Name var2, Tree var3, List<TypeParameter> var4, List<VarDef> var5, List<Tree> var6, Block var7);

        public VarDef VarDef(int var1, Name var2, Tree var3, Tree var4);

        public Block Block(int var1, List<Tree> var2);

        public DoLoop DoLoop(Tree var1, Tree var2);

        public WhileLoop WhileLoop(Tree var1, Tree var2);

        public ForLoop ForLoop(List<Tree> var1, Tree var2, List<Tree> var3, Tree var4);

        public Labelled Labelled(Name var1, Tree var2);

        public Switch Switch(Tree var1, List<Case> var2);

        public Case Case(Tree var1, List<Tree> var2);

        public Synchronized Synchronized(Tree var1, Tree var2);

        public Try Try(Tree var1, List<Catch> var2, Tree var3);

        public Catch Catch(VarDef var1, Tree var2);

        public Conditional Conditional(int var1, Tree var2, Tree var3, Tree var4);

        public Assert Assert(Tree var1, Tree var2);

        public Exec Exec(Tree var1);

        public Break Break(Name var1);

        public Continue Continue(Name var1);

        public Return Return(Tree var1);

        public Throw Throw(Tree var1);

        public Apply Apply(Tree var1, List<Tree> var2);

        public NewClass NewClass(Tree var1, Tree var2, List<Tree> var3, ClassDef var4);

        public NewArray NewArray(Tree var1, List<Tree> var2, List<Tree> var3);

        public Assign Assign(Tree var1, Tree var2);

        public Assignop Assignop(int var1, Tree var2, Tree var3);

        public Operation Operation(int var1, List<Tree> var2);

        public TypeCast TypeCast(Tree var1, Tree var2);

        public TypeTest TypeTest(Tree var1, Tree var2);

        public Indexed Indexed(Tree var1, Tree var2);

        public Select Select(Tree var1, Name var2);

        public Ident Ident(Name var1);

        public Literal Literal(int var1, Object var2);

        public TypeIdent TypeIdent(int var1);

        public TypeArray TypeArray(Tree var1);

        public TypeApply TypeApply(Tree var1, List<Tree> var2);

        public TypeParameter TypeParameter(Name var1, Tree var2, Tree var3);

        public Erroneous Erroneous();
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Erroneous
    extends Tree {
        public Erroneous() {
            super(37);
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeParameter
    extends Tree {
        public Name name;
        public Tree extBound;
        public Tree implBound;
        public static final List<TypeParameter> emptyList = new List();

        public TypeParameter(Name name, Tree extBound, Tree tree) {
            super(36);
            this.name = name;
            this.extBound = extBound;
            this.implBound = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeApply
    extends Tree {
        public Tree clazz;
        public List<Tree> arguments;

        public TypeApply(Tree clazz, List<Tree> list) {
            super(35);
            this.clazz = clazz;
            this.arguments = list;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeArray
    extends Tree {
        public Tree elemtype;

        public TypeArray(Tree tree) {
            super(34);
            this.elemtype = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeIdent
    extends Tree {
        public int typetag;

        public TypeIdent(int n) {
            super(33);
            this.typetag = n;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Literal
    extends Tree {
        public int typetag;
        public Object value;

        public Literal(int typetag, Object object) {
            super(32);
            this.typetag = typetag;
            this.value = object;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Ident
    extends Tree {
        public Name name;
        public Symbol sym;

        public Ident(Name name, Symbol symbol) {
            super(31);
            this.name = name;
            this.sym = symbol;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Select
    extends Tree {
        public Tree selected;
        public Name name;
        public Symbol sym;

        public Select(Tree selected, Name name, Symbol symbol) {
            super(30);
            this.selected = selected;
            this.name = name;
            this.sym = symbol;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Indexed
    extends Tree {
        public Tree indexed;
        public Tree index;

        public Indexed(Tree indexed, Tree tree) {
            super(29);
            this.indexed = indexed;
            this.index = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeTest
    extends Tree {
        public Tree expr;
        public Tree clazz;

        public TypeTest(Tree expr, Tree tree) {
            super(28);
            this.expr = expr;
            this.clazz = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeCast
    extends Tree {
        public Tree clazz;
        public Tree expr;

        public TypeCast(Tree clazz, Tree tree) {
            super(27);
            this.clazz = clazz;
            this.expr = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Operation
    extends Tree {
        public List<Tree> args;
        public Symbol operator;

        public Operation(int opcode, List<Tree> args, Symbol symbol) {
            super(opcode);
            this.args = args;
            this.operator = symbol;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Assignop
    extends Tree {
        public Tree lhs;
        public Tree rhs;
        public Symbol operator;

        public Assignop(int opcode, Tree lhs, Tree rhs, Symbol symbol) {
            super(opcode);
            this.lhs = lhs;
            this.rhs = rhs;
            this.operator = symbol;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Assign
    extends Tree {
        public Tree lhs;
        public Tree rhs;

        public Assign(Tree lhs, Tree tree) {
            super(26);
            this.lhs = lhs;
            this.rhs = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewArray
    extends Tree {
        public Tree elemtype;
        public List<Tree> dims;
        public List<Tree> elems;

        public NewArray(Tree elemtype, List<Tree> dims, List<Tree> list) {
            super(25);
            this.elemtype = elemtype;
            this.dims = dims;
            this.elems = list;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewClass
    extends Tree {
        public Tree encl;
        public Tree clazz;
        public List<Tree> args;
        public Tree at;
        public ClassDef def;
        public Symbol constructor;

        public NewClass(Tree encl, Tree clazz, List<Tree> args, ClassDef def, Symbol symbol) {
            super(24);
            this.encl = encl;
            this.clazz = clazz;
            this.args = args;
            this.def = def;
            this.constructor = symbol;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Apply
    extends Tree {
        public Tree meth;
        public List<Tree> args;

        public Apply(Tree meth, List<Tree> list) {
            super(23);
            this.meth = meth;
            this.args = list;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Throw
    extends Tree {
        public Tree expr;

        public Throw(Tree tree) {
            super(22);
            this.expr = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Return
    extends Tree {
        public Tree expr;

        public Return(Tree tree) {
            super(21);
            this.expr = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Continue
    extends Tree {
        public Name label;
        public Tree target;

        public Continue(Name label, Tree tree) {
            super(20);
            this.label = label;
            this.target = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Break
    extends Tree {
        public Name label;
        public Tree target;

        public Break(Name label, Tree tree) {
            super(19);
            this.label = label;
            this.target = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Exec
    extends Tree {
        public Tree expr;

        public Exec(Tree tree) {
            super(18);
            this.expr = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Assert
    extends Tree {
        public Tree cond;
        public Tree msg;

        public Assert(Tree cond, Tree tree) {
            super(17);
            this.cond = cond;
            this.msg = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Conditional
    extends Tree {
        public Tree cond;
        public Tree thenpart;
        public Tree elsepart;

        public Conditional(int tag, Tree cond, Tree thenpart, Tree tree) {
            super(tag);
            this.cond = cond;
            this.thenpart = thenpart;
            this.elsepart = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Catch
    extends Tree {
        public VarDef param;
        public Tree body;
        public static List<Catch> emptyList = new List();

        public Catch(VarDef param, Tree tree) {
            super(15);
            this.param = param;
            this.body = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Try
    extends Tree {
        public Tree body;
        public List<Catch> catchers;
        public Tree finalizer;

        public Try(Tree body, List<Catch> catchers, Tree tree) {
            super(14);
            this.body = body;
            this.catchers = catchers;
            this.finalizer = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Synchronized
    extends Tree {
        public Tree lock;
        public Tree body;

        public Synchronized(Tree lock, Tree tree) {
            super(13);
            this.lock = lock;
            this.body = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Case
    extends Tree {
        public Tree pat;
        public List<Tree> stats;

        public Case(Tree pat, List<Tree> list) {
            super(12);
            this.pat = pat;
            this.stats = list;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Switch
    extends Tree {
        public Tree selector;
        public List<Case> cases;

        public Switch(Tree selector, List<Case> list) {
            super(11);
            this.selector = selector;
            this.cases = list;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Labelled
    extends Tree {
        public Name label;
        public Tree body;

        public Labelled(Name label, Tree tree) {
            super(10);
            this.label = label;
            this.body = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForLoop
    extends Tree {
        public List<Tree> init;
        public Tree cond;
        public List<Tree> step;
        public Tree body;

        public ForLoop(List<Tree> init, Tree cond, List<Tree> step, Tree tree) {
            super(9);
            this.init = init;
            this.cond = cond;
            this.step = step;
            this.body = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WhileLoop
    extends Tree {
        public Tree cond;
        public Tree body;

        public WhileLoop(Tree cond, Tree tree) {
            super(8);
            this.cond = cond;
            this.body = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoLoop
    extends Tree {
        public Tree body;
        public Tree cond;

        public DoLoop(Tree body, Tree tree) {
            super(7);
            this.body = body;
            this.cond = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Block
    extends Tree {
        public int flags;
        public List<Tree> stats;

        public Block(int flags, List<Tree> list) {
            super(6);
            this.stats = list;
            this.flags = flags;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VarDef
    extends Tree {
        public int flags;
        public Name name;
        public Tree vartype;
        public Tree init;
        public Tree merge;
        public Symbol.VarSymbol sym;
        public static final List<VarDef> emptyList = new List();

        public VarDef(int flags, Name name, Tree vartype, Tree init, Symbol.VarSymbol varSymbol) {
            super(5);
            this.flags = flags;
            this.name = name;
            this.vartype = vartype;
            this.init = init;
            this.sym = varSymbol;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodDef
    extends Tree {
        public int flags;
        public Name name;
        public Tree restype;
        public List<TypeParameter> typarams;
        public List<VarDef> params;
        public List<Tree> thrown;
        public Block body;
        public Symbol.MethodSymbol sym;

        public MethodDef(int flags, Name name, Tree restype, List<TypeParameter> typarams, List<VarDef> params, List<Tree> thrown, Block body, Symbol.MethodSymbol methodSymbol) {
            super(4);
            this.flags = flags;
            this.name = name;
            this.restype = restype;
            this.typarams = typarams;
            this.params = params;
            this.thrown = thrown;
            this.body = body;
            this.sym = methodSymbol;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassDef
    extends Tree {
        public int flags;
        public Name name;
        public List<TypeParameter> typarams;
        public Tree extending;
        public List<Tree> implementing;
        public List<Tree> defs;
        public Symbol.ClassSymbol sym;

        public ClassDef(int flags, Name name, List<TypeParameter> typarams, Tree extending, List<Tree> implementing, List<Tree> defs, Symbol.ClassSymbol classSymbol) {
            super(3);
            this.flags = flags;
            this.name = name;
            this.typarams = typarams;
            this.extending = extending;
            this.implementing = implementing;
            this.defs = defs;
            this.sym = classSymbol;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Import
    extends Tree {
        public Tree qualid;

        public Import(Tree tree) {
            super(2);
            this.qualid = tree;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TopLevel
    extends Tree {
        public Tree pid;
        public List<Tree> defs;
        public Name sourcefile;
        public Symbol.PackageSymbol packge;
        public Scope namedImportScope;
        public Scope starImportScope;

        public TopLevel(Tree pid, List<Tree> defs, Name sourcefile, Symbol.PackageSymbol packge, Scope namedImportScope, Scope scope) {
            super(1);
            this.pid = pid;
            this.defs = defs;
            this.sourcefile = sourcefile;
            this.packge = packge;
            this.namedImportScope = namedImportScope;
            this.starImportScope = scope;
        }

        @Override
        public <R, A> R visit(Visitor<R, A> v, A a) {
            return v._case(this, a);
        }
    }
}

