/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.util;

import gjc.v6.util.Base;

public class Bits {
    static final int wordlen = 32;
    static final int wordshift = 5;
    static final int wordmask = 31;
    private int[] bits;

    public Bits() {
        this(new int[1]);
    }

    public Bits(int[] nArray) {
        this.bits = nArray;
    }

    public Bits(int start, int n) {
        this();
        this.inclRange(start, n);
    }

    private void sizeTo(int len) {
        if (this.bits.length < len) {
            int[] nArray = new int[len];
            System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
            this.bits = nArray;
        }
    }

    public void clear() {
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = 0;
        }
    }

    public Bits dup() {
        int[] nArray = new int[this.bits.length];
        System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
        return new Bits(nArray);
    }

    public void incl(int n) {
        Base._assert(n >= 0);
        this.sizeTo((n >>> 5) + 1);
        this.bits[n >>> 5] = this.bits[n >>> 5] | 1 << (n & 0x1F);
    }

    public void inclRange(int start, int limit) {
        this.sizeTo((limit >>> 5) + 1);
        for (int i = start; i < limit; ++i) {
            this.bits[i >>> 5] = this.bits[i >>> 5] | 1 << (i & 0x1F);
        }
    }

    public void excl(int n) {
        Base._assert(n >= 0);
        this.sizeTo((n >>> 5) + 1);
        this.bits[n >>> 5] = this.bits[n >>> 5] & ~(1 << (n & 0x1F));
    }

    public boolean member(int n) {
        return 0 <= n && n < this.bits.length << 5 && (this.bits[n >>> 5] & 1 << (n & 0x1F)) != 0;
    }

    public Bits andSet(Bits xs) {
        this.sizeTo(xs.bits.length);
        for (int i = 0; i < xs.bits.length; ++i) {
            this.bits[i] = this.bits[i] & xs.bits[i];
        }
        return this;
    }

    public Bits orSet(Bits xs) {
        this.sizeTo(xs.bits.length);
        for (int i = 0; i < xs.bits.length; ++i) {
            this.bits[i] = this.bits[i] | xs.bits[i];
        }
        return this;
    }

    public String toString() {
        char[] digits = new char[this.bits.length * 32];
        for (int i = 0; i < this.bits.length * 32; ++i) {
            digits[i] = this.member(i) ? 49 : 48;
        }
        return new String(digits);
    }
}

