/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.util;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hashtable<Key, Data> {
    private int hashSize;
    private int hashMask;
    private int limit;
    private int size;
    private Entry<Key, Data>[] table;

    public Hashtable(int initialSize, float fillFactor) {
        int n;
        for (n = 1; n < initialSize; n <<= 1) {
        }
        this.hashSize = n;
        this.hashMask = n - 1;
        this.limit = (int)((float)n * fillFactor);
        this.size = 0;
        this.table = new Entry[n];
    }

    public Hashtable(int n) {
        this(n, 0.75f);
    }

    public Hashtable() {
        this(32);
    }

    public static <A, B> Hashtable<A, B> make() {
        return new Hashtable();
    }

    private void dble() {
        this.hashSize <<= 1;
        this.hashMask = this.hashSize - 1;
        this.limit <<= 1;
        Entry<Key, Data>[] oldtable = this.table;
        this.table = new Entry[this.hashSize];
        for (int i = 0; i < oldtable.length; ++i) {
            this.copy(oldtable[i]);
        }
    }

    private void copy(Entry<Key, Data> entry) {
        if (entry != null) {
            this.copy(entry.next);
            entry.next = this.table[entry.hash & this.hashMask];
            this.table[entry.hash & this.hashMask] = entry;
        }
    }

    public Data get(Key key) {
        int hash = key.hashCode();
        Entry<Key, Data> entry = this.table[hash & this.hashMask];
        while (entry != null) {
            if (entry.hash == hash && entry.key.equals(key)) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Data put(Key key, Data value) {
        int hash = key.hashCode();
        Entry<Key, Data> e = this.table[hash & this.hashMask];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Object oldvalue = e.value;
                e.value = value;
                return oldvalue;
            }
            e = e.next;
        }
        ++this.size;
        if (this.size > this.limit) {
            this.dble();
        }
        int index = hash & this.hashMask;
        Entry<Key, Data> entry = new Entry<Key, Data>(key, value, hash, this.table[index]);
        this.table[index] = entry;
        return null;
    }

    public Data remove(Key key) {
        int hash = key.hashCode();
        Entry<Key, Data> prev = null;
        Entry<Key, Data> entry = this.table[hash & this.hashMask];
        while (entry != null) {
            if (entry.hash == hash && entry.key.equals(key)) {
                if (prev != null) {
                    prev.next = entry.next;
                } else {
                    this.table[hash & this.hashMask] = entry.next;
                }
                --this.size;
                return entry.value;
            }
            prev = entry;
            entry = entry.next;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void reset() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.size = 0;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<Key, Data> {
        Key key;
        Data value;
        int hash;
        Entry<Key, Data> next;

        Entry(Key key, Data value, int hash, Entry<Key, Data> entry) {
            this.key = key;
            this.value = value;
            this.hash = hash;
            this.next = entry;
        }
    }
}

