/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.util;

import gjc.v6.util.Enumeration;
import gjc.v6.util.List;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBuffer<A> {
    public List<A> elems = new List();
    public List<A> last = this.elems;
    public int count = 0;
    public boolean isshared = false;

    public int length() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean nonEmpty() {
        return this.count != 0;
    }

    private void copy() {
        List<A> list = this.elems;
        this.elems = new List();
        this.last = this.elems;
        while (list.nonEmpty()) {
            this.last.head = list.head;
            this.last.tail = new List();
            this.last = this.last.tail;
            list = list.tail;
        }
        this.isshared = false;
    }

    public ListBuffer<A> prepend(A a) {
        if (this.isshared) {
            this.copy();
        }
        this.elems = this.elems.prepend(a);
        ++this.count;
        return this;
    }

    public ListBuffer<A> append(A a) {
        if (this.isshared) {
            this.copy();
        }
        this.last.head = a;
        this.last.tail = new List();
        this.last = this.last.tail;
        ++this.count;
        return this;
    }

    public ListBuffer<A> append(List<A> list) {
        while (list.nonEmpty()) {
            this.append(list.head);
            list = list.tail;
        }
        return this;
    }

    public ListBuffer<A> append(A[] xs) {
        for (int i = 0; i < xs.length; ++i) {
            this.append(xs[i]);
        }
        return this;
    }

    public List<A> toList() {
        this.isshared = true;
        return this.elems;
    }

    public A first() {
        return this.elems.head;
    }

    public void remove() {
        if (this.elems != this.last) {
            this.elems = this.elems.tail;
            --this.count;
        }
    }

    public Enumeration<A> elements() {
        return new Enumerator<A>(this.elems, this.last);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Enumerator<A>
    implements Enumeration<A> {
        List<A> elems;
        List<A> last;

        Enumerator(List<A> elems, List<A> list) {
            this.elems = elems;
            this.last = list;
        }

        @Override
        public boolean hasMoreElements() {
            return this.elems != this.last;
        }

        @Override
        public A nextElement() {
            Object a = this.elems.head;
            this.elems = this.elems.tail;
            return a;
        }
    }
}

