/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.util;

import gjc.v6.util.LayoutCharacters;
import gjc.v6.util.Name;
import gjc.v6.util.Names;
import gjc.v6.util.Pair;
import gjc.v6.util.Position;
import gjc.v6.util.Set;
import java.io.FileInputStream;
import java.io.IOException;

public class Log
implements LayoutCharacters {
    public int MaxErrors = 100;
    public int MaxWarnings = 100;
    public boolean promptOnError;
    public boolean emitWarnings;
    private Name sourcename = Names.__input;
    public int nerrors = 0;
    public int nwarnings = 0;
    private Set<Pair<Name, Integer>> recorded = Set.make();
    private byte[] buf = null;
    private int bp;
    private int lastLine;

    public Log(boolean promptOnError, boolean bl) {
        this.promptOnError = promptOnError;
        this.emitWarnings = bl;
    }

    public Log() {
        this(false, true);
    }

    public Name useSource(Name name) {
        Name name2 = this.sourcename;
        this.sourcename = name;
        if (name2 != this.sourcename) {
            this.buf = null;
        }
        return name2;
    }

    public void print(String string) {
        System.err.print(string);
    }

    public void println(String string) {
        this.print(String.valueOf(string).concat(String.valueOf("\n")));
    }

    public void prompt() {
        if (this.promptOnError) {
            System.err.println("R)esume, A)bort>");
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new InternalError("user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void printErrLine(int line, int col) {
        try {
            int lineEnd;
            if (this.buf == null) {
                FileInputStream in = new FileInputStream(this.sourcename.toString());
                this.buf = new byte[in.available()];
                in.read(this.buf);
                in.close();
                this.bp = 0;
                this.lastLine = 1;
            } else if (this.lastLine > line) {
                this.bp = 0;
                this.lastLine = 1;
            }
            block6: while (this.bp < this.buf.length && this.lastLine < line) {
                switch (this.buf[this.bp]) {
                    case 13: {
                        ++this.bp;
                        if (this.bp < this.buf.length && this.buf[this.bp] == 10) {
                            ++this.bp;
                        }
                        ++this.lastLine;
                        continue block6;
                    }
                    case 10: {
                        ++this.bp;
                        ++this.lastLine;
                        continue block6;
                    }
                }
                ++this.bp;
            }
            for (lineEnd = this.bp; lineEnd < this.buf.length && this.buf[lineEnd] != 13 && this.buf[lineEnd] != 10; ++lineEnd) {
            }
            this.println(Log.untabify(new String(this.buf, this.bp, lineEnd - this.bp)));
            byte[] ptr = new byte[col];
            for (int i = 0; i < col - 1; ++i) {
                ptr[i] = 32;
            }
            ptr[col - 1] = 94;
            this.println(new String(ptr, 0, col));
        }
        catch (IOException iOException) {
            this.println("(source unavailable)");
        }
    }

    public static String untabify(String s) {
        StringBuffer b = new StringBuffer(s);
        for (int n = 0; n < b.length(); ++n) {
            if (b.charAt(n) != '\t') continue;
            b.deleteCharAt(n);
            int stop = n - n % 8 + 8;
            while (n < stop) {
                b.insert(n, ' ');
                ++n;
            }
            --n;
        }
        return b.toString();
    }

    private void printError(int pos, String msg) {
        if (pos == 0) {
            this.println(String.valueOf(String.valueOf(String.valueOf("error: ").concat(String.valueOf(this.sourcename))).concat(String.valueOf(": "))).concat(String.valueOf(msg)));
        } else {
            int line = Position.line(pos);
            int n = Position.column(pos);
            this.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.sourcename).concat(String.valueOf(":"))).concat(String.valueOf(line))).concat(String.valueOf(": "))).concat(String.valueOf(msg)));
            this.printErrLine(line, n);
        }
    }

    public void error(int pos, String msg) {
        Pair<Name, Integer> pair;
        if (this.nerrors < this.MaxErrors && !this.recorded.contains(pair = new Pair<Name, Integer>(this.sourcename, new Integer(pos)))) {
            this.recorded.put(pair);
            this.printError(pos, msg);
            this.prompt();
            ++this.nerrors;
        }
    }

    public void fatal(int pos, String string) {
        this.error(pos, string);
        System.exit(1);
    }

    public void warning(int pos, String string) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printError(pos, String.valueOf("warning: ").concat(String.valueOf(string)));
        }
        ++this.nwarnings;
    }
}

