/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.util;

import gjc.v6.util.Convert;
import gjc.v6.util.List;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Name {
    public int index;
    public int len;
    Name next;
    private static final int HASH_SIZE = 32768;
    private static final int HASH_MASK = Short.MAX_VALUE;
    private static final int NAME_SIZE = 131072;
    private static Name[] hashtable = new Name[32768];
    public static byte[] names = new byte[131072];
    private static int nc = 0;

    private static int hashValue(byte[] cs, int start, int len) {
        if (len > 0) {
            return len * 68921 + cs[start] * 1681 + cs[start + len - 1] * 41 + cs[start + (len >> 1)];
        }
        return 0;
    }

    private static boolean equals(int index, byte[] cs, int start, int len) {
        int i;
        for (i = 0; i < len && names[index + i] == cs[start + i]; ++i) {
        }
        return i == len;
    }

    public static Name fromUtf(byte[] cs, int start, int len) {
        int h = Name.hashValue(cs, start, len) & Short.MAX_VALUE;
        Name n = hashtable[h];
        while (!(n == null || n.len == len && Name.equals(n.index, cs, start, len))) {
            n = n.next;
        }
        if (n == null) {
            while (nc + len > names.length) {
                byte[] newnames = new byte[names.length * 2];
                System.arraycopy(names, 0, newnames, 0, names.length);
                names = newnames;
            }
            System.arraycopy(cs, start, names, nc, len);
            n = new Name();
            n.index = nc;
            n.len = len;
            n.next = hashtable[h];
            Name.hashtable[h] = n;
            nc += len;
            if (len == 0) {
                ++nc;
            }
        }
        return n;
    }

    public static Name fromUtf(byte[] cs) {
        return Name.fromUtf(cs, 0, cs.length);
    }

    public static Name fromChars(char[] cs, int start, int len) {
        while (nc + cs.length * 3 >= names.length) {
            byte[] newnames = new byte[names.length * 2];
            System.arraycopy(names, 0, newnames, 0, names.length);
            names = newnames;
        }
        int nbytes = Convert.chars2utf(cs, 0, names, nc, len) - nc;
        int h = Name.hashValue(names, nc, nbytes) & Short.MAX_VALUE;
        Name n = hashtable[h];
        while (!(n == null || n.len == nbytes && Name.equals(n.index, names, nc, nbytes))) {
            n = n.next;
        }
        if (n == null) {
            n = new Name();
            n.index = nc;
            n.len = nbytes;
            n.next = hashtable[h];
            Name.hashtable[h] = n;
            nc += nbytes;
            if (nbytes == 0) {
                ++nc;
            }
        }
        return n;
    }

    public static Name fromString(String s) {
        char[] cs = s.toCharArray();
        return Name.fromChars(cs, 0, cs.length);
    }

    public byte[] toUtf() {
        byte[] byArray = new byte[this.len];
        System.arraycopy(names, this.index, byArray, 0, this.len);
        return byArray;
    }

    public List<Name> toList() {
        Name name = this;
        List<Name> list = new List<Name>();
        while (name.length() > 0) {
            list = new List<Name>(Convert.shortName(name), list);
            name = Convert.packagePart(name);
        }
        return list;
    }

    public String toString() {
        return Convert.utf2string(names, this.index, this.len);
    }

    public void getBytes(byte[] cs, int n) {
        System.arraycopy(names, this.index, cs, n, this.len);
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object object) {
        if (object instanceof Name) {
            return this.index == ((Name)object).index;
        }
        return false;
    }

    public int length() {
        return this.len;
    }

    public byte byteAt(int n) {
        return names[this.index + n];
    }

    public int indexOf(byte b) {
        int n;
        for (n = 0; n < this.len && names[this.index + n] != b; ++n) {
        }
        return n;
    }

    public int lastIndexOf(byte b) {
        int n;
        for (n = this.len - 1; n >= 0 && names[this.index + n] != b; --n) {
        }
        return n;
    }

    public boolean startsWith(Name prefix) {
        int n;
        for (n = 0; n < prefix.len && n < this.len && names[this.index + n] == names[prefix.index + n]; ++n) {
        }
        return n == prefix.len;
    }

    public boolean endsWith(Name suffix) {
        int n;
        int i = this.len - 1;
        for (n = suffix.len - 1; n >= 0 && i >= 0 && names[this.index + i] == names[suffix.index + n]; --i, --n) {
        }
        return n < 0;
    }

    public Name subName(int start, int n) {
        if (n < start) {
            n = start;
        }
        return Name.fromUtf(names, this.index + start, n - start);
    }

    public Name replace(byte from, byte to) {
        for (int i = 0; i < this.len; ++i) {
            if (names[this.index + i] != from) continue;
            byte[] bs = new byte[this.len];
            System.arraycopy(names, this.index, bs, 0, i);
            bs[i] = to;
            ++i;
            while (i < this.len) {
                byte by = names[this.index + i];
                bs[i] = by == from ? to : by;
                ++i;
            }
            return Name.fromUtf(bs, 0, this.len);
        }
        return this;
    }

    public Name append(Name n) {
        byte[] byArray = new byte[this.len + n.len];
        this.getBytes(byArray, 0);
        n.getBytes(byArray, this.len);
        return Name.fromUtf(byArray, 0, byArray.length);
    }

    public static Name concat(Name[] ns) {
        int len = 0;
        for (int i = 0; i < ns.length; ++i) {
            len += ns[i].len;
        }
        byte[] bs = new byte[len];
        len = 0;
        for (int i = 0; i < ns.length; ++i) {
            ns[i].getBytes(bs, len);
            len += ns[i].len;
        }
        return Name.fromUtf(bs, 0, len);
    }
}

