/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.util;

import java.io.File;
import java.io.FilenameFilter;

public class PathlistParser {
    protected String pathList;
    public static final FilenameFilter JAR_FILTER = new FilenameFilter(){

        public boolean accept(File dir, String string) {
            return string.endsWith(".jar");
        }
    };

    public PathlistParser(String string) {
        this.pathList = string;
    }

    public void getPaths(Callback cb) {
        int n;
        if (this.pathList == null) {
            return;
        }
        int lastidx = 0;
        while ((n = this.pathList.indexOf(File.pathSeparatorChar, lastidx)) >= 0) {
            if (n == lastidx + 1) continue;
            cb.next(this.pathList.substring(lastidx, n));
            lastidx = n + 1;
        }
        if (lastidx < this.pathList.length()) {
            cb.next(this.pathList.substring(lastidx));
        }
    }

    public void getJars(Callback callback) {
        this.getPaths(new JarAdapter(callback));
    }

    private static final class JarAdapter
    implements Callback {
        final Callback parent;

        public JarAdapter(Callback callback) {
            this.parent = callback;
        }

        public void next(String path) {
            File dir = new File(path);
            if (!dir.exists()) {
                return;
            }
            if (!dir.isDirectory()) {
                return;
            }
            String[] jars = dir.list(JAR_FILTER);
            for (int n = 0; n < jars.length; ++n) {
                File file = new File(dir, jars[n]);
                if (!file.exists() || !file.isFile()) continue;
                this.parent.next(file.getAbsolutePath());
            }
        }
    }

    public static interface Callback {
        public void next(String var1);
    }
}

