/*
 * Decompiled with CFR 0.152.
 */
package gjc.v6.util;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Set<Key> {
    private int hashSize;
    private int hashMask;
    private int limit;
    private int size;
    private Entry<Key>[] table;

    public Set(int initialSize, float fillFactor) {
        int n;
        for (n = 1; n < initialSize; n <<= 1) {
        }
        this.hashSize = n;
        this.hashMask = n - 1;
        this.limit = (int)((float)n * fillFactor);
        this.size = 0;
        this.table = new Entry[n];
    }

    public Set(int n) {
        this(n, 0.75f);
    }

    public Set() {
        this(32);
    }

    public static <A> Set<A> make() {
        return new Set();
    }

    private void dble() {
        this.hashSize <<= 1;
        this.hashMask = this.hashSize - 1;
        this.limit <<= 1;
        Entry<Key>[] oldtable = this.table;
        this.table = new Entry[this.hashSize];
        for (int i = 0; i < oldtable.length; ++i) {
            this.copy(oldtable[i]);
        }
    }

    private void copy(Entry<Key> entry) {
        if (entry != null) {
            this.copy(entry.next);
            entry.next = this.table[entry.hash & this.hashMask];
            this.table[entry.hash & this.hashMask] = entry;
        }
    }

    public boolean contains(Key key) {
        int hash = key.hashCode();
        Entry<Key> entry = this.table[hash & this.hashMask];
        while (entry != null) {
            if (entry.hash == hash && entry.key.equals(key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public boolean put(Key key) {
        int hash = key.hashCode();
        Entry<Key> e = this.table[hash & this.hashMask];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        ++this.size;
        if (this.size > this.limit) {
            this.dble();
        }
        int index = hash & this.hashMask;
        Entry<Key> entry = new Entry<Key>(key, hash, this.table[index]);
        this.table[index] = entry;
        return false;
    }

    public void reset() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.size = 0;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<Key> {
        Key key;
        int hash;
        Entry<Key> next;

        Entry(Key key, int hash, Entry<Key> entry) {
            this.key = key;
            this.hash = hash;
            this.next = entry;
        }
    }
}

