/*
 * Decompiled with CFR 0.152.
 */
package jp.lang;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;
import java.util.Random;
import jp.lang.ConfigurationException;
import jp.lang.Marker;
import jp.lang.RuntimeManager;
import jp.lang.RuntimeManager_instance_intf;
import uka.karmi.rmi.NotBoundException;
import uka.karmi.rmi.RemoteException;
import uka.karmi.rmi.registry.LocateRegistry;
import uka.karmi.rmi.registry.Registry;
import uka.karmi.rmi.server.RemoteStub;
import uka.patch.PatchInput;
import uka.patch.PatchOutput;
import uka.patch.ReferenceConsumer;
import uka.patch.ReferenceFilter;
import uka.transport.BasicIO;
import uka.transport.DeepClone;
import uka.transport.MarshalStream;
import uka.transport.TransportDescriptor;
import uka.transport.Transportable;
import uka.transport.UnmarshalStream;

public class Configuration
implements Transportable {
    InetAddress host;
    int port;
    String code;
    boolean debug = false;
    public static final int MCAST_PORT = 4711;
    public static InetAddress MCAST_GROUP;
    public static final TransportDescriptor TRANSPORT_DESCRIPTOR;
    private static final int _SIZE = 5;
    static /* synthetic */ Class class$jp$lang$Configuration;

    public Configuration(boolean debug) throws ConfigurationException {
        this(debug, null, -1, null);
    }

    public Configuration(boolean debug, String host, int port, String code) throws ConfigurationException {
        this.debug = debug;
        try {
            if (host == null) {
                host = System.getProperty("jp.host");
            }
            if (host != null) {
                this.host = InetAddress.getByName(host);
            }
        }
        catch (UnknownHostException ex) {
            throw new ConfigurationException("can not resolve hostname: " + host);
        }
        String portString = null;
        try {
            if (port <= 0 && (portString = System.getProperty("jp.port")) != null) {
                port = Integer.parseInt(portString);
            }
        }
        catch (NumberFormatException ex) {
            throw new ConfigurationException("not a port number: " + portString);
        }
        this.port = port;
        if (code == null) {
            code = System.getProperty("jp.code");
        }
        this.code = code;
    }

    protected void complete() {
        if (this.code == null) {
            this.code = System.getProperty("user.name");
        }
    }

    public Configuration completeForServer() throws ConfigurationException {
        this.complete();
        if (this.host == null) {
            try {
                this.host = InetAddress.getLocalHost();
            }
            catch (UnknownHostException ex) {
                throw new ConfigurationException("can not resolve local host");
            }
        }
        return this;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public boolean hasPort() {
        return this.port > 0;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    /*
     * Unable to fully structure code
     */
    public void run(RuntimeManager rm) {
        try {
            r = new MulticastSocket(4711);
            r.joinGroup(Configuration.MCAST_GROUP);
            if (this.debug) {
                System.err.println("Configuration: listen at " + Configuration.MCAST_GROUP + ":" + 4711);
            }
            data = new byte[1024];
            packet = new DatagramPacket(data, data.length);
            while (true) lbl-1000:
            // 5 sources

            {
                try {
                    while (true) {
                        r.receive(packet);
                        if (this.debug) {
                            System.err.println("Configuration: request packet received from " + packet.getAddress() + ":" + packet.getPort());
                        }
                        buffer = new ByteArrayInputStream(packet.getData(), 0, packet.getLength());
                        serializer = new ObjectInputStream(buffer);
                        other = (Configuration)serializer.readObject();
                        otherPort = serializer.readInt();
                        if (!other.isCompatible(this)) {
                            if (!this.debug) continue;
                            System.err.println("Configuration: not compatible: " + other);
                            continue;
                        }
                        other.completeWith(this);
                        if (this.debug) {
                            System.err.println("Configuration: accepted and completed to: " + other);
                        }
                        s = new DatagramSocket();
                        buffer = new ByteArrayOutputStream();
                        serializer = new ObjectOutputStream(buffer);
                        serializer.writeObject(other);
                        serializer.flush();
                        sdata = buffer.toByteArray();
                        spacket = new DatagramPacket(sdata, sdata.length, packet.getAddress(), otherPort);
                        s.send(spacket);
                        if (!this.debug) continue;
                        System.err.println("Configuration: answer sent to " + packet.getAddress() + ":" + otherPort);
                    }
                }
                catch (ClassNotFoundException ex) {
                    if (!this.debug) ** GOTO lbl-1000
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    if (!this.debug) ** GOTO lbl-1000
                    ex.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            if (this.debug) {
                ex.printStackTrace();
            }
            throw new InternalError("config server crashed: " + ex.toString());
        }
        ** GOTO lbl-1000
    }

    public RuntimeManager completeForClient(int timeout) throws ConfigurationException {
        this.complete();
        if (this.host == null || this.port <= 0) {
            try {
                boolean forever;
                MulticastSocket s = new MulticastSocket();
                DatagramSocket r = new DatagramSocket();
                r.setSoTimeout(1000);
                if (this.debug) {
                    System.err.println("Configuration: answer expected at: port " + r.getLocalPort());
                }
                boolean bl = forever = timeout == 0;
                while (timeout > 0 || forever) {
                    if (timeout > 0) {
                        --timeout;
                    }
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    ObjectOutputStream serializer = new ObjectOutputStream(buffer);
                    serializer.writeObject(this);
                    serializer.writeInt(r.getLocalPort());
                    serializer.flush();
                    byte[] data = buffer.toByteArray();
                    DatagramPacket packet = new DatagramPacket(data, data.length, MCAST_GROUP, 4711);
                    s.send(packet);
                    if (this.debug) {
                        System.err.println("Configuration: request sent: " + this);
                    }
                    byte[] data2 = new byte[1024];
                    DatagramPacket packet2 = new DatagramPacket(data2, data2.length);
                    try {
                        Configuration other;
                        do {
                            r.receive(packet2);
                            ByteArrayInputStream buffer2 = new ByteArrayInputStream(packet2.getData(), 0, packet2.getLength());
                            ObjectInputStream serializer2 = new ObjectInputStream(buffer2);
                            other = (Configuration)serializer2.readObject();
                            if (!this.debug) continue;
                            System.err.println("Configuration: answer received: " + other);
                        } while (!this.isCompatible(other));
                        this.completeWith(other);
                        if (this.debug) {
                            System.err.println("Configuration: completed to: " + this);
                        }
                        RuntimeManager rm = other.getRuntimeManager(timeout);
                        return rm;
                    }
                    catch (ClassNotFoundException ex) {
                    }
                    catch (InterruptedIOException ex) {
                        if (!this.debug) continue;
                        System.err.println("no answer.");
                    }
                    catch (IOException ex) {
                        if (!this.debug) continue;
                        System.err.println(ex.toString());
                    }
                }
            }
            catch (IOException ex) {
                throw new ConfigurationException("problem while contacting server: " + ex.toString());
            }
            throw new ConfigurationException("no server responding");
        }
        return this.getRuntimeManager(timeout);
    }

    public boolean isCompatible(Configuration other) {
        if (this.host != null && !this.host.equals(other.host)) {
            return false;
        }
        if (this.hasPort() && this.port != other.port) {
            return false;
        }
        return this.code == null || this.code.equals(other.code);
    }

    public void completeWith(Configuration other) {
        if (this.host == null) {
            this.host = other.host;
        }
        if (this.port <= 0) {
            this.port = other.port;
        }
        if (this.code == null) {
            this.code = other.code;
        }
    }

    public final String toString() {
        return "(jp.host=" + (this.host == null ? "any" : this.host.toString()) + " jp.port=" + (this.port <= 0 ? "any" : Integer.toString(this.port)) + " jp.code=" + (this.code == null ? "any" : this.code) + ")";
    }

    public RuntimeManager getRuntimeManager(int timeout) throws ConfigurationException {
        RuntimeManager rm;
        if (this.debug) {
            System.err.println("lookup runtime manager at " + this);
        }
        Registry registry = null;
        try {
            RuntimeManager_instance_intf rmintf;
            boolean forever = timeout == 0;
            while (true) {
                try {
                    if (registry == null) {
                        if (this.debug) {
                            System.err.println("trying registry access");
                        }
                        registry = this.getPort() > 0 ? LocateRegistry.getRegistry((String)this.getHost().getHostAddress(), (int)this.getPort()) : LocateRegistry.getRegistry((String)this.getHost().getHostAddress());
                        if (this.debug) {
                            System.err.println("registry found.");
                        }
                    }
                    if (this.debug) {
                        System.err.println("trying runtime access.");
                    }
                    rmintf = (RuntimeManager_instance_intf)registry.lookup("jp.lang.RuntimeManager");
                }
                catch (RemoteException ex) {
                    if (timeout > 0) {
                        --timeout;
                    }
                    if (timeout > 0 || forever) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException exx) {}
                        continue;
                    }
                    if (this.debug && ex.getCause() != null) {
                        ex.getCause().printStackTrace();
                    }
                    throw new ConfigurationException("can not lookup runtime manager: " + (Object)((Object)ex));
                }
                break;
            }
            rm = new RuntimeManager((Marker)null);
            rm._init(((RemoteStub)rmintf)._KARMI_getRemoteClientRef());
        }
        catch (NotBoundException ex) {
            throw new ConfigurationException("runtime manager not bound in registry: " + ex.getMessage());
        }
        if (this.debug) {
            System.err.println("runtime manager found.");
        }
        return rm;
    }

    public static void main(String[] arg) throws Exception {
        boolean server = false;
        for (int n = 0; n < arg.length; ++n) {
            if (!arg[n].equals("-server")) continue;
            server = true;
        }
        Configuration config = new Configuration(true);
        if (server) {
            config.completeForServer();
            if (!config.hasPort()) {
                config.setPort(2000 + (new Random(System.currentTimeMillis()).nextInt() & 0x3FF));
            }
            System.out.println("starting server: " + config);
            config.run(null);
        } else {
            config.completeForClient(5);
            System.out.println("client configuration: " + config);
        }
    }

    public void createPatch(Object _copy, PatchOutput po) throws IOException {
        Configuration copy = (Configuration)_copy;
        if (po.writeDiff(this.debug, copy.debug)) {
            copy.debug = this.debug;
        }
        if (po.writeDiff(this.port, copy.port)) {
            copy.port = this.port;
        }
        copy.code = this.code = (String)po.writeDiff((Object)this.code, (Object)copy.code);
        copy.host = this.host = (InetAddress)po.writeDiff((Object)this.host, (Object)copy.host);
    }

    public void applyPatch(Object _copy, PatchInput pi) throws IOException, ClassNotFoundException {
        Configuration copy = (Configuration)_copy;
        if (pi.hasDiff()) {
            copy.debug = this.debug = pi.getDiffAsBoolean();
        }
        if (pi.hasDiff()) {
            copy.port = this.port = pi.getDiffAsInt();
        }
        if (pi.hasDiff()) {
            copy.code = this.code = (String)pi.getDiffAsObject();
        }
        if (pi.hasDiff()) {
            copy.host = this.host = (InetAddress)pi.getDiffAsObject();
        }
    }

    public void descendReferences(ReferenceConsumer c) throws IOException {
        c.descend((Object)this.code);
        c.descend((Object)this.host);
    }

    public void filterReferences(ReferenceFilter f) {
        this.code = (String)f.filter((Object)this.code);
        this.host = (InetAddress)f.filter((Object)this.host);
    }

    public Object flatClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)"Declared Cloneable but clone() is still unsupported");
        }
    }

    public TransportDescriptor getTransportDescriptor() {
        return TRANSPORT_DESCRIPTOR;
    }

    public Configuration(UnmarshalStream _stream, int _id) throws IOException, ClassNotFoundException {
        _stream.register((Object)this, _id);
    }

    public void unmarshal(UnmarshalStream _stream) throws IOException, ClassNotFoundException {
        _stream.request(5);
        byte[] _buffer = _stream.getBuffer();
        int _pos = _stream.getPosition();
        this.debug = BasicIO.extractBoolean((byte[])_buffer, (int)_pos);
        this.port = BasicIO.extractInt((byte[])_buffer, (int)(++_pos));
        _pos += 4;
        _stream.accept(5);
        this.code = (String)_stream.readReference();
        this.host = (InetAddress)_stream.readReference();
    }

    public void marshalReference(MarshalStream _stream) throws IOException {
    }

    public void marshal(MarshalStream _stream) throws IOException {
        _stream.reserve(5);
        byte[] _buffer = _stream.getBuffer();
        int _pos = _stream.getPosition();
        _pos = BasicIO.insert((byte[])_buffer, (int)_pos, (boolean)this.debug);
        _pos = BasicIO.insert((byte[])_buffer, (int)_pos, (int)this.port);
        _stream.deliver(5);
        _stream.writeReference((Object)this.code);
        _stream.writeReference((Object)this.host);
    }

    public Configuration(Configuration _orig, int _id, DeepClone _helper) throws CloneNotSupportedException, IOException {
        _helper.add(_id, (Object)this);
        this.debug = _orig.debug;
        this.port = _orig.port;
    }

    public void deepCloneReferences(Configuration _orig, DeepClone _helper) throws CloneNotSupportedException {
        this.code = (String)_helper.internalDeepClone((Object)_orig.code);
        this.host = (InetAddress)_helper.internalDeepClone((Object)_orig.host);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            MCAST_GROUP = InetAddress.getByName("224.1.2.3");
        }
        catch (UnknownHostException ex) {
            throw new InternalError("unable to resolve mcast group");
        }
        TRANSPORT_DESCRIPTOR = new TransportDescriptor(){

            public Object unmarshalReference(UnmarshalStream s, int id) throws IOException, ClassNotFoundException {
                return new Configuration(s, id);
            }

            public boolean unmarshal(Object obj, UnmarshalStream s) throws ClassNotFoundException, IOException {
                ((Configuration)obj).unmarshal(s);
                return false;
            }

            public void marshalReference(Object obj, MarshalStream s) throws IOException {
                ((Configuration)obj).marshalReference(s);
            }

            public void marshal(Object obj, MarshalStream s) throws IOException {
                ((Configuration)obj).marshal(s);
            }

            public Object deepClone(Object orig, int id, DeepClone _helper) throws CloneNotSupportedException {
                try {
                    return new Configuration((Configuration)orig, id, _helper);
                }
                catch (IOException ex) {
                    throw (CloneNotSupportedException)new CloneNotSupportedException().initCause(ex);
                }
            }

            public boolean deepCloneReferences(Object orig, Object copy, DeepClone _helper) throws CloneNotSupportedException {
                ((Configuration)copy).deepCloneReferences((Configuration)orig, _helper);
                return false;
            }

            public Class getType() {
                return class$jp$lang$Configuration == null ? (class$jp$lang$Configuration = Configuration.class$("jp.lang.Configuration")) : class$jp$lang$Configuration;
            }
        };
    }
}

