/*
 * Decompiled with CFR 0.152.
 */
package jp.lang;

import java.io.IOException;
import jp.lang.ConfigurationException;
import jp.lang.Distributor;
import jp.lang.RemoteError;
import jp.lang.RemoteObject;
import jp.lang.ReplicatedObject;
import jp.lang.RuntimeEnvironment;
import uka.karmi.rmi.RemoteException;
import uka.karo.ReplicaDiagnostics;

public final class DistributedRuntime {
    public static final int getMachineID() {
        return RuntimeEnvironment.getMachineID();
    }

    public static final int getMachineCnt() {
        return RuntimeEnvironment.getMachineCnt();
    }

    public static boolean replicatedClassInitializing(String className) {
        return RuntimeEnvironment.replicatedClassInitializing(className);
    }

    public static void setReplicatedClassInitializingEnd(String className, Object o) throws IllegalAccessException {
        RuntimeEnvironment.setReplicatedClassInitializingEnd(className, o);
    }

    public static boolean getReplicatedClassInitializingEnd(String className) throws IllegalAccessException {
        return RuntimeEnvironment.getReplicatedClassInitializingEnd(className);
    }

    public static Object getReplicatedClassImplReference(String clazzName) {
        return RuntimeEnvironment.getReplicatedClassImplReference(clazzName);
    }

    public static final void setTarget() {
        RuntimeEnvironment.setPriority(RuntimeEnvironment.getMachineID(), Distributor.ALWAYS);
    }

    public static final void setTarget(int t) {
        RuntimeEnvironment.setPriority(t, Distributor.ALWAYS);
    }

    public static final void setTarget(RemoteObject obj) {
        if (obj != null) {
            RuntimeEnvironment.setPriority(obj._location(), Distributor.ALWAYS);
        }
    }

    public static final void resetTarget() {
        RuntimeEnvironment.reset();
    }

    public static final void setObjectDistributor(Distributor distr) {
        RuntimeEnvironment.setObjectDistributor(distr);
    }

    public static final void setClassDistributor(Distributor distr) {
        RuntimeEnvironment.setClassDistributor(distr);
    }

    public static final void exit(int status) {
        RuntimeEnvironment.exit(status);
    }

    public static final void kill(int status) {
        RuntimeEnvironment.kill(status);
    }

    public static final boolean migrate(RemoteObject obj, int id) {
        return obj._migrateTo(RuntimeEnvironment.getMachine(id));
    }

    public static final int getLocation(RemoteObject obj) {
        return obj._location();
    }

    public static void distribute(Object replica, Object obj, int[] distribution) {
        ((ReplicatedObject)((Object)replica)).distributeTo(obj, distribution);
    }

    public static void distribute(Object replica, Object obj, boolean[] distribution) {
        ((ReplicatedObject)((Object)replica)).distributeTo(obj, distribution);
    }

    public static void setReadOnly(Object replica, Object object) {
        if (!(replica instanceof uka.karmi.rmi.server.ReplicatedObject)) {
            throw new IllegalArgumentException("Only replicated objects can have read-only sub-objects");
        }
        ((uka.karmi.rmi.server.ReplicatedObject)replica).setReadOnly(object, true);
    }

    public static boolean isReadOnly(Object replica, Object object) {
        return ((uka.karmi.rmi.server.ReplicatedObject)replica).isReadOnly(object);
    }

    public static ReplicaDiagnostics getDiagnostics(Object obj) {
        if (!(obj instanceof uka.karmi.rmi.server.ReplicatedObject)) {
            throw new IllegalArgumentException("diagnostics only for replicated objects available");
        }
        return ((uka.karmi.rmi.server.ReplicatedObject)obj).getDiagnostics();
    }

    public static int getRank(Object obj) {
        if (obj instanceof uka.karmi.rmi.server.ReplicatedObject) {
            return ((uka.karmi.rmi.server.ReplicatedObject)obj).getRank();
        }
        throw new IllegalArgumentException("only replicas of replicated objects have a rank");
    }

    public static int getSize(Object obj) {
        if (obj instanceof uka.karmi.rmi.server.ReplicatedObject) {
            return ((uka.karmi.rmi.server.ReplicatedObject)obj).getSize();
        }
        throw new IllegalArgumentException("only replicas of replicated objects have a size");
    }

    public static Object[] exchange(Object replica, Object[] arguments) {
        try {
            return ((ReplicatedObject)((Object)replica)).exchange(arguments);
        }
        catch (IOException ex) {
            throw new RemoteError("exchange failed", (Exception)((Object)new RemoteException((Throwable)ex)));
        }
        catch (ClassNotFoundException ex) {
            throw new RemoteError("exchange failed", (Exception)((Object)new RemoteException((Throwable)ex)));
        }
    }

    public static void barrier(Object replica) throws InterruptedException {
        try {
            ((ReplicatedObject)((Object)replica)).barrier();
        }
        catch (IOException ex) {
            throw new RemoteError("exchange failed", (Exception)((Object)new RemoteException((Throwable)ex)));
        }
    }

    public static void barrier(Object replica, int fanout) throws InterruptedException {
        try {
            ((ReplicatedObject)((Object)replica)).barrier(fanout);
        }
        catch (IOException ex) {
            throw new RemoteError("exchange failed", (Exception)((Object)new RemoteException((Throwable)ex)));
        }
    }

    public static final int machines() {
        return DistributedRuntime.getMachineCnt();
    }

    public static final int thisLocation() {
        return DistributedRuntime.getMachineID();
    }

    public static final void setObjectDistributor(String classname) {
        try {
            RuntimeEnvironment.setObjectDistributor(Distributor.loadDistributor(classname));
        }
        catch (ConfigurationException ex) {
            System.err.println(ex.getMessage());
        }
    }
}

