/*
 * Decompiled with CFR 0.152.
 */
package jp.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import jp.lang.ApplicationContext;
import jp.lang.ConfigJP;
import jp.lang.ConfigMain;
import jp.lang.ConfigMulti;
import jp.lang.ConfigRM;
import jp.lang.ConfigVM;
import jp.lang.Configuration;
import jp.lang.ConfigurationException;
import jp.lang.Constants;
import jp.lang.MovedException;
import jp.lang.RemoteError;
import jp.lang.RuntimeEnvironment;
import jp.lang.RuntimeManager;
import jp.lang.RuntimeManager_instance_impl;
import jp.lang.VirtualMachine;
import jp.lang.VirtualMachine_instance_impl;
import uka.karmi.rmi.Remote;
import uka.karmi.rmi.RemoteException;
import uka.karmi.rmi.registry.LocateRegistry;
import uka.karmi.rmi.registry.Registry;

public class JavaParty
implements Constants {
    static RuntimeManager rm;
    static VirtualMachine vm;
    static /* synthetic */ Class array$Ljava$lang$String;

    public static void usage() {
        System.err.println("usage: ");
        System.err.println("  JavaParty rm <runtime manager options>");
        System.err.println("  JavaParty vm <virtual machine options>");
        System.err.println("  JavaParty exec <program options>");
        System.err.println("  JavaParty kill <runtime manager options>");
        System.exit(1);
    }

    private static Throwable unwrapRemoteExceptions(Throwable ex) {
        if (ex instanceof RemoteError) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                return JavaParty.unwrapRemoteExceptions(cause);
            }
            return ex;
        }
        if (ex instanceof RemoteException) {
            Throwable cause = ex.getCause();
            if (cause != null) {
                return JavaParty.unwrapRemoteExceptions(cause);
            }
            return ex;
        }
        return ex;
    }

    private static void reportException(String msg, Throwable ex) {
        Throwable unwrapped = JavaParty.unwrapRemoteExceptions(ex);
        StringBuffer description = new StringBuffer(msg + ": " + unwrapped);
        if (unwrapped instanceof InvocationTargetException) {
            Throwable target = ((InvocationTargetException)unwrapped).getTargetException();
            target = JavaParty.unwrapRemoteExceptions(target);
            description.append(". caused by: ");
            description.append(target);
        }
        System.err.println(description.toString());
        ex.printStackTrace();
    }

    public static void main(String[] arg) {
        block18: {
            ConfigMulti config = new ConfigMulti();
            String jobDescription = "parsing arguments";
            int returnCode = -1;
            if (arg.length == 0) {
                JavaParty.usage();
            }
            try {
                if (arg[0].equals("kill")) {
                    String[] subarg = new String[arg.length - 1];
                    System.arraycopy(arg, 1, subarg, 0, subarg.length);
                    try {
                        JavaParty.mainKill(subarg);
                    }
                    catch (Throwable ex) {
                        JavaParty.reportException("killing the distributed environment failed", ex);
                        System.exit(1);
                    }
                    break block18;
                }
                config.init(arg);
                if (config.isStopped()) {
                    return;
                }
                if (config.rmconfig != null) {
                    try {
                        JavaParty.mainRuntimeManager(config.rmconfig);
                    }
                    catch (Throwable ex) {
                        JavaParty.reportException("starting runtime manager failed", ex);
                        System.exit(1);
                    }
                }
                if (config.vmconfig != null) {
                    try {
                        JavaParty.mainVirtualMachine(config.vmconfig);
                    }
                    catch (Throwable ex) {
                        JavaParty.reportException("starting virtual machine failed", ex);
                        if (config.rmconfig != null) {
                            JavaParty.verbosePrintln(config.vmconfig.verbose, "shutting down runtime environment");
                            rm.kill(1);
                        }
                        System.exit(1);
                    }
                }
                if (config.mainconfig == null) break block18;
                try {
                    JavaParty.mainExec(config.mainconfig);
                    if (config.mainconfig.killOnExit) {
                        JavaParty.verbosePrintln(config.mainconfig.verbose, "shutting down runtime environment");
                        rm.kill(1);
                    }
                }
                catch (Throwable ex) {
                    JavaParty.reportException("invoking main() method failed", ex);
                    if (rm != null && (config.rmconfig != null || config.mainconfig.killOnExit)) {
                        JavaParty.verbosePrintln(config.mainconfig.verbose, "shutting down runtime environment");
                        rm.kill(1);
                    }
                    System.exit(1);
                }
            }
            catch (Throwable ex) {
                JavaParty.reportException("shutdown failed", ex);
                System.exit(1);
            }
        }
    }

    public static void mainExec(ConfigMain config) throws Exception {
        if (rm == null) {
            JavaParty.verbosePrintln(config.verbose, "contacting runtime manager");
            rm = JavaParty.getConfiguration(config).completeForClient(config.timeout);
            JavaParty.verbosePrintln(config.verbose, "runtime manager contacted");
        }
        JavaParty.verbosePrintln(config.verbose, "invoking main method");
        JavaParty.invokeMain(rm, config);
        JavaParty.verbosePrintln(config.verbose, "main method returned");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void invokeMain(RuntimeManager rm, ConfigMain config) throws Exception {
        ApplicationContext context = rm.allocateContext();
        try {
            if (vm == null) {
                RuntimeEnvironment.init(rm, context);
            }
            Class<?> mainClass = Class.forName(config.mainName);
            Method mainMethod = mainClass.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = JavaParty.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
            JavaParty.verbosePrintln(config.verbose, "executing main method");
            mainMethod.invoke(null, new Object[]{config.mainArg});
        }
        finally {
            rm.freeContext();
        }
    }

    public static void mainKill(String[] arg) throws Exception {
        ConfigRM config = new ConfigRM();
        config.init(arg);
        if (config.isStopped()) {
            return;
        }
        rm = JavaParty.getConfiguration(config).completeForClient(config.timeout);
        JavaParty.verbosePrintln(config.verbose, "runtime manager contacted");
        JavaParty.verbosePrintln(config.verbose, "shutting down runtime environment");
        rm.kill(0);
    }

    public static void mainRuntimeManager(ConfigRM config) throws Exception {
        Configuration configuration = JavaParty.getConfiguration(config).completeForServer();
        if (config.debug) {
            System.err.println("configuration: " + configuration);
        }
        if (!configuration.getHost().equals(InetAddress.getLocalHost())) {
            throw new ConfigurationException("runtime manager can only be exported on local host: " + configuration.getHost() + " != " + InetAddress.getLocalHost());
        }
        rm = JavaParty.createRM(config);
        if (!config.passive) {
            JavaParty.startConfigServer(configuration);
        }
    }

    protected static void startConfigServer(final Configuration configuration) {
        new Thread("JP-config-server"){

            public void run() {
                if (configuration.debug) {
                    System.err.println("starting config server: " + configuration);
                }
                configuration.run(rm);
            }
        }.start();
    }

    protected static RuntimeManager createRM(ConfigRM config) throws ConfigurationException {
        RuntimeManager_instance_impl rmimpl;
        try {
            JavaParty.verbosePrintln(config.verbose, "creating runtime manager");
            rmimpl = new RuntimeManager_instance_impl(config);
        }
        catch (RemoteException ex) {
            throw new ConfigurationException("unable to export runtime manager", ex);
        }
        Registry registry = null;
        try {
            if (config.debug) {
                System.err.println("exporting registry at port " + config.port + ".");
            }
            registry = config.port > 0 ? LocateRegistry.createRegistry((int)config.port) : LocateRegistry.createRegistry((int)1099);
        }
        catch (RemoteException ex) {
            throw new ConfigurationException("could not export registry at port " + config.port, ex);
        }
        try {
            if (config.debug) {
                System.err.println("binding runtime in registry.");
            }
            registry.rebind("jp.lang.RuntimeManager", (Remote)rmimpl);
        }
        catch (RemoteException ex) {
            throw new ConfigurationException("unable to bind runtime manager", ex);
        }
        try {
            return rmimpl.getHandle();
        }
        catch (MovedException ex) {
            throw new InternalError("RuntimeManager has moved unexpectedly");
        }
    }

    public static void mainVirtualMachine(ConfigVM config) throws Exception {
        boolean localVM = true;
        if (rm == null) {
            rm = JavaParty.getConfiguration(config).completeForClient(config.timeout);
            localVM = false;
        }
        vm = JavaParty.createVM(rm, config, localVM);
    }

    protected static VirtualMachine createVM(RuntimeManager rm, ConfigVM config, boolean localVM) throws ConfigurationException {
        try {
            return new VirtualMachine_instance_impl(rm, config, localVM).getHandle();
        }
        catch (MovedException ex) {
            throw new InternalError("VirtualMachine has moved unexpectedly");
        }
        catch (RemoteException ex) {
            throw new ConfigurationException("unable to export virtual machine", ex);
        }
    }

    public static Configuration getConfiguration(ConfigJP config) throws ConfigurationException {
        return new Configuration(config.debug, config.host, config.port, config.code);
    }

    private static void verbosePrintln(boolean verbose, String msg) {
        if (verbose) {
            System.err.println("JP: " + msg);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

