/*
 * Decompiled with CFR 0.152.
 */
package jp.tools.monitor;

import javax.swing.SwingUtilities;
import jp.lang.RuntimeManager;
import jp.lang.VirtualMachine;
import jp.tools.monitor.JVMSelectionPanel;
import jp.tools.monitor.JVMStatusPanel;
import jp.tools.monitor.MenuBar;

public class ActionHandler {
    private RuntimeManager rm;
    private MenuBar menuBar;
    private JVMSelectionPanel jvmSelectionPanel;
    private JVMStatusPanel jvmStatusPanel;
    private Runnable jvmListUpdater = new Runnable(){

        public void run() {
            ActionHandler.this.jvmSelectionPanel.updateJVMList();
        }
    };
    private Runnable jvmStatusUpdater = new Runnable(){

        public void run() {
            ActionHandler.this.jvmStatusPanel.updateVM();
        }
    };

    public void setRuntimeManager(RuntimeManager rm) {
        this.rm = rm;
    }

    public void setMenuBar(MenuBar menuBar) {
        this.menuBar = menuBar;
    }

    public void setJVMSelectionPanel(JVMSelectionPanel jvmSelectionPanel) {
        this.jvmSelectionPanel = jvmSelectionPanel;
    }

    public void setJVMStatusPanel(JVMStatusPanel jvmStatusPanel) {
        this.jvmStatusPanel = jvmStatusPanel;
    }

    public int getMachineCnt() {
        return this.rm.getMachineCnt();
    }

    public VirtualMachine getMachine(int i) {
        return this.rm.getMachine(i);
    }

    public void exitProgram() {
        try {
            this.rm.kill(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void resetRM() {
        this.rm.reset();
        this.updateJVMList();
    }

    public void resetVM(VirtualMachine vm) {
        vm.reset();
        this.selectVM(vm);
    }

    public void updateJVMList() {
        SwingUtilities.invokeLater(this.jvmListUpdater);
    }

    public void selectVM(VirtualMachine vm) {
        this.jvmStatusPanel.selectVM(vm);
    }

    public void updateVM(int machineID) {
        if (machineID == this.jvmStatusPanel.getMachineID()) {
            SwingUtilities.invokeLater(this.jvmStatusUpdater);
        }
    }
}

