/*
 * Decompiled with CFR 0.152.
 */
package jp.tools.monitor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.lang.VirtualMachine;
import jp.tools.monitor.ActionHandler;

public class ConstructorTablePanel
extends JPanel {
    private static final String TITLE = "Constructor Table";
    private static final Dimension CONSTRUCTORTABLEPANE_PREFERRED_SIZE = new Dimension(200, 50);
    private static final String[] EMPTY_LIST = new String[0];
    private static final String[] PSEUDO_LIST = new String[]{"<no constructor registered>"};
    private ActionHandler handler;
    private VirtualMachine vm;
    private String classname;
    private JList constructorTableList;
    private JScrollPane constructorTablePane;

    private ConstructorTablePanel() {
    }

    public ConstructorTablePanel(ActionHandler handler) {
        this.handler = handler;
        this.setLayout(new BorderLayout());
        this.constructorTableList = new JList();
        this.constructorTableList.setListData(this.getConstructorInfo());
        this.constructorTableList.addListSelectionListener(new ConstructorTableListSelectionListener());
        this.constructorTablePane = new JScrollPane(this.constructorTableList);
        this.constructorTablePane.setPreferredSize(CONSTRUCTORTABLEPANE_PREFERRED_SIZE);
        Border etchedBorder = BorderFactory.createEtchedBorder();
        this.constructorTablePane.setBorder(BorderFactory.createTitledBorder(etchedBorder, TITLE, 2, 2));
        this.add((Component)this.constructorTablePane, "Center");
    }

    private String[] getConstructorInfo() {
        String[] table;
        if (this.vm == null || this.classname == null) {
            table = EMPTY_LIST;
        } else {
            table = this.vm.getConstructorTableNames(this.classname);
            if (table == null) {
                table = PSEUDO_LIST;
            }
        }
        return table;
    }

    public void validate() {
        this.constructorTableList.setListData(this.getConstructorInfo());
        super.validate();
    }

    public void selectClassName(VirtualMachine vm, String classname) {
        this.classname = classname;
        this.vm = vm;
        this.validate();
    }

    private class ConstructorTableListSelectionListener
    implements ListSelectionListener {
        private ConstructorTableListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
        }
    }
}

