/*
 * Decompiled with CFR 0.152.
 */
package jp.tools.scheduler;

import java.io.IOException;
import jp.tools.scheduler.Job;
import jp.tools.scheduler.Worker;
import uka.patch.PatchInput;
import uka.patch.PatchOutput;
import uka.patch.Patchable;
import uka.patch.ReferenceConsumer;
import uka.patch.ReferenceFilter;
import uka.transport.BasicIO;
import uka.transport.DeepClone;
import uka.transport.MarshalStream;
import uka.transport.TransportDescriptor;
import uka.transport.Transportable;
import uka.transport.UnmarshalStream;

public class Activity
extends Thread
implements Patchable,
Transportable {
    public static final TransportDescriptor TRANSPORT_DESCRIPTOR = new TransportDescriptor(){

        public Object unmarshalReference(UnmarshalStream s, int n) throws IOException, ClassNotFoundException {
            return new Activity(s, n);
        }

        public boolean unmarshal(Object obj, UnmarshalStream unmarshalStream) throws ClassNotFoundException, IOException {
            ((Activity)obj).unmarshal(unmarshalStream);
            return false;
        }

        public void marshalReference(Object obj, MarshalStream marshalStream) throws IOException {
            ((Activity)obj).marshalReference(marshalStream);
        }

        public void marshal(Object obj, MarshalStream marshalStream) throws IOException {
            ((Activity)obj).marshal(marshalStream);
        }

        public Object deepClone(Object orig, int id, DeepClone _helper) throws CloneNotSupportedException {
            try {
                return new Activity((Activity)orig, id, _helper);
            }
            catch (IOException iOException) {
                throw (CloneNotSupportedException)new CloneNotSupportedException().initCause(iOException);
            }
        }

        public boolean deepCloneReferences(Object orig, Object copy, DeepClone deepClone) throws CloneNotSupportedException {
            ((Activity)copy).deepCloneReferences((Activity)orig, deepClone);
            return false;
        }

        public Class getType() {
            return Class.forName("jp.tools.scheduler.Activity");
        }
    };
    private static final int _SIZE = 4;
    private Worker worker;
    private Job job;
    private int jobID;
    private Job[] requisites;

    public void createPatch(Object _copy, PatchOutput po) throws IOException {
        Activity activity = (Activity)_copy;
        if (po.writeDiff(this.jobID, activity.jobID)) {
            activity.jobID = this.jobID;
        }
        activity.requisites = this.requisites = (Job[])po.writeDiff((Object)this.requisites, (Object)activity.requisites);
        activity.job = this.job = (Job)po.writeDiff((Object)this.job, (Object)activity.job);
        activity.worker = this.worker = (Worker)po.writeDiff((Object)this.worker, (Object)activity.worker);
    }

    public void applyPatch(Object _copy, PatchInput pi) throws IOException, ClassNotFoundException {
        Activity activity = (Activity)_copy;
        if (pi.hasDiff()) {
            activity.jobID = this.jobID = pi.getDiffAsInt();
        }
        if (pi.hasDiff()) {
            activity.requisites = this.requisites = (Job[])pi.getDiffAsObject();
        }
        if (pi.hasDiff()) {
            activity.job = this.job = (Job)pi.getDiffAsObject();
        }
        if (pi.hasDiff()) {
            activity.worker = this.worker = (Worker)pi.getDiffAsObject();
        }
    }

    public void descendReferences(ReferenceConsumer referenceConsumer) throws IOException {
        referenceConsumer.descend((Object)this.requisites);
        referenceConsumer.descend((Object)this.job);
        referenceConsumer.descend((Object)this.worker);
    }

    public void filterReferences(ReferenceFilter referenceFilter) {
        this.requisites = (Job[])referenceFilter.filter((Object)this.requisites);
        this.job = (Job)referenceFilter.filter((Object)this.job);
        this.worker = (Worker)referenceFilter.filter((Object)this.worker);
    }

    public Object flatClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)"Declared Cloneable but clone() is still unsupported");
        }
    }

    public TransportDescriptor getTransportDescriptor() {
        return TRANSPORT_DESCRIPTOR;
    }

    public Activity(UnmarshalStream _stream, int n) throws IOException, ClassNotFoundException {
        _stream.register((Object)this, n);
    }

    public void unmarshal(UnmarshalStream _stream) throws IOException, ClassNotFoundException {
        _stream.request(4);
        byte[] _buffer = _stream.getBuffer();
        int n = _stream.getPosition();
        this.jobID = BasicIO.extractInt((byte[])_buffer, (int)n);
        n += 4;
        _stream.accept(4);
        this.requisites = (Job[])_stream.readReference();
        this.job = (Job)_stream.readReference();
        this.worker = (Worker)_stream.readReference();
    }

    public void marshalReference(MarshalStream marshalStream) throws IOException {
    }

    public void marshal(MarshalStream _stream) throws IOException {
        _stream.reserve(4);
        byte[] _buffer = _stream.getBuffer();
        int n = _stream.getPosition();
        n = BasicIO.insert((byte[])_buffer, (int)n, (int)this.jobID);
        _stream.deliver(4);
        _stream.writeReference((Object)this.requisites);
        _stream.writeReference((Object)this.job);
        _stream.writeReference((Object)this.worker);
    }

    public Activity(Activity _orig, int _id, DeepClone deepClone) throws CloneNotSupportedException, IOException {
        deepClone.add(_id, (Object)this);
        this.jobID = _orig.jobID;
    }

    public void deepCloneReferences(Activity _orig, DeepClone deepClone) throws CloneNotSupportedException {
        this.requisites = (Job[])deepClone.internalDeepClone((Object)_orig.requisites);
        this.job = (Job)deepClone.internalDeepClone((Object)_orig.job);
        this.worker = (Worker)deepClone.internalDeepClone((Object)_orig.worker);
    }

    Activity(Worker worker, Job job, int jobID, Job[] jobArray) {
        this.worker = worker;
        this.job = job;
        this.jobID = jobID;
        this.requisites = jobArray;
    }

    public void run() {
        Throwable throwable = null;
        try {
            this.job.performWork(this.requisites);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        this.worker.notifyAllListeners(this.jobID, throwable);
    }
}

