/*
 * Decompiled with CFR 0.152.
 */
package jp.tools.scheduler;

import java.io.IOException;
import jp.tools.scheduler.Schedule;
import uka.patch.PatchInput;
import uka.patch.PatchOutput;
import uka.patch.Patchable;
import uka.patch.ReferenceConsumer;
import uka.patch.ReferenceFilter;
import uka.transport.BasicIO;
import uka.transport.DeepClone;
import uka.transport.MarshalStream;
import uka.transport.TransportDescriptor;
import uka.transport.Transportable;
import uka.transport.UnmarshalStream;

public class ItemCache
implements Patchable,
Transportable {
    public static final TransportDescriptor TRANSPORT_DESCRIPTOR = new TransportDescriptor(){

        public Object unmarshalReference(UnmarshalStream s, int n) throws IOException, ClassNotFoundException {
            return new ItemCache(s, n);
        }

        public boolean unmarshal(Object obj, UnmarshalStream unmarshalStream) throws ClassNotFoundException, IOException {
            ((ItemCache)obj).unmarshal(unmarshalStream);
            return false;
        }

        public void marshalReference(Object obj, MarshalStream marshalStream) throws IOException {
            ((ItemCache)obj).marshalReference(marshalStream);
        }

        public void marshal(Object obj, MarshalStream marshalStream) throws IOException {
            ((ItemCache)obj).marshal(marshalStream);
        }

        public Object deepClone(Object orig, int id, DeepClone _helper) throws CloneNotSupportedException {
            try {
                return new ItemCache((ItemCache)orig, id, _helper);
            }
            catch (IOException iOException) {
                throw (CloneNotSupportedException)new CloneNotSupportedException().initCause(iOException);
            }
        }

        public boolean deepCloneReferences(Object orig, Object copy, DeepClone deepClone) throws CloneNotSupportedException {
            ((ItemCache)copy).deepCloneReferences((ItemCache)orig, deepClone);
            return false;
        }

        public Class getType() {
            return Class.forName("jp.tools.scheduler.ItemCache");
        }
    };
    private static final int _SIZE = 8;
    private static final int INITIAL_SIZE = 10;
    private static final String CACHE_OVERFLOW_MESSAGE = "item cache overflow\r\n(this usually happens if you add items to a schedule while it is scheduled)";
    private Schedule.Item[] items;
    private int[] holes;
    private int firstHoleIndex;
    private int nextHoleIndex;

    public void createPatch(Object _copy, PatchOutput po) throws IOException {
        ItemCache itemCache = (ItemCache)_copy;
        if (po.writeDiff(this.nextHoleIndex, itemCache.nextHoleIndex)) {
            itemCache.nextHoleIndex = this.nextHoleIndex;
        }
        if (po.writeDiff(this.firstHoleIndex, itemCache.firstHoleIndex)) {
            itemCache.firstHoleIndex = this.firstHoleIndex;
        }
        itemCache.holes = this.holes = (int[])po.writeDiff((Object)this.holes, (Object)itemCache.holes);
        itemCache.items = this.items = (Schedule.Item[])po.writeDiff((Object)this.items, (Object)itemCache.items);
    }

    public void applyPatch(Object _copy, PatchInput pi) throws IOException, ClassNotFoundException {
        ItemCache itemCache = (ItemCache)_copy;
        if (pi.hasDiff()) {
            itemCache.nextHoleIndex = this.nextHoleIndex = pi.getDiffAsInt();
        }
        if (pi.hasDiff()) {
            itemCache.firstHoleIndex = this.firstHoleIndex = pi.getDiffAsInt();
        }
        if (pi.hasDiff()) {
            itemCache.holes = this.holes = (int[])pi.getDiffAsObject();
        }
        if (pi.hasDiff()) {
            itemCache.items = this.items = (Schedule.Item[])pi.getDiffAsObject();
        }
    }

    public void descendReferences(ReferenceConsumer referenceConsumer) throws IOException {
        referenceConsumer.descend((Object)this.holes);
        referenceConsumer.descend((Object)this.items);
    }

    public void filterReferences(ReferenceFilter referenceFilter) {
        this.holes = (int[])referenceFilter.filter((Object)this.holes);
        this.items = (Schedule.Item[])referenceFilter.filter((Object)this.items);
    }

    public Object flatClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)"Declared Cloneable but clone() is still unsupported");
        }
    }

    public TransportDescriptor getTransportDescriptor() {
        return TRANSPORT_DESCRIPTOR;
    }

    public ItemCache(UnmarshalStream _stream, int n) throws IOException, ClassNotFoundException {
        _stream.register((Object)this, n);
    }

    public void unmarshal(UnmarshalStream _stream) throws IOException, ClassNotFoundException {
        _stream.request(8);
        byte[] _buffer = _stream.getBuffer();
        int n = _stream.getPosition();
        this.nextHoleIndex = BasicIO.extractInt((byte[])_buffer, (int)n);
        this.firstHoleIndex = BasicIO.extractInt((byte[])_buffer, (int)(n += 4));
        n += 4;
        _stream.accept(8);
        this.holes = (int[])_stream.readReference();
        this.items = (Schedule.Item[])_stream.readReference();
    }

    public void marshalReference(MarshalStream marshalStream) throws IOException {
    }

    public void marshal(MarshalStream _stream) throws IOException {
        _stream.reserve(8);
        byte[] _buffer = _stream.getBuffer();
        int n = _stream.getPosition();
        n = BasicIO.insert((byte[])_buffer, (int)n, (int)this.nextHoleIndex);
        n = BasicIO.insert((byte[])_buffer, (int)n, (int)this.firstHoleIndex);
        _stream.deliver(8);
        _stream.writeReference((Object)this.holes);
        _stream.writeReference((Object)this.items);
    }

    public ItemCache(ItemCache _orig, int _id, DeepClone deepClone) throws CloneNotSupportedException, IOException {
        deepClone.add(_id, (Object)this);
        this.nextHoleIndex = _orig.nextHoleIndex;
        this.firstHoleIndex = _orig.firstHoleIndex;
    }

    public void deepCloneReferences(ItemCache _orig, DeepClone deepClone) throws CloneNotSupportedException {
        this.holes = (int[])deepClone.internalDeepClone((Object)_orig.holes);
        this.items = (Schedule.Item[])deepClone.internalDeepClone((Object)_orig.items);
    }

    public ItemCache() {
        this(10);
    }

    public ItemCache(int size) {
        this.items = new Schedule.Item[size + 1];
        this.holes = new int[size + 1];
        for (int i = 0; i < this.holes.length - 1; ++i) {
            this.holes[i] = i;
        }
        this.firstHoleIndex = 0;
        this.nextHoleIndex = 0;
    }

    public synchronized int store(Schedule.Item item) {
        if ((this.firstHoleIndex - this.nextHoleIndex - this.items.length) % this.items.length == -1) {
            throw new IllegalStateException(CACHE_OVERFLOW_MESSAGE);
        }
        int n = this.firstHoleIndex;
        this.items[this.firstHoleIndex++] = item;
        this.firstHoleIndex %= this.items.length;
        return n;
    }

    public Schedule.Item getItemFor(int n) {
        return this.items[n];
    }

    public synchronized void delete(int n) {
        if (n < 0 || n >= this.items.length - 1) {
            throw new IllegalArgumentException("invalid jobID");
        }
        this.holes[this.nextHoleIndex++] = n;
        this.nextHoleIndex %= this.holes.length;
    }
}

