/*
 * Decompiled with CFR 0.152.
 */
package jp.tools.scheduler;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import jp.tools.scheduler.Job;
import jp.tools.scheduler.Schedule;
import uka.patch.PatchInput;
import uka.patch.PatchOutput;
import uka.patch.Patchable;
import uka.patch.ReferenceConsumer;
import uka.patch.ReferenceFilter;
import uka.transport.BasicIO;
import uka.transport.DeepClone;
import uka.transport.MarshalStream;
import uka.transport.TransportDescriptor;
import uka.transport.Transportable;
import uka.transport.UnmarshalStream;

public class SimpleSchedule
implements Patchable,
Transportable,
Schedule {
    public static final TransportDescriptor TRANSPORT_DESCRIPTOR = new TransportDescriptor(){

        public Object unmarshalReference(UnmarshalStream s, int n) throws IOException, ClassNotFoundException {
            return new SimpleSchedule(s, n);
        }

        public boolean unmarshal(Object obj, UnmarshalStream unmarshalStream) throws ClassNotFoundException, IOException {
            ((SimpleSchedule)obj).unmarshal(unmarshalStream);
            return false;
        }

        public void marshalReference(Object obj, MarshalStream marshalStream) throws IOException {
            ((SimpleSchedule)obj).marshalReference(marshalStream);
        }

        public void marshal(Object obj, MarshalStream marshalStream) throws IOException {
            ((SimpleSchedule)obj).marshal(marshalStream);
        }

        public Object deepClone(Object orig, int id, DeepClone _helper) throws CloneNotSupportedException {
            try {
                return new SimpleSchedule((SimpleSchedule)orig, id, _helper);
            }
            catch (IOException iOException) {
                throw (CloneNotSupportedException)new CloneNotSupportedException().initCause(iOException);
            }
        }

        public boolean deepCloneReferences(Object orig, Object copy, DeepClone deepClone) throws CloneNotSupportedException {
            ((SimpleSchedule)copy).deepCloneReferences((SimpleSchedule)orig, deepClone);
            return false;
        }

        public Class getType() {
            return Class.forName("jp.tools.scheduler.SimpleSchedule");
        }
    };
    private static final int _SIZE = 4;
    private Hashtable job2item;
    private int size;
    private SimpleItem root;

    public void createPatch(Object _copy, PatchOutput po) throws IOException {
        SimpleSchedule simpleSchedule = (SimpleSchedule)_copy;
        if (po.writeDiff(this.size, simpleSchedule.size)) {
            simpleSchedule.size = this.size;
        }
        simpleSchedule.root = this.root = (SimpleItem)po.writeDiff((Object)this.root, (Object)simpleSchedule.root);
        simpleSchedule.job2item = this.job2item = (Hashtable)po.writeDiff((Object)this.job2item, (Object)simpleSchedule.job2item);
    }

    public void applyPatch(Object _copy, PatchInput pi) throws IOException, ClassNotFoundException {
        SimpleSchedule simpleSchedule = (SimpleSchedule)_copy;
        if (pi.hasDiff()) {
            simpleSchedule.size = this.size = pi.getDiffAsInt();
        }
        if (pi.hasDiff()) {
            simpleSchedule.root = this.root = (SimpleItem)pi.getDiffAsObject();
        }
        if (pi.hasDiff()) {
            simpleSchedule.job2item = this.job2item = (Hashtable)pi.getDiffAsObject();
        }
    }

    public void descendReferences(ReferenceConsumer referenceConsumer) throws IOException {
        referenceConsumer.descend((Object)this.root);
        referenceConsumer.descend((Object)this.job2item);
    }

    public void filterReferences(ReferenceFilter referenceFilter) {
        this.root = (SimpleItem)referenceFilter.filter((Object)this.root);
        this.job2item = (Hashtable)referenceFilter.filter((Object)this.job2item);
    }

    public Object flatClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)"Declared Cloneable but clone() is still unsupported");
        }
    }

    public TransportDescriptor getTransportDescriptor() {
        return TRANSPORT_DESCRIPTOR;
    }

    public SimpleSchedule(UnmarshalStream _stream, int n) throws IOException, ClassNotFoundException {
        _stream.register((Object)this, n);
    }

    public void unmarshal(UnmarshalStream _stream) throws IOException, ClassNotFoundException {
        _stream.request(4);
        byte[] _buffer = _stream.getBuffer();
        int n = _stream.getPosition();
        this.size = BasicIO.extractInt((byte[])_buffer, (int)n);
        n += 4;
        _stream.accept(4);
        this.root = (SimpleItem)_stream.readReference();
        this.job2item = (Hashtable)_stream.readReference();
    }

    public void marshalReference(MarshalStream marshalStream) throws IOException {
    }

    public void marshal(MarshalStream _stream) throws IOException {
        _stream.reserve(4);
        byte[] _buffer = _stream.getBuffer();
        int n = _stream.getPosition();
        n = BasicIO.insert((byte[])_buffer, (int)n, (int)this.size);
        _stream.deliver(4);
        _stream.writeReference((Object)this.root);
        _stream.writeReference((Object)this.job2item);
    }

    public SimpleSchedule(SimpleSchedule _orig, int _id, DeepClone deepClone) throws CloneNotSupportedException, IOException {
        deepClone.add(_id, (Object)this);
        this.size = _orig.size;
    }

    public void deepCloneReferences(SimpleSchedule _orig, DeepClone deepClone) throws CloneNotSupportedException {
        this.root = (SimpleItem)deepClone.internalDeepClone((Object)_orig.root);
        this.job2item = (Hashtable)deepClone.internalDeepClone((Object)_orig.job2item);
    }

    public SimpleSchedule() {
        this.job2item = new Hashtable();
        this.root = new SimpleItem(this);
        this.size = 1;
    }

    public Schedule.Item getRoot() {
        return this.root;
    }

    private SimpleItem findSchedulableItem(SimpleItem root) {
        if (!root.isOrphane()) {
            return null;
        }
        Schedule.Item[] requisites = root.getRequisites();
        boolean hasUnfulfilledRequisite = false;
        for (int i = 0; i < requisites.length; ++i) {
            SimpleItem requisite = (SimpleItem)requisites[i];
            if (requisite.isDone()) continue;
            SimpleItem simpleItem = this.findSchedulableItem(requisite);
            if (simpleItem != null) {
                return simpleItem;
            }
            hasUnfulfilledRequisite = true;
        }
        if (hasUnfulfilledRequisite) {
            return null;
        }
        return root;
    }

    private synchronized SimpleItem findSchedulableItem() {
        return this.findSchedulableItem(this.root);
    }

    public Schedule.Item selectItemForScheduling() {
        SimpleItem simpleItem = this.findSchedulableItem();
        if (simpleItem != null) {
            simpleItem.setScheduled();
        }
        return simpleItem;
    }

    public Schedule.Item searchItem(Job job) {
        return (Schedule.Item)this.job2item.get(job);
    }

    private synchronized void setJob(Schedule.Item item, Job job) {
        if (job == null) {
            if (item.getJob() != null) {
                this.job2item.remove(item.getJob());
            }
        } else {
            if (this.searchItem(job) != null) {
                throw new IllegalArgumentException("job already associated with different item");
            }
            this.job2item.put(item, job);
        }
    }

    public int getSize() {
        return this.size;
    }

    public static class SimpleItem
    implements Schedule.Item {
        private static final int STATE_ORPHANE = 0;
        private static final int STATE_SCHEDULED = 1;
        private static final int STATE_DONE = 2;
        private static final SimpleItem[] EMPTY_ITEM_ARRAY = new SimpleItem[0];
        private SimpleSchedule schedule;
        private Vector requisites;
        private Job job;
        private int state;

        private SimpleItem() {
        }

        private SimpleItem(SimpleSchedule simpleSchedule) {
            this.schedule = simpleSchedule;
            this.requisites = new Vector();
            this.job = null;
            this.state = 0;
        }

        public Schedule.Item[] getRequisites() {
            return this.requisites.toArray(EMPTY_ITEM_ARRAY);
        }

        public void setJob(Job job) {
            this.schedule.setJob(this, job);
            this.job = job;
        }

        public Job getJob() {
            return this.job;
        }

        public Schedule.Item createRequisite() {
            SimpleItem simpleItem = new SimpleItem(this.schedule);
            this.requisites.addElement(simpleItem);
            this.schedule.size++;
            return simpleItem;
        }

        public void addRequisite(SimpleItem simpleItem) {
            this.requisites.addElement(simpleItem);
        }

        public boolean isOrphane() {
            return this.state == 0;
        }

        public synchronized void setScheduled() {
            if (this.state != 0) {
                throw new IllegalStateException(String.valueOf("state==").concat(String.valueOf(this.state)));
            }
            this.state = 1;
        }

        public boolean isScheduled() {
            return this.state == 1;
        }

        public synchronized void setDone() {
            if (this.state != 1) {
                throw new IllegalStateException(String.valueOf("state==").concat(String.valueOf(this.state)));
            }
            this.state = 2;
        }

        public boolean isDone() {
            return this.state == 2;
        }
    }
}

