/*
 *
 * GLFW Constants
 *
 */

typedef struct t_ioGLFW_constTable {
	char *name;
	long value;
} t_ioGLFW_constTable;


t_ioGLFW_constTable ioGLFW_constTable[] = {
	{"GLFW_VERSION_MAJOR", GLFW_VERSION_MAJOR},
	{"GLFW_VERSION_MINOR", GLFW_VERSION_MINOR},
	{"GLFW_VERSION_REVISION", GLFW_VERSION_REVISION},


//========================================================================
// Input handling definitions
//========================================================================

// Key and button state/action definitions
	{"GLFW_RELEASE", GLFW_RELEASE},
	{"GLFW_PRESS", GLFW_PRESS},

// Keyboard key definitions: 8-bit ISO-8859-1 (Latin 1) encoding is used
// for printable keys (such as A-Z, 0-9 etc), and values above 256
// represent special (non-printable) keys (e.g. F1, Page Up etc).
	{"GLFW_KEY_UNKNOWN", GLFW_KEY_UNKNOWN},
	{"GLFW_KEY_SPACE", GLFW_KEY_SPACE},
	{"GLFW_KEY_SPECIAL", GLFW_KEY_SPECIAL},
	{"GLFW_KEY_ESC", GLFW_KEY_ESC},
	{"GLFW_KEY_F1", GLFW_KEY_F1},
	{"GLFW_KEY_F2", GLFW_KEY_F2},
	{"GLFW_KEY_F3", GLFW_KEY_F3},
	{"GLFW_KEY_F4", GLFW_KEY_F4},
	{"GLFW_KEY_F5", GLFW_KEY_F5},
	{"GLFW_KEY_F6", GLFW_KEY_F6},
	{"GLFW_KEY_F7", GLFW_KEY_F7},
	{"GLFW_KEY_F8", GLFW_KEY_F8},
	{"GLFW_KEY_F9", GLFW_KEY_F9},
	{"GLFW_KEY_F10", GLFW_KEY_F10},
	{"GLFW_KEY_F11", GLFW_KEY_F11},
	{"GLFW_KEY_F12", GLFW_KEY_F12},
	{"GLFW_KEY_F13", GLFW_KEY_F13},
	{"GLFW_KEY_F14", GLFW_KEY_F14},
	{"GLFW_KEY_F15", GLFW_KEY_F15},
	{"GLFW_KEY_F16", GLFW_KEY_F16},
	{"GLFW_KEY_F17", GLFW_KEY_F17},
	{"GLFW_KEY_F18", GLFW_KEY_F18},
	{"GLFW_KEY_F19", GLFW_KEY_F19},
	{"GLFW_KEY_F20", GLFW_KEY_F20},
	{"GLFW_KEY_F21", GLFW_KEY_F21},
	{"GLFW_KEY_F22", GLFW_KEY_F22},
	{"GLFW_KEY_F23", GLFW_KEY_F23},
	{"GLFW_KEY_F24", GLFW_KEY_F24},
	{"GLFW_KEY_F25", GLFW_KEY_F25},
	{"GLFW_KEY_UP", GLFW_KEY_UP},
	{"GLFW_KEY_DOWN", GLFW_KEY_DOWN},
	{"GLFW_KEY_LEFT", GLFW_KEY_LEFT},
	{"GLFW_KEY_RIGHT", GLFW_KEY_RIGHT},
	{"GLFW_KEY_LSHIFT", GLFW_KEY_LSHIFT},
	{"GLFW_KEY_RSHIFT", GLFW_KEY_RSHIFT},
	{"GLFW_KEY_LCTRL", GLFW_KEY_LCTRL},
	{"GLFW_KEY_RCTRL", GLFW_KEY_RCTRL},
	{"GLFW_KEY_LALT", GLFW_KEY_LALT},
	{"GLFW_KEY_RALT", GLFW_KEY_RALT},
	{"GLFW_KEY_TAB", GLFW_KEY_TAB},
	{"GLFW_KEY_ENTER", GLFW_KEY_ENTER},
	{"GLFW_KEY_BACKSPACE", GLFW_KEY_BACKSPACE},
	{"GLFW_KEY_INSERT", GLFW_KEY_INSERT},
	{"GLFW_KEY_DEL", GLFW_KEY_DEL},
	{"GLFW_KEY_PAGEUP", GLFW_KEY_PAGEUP},
	{"GLFW_KEY_PAGEDOWN", GLFW_KEY_PAGEDOWN},
	{"GLFW_KEY_HOME", GLFW_KEY_HOME},
	{"GLFW_KEY_END", GLFW_KEY_END},
	{"GLFW_KEY_KP_0", GLFW_KEY_KP_0},
	{"GLFW_KEY_KP_1", GLFW_KEY_KP_1},
	{"GLFW_KEY_KP_2", GLFW_KEY_KP_2},
	{"GLFW_KEY_KP_3", GLFW_KEY_KP_3},
	{"GLFW_KEY_KP_4", GLFW_KEY_KP_4},
	{"GLFW_KEY_KP_5", GLFW_KEY_KP_5},
	{"GLFW_KEY_KP_6", GLFW_KEY_KP_6},
	{"GLFW_KEY_KP_7", GLFW_KEY_KP_7},
	{"GLFW_KEY_KP_8", GLFW_KEY_KP_8},
	{"GLFW_KEY_KP_9", GLFW_KEY_KP_9},
	{"GLFW_KEY_KP_DIVIDE", GLFW_KEY_KP_DIVIDE},
	{"GLFW_KEY_KP_MULTIPLY", GLFW_KEY_KP_MULTIPLY},
	{"GLFW_KEY_KP_SUBTRACT", GLFW_KEY_KP_SUBTRACT},
	{"GLFW_KEY_KP_ADD", GLFW_KEY_KP_ADD},
	{"GLFW_KEY_KP_DECIMAL", GLFW_KEY_KP_DECIMAL},
	{"GLFW_KEY_KP_EQUAL", GLFW_KEY_KP_EQUAL},
	{"GLFW_KEY_KP_ENTER", GLFW_KEY_KP_ENTER},
	{"GLFW_KEY_LAST", GLFW_KEY_LAST},

// Mouse button definitions
	{"GLFW_MOUSE_BUTTON_1", GLFW_MOUSE_BUTTON_1},
	{"GLFW_MOUSE_BUTTON_2", GLFW_MOUSE_BUTTON_2},
	{"GLFW_MOUSE_BUTTON_3", GLFW_MOUSE_BUTTON_3},
	{"GLFW_MOUSE_BUTTON_4", GLFW_MOUSE_BUTTON_4},
	{"GLFW_MOUSE_BUTTON_5", GLFW_MOUSE_BUTTON_5},
	{"GLFW_MOUSE_BUTTON_6", GLFW_MOUSE_BUTTON_6},
	{"GLFW_MOUSE_BUTTON_7", GLFW_MOUSE_BUTTON_7},
	{"GLFW_MOUSE_BUTTON_LAST", GLFW_MOUSE_BUTTON_LAST},

// Mouse button aliases
	{"GLFW_MOUSE_BUTTON_LEFT", GLFW_MOUSE_BUTTON_LEFT},
	{"GLFW_MOUSE_BUTTON_RIGHT", GLFW_MOUSE_BUTTON_RIGHT},
	{"GLFW_MOUSE_BUTTON_MIDDLE", GLFW_MOUSE_BUTTON_MIDDLE},


// Joystick identifiers
	{"GLFW_JOYSTICK_1", GLFW_JOYSTICK_1},
	{"GLFW_JOYSTICK_2", GLFW_JOYSTICK_2},
	{"GLFW_JOYSTICK_3", GLFW_JOYSTICK_3},
	{"GLFW_JOYSTICK_4", GLFW_JOYSTICK_4},
	{"GLFW_JOYSTICK_5", GLFW_JOYSTICK_5},
	{"GLFW_JOYSTICK_6", GLFW_JOYSTICK_6},
	{"GLFW_JOYSTICK_7", GLFW_JOYSTICK_7},
	{"GLFW_JOYSTICK_8", GLFW_JOYSTICK_8},
	{"GLFW_JOYSTICK_9", GLFW_JOYSTICK_9},
	{"GLFW_JOYSTICK_10", GLFW_JOYSTICK_10},
	{"GLFW_JOYSTICK_11", GLFW_JOYSTICK_11},
	{"GLFW_JOYSTICK_12", GLFW_JOYSTICK_12},
	{"GLFW_JOYSTICK_13", GLFW_JOYSTICK_13},
	{"GLFW_JOYSTICK_14", GLFW_JOYSTICK_14},
	{"GLFW_JOYSTICK_15", GLFW_JOYSTICK_15},
	{"GLFW_JOYSTICK_16", GLFW_JOYSTICK_16},
	{"GLFW_JOYSTICK_LAST", GLFW_JOYSTICK_LAST},


//========================================================================
// Other definitions
//========================================================================

// glfwOpenWindow modes
	{"GLFW_WINDOW", GLFW_WINDOW},
	{"GLFW_FULLSCREEN", GLFW_FULLSCREEN},

// glfwGetWindowParam tokens
	{"GLFW_OPENED", GLFW_OPENED},
	{"GLFW_ACTIVE", GLFW_ACTIVE},
	{"GLFW_ICONIFIED", GLFW_ICONIFIED},
	{"GLFW_ACCELERATED", GLFW_ACCELERATED},
	{"GLFW_RED_BITS", GLFW_RED_BITS},
	{"GLFW_GREEN_BITS", GLFW_GREEN_BITS},
	{"GLFW_BLUE_BITS", GLFW_BLUE_BITS},
	{"GLFW_ALPHA_BITS", GLFW_ALPHA_BITS},
	{"GLFW_DEPTH_BITS", GLFW_DEPTH_BITS},
	{"GLFW_STENCIL_BITS", GLFW_STENCIL_BITS},

// The following constants are used for both glfwGetWindowParam
// and glfwOpenWindowHint
	{"GLFW_REFRESH_RATE", GLFW_REFRESH_RATE},
	{"GLFW_ACCUM_RED_BITS", GLFW_ACCUM_RED_BITS},
	{"GLFW_ACCUM_GREEN_BITS", GLFW_ACCUM_GREEN_BITS},
	{"GLFW_ACCUM_BLUE_BITS", GLFW_ACCUM_BLUE_BITS},
	{"GLFW_ACCUM_ALPHA_BITS", GLFW_ACCUM_ALPHA_BITS},
	{"GLFW_AUX_BUFFERS", GLFW_AUX_BUFFERS},
	{"GLFW_STEREO", GLFW_STEREO},

// glfwEnable/glfwDisable tokens
	{"GLFW_MOUSE_CURSOR", GLFW_MOUSE_CURSOR},
	{"GLFW_STICKY_KEYS", GLFW_STICKY_KEYS},
	{"GLFW_STICKY_MOUSE_BUTTONS", GLFW_STICKY_MOUSE_BUTTONS},
	{"GLFW_SYSTEM_KEYS", GLFW_SYSTEM_KEYS},
	{"GLFW_KEY_REPEAT", GLFW_KEY_REPEAT},
	{"GLFW_AUTO_POLL_EVENTS", GLFW_AUTO_POLL_EVENTS},

// glfwWaitThread wait modes
/*
	{"GLFW_WAIT", GLFW_WAIT},
	{"GLFW_NOWAIT", GLFW_NOWAIT},
*/

// glfwGetJoystickParam tokens
	{"GLFW_PRESENT", GLFW_PRESENT},
	{"GLFW_AXES", GLFW_AXES},
	{"GLFW_BUTTONS", GLFW_BUTTONS},

// glfwReadImage/glfwLoadTexture2D flags
/*
	{"GLFW_NO_RESCALE_BIT", GLFW_NO_RESCALE_BIT},
	{"GLFW_ORIGIN_UL_BIT", GLFW_ORIGIN_UL_BIT},
	{"GLFW_BUILD_MIPMAPS_BIT", GLFW_BUILD_MIPMAPS_BIT},
	{"GLFW_ALPHA_MAP_BIT", GLFW_ALPHA_MAP_BIT},
*/

// Time spans longer than this (seconds) are considered to be infinity
	{"GLFW_INFINITY", GLFW_INFINITY},

	/* The end */
	{NULL,0},
};

