/******************************************************************************
* Bool_err.c - handler for all bool library fatal errors.		      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, May. 91.					      *
******************************************************************************/


#include <stdio.h>
#include "irit_sm.h"
#include "allocate.h"
#include "bool_loc.h"

typedef struct BoolErrorStruct {
    BoolFatalErrorType ErrorNum;
    char *ErrorDesc;
} BoolErrorStruct;

STATIC_DATA BoolErrorStruct ErrMsgs[] =
{
    { BOOL_ERR_NO_POLY_OBJ,	    "Operation on non polygonal object(s)" },
    { BOOL_ERR_NO_BOOL_OP_SUPPORT,  "Undefined Boolean operation" },
    { BOOL_ERR_NO_MATCH_POINT,	    "Failed to find matching point" },
    { BOOL_ERR_NO_ELMNT_TO_DEL,	    "Element to delete not found" },
    { BOOL_ERR_SORT_INTER_LIST,	    "Fail to sort intersection list" },
    { BOOL_ERR_FIND_VERTEX_FAILED,  "Fail to find vertex" },
    { BOOL_ERR_NO_COPLANAR_VRTX,    "Failed to find non coplanar point" },
    { BOOL_ERR_NO_OPEN_LOOP,	    "None open loop" },
    { BOOL_ERR_NO_NEWER_VERTEX,	    "Failed to find newer vertex" },
    { BOOL_ERR_NO_INTERSECTION,	    "Fail to find intersection" },
    { BOOL_ERR_LOOP_LESS_3_VRTCS,   "Closed loop with fewer than 3 vertices" },
    { BOOL_ERR_NO_INVERSE_MAT,	    "Inverse matrix does not exists" },
    { BOOL_ERR_ADJ_STACK_OF,	    "Adjacency stack overflow, object too large" },
    { BOOL_ERR_CIRC_VRTX_LST,	    "Vertex list must be circular for proper adjacencies" },
    { BOOL_ERR_NO_2D_OP_SUPPORT,    "Unsupported 2D Boolean operation" },
    { BOOL_ERR_NO_PLLN_MATCH,	    "Failed to match polylines" },
    { BOOL_ERR_DISJ_PROP_ERR,	    "Disjoint propagation error" },

    { BOOL_ERR_UNDEFINE_ERR,	    NULL }
};

/*****************************************************************************
* DESCRIPTION:                                                               M
* Returns a string describing a the given error. Errors can be raised by     M
* any member of this bool library as well as other users. Raised error will  M
* cause an invokation of BoolFatalError function which decides how to handle M
* this error. BoolFatalError can for example, invoke this routine with the   M
* error type, print the appropriate message and quit the program.            M
*                                                                            *
* PARAMETERS:                                                                M
*   ErrorNum:   Type of the error that was raised.                           M
*                                                                            *
* RETURN VALUE:                                                              M
*   char *:     A string describing the error type.                          M
*                                                                            *
* KEYWORDS:                                                                  M
*   BoolDescribeError, error handling                                        M
*****************************************************************************/
char *BoolDescribeError(BoolFatalErrorType ErrorNum)
{
    int i = 0;

    for ( ; ErrMsgs[i].ErrorDesc != NULL; i++)
	if (ErrorNum == ErrMsgs[i].ErrorNum)
	    return ErrMsgs[i].ErrorDesc;

    return "Undefined error";
}
