/*****************************************************************************
* Filter to convert IRIT data files to IGES files.	        	     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Gershon Elber	 			 Ver 1.0, May 1998   *
*****************************************************************************/

#include <stdio.h>
#include "irit_sm.h"
#include "iritprsr.h"
#include "geom_lib.h"

STATIC_DATA char
#ifdef NO_CONCAT_STR
    *VersionStr =
	"Irit2IGS		Version 9.5,	     Gershon Elber,\n\
	 (C) Copyright 1989-2005 Gershon Elber, Non commercial use only.";
#else
    *VersionStr = "irit2igs	" IRIT_VERSION ",   Gershon Elber,	"
	__DATE__ ",   " __TIME__ "\n" IRIT_COPYRIGHT ", Non commercial use only.";
#endif /* NO_CONCAT_STR*/

STATIC_DATA char
#ifdef IRIT_DOUBLE
    *CtrlStr = "Irit2igs m%- o%-OutName!s t%-AnimTime!F E%- u%- z%- IritFile!*s";
#else
    *CtrlStr = "Irit2igs m%- o%-OutName!s t%-AnimTime!f E%- u%- z%- IritFile!*s";
#endif /* IRIT_DOUBLE */

static void Irit2IgesExit(int ExitCode);

/*****************************************************************************
* DESCRIPTION:                                                               M
* Main module of irit2igs - Read command line and do what is needed...	     M
*                                                                            *
* PARAMETERS:                                                                M
*   argc, argv:  Command line.                                               M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   main                                                                     M
*****************************************************************************/
void main(int argc, char **argv)
{
    int Error,
	MoreFlag = 1,
        HasTime = FALSE,
	VerFlag = FALSE,
	OutFileFlag = FALSE,
	ForceUnitMat = FALSE,
	DumpEucTrimCrvs = FALSE,
	NumFiles = 0;
    char
	*IgesFileName = NULL,
	**FileNames = NULL;
    RealType CurrentTime;
    MatrixType CrntViewMat;
    IPObjectStruct *PObjects;

#ifdef DEBUG_IRIT_MALLOC
    IritInitTestDynMemory();
#endif /* DEBUG_IRIT_MALLOC */

    if ((Error = GAGetArgs(argc, argv, CtrlStr, &MoreFlag,
			   &OutFileFlag, &IgesFileName,
			   &HasTime, &CurrentTime, &DumpEucTrimCrvs,
			   &ForceUnitMat, &VerFlag,
			   &NumFiles, &FileNames)) != 0) {
	GAPrintErrMsg(Error);
	GAPrintHowTo(CtrlStr);
	Irit2IgesExit(1);
    }

    if (VerFlag) {
	fprintf(stderr, "\n%s\n\n", VersionStr);
	GAPrintHowTo(CtrlStr);
	Irit2IgesExit(0);
    }

    if (!NumFiles) {
	fprintf(stderr, "No data file names were given, exit.\n");
	GAPrintHowTo(CtrlStr);
	Irit2IgesExit(1);
    }

    IPSetFlattenObjects(FALSE);
    if ((PObjects = IPGetDataFiles(FileNames, NumFiles, TRUE, FALSE)) == NULL)
	Irit2IgesExit(1);
    PObjects = IPResolveInstances(PObjects);

    if (HasTime)
	GMAnimEvalAnimationList(CurrentTime, PObjects);
    else
        GMAnimEvalAnimationList(GM_ANIM_NO_DEFAULT_TIME, PObjects);

    if (ForceUnitMat) {
	MatGenUnitMat(CrntViewMat);
    }
    else {
	if (IPWasPrspMat)
	    MatMultTwo4by4(CrntViewMat, IPViewMat, IPPrspMat);
	else
	    GEN_COPY(CrntViewMat, IPViewMat, sizeof(MatrixType));
    }

    IPSaveIgesFileSetup(DumpEucTrimCrvs);

    IPSaveIgesFile(PObjects, CrntViewMat,
		   OutFileFlag ? IgesFileName : NULL, MoreFlag);

    Irit2IgesExit(0);
}

/*****************************************************************************
* DESCRIPTION:                                                               *
* Irit2igs exit routine.						     *
*                                                                            *
* PARAMETERS:                                                                *
*   ExitCode:                                                                *
*                                                                            *
* RETURN VALUE:                                                              *
*   void                                                                     *
*****************************************************************************/
static void Irit2IgesExit(int ExitCode)
{
    exit(ExitCode);
}
