/*****************************************************************************
* Filter to convert STL data files to IRIT .irt files.			     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Gershon Elber				Ver 1.0, June 2002   *
*****************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <string.h>
#include "irit_sm.h"
#include "geom_lib.h"
#include "misc_lib.h"

#ifdef __WINNT__
#include <io.h>
#include <fcntl.h>
#endif /* __WINNT__ */

#ifdef NO_CONCAT_STR
STATIC_DATA char *VersionStr =
	"stl2irit		Version 9.5,		Gershon Elber,\n\
	 (C) Copyright 1989-2005 Gershon Elber, Non commercial use only.";
#else
STATIC_DATA char *VersionStr = "stl2irit	" IRIT_VERSION ",	Gershon Elber,	"
	__DATE__ ",   " __TIME__ "\n" IRIT_COPYRIGHT ", Non commercial use only.";
#endif /* NO_CONCAT_STR */

STATIC_DATA char
    *CtrlStr = "stl2irit b%- w%- n%- o%-OutName!s z%- STLFile!*s";

static void Stl2IritExit(int ExitCode);

/*****************************************************************************
* DESCRIPTION:                                                               M
* Main module of stl2irit - Read command line and do what is needed...	     M
*                                                                            *
* PARAMETERS:                                                                M
*   argc, argv:  Command line.                                               M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   main                                                                     M
*****************************************************************************/
void main(int argc, char **argv)
{
    int Error, NumFiles,
	VerFlag = FALSE,
	OutFileFlag = FALSE,
        BinarySTL = FALSE,
        EndianSwap = FALSE,
        NormalFlip = FALSE,
        NumInputPolys = 0,
        NumOutputPolys = 0;
    char 
	*OutFileName = NULL,
	**FileNames = NULL;
    FILE *DATFile;
    IPObjectStruct *PObj;

#ifdef DEBUG_IRIT_MALLOC
    IritInitTestDynMemory();
#endif /* DEBUG_IRIT_MALLOC */

    if ((Error = GAGetArgs(argc, argv, CtrlStr,
			   &BinarySTL, &EndianSwap, &NormalFlip,
			   &OutFileFlag, &OutFileName, &VerFlag,
			   &NumFiles, &FileNames)) != 0) {
	GAPrintErrMsg(Error);
	GAPrintHowTo(CtrlStr);
	Stl2IritExit(1);
    }

    if (VerFlag) {
	fprintf(stderr, "\n%s\n\n", VersionStr);
	GAPrintHowTo(CtrlStr);
	Stl2IritExit(0);
    }

    if (!NumFiles) {
	fprintf(stderr, "No data file names were given, exit.\n");
	GAPrintHowTo(CtrlStr);
	Stl2IritExit(1);
    }
    else if (NumFiles > 1) {
	fprintf(stderr, "Cannot handle more than one STL file at a time, exit.\n");
	GAPrintHowTo(CtrlStr);
	Stl2IritExit(1);
    }

    PObj = IPLoadStlFile(FileNames[0], BinarySTL, EndianSwap, NormalFlip,
			 TRUE);

    if (OutFileName != NULL) {
	if ((DATFile = fopen(OutFileName, "w")) == NULL) {
	    fprintf(stderr, "Failed to open \"%s\".\n", OutFileName);
	    Stl2IritExit(2);
	}
    }
    else
        DATFile = stdout;
    IPPutObjectToFile(DATFile, PObj, FALSE);
    fclose(DATFile);
    IPFreeObject(PObj);

    fprintf(stderr,
	    "%d triangles processed in STL file, %d dumped out\n",
	    NumInputPolys, NumOutputPolys);

    Stl2IritExit(0);
}

/*****************************************************************************
* DESCRIPTION:                                                               *
* Stl2Irit exit routine.						     *
*                                                                            *
* PARAMETERS:                                                                *
*   ExitCode:                                                                *
*                                                                            *
* RETURN VALUE:                                                              *
*   void                                                                     *
*****************************************************************************/
static void Stl2IritExit(int ExitCode)
{
    exit(ExitCode);
}
